static char RcsId[] =
"$Header: /segfs/dserver/dev/system/xdr/src/RCS/slit_xdr.c,v 5.18 1999/07/08 14:10:46 goetz Rel $";

/*+*******************************************************************

 File:          slit_xdr.c

 Project:       Device Servers with sun-rpc

 Description:   xdr_routines for SLIT types.

 Author(s):     Timo Mett\"al\"a

 Original:      September 1992

$Log: slit_xdr.c,v $
Revision 5.18  1999/07/08 14:10:46  goetz
changed _LPfd_set type for Linux in macros.h

Revision 5.17  1998/05/25 17:59:44  klotz
fixed C++ prototypes in api_xdr.h

Revision 5.16  1998/04/29 10:24:06  goetz
macros.h - added __STDCPP__ for HP C++ compiler (aCC)

 * Revision 5.15  97/12/01  15:16:43  15:16:43  klotz (W.D. Klotz)
 * WIN_NT_95_released_NOV_97
 * 
 * Revision 4.34  97/01/30  13:58:40  13:58:40  goetz (Andy Goetz)
 * removed dev_printdebug() from DevXdrKernel.h
 * 
 * Revision 4.33  97/01/09  10:08:45  10:08:45  goetz (Andy Goetz)
 * (xdrproc_t) castings added to maxe_xdr, ram_xdr, thc_xdr, seism_xdr
 * 
 * Revision 4.32  97/01/08  16:48:34  16:48:34  goetz (Andy Goetz)
 * Ported to Linux (2.0.9)
 * 
Revision 4.31  1996/11/18 17:28:50  goetz
Check

 * Revision 4.28  96/10/21  16:22:28  16:22:28  taurel (E.Taurel)
 * Check_in_after_port_to_OS9/ISP_2.1_and_OS9/RPC1.4
 * 
 * Revision 4.27  96/09/17  16:40:22  16:40:22  klotz (W.D. Klotz)
 * WD Klotz: tested NT build  
 * 
 * Revision 4.26  96/07/19  10:01:03  10:01:03  taurel (E.Taurel)
 * Some_change_in_macros.h_for_the_API_port_to_OS-9_Ultra_C++
 * 
 * Revision 4.25  96/06/07  16:23:08  16:23:08  meyer (J.Meyer)
 * Corrected_elif_to_else_in_macros.h
 * 
 * Revision 4.24  96/06/05  15:01:43  15:01:43  meyer (J.Meyer)
 * Corrected_macros.h
 * 
 * Revision 4.23  96/06/03  13:10:21  13:10:21  meyer (J.Meyer)
 * Cleaned-up_MSDOS_and_added_porting_options_for_Windows_NT.
 * 
 * Revision 4.22  96/05/23  11:07:29  11:07:29  taurel (E.Taurel)
 * Added_some_definitions_for_C++_in_API_xdr.h_file
 * 
 * Revision 4.21  96/05/06  18:37:39  18:37:39  meyer (J.Meyer)
 * Fortran_compatibility_for:_dev_xdr.h,macros.h,maxe_xdr.h
 * 
 * Revision 4.20  96/02/27  13:31:39  13:31:39  meyer (J.Meyer)
 * Deleted_Cross_References_To_DSAPI_Library
 * 
 * Revision 4.19  96/01/11  17:40:24  17:40:24  meyer (Jens Meyer)
 * Added_#define_PORTMAP_to_macros.h.
 * 
 * Revision 4.18  95/12/21  10:33:36  10:33:36  meyer (Jens Meyer)
 * Corrected length calculation for D_VAR_MSTATARR.
 * 
 * Revision 4.17  95/08/02  16:05:16  16:05:16  meyer (Jens Meyer)
 * Corrected DevXdrKernel.h after C++ implementation.
 * 
 * Revision 4.15  95/03/02  10:27:59  10:27:59  meyer (Jens Meyer)
 * Added D_VAR_SFRPARR type to the kernel.
 * 
 * Revision 4.14  95/02/20  09:56:49  09:56:49  meyer (Jens Meyer)
 * Passed the compilers for HPUX, SUNOS and UCC after the first windows check in.
 * 
 * Revision 4.13  95/02/10  17:19:06  17:19:06  meyer (Jens Meyer)
 * Deleted
 * 
 * Revision 4.12  95/02/01  14:27:05  14:27:05  klotz (W.D. Klotz)
 * WDK: first successfull compile of dbase, api, xdr on WIN16/3.1
 * 
 * Revision 4.11  95/01/03  13:19:27  13:19:27  meyer (Jens Meyer)
 * Repared bug in dev_cmd_query() for version 3!
 * 
 * Revision 4.10  94/12/08  15:24:57  15:24:57  meyer (Jens Meyer)
 * Changed _manager_data in API_xdr and added old version to API_xdr_vers3.
 * 
 * Revision 4.9  94/11/28  17:04:19  17:04:19  meyer (Jens Meyer)
 * Data types for compatibility with library version 3.x
 * 
 * Revision 4.8  94/08/16  16:59:36  16:59:36  meyer (Jens Meyer)
 * Corrected error in ws_xdr.h
 * 
 * Revision 4.7  94/08/16  16:34:31  16:34:31  meyer (Jens Meyer)
 * Added define for MAX_RESOURCE_FIELD_LENGTH to macros.h
 * 
 * Revision 4.6  94/08/12  15:07:46  15:07:46  meyer (Jens Meyer)
 * Added valriable arguments to all API RPC structures.
 * 
 * Revision 4.5  94/07/20  18:15:46  18:15:46  meyer (Jens Meyer)
 * Changed include files in macros.h!
 * 
 * Revision 4.4  94/07/20  08:55:55  08:55:55  meyer (Jens Meyer)
 * All XDR functions with prototypes!
 * 
 * Revision 4.3  94/07/18  18:50:56  18:50:56  meyer (Jens Meyer)
 * Had to change macros.h, because #define must be in the first column!
 * 
 * Revision 4.2  94/07/18  18:22:23  18:22:23  meyer (Jens Meyer)
 * First test with PC macros for the XDR kernel.
 * 
 * Revision 4.1  94/05/02  10:50:49  10:50:49  meyer (Jens Meyer)
 * For Security System without connection count.
 * 
 * Revision 4.0  94/03/14  18:17:34  18:17:34  meyer (Jens Meyer)
 * Library version with Security System.
 * 
 * Revision 3.50  94/03/12  14:36:27  14:36:27  meyer (Jens Meyer)
 * Changed API xdr structures for security.
 * 
 * Revision 3.35  94/03/03  10:52:12  10:52:12  taurel (Emmanuel TAUREL)
 * Added unsigned long array type in the XDRkernel
 * 
 * Revision 3.34  94/03/03  10:29:03  10:29:03  taurel (Emmanuel TAUREL)
 * Added the unsigned long array type in
 * XDR kernel (LC and ET).
 * 
 * Revision 3.33  94/01/12  16:34:27  16:34:27  meyer (Jens Meyer)
 * Global XDR type array for data collector access
 * 
 * Revision 3.31  93/12/02  09:39:02  09:39:02  meyer (Jens Meyer)
 * New release with small XDR data type kernel.
 * 
 * Revision 1.1  93/12/01  15:25:29  15:25:29  meyer (Jens Meyer)
 * Initial revision
 * 
 
Copyright (c) 1992 by European Synchrotron Radiation Facility,
                      Grenoble, France

*******************************************************************-*/

#include <dev_xdr.h>
#include <slit_xdr.h>


bool_t xdr_pslit_head(xdrs, objp)
        XDR *xdrs;
        pslit_head *objp;
{
        if (!xdr_long(xdrs, &objp->pmain_st))
                return (FALSE);
        if (!xdr_long(xdrs, &objp->dev_diag))
                return (FALSE);
        if (!xdr_long(xdrs, &objp->unit))
                return (FALSE);

        return (TRUE);
}


bool_t xdr_blade_state(xdrs, objp)
        XDR *xdrs;
        blade_state *objp;
{
        if (!xdr_long(xdrs, &objp->values_st))
                return (FALSE);
        if (!xdr_long(xdrs, &objp->mot_moving))
                return (FALSE);
        if (!xdr_float(xdrs, &objp->mot_pos))
                return (FALSE);
        if (!xdr_float(xdrs, &objp->enc_pos))
                return (FALSE);
        if (!xdr_float(xdrs, &objp->temp))
                return (FALSE);
        if (!xdr_long(xdrs, &objp->brake))
                return (FALSE);
        if (!xdr_long(xdrs, &objp->switch_st))
                return (FALSE);
        if (!xdr_long(xdrs, &objp->tuned))
                return (FALSE);
        return (TRUE);
}


bool_t xdr_DevBladeState(xdrs, objp)
        XDR *xdrs;
        DevBladeState *objp;
{
        if (!xdr_pslit_head(xdrs, &objp->pslit_head))
                return (FALSE);
        if (!xdr_blade_state(xdrs, &objp->up_state))
                return (FALSE);
        if (!xdr_blade_state(xdrs, &objp->do_state))
                return (FALSE);
        if (!xdr_blade_state(xdrs, &objp->fr_state))
                return (FALSE);
        if (!xdr_blade_state(xdrs, &objp->ba_state))
                return (FALSE); 
        return (TRUE);
}

bool_t xdr_pslit_state(xdrs, objp)
        XDR *xdrs;
        pslit_state *objp;
{
        if (!xdr_long(xdrs, &objp->values_st))
                return (FALSE);
        if (!xdr_float(xdrs, &objp->gap))
                return (FALSE);
        if (!xdr_float(xdrs, &objp->offset))
                return (FALSE);
        if (!xdr_float(xdrs, &objp->temp_1))
                return (FALSE);
        if (!xdr_float(xdrs, &objp->temp_2))
                return (FALSE);
        if (!xdr_long(xdrs, &objp->brake_1))
                return (FALSE);
        if (!xdr_long(xdrs, &objp->brake_2))
                return (FALSE);
        if (!xdr_long(xdrs, &objp->switch_1))
                return (FALSE);
        if (!xdr_long(xdrs, &objp->switch_2))
                return (FALSE);
        return (TRUE);
}


bool_t xdr_DevPslitState(xdrs, objp)
        XDR *xdrs;
        DevPslitState *objp;
{
        if (!xdr_pslit_head(xdrs, &objp->pslit_head))
                return (FALSE);
        if (!xdr_pslit_state(xdrs, &objp->vertical))
                return (FALSE);
        if (!xdr_pslit_state(xdrs, &objp->horizontal))
                return (FALSE);
        return (TRUE);
}

