/*+*******************************************************************

 File:          seism_xdr.h

 Project:       Device Servers with sun-rpc

 Description:   Include file for XDR definitions
		of the Seismic Survey System data types.

 Author(s):  	Jean Michel Chaize

 Original:	August 1992


 $Revision: 5.18 $
 $Date: 1999/07/08 14:10:49 $

 $Author: goetz $

 $Log: seism_xdr.h,v $
 Revision 5.18  1999/07/08 14:10:49  goetz
 changed _LPfd_set type for Linux in macros.h

 Revision 5.17  1998/05/25 17:59:58  klotz
 fixed C++ prototypes in api_xdr.h

 Revision 5.16  1998/04/29 10:24:20  goetz
 macros.h - added __STDCPP__ for HP C++ compiler (aCC)

 * Revision 5.15  97/12/01  15:22:45  15:22:45  klotz (W.D. Klotz)
 * WIN_NT_95_released_NOV_97
 * 
 * Revision 4.34  97/01/30  13:58:49  13:58:49  goetz (Andy Goetz)
 * removed dev_printdebug() from DevXdrKernel.h
 * 
 * Revision 4.33  97/01/09  10:08:53  10:08:53  goetz (Andy Goetz)
 * (xdrproc_t) castings added to maxe_xdr, ram_xdr, thc_xdr, seism_xdr
 * 
 * Revision 4.32  97/01/08  16:48:44  16:48:44  goetz (Andy Goetz)
 * Ported to Linux (2.0.9)
 * 
 Revision 4.31  1996/11/18 17:28:59  goetz
 Check

 * Revision 4.28  96/10/21  16:22:45  16:22:45  taurel (E.Taurel)
 * Check_in_after_port_to_OS9/ISP_2.1_and_OS9/RPC1.4
 * 
 * Revision 4.27  96/09/17  16:46:02  16:46:02  klotz (W.D. Klotz)
 * WD Klotz: checked NT build
 * 
 * Revision 4.26  96/07/19  10:01:11  10:01:11  taurel (E.Taurel)
 * Some_change_in_macros.h_for_the_API_port_to_OS-9_Ultra_C++
 * 
 * Revision 4.25  96/06/07  16:23:16  16:23:16  meyer (J.Meyer)
 * Corrected_elif_to_else_in_macros.h
 * 
 * Revision 4.24  96/06/05  15:01:52  15:01:52  meyer (J.Meyer)
 * Corrected_macros.h
 * 
 * Revision 4.23  96/06/03  13:10:30  13:10:30  meyer (J.Meyer)
 * Cleaned-up_MSDOS_and_added_porting_options_for_Windows_NT.
 * 
 * Revision 4.22  96/05/23  11:07:37  11:07:37  taurel (E.Taurel)
 * Added_some_definitions_for_C++_in_API_xdr.h_file
 * 
 * Revision 4.21  96/05/06  18:37:47  18:37:47  meyer (J.Meyer)
 * Fortran_compatibility_for:_dev_xdr.h,macros.h,maxe_xdr.h
 * 
 * Revision 4.20  96/02/27  13:31:47  13:31:47  meyer (J.Meyer)
 * Deleted_Cross_References_To_DSAPI_Library
 * 
 * Revision 4.19  96/01/11  17:40:33  17:40:33  meyer (Jens Meyer)
 * Added_#define_PORTMAP_to_macros.h.
 * 
 * Revision 4.18  95/12/21  10:33:53  10:33:53  meyer (Jens Meyer)
 * Corrected length calculation for D_VAR_MSTATARR.
 * 
 * Revision 4.17  95/08/02  16:05:24  16:05:24  meyer (Jens Meyer)
 * Corrected DevXdrKernel.h after C++ implementation.
 * 
 * Revision 4.15  95/03/02  10:28:19  10:28:19  meyer (Jens Meyer)
 * Added D_VAR_SFRPARR type to the kernel.
 * 
 * Revision 4.14  95/02/20  09:57:19  09:57:19  meyer (Jens Meyer)
 * Passed the compilers for HPUX, SUNOS and UCC after the first windows check in.
 * 
 * Revision 4.13  95/02/10  17:19:27  17:19:27  meyer (Jens Meyer)
 * Deleted
 * 
 * Revision 4.12  95/02/01  14:27:40  14:27:40  klotz (W.D. Klotz)
 * WDK: first successfull compile of dbase, api, xdr on WIN16/3.1
 * 
 * Revision 4.11  95/01/03  13:19:45  13:19:45  meyer (Jens Meyer)
 * Repared bug in dev_cmd_query() for version 3!
 * 
 * Revision 4.10  94/12/08  15:25:15  15:25:15  meyer (Jens Meyer)
 * Changed _manager_data in API_xdr and added old version to API_xdr_vers3.
 * 
 * Revision 4.9  94/11/28  17:04:38  17:04:38  meyer (Jens Meyer)
 * Data types for compatibility with library version 3.x
 * 
 * Revision 4.8  94/08/16  16:59:52  16:59:52  meyer (Jens Meyer)
 * Corrected error in ws_xdr.h
 * 
 * Revision 4.7  94/08/16  16:34:49  16:34:49  meyer (Jens Meyer)
 * Added define for MAX_RESOURCE_FIELD_LENGTH to macros.h
 * 
 * Revision 4.6  94/08/12  15:08:03  15:08:03  meyer (Jens Meyer)
 * Added valriable arguments to all API RPC structures.
 * 
 * Revision 4.5  94/07/20  18:16:03  18:16:03  meyer (Jens Meyer)
 * Changed include files in macros.h!
 * 
 * Revision 4.4  94/07/20  08:56:27  08:56:27  meyer (Jens Meyer)
 * All XDR functions with prototypes!
 * 
 * Revision 4.3  94/07/18  18:51:11  18:51:11  meyer (Jens Meyer)
 * Had to change macros.h, because #define must be in the first column!
 * 
 * Revision 4.2  94/07/18  18:22:55  18:22:55  meyer (Jens Meyer)
 * First test with PC macros for the XDR kernel.
 * 
 * Revision 4.1  94/05/02  10:51:05  10:51:05  meyer (Jens Meyer)
 * For Security System without connection count.
 * 
 * Revision 4.0  94/03/14  18:17:48  18:17:48  meyer (Jens Meyer)
 * Library version with Security System.
 * 
 * Revision 3.50  94/03/12  14:36:42  14:36:42  meyer (Jens Meyer)
 * Changed API xdr structures for security.
 * 
 * Revision 3.35  94/03/03  10:52:27  10:52:27  taurel (Emmanuel TAUREL)
 * Added unsigned long array type in the XDRkernel
 * 
 * Revision 3.34  94/03/03  10:29:17  10:29:17  taurel (Emmanuel TAUREL)
 * Added the unsigned long array type in
 * XDR kernel (LC and ET).
 * 
 * Revision 3.33  94/01/12  16:34:45  16:34:45  meyer (Jens Meyer)
 * Global XDR type array for data collector access
 * 
 * Revision 3.31  93/12/02  09:39:25  09:39:25  meyer (Jens Meyer)
 * New release with small XDR data type kernel.
 * 
 * Revision 1.1  93/12/01  14:10:59  14:10:59  meyer (Jens Meyer)
 * Initial revision
 * 

 Copyright (c) 1990 by European Synchrotron Radiation Facility,PI
		       Grenoble, France

*******************************************************************-*/

#ifndef _seism_xdr_h
#define _seism_xdr_h

struct DevSeismEvent {
	int   nsta;
        short weight[16];
	short coincid_sum;
	short pre_eventtime;
	short post_eventtime;
        char  tape_id;
        char  file_num[3];
	float t_beg;
	float t_ana;
	int   win_type;
	float win_width;
        int   inst_cor_flag;
	float rms_fmin;
	float rms_fmax;
	int   smooth_flag;
	float smo_width;
	float freq_inc;
	int   nspecout;
	float out_freqinc;
		     };
typedef struct DevSeismEvent 	DevSeismEvent;
bool_t 	_DLLFunc xdr_DevSeismEvent PT_((XDR *xdrs, DevSeismEvent *objp));
#define D_SEISM_EVENT           48
#define LOAD_SEISM_EVENT(A)     xdr_load_type ( D_SEISM_EVENT, \
                                                xdr_DevSeismEvent, \
                                                sizeof(DevSeismEvent), \
                                                NULL, \
                                                A )

struct DevSeismStat {
                char comp;
		DevString sismo_type;
		float n_lat;
		float e_lon;
		float elev;
		float freq_prop;
		float damping;
		float gain;
		float sampling;
		float transduct;
		float conv;
		DevString pos;
		float high_pass;
		float tr_mode;
		float tr_hpass;
		float tr_lpass;
		float tr_sta;
		float tr_lta;
		int tr_stalta;
		int trigger;
		int v_test;
		float vmin_a;
		float vmax_a;
		float vmin_w;
		float vmax_w;
		float dmin;
		float dmax;
		float rms_time;
		float rms_spec;
		    };
typedef struct DevSeismStat 	DevSeismStat;
bool_t 	_DLLFunc xdr_DevSeismStat PT_((XDR *xdrs, DevSeismStat *objp));
#define D_SEISM_STAT            49
#define LOAD_SEISM_STAT(A)      xdr_load_type ( D_SEISM_STAT, \
                                                xdr_DevSeismStat, \
                                                sizeof(DevSeismStat), \
                                                NULL, \
                                                A )

#endif /* _seism_xdr_h */
