static char RcsId[] =
"@(#)$Header: ManagerMain.c,v 4.12 2000/03/15 17:23:22 taurel Rel $ ";
/********************************************************************

 File:          ManagerMain.c

 Project:       Device Servers with sun-rpc

 Description:   Main Programm for a Network Manager running under
		HPUX or SUN or without message server and with a
		dummy database under OS9.

 Author(s):     Jens Meyer

 Original: 	January 1991


 $Revision: 4.12 $
 $Date: 2000/03/15 17:23:22 $

 $Author: taurel $

 $Log:	ManagerMain.c,v $
 * Revision 4.12  2000/03/15  17:23:22  17:23:22  taurel (E.Taurel)
 * Remove the chmod for unix operating system
 * 
 * Revision 4.11  99/11/21  20:36:15  20:36:15  goetz (Andy Goetz)
 * calling svc_destroy() before execv() for database and message server (M.Diehl patch)
 * 
 Revision 4.10  1999/08/04 11:55:08  goetz
 fixed bug in initialisation of config_flags to initialise only 7 fields

 Revision 4.9  1999/07/11 10:19:35  goetz
 added support for Linux binaries

 Revision 4.8  1999/03/10 14:11:49  taurel
 Added new env. variables for ORACLE db

 * Revision 4.7  98/10/15  16:56:55  16:56:55  taurel (E.Taurel)
 * Some
 * 
 * Revision 4.6  98/10/15  16:53:00  16:53:00  taurel (Emmanuel Taurel)
 * Added a new -oracle option
 * 
 * Revision 4.5  98/10/13  12:42:22  12:42:22  goetz (Andy Goetz)
 * added code to use local host if NETHOST is not defined
 * 
 * Revision 4.4  96/01/16  11:00:01  11:00:01  meyer (J.Meyer)
 * Added environment variable DBHOME for RTDB startup.
 * 
 * Revision 4.3  96/01/11  10:17:50  10:17:50  taurel (Emmanuel TAUREL)
 * Change the dbase path in the include file.
 * 
 * Revision 4.2  95/01/04  16:28:29  16:28:29  meyer (Jens Meyer)
 * Version ported to solaris2.
 * 
 * Revision 4.1  94/12/19  17:01:40  17:01:40  meyer (Jens Meyer)
 * Tested for RTDB and DBM.
 * 
 * Revision 4.0  94/12/12  11:31:30  11:31:30  meyer (Jens Meyer)
 * Version with security tested for RTDB
 * 
 * Revision 3.4  92/11/16  19:19:09  19:19:09  meyer (Jens Meyer)
 * Corrected compile options for s700 version
 * 
 * Revision 3.3  92/11/11  13:25:48  13:25:48  meyer (Jens Meyer)
 * Added variable pathes for the different hardware platforms.
 * 
 * Revision 3.2  92/11/10  11:27:27  11:27:27  meyer (Jens Meyer)
 * Corrected directory path to system/bin
 * 
 * Revision 3.1  92/11/10  11:14:26  11:14:26  meyer (Jens Meyer)
 * Corrected
 * 
 * Revision 3.0  92/11/10  10:57:46  10:57:46  meyer (Jens Meyer)
 * Unique
 * 

 Copyright (c) 1990 by  European Synchrotron Radiation Facility,
			Grenoble, France

			All Rights Reserved
**********************************************************************/


#include <API.h>
#include <ApiP.h>
#include <API_xdr_vers3.h>
#include <ManagerP.h>
#include <signal.h>
#include <sys/wait.h>


	static void 	network_manager_1();
	static void 	network_manager_4();
	static void 	startup_msg();

	config_flags	c_flags = {False,False,False,False,False,False,False};
	char 		*dshome  = NULL;
	char		*display = NULL;
	char	 	nethost [32];
	char		logfile [256];
	FILE		*system_log = NULL;

	int		pid = 0;


main (argc,argv)
        int     argc;
	char    **argv;

{
	SVCXPRT *transp;
	FILE	*fptr;
	char	*dbhost = NULL;
	char	*dbhome = NULL;
	char 	*dbtables = NULL;
	char	*nethost_env = NULL;
	char	*ora_sid = NULL;
	char 	*ora_home = NULL;
	char 	*cmd_argv [5];
	char	rtdb_server_path [200];
	char	oracle_server_path [200];
	char	ld_path [200];
	char	db_path [200];
	char	homepath [200];
	char	homedir [200];
	char	dbase_env [200];
	char	db_start [256];
	char	mode [256];
	char    *time_string;
	time_t	clock;
	int	msg_pid = 0;
	int	db_pid = 0;
	int	i;
	int     res;


	pid = getpid ();

#ifdef unix
	if ( (nethost_env = (char *)getenv ("NETHOST")) == NULL )
	   {
	   printf ("Environment variable NETHOST not defined, using local host ...\n");
	   gethostname (nethost, 32);
	   }
	else
	   {
	   sprintf(nethost,"%s",nethost_env);
/*	   printf ("Environment variable NETHOST = %s\n",nethost);*/
	   }
#endif /* unix */


	/*
	 *  read options for the manager startup.
	 */

	if (argc > 1)
	   {
	   for (i=1; i<argc; i++)
	      {
	      if (strcmp (argv[i],"-rtdb") == 0)
		 c_flags.rtdb        = True;
	      if (strcmp (argv[i],"-log") == 0)
		 c_flags.request_log = True;
	      if (strcmp (argv[i],"-security") == 0)
		 c_flags.security    = True;
	      if (strcmp (argv[i],"-oracle") == 0)
	         c_flags.oracle	     = True;
	      }
	   }


	/*
	 *  get environment variables 
	 */

#ifdef unix
	if ( (dshome = (char *)getenv ("DSHOME")) == NULL )
	   {
	   printf ("Environment variable DSHOME not defined, exiting...\n");
	   exit (-1);
	   }

	if ( (display = (char *)getenv ("DISPLAY")) == NULL )
	   {
	   display = "localhost:0.0";
	   }

        if ( (dbhost = (char *)getenv ("DBHOST")) == NULL )
           {
	   dbhost = "localhost";
           }
#endif /* unix */

#ifdef _OSK
	/*
      	 *  fixed path for a automatic os9 startup with 
	 *  dummy database.
	 */
	dshome = "/h0";
#endif /* _OSK */

#ifdef linuxx86
	sprintf (homepath, "%s/system/bin/linux/x86", dshome);
#endif /* linuxx86 */
#ifdef linux68k
	sprintf (homepath, "%s/system/bin/linux/68k", dshome);
#endif /* linux68k */

#ifdef sun
#ifdef solaris
	sprintf (homepath, "%s/system/bin/solaris", dshome);
#else
	sprintf (homepath, "%s/system/bin/sun4", dshome);
#endif /* solaris */
#endif /* sun */

#ifdef hpux10
	sprintf (homepath, "%s/system/bin/hpux10.2", dshome);
#endif /* hpux10 */

#ifdef unix
	if ( (fptr = fopen (homepath,"r")) == NULL )
#endif /* unix */
#ifdef _OSK
	if ( (fptr = fopen (homepath,"d")) == NULL )
#endif /* _OSK */
	   {
	   printf ("DSHOME leads to a strange directory, exiting...\n");
	   exit (-1);
	   }
	else
	   {
	   fclose (fptr);
	   }


#ifdef unix
        /*
         * Check the environment if DBM database is used !!
         */

	if (c_flags.rtdb == False )
	   {
	   if (c_flags.oracle == False )
	   	{
           	if ( ((char *)getenv ("DBTABLES")) == NULL ||
                     ((char *)getenv ("DBM_DIR")) == NULL ||
                     ((char *)getenv ("RES_BASE_DIR")) == NULL )
	      		{
	      		printf ("\n");
	      		printf (
	    		"Environment variables for DBM database not defined, exiting...\n");
	      		printf ("Use %s/dbm_env to set the environment variables!\n", homepath);
	      		exit (-1);
	      		}
		}
	   else
	  /*
	   * Check the environment if ORACLE is used 
	   */
		{
		if ( (dbtables = (char *)getenv ("DBTABLES")) == NULL )
			{
	      		printf ("\n");
	      		printf (
	    		"Environment variables for ORACLE database not defined, exiting...\n");
	      		printf ("DBTABLES must be defined!\n");
	      		exit (-1);
			}
	   	if ( (dbhome = (char *)getenv ("DBHOME")) == NULL )
	      		{
	      		printf ("Environment variable DBHOME not defined, exiting...\n");
	      		exit (-1);
	      		}
		if ( (ora_sid = (char *)getenv("ORACLE_SID")) == NULL)
			{
			printf ("Environment variable ORACLE_SID not defined, exiting...\n");
			exit(-1);
			}
		if  ( (ora_home = (char *)getenv("ORACLE_HOME")) == NULL)
			{
			printf ("Environment variable ORACLE_HOME not defined, exiting...\n");
			exit(-1);
			}
	   /* Set the pathes and check them. */
	   	sprintf (oracle_server_path, "%s/bin/solaris", dbhome);
	   	if ( (fptr = fopen (oracle_server_path,"r")) == NULL )
	      		{
	      		printf ("DBHOME leads to a strange directory, exiting...\n");
	      		exit (-1);
	      		}
	   	else
	      		{
	      		fclose (fptr);
	      		}
		}
	   }
	else
           /*
            * Check the environment if RTDB database is used !!
            */

	   {
	   if ( (dbhome = (char *)getenv ("DBHOME")) == NULL )
	      {
	      printf ("Environment variable DBHOME not defined, exiting...\n");
	      exit (-1);
	      }

	   /* Set the pathes and check them. */
	   sprintf (rtdb_server_path, "%s/bin", dbhome);
	   if ( (fptr = fopen (rtdb_server_path,"r")) == NULL )
	      {
	      printf ("DBHOME leads to a strange directory, exiting...\n");
	      exit (-1);
	      }
	   else
	      {
	      fclose (fptr);
	      }

	   sprintf (db_path, "%s/setup", dbhome);
	   if ( (fptr = fopen (rtdb_server_path,"r")) == NULL )
	      {
	      printf ("DBHOME leads to a strange directory, exiting...\n");
	      exit (-1);
	      }
	   else
	      {
	      fclose (fptr);
	      }
	   }
#endif /* unix */


	/*
	 *  setup signal handling
	 */

#ifdef unix
	(void) signal(SIGQUIT, unreg_server);
	(void) signal(SIGTERM, unreg_server);
	(void) signal(SIGINT,  unreg_server);
	(void) signal(SIGPIPE, SIG_IGN);
	(void) signal(SIGHUP,  SIG_IGN);
	(void) signal(SIGCHLD, SIG_IGN);
#endif /* unix */

#ifdef _OSK
	intercept (unreg_server);
#endif /* _OSK */

#ifdef _OSK
	/*   because the normal kill command under OS9 can not
	 *    be caugth it makes live easier to unregister the manager
	 *   from the portmapper every time before startup.
	 *   Safty will be neglected because now it is possible
	 *   to start several managers on the same host.
	 */

	pmap_unset (NMSERVER_PROG, NMSERVER_VERS);
	pmap_unset (NMSERVER_PROG, NMSERVER_VERS_1);
#endif /* _OSK */


	/*
	 *   create server transport with udp protocol
	 */

	transp = svcudp_create(RPC_ANYSOCK);
	if (transp == NULL) 
		{
		fprintf(stderr, "cannot create udp service for manager.\n");
	        exit (-1);
		}

	if (!svc_register(transp, NMSERVER_PROG, NMSERVER_VERS_1, 
			  network_manager_1, IPPROTO_UDP)) 	
		{
		fprintf(stderr, "Unable to register network manager.\n");
		fprintf(stderr, "Program number 100 already in use?\n");
	        exit (-1);
		}

	if (!svc_register(transp, NMSERVER_PROG, NMSERVER_VERS, 
			  network_manager_4, IPPROTO_UDP)) 	
		{
		fprintf(stderr, "unable to register network manager\n");
		fprintf(stderr, "Program number 100 already in use?\n");
		pmap_unset (NMSERVER_PROG, NMSERVER_VERS_1);
	        exit (-1);
		}


	/*
	 *  delete old System.log and open a new
	 *  System.log file for writing system information
	 */
	
	sprintf (logfile, "%s/System.log", homepath);
	if ( (system_log = fopen (logfile, "w")) == NULL )
	   {
           fprintf (stderr,"cannot open System.log file, exiting...\n");
	   kill (pid,SIGQUIT);
	   }

	   /*
	    *  Start the database server on a remote host, if the
	    *  DBHOST environment variable is set and 
	    *  specifies not the local host.
	    */

	if ( strcmp (dbhost, nethost)     != 0 && 
	     strcmp (dbhost, "localhost") != 0 )
	   {
#ifdef unix
	   /*
	    *  startup database server on a remote host
	    */

	   if ( c_flags.rtdb == False )
	      {
	      if ( c_flags.oracle == False )
	      		{
	      /* DBM startup sequence */
#ifdef __hpux
	      		sprintf (db_start,
	      		"remsh %s -l dserver -n \"export %s/%s %s %s 1>&- 2>&- &\" ", dbhost, homepath, dbm_server, dbm_name, nethost);
#endif

#ifdef sun
	      		sprintf (db_start,
	      		"rsh %s -l dserver -n \"export %s/%s %s %s 1>&- 2>&- &\" ", dbhost, homepath, dbm_server, dbm_name, nethost);
#endif
	      		}
	      else
	      /* ORACLE startup sequence */
	      		{
#ifdef __hpux
	      		sprintf (db_start,
	      		"remsh %s -l dserver -n \"export DBTABLES=%s;export ORACLE_SID=%s;export ORACLE_HOME=%s;%s/%s %s %s 1>&- 2>&- &\" ", dbhost, dbtables, ora_sid, ora_home, oracle_server_path, ora_server, nethost, ora_name);
#endif

#ifdef sun
	      		sprintf (db_start,
	      		"rsh %s -l dserver -n \"export DBTABLES=%s;export ORACLE_SID=%s;export ORACLE_HOME=%s;%s/%s %s %s 1>&- 2>&- &\" ", dbhost, dbtables, ora_sid, ora_home, oracle_server_path, ora_server, nethost, ora_name);
#endif
			}
	      }
	    else
	      {
	    /* RTDB startup sequence */
#ifdef __hpux
	      sprintf (db_start,
	      "remsh %s -l dbase -n \"export %s=%s:%s/%s;%s/%s %s %s 1>&- 2>&- &\" ", dbhost, db_name, db_name, db_path, db_name, rtdb_server_path, db_server, db_name, nethost);
#endif

#ifdef sun
	      sprintf (db_start,
	      "rsh %s -l dbase -n \"export %s=%s:%s/%s;%s/%s %s %s 1>&- 2>&- &\" ", dbhost, db_name, db_name, db_path, db_name, rtdb_server_path, db_server, db_name, nethost);
#endif
	      }


	   res = system(db_start);
	   if ( res != 0 )
	      {
              fprintf (stderr,"database server startup failed, exiting...\n");
              fprintf (system_log,
		       "database server startup failed, exiting...\n");
	      kill (pid,SIGQUIT);
	      }
	   }

	else
	   {
           if (( db_pid = fork () ) < 0 )
              {
              fprintf (stderr,"database server startup failed, exiting...\n");
              fprintf (system_log,
		       "database server startup failed, exiting...\n");
              kill (pid,SIGQUIT);
              }

           if (!db_pid)
              {
	      if ( c_flags.rtdb == True )
	         {
	 	 /* Set environment */
                 sprintf (dbase_env, "%s=%s:%s/%s", db_name, db_name, 
		       db_path, db_name );
                 if ( putenv (dbase_env) != NULL )
                    {
                    fprintf (stderr,
                         "Cannot set environment variable %s, exiting...\n", 
		         db_name);
                    fprintf (system_log,
		      "Cannot set environment variable %s, exiting...\n",
		         db_name);
                    kill (pid,SIGQUIT);
                    }

	         /* Set path to executable */
                 sprintf (homedir, "%s/%s", rtdb_server_path, db_server);

		 /* Set arguments for execv */
                 i = 0;
                 cmd_argv[i] = db_server; i++;
                 cmd_argv[i] = db_name; i++;
                 cmd_argv[i] = nethost; i++;
                 cmd_argv[i] = 0;
		 }
	      else
		 {
		 /* Set path to DBM server */
                 sprintf (homedir, "%s/%s", homepath, dbm_server);

		 /* Set arguments for execv */
                 i = 0;
                 cmd_argv[i] = dbm_server; i++;
                 cmd_argv[i] = dbm_name; i++;
                 cmd_argv[i] = nethost; i++;
                 cmd_argv[i] = 0;
		 }

	      svc_destroy(transp); 
	      
              execv (homedir, cmd_argv);

              fprintf (stderr,"execv failed, database_server not started\n");
              fprintf (system_log,
		       "execv failed, database_server not started\n");
              kill (pid,SIGQUIT);
              }
	   }


	/*
	 *  startup message server
	 */

        if (( msg_pid = fork () ) < 0 )
	   {
           fprintf (stderr,"message server startup failed, exiting...\n");
           fprintf (system_log,
	     "message server startup failed, exiting...\n");
	   kill (pid,SIGQUIT);
	   }

	if (!msg_pid)
	   {
	   sprintf (homedir, "%s/MessageServer", homepath);
	   i = 0;
	   cmd_argv[i] = "MessageServer"; i++;
	   cmd_argv[i] = nethost; i++;
	   cmd_argv[i] = 0;

	   svc_destroy(transp); 

	   execv (homedir,cmd_argv);

      	   fprintf (stderr,"execv failed, message server not started\n");
      	   fprintf (system_log,"execv failed, message server not started\n");
 	   kill (pid,SIGQUIT);
	   }
#endif /* unix */

#ifdef _OSK
	   /*
	    *  Startup of the dummy database server
	    */

	{
	int  	os9forkc();
	extern char	**environ;
	int		db_pid = 0;

	sprintf (homedir, "%s/CMDS/os9_dbsu_server", dshome);
	i = 0;
	cmd_argv[i] = homedir; i++;
	cmd_argv[i] = 0;

	if ((db_pid = os9exec(os9forkc, cmd_argv[0], 
			      cmd_argv, environ,0,0,3)) <= 0)
    	   {
    	   fprintf (stderr,"os9exec failed, os9_dbsu-server not started\n");
    	   fprintf (system_log,
   	   "os9exec failed, os9_dbsu-server not started\n");
  	   kill (pid,SIGQUIT);
    	   }
 	}
#endif /* _OSK */

#ifdef _OSK
	   /*
	    *  Simulation of a normal message server startup
	    */

	   {
	   _register_data		register_data;
	   _msg_manager_data		*ret_data;

	   register_data.host_name   = "NULL";
	   register_data.prog_number = 0;
	   register_data.vers_number = 0;

	   ret_data = rpc_msg_register_1 (&register_data);
	   }
#endif /* _OSK */


	/*
	 * print network manager starttime to System.log
	 */

	time (&clock);
	time_string = ctime (&clock);
      	fprintf (system_log,"Network Manager started subprocesses at : %s",
	         time_string);
      	fprintf (system_log,"NETHOST = %s   PID = %d\n\n",nethost,pid);
	fclose (system_log);
	

	/*
	 *  point of no return
	 */
	
	svc_run();
	fprintf(stderr, "svc_run returned\n");
	kill (pid,SIGQUIT);
}

static void network_manager_4(rqstp, transp)
	struct svc_req *rqstp;
	SVCXPRT *transp;
{
	union 	{
		_register_data  	rpc_msg_register_4_arg;
		_register_data  	rpc_db_register_4_arg;
		_register_data  	rpc_get_config_4_arg;
		} argument;

	char *result;
	bool_t (*xdr_argument)(), (*xdr_result)();
	char *(*local)();

	switch (rqstp->rq_proc) 
	   {
	   case NULLPROC:
		svc_sendreply (transp, xdr_void, NULL);
		return;

	   case RPC_MSG_REGISTER:
		 xdr_argument = xdr__register_data;
		 xdr_result = xdr__msg_manager_data;
		 local = (char *(*)()) rpc_msg_register_1;
		 break;

	   case RPC_DB_REGISTER:
		 xdr_argument = xdr__register_data;
		 xdr_result = xdr_int;
		 local = (char *(*)()) rpc_db_register_1;
		 break;

	   case RPC_GET_CONFIG:
		   /*
 		    * Execute only if the startup is finished!
	            */
		   if ( c_flags.startup == True )
		      {
		      xdr_argument = xdr__register_data;
		      xdr_result = xdr__manager_data;
		      local = (char *(*)()) rpc_get_config_4;
		      break;
		      }
	           else
	              {
		      svcerr_noproc(transp);
		      return;
		      }

	   default:
		 svcerr_noproc(transp);
		 return;
	   }


	memset(&argument, 0, sizeof(argument));

	if (!svc_getargs(transp, xdr_argument, (char *) &argument)) 
		{
		svcerr_decode(transp);
		return;
		}

	result = (*local)(&argument, rqstp);
	if (result != NULL && !svc_sendreply (transp, xdr_result, result)) 
		{
		svcerr_systemerr(transp);
		}

	if (!svc_freeargs(transp, xdr_argument, (char *) &argument)) 
		{
		fprintf(stderr, "unable to free arguments\n");
		exit (-1);
		}

	startup_msg ();
}





static void network_manager_1(rqstp, transp)
	struct svc_req *rqstp;
	SVCXPRT *transp;
{
	union 	{
		_register_data  	rpc_msg_register_1_arg;
		_register_data  	rpc_db_register_1_arg;
		_register_data  	rpc_get_config_1_arg;
		} argument;

	char *result;
	bool_t (*xdr_argument)(), (*xdr_result)();
	char *(*local)();

	switch (rqstp->rq_proc) 
	   {
	   case NULLPROC:
		svc_sendreply (transp, xdr_void, NULL);
		return;

	   case RPC_MSG_REGISTER:
		 xdr_argument = xdr__register_data;
		 xdr_result = xdr__msg_manager_data;
		 local = (char *(*)()) rpc_msg_register_1;
		 break;

	   case RPC_DB_REGISTER:
		 xdr_argument = xdr__register_data;
		 xdr_result = xdr_int;
		 local = (char *(*)()) rpc_db_register_1;
		 break;

	   case RPC_GET_CONFIG:
		   /*
 		    * Execute only if the startup is finished!
	            */
		   if ( c_flags.startup == True )
		      {
		      xdr_argument = xdr__register_data;
		      xdr_result = xdr__manager_data_3;
		      local = (char *(*)()) rpc_get_config_4;
		      break;
		      }
	           else
	              {
		      svcerr_noproc(transp);
		      return;
		      }

	   default:
		 svcerr_noproc(transp);
		 return;
	   }


	memset(&argument, 0, sizeof(argument));

	if (!svc_getargs(transp, xdr_argument, (char *) &argument)) 
		{
		svcerr_decode(transp);
		return;
		}

	result = (*local)(&argument, rqstp);
	if (result != NULL && !svc_sendreply (transp, xdr_result, result)) 
		{
		svcerr_systemerr(transp);
		}

	if (!svc_freeargs(transp, xdr_argument, (char *) &argument)) 
		{
		fprintf(stderr, "unable to free arguments\n");
		exit (-1);
		}

	startup_msg ();
}



/****************************************************************
 *     Network Manager startup message                          *
 ****************************************************************/

static void startup_msg ()

{
	FILE	*system_log = NULL;
	char    *time_string;
	time_t	clock;


	if ( c_flags.startup == False )
	   {
	   if ( c_flags.msg_server == True && c_flags.db_server == True) 
		{
		c_flags.startup = True;
#ifdef unix
	        /*
	         *  Open the System.log file for writing system information
	         */
	
		if ( (system_log = fopen (logfile, "a")) != NULL )
	   	   {
		   time (&clock);
		   time_string = ctime (&clock);
      		   fprintf (system_log,
			    "Network Manager startup finished at : %s\n",
	         	    time_string);
		   fclose (system_log);
	   	   }
		else
	  	   {
           	   fprintf (stderr,"cannot open System.log file.\n");
		   }
		
#endif /* unix */
#ifdef _OSK
		printf (
		      "Database Dummy Server OK !\nNetwork Manager OK !\n");
#endif /* _OSK */
		}
	   }
}


