static char RcsId[] = "@(#)$Header: dc_mfrees.c,v 3.1 96/02/27 16:52:12 taurel Exp $";

/* $Log:	dc_mfrees.c,v $
 * Revision 3.1  96/02/27  16:52:12  16:52:12  taurel (Emmanuel TAUREL)
 * Ported to Solaris.
 * 
 * Revision 3.0  93/05/17  17:34:07  17:34:07  taurel (Emmanuel TAUREL)
 * Modified to port the dc system to SUN (without RTDB).
 * 
 * Revision 1.1  93/02/03  12:49:20  12:49:20  taurel (Emmanuel Taurel)
 * Initial revision
 *  */

#include <API.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <string.h>
#include <errno.h>

#include <dcP.h>

db_resource res1[] = {
	{"data_size",D_LONG_TYPE},
		};
int res1_size = sizeof(res1) / sizeof(db_resource);


/****************************************************************************
*                                                                           *
*		Code for dc_mfrees command                                  *
*                        ---------                                          *
*                                                                           *
*    Command rule : To give information about the data buffer memory.	    *
*		    This command prints the amout of free memory and the    *
*		    size of the largest free area.			    *
*                                                                           *
*    Synopsis : dc_mfrees 			               		    *
*                                                                           *
****************************************************************************/

void main(argc,argv)
int argc;
char *argv[];
{
	int shmid_alloc;
	char *shmadr_alloc;
	long error;
	unsigned int free,lfree;
	float free_f,lfree_f,data_f;
	int nb_area;
	char *tmp;
	unsigned int diff;
	static long dat_size;
	char hostna[32];
	char dev_name[40];
	int alloc_size;

/* Arguments number test */

	if(argc != 1) {
		fprintf(stderr,"dc_mfrees usage : dc_mfrees \n");
		exit(-1);
		}

/* Import static database */

	if (db_import(&error)) {
		printf("dc_mfrees : Can't import static database\n");
		printf("dc_mfrees : Check your NETHOST environment variable\n");
		exit(-1);
				}

/* Build device name. It is a function of the host name */

	gethostname(hostna,sizeof(hostna));
	if ((tmp = strchr(hostna,'.')) != NULL) {
		diff = (u_int)(tmp - hostna);
		hostna[diff] = 0;
						}
	strcpy(dev_name,"CLASS/DC/");
	strcat(dev_name,hostna);

/* Retrieve data collector memories size */

	dat_size = 0;
	res1[0].resource_adr = &dat_size;
	if (db_getresource(dev_name,res1,res1_size,&error)) {
		printf("dc_mfrees : Can't retrieve resources\n");
		printf("dc_mfrees : Error code : %d\n",error);
		exit(-1);
								  }
	if (dat_size == 0) {
		printf("dc_mfrees : Resource dat_size not defined\n");
		printf("dc_mfrees : Sorry but I exit !\n");
		exit(-1);
			   }

/* Compute allocation area size */

	alloc_size = (int)(dat_size / 256);

/* Attach the alloc area (it's a shared memory area) to this process data
   area */
 
	if ((shmid_alloc = shmget((key_t)KEY_ALLOC,(size_t)alloc_size,0666)) == -1) {
		if (errno == ENOENT)
			printf("Allocation area does not exist in memory !\n");
		else {
			printf("dc_mfrees : Can't get the allocation table\n");
			printf("dc_mfrees : Error code : %d\n",errno);
		     }
		exit(-1);
					}

	if ((shmadr_alloc = (char *)shmat(shmid_alloc,(char *)0,0)) == (char *)-1) {
		printf("dc_mfrees : Can't attach to the allocation area shred memory segment\n");
		printf("dc_mfrees : Error code : %d\n",errno);
		exit(-1);
					}

/* Call the memory function */

	if (dcmem_info(shmadr_alloc,alloc_size,&lfree,&free,&nb_area,&error)) {
		printf("dc_mfrees : Error %d during mem_info function !\n",error);
		exit(-1);
									}

/* Print the results */

	free_f = (float)free / 1024.0;
	lfree_f = (float)lfree / 1024.0;
	data_f = (float)dat_size / 1024.0;
	printf("Data buffer size :          %9.2f K-bytes\n",data_f);
	printf("Block size (in bytes) :         %d\n",BLOC_SIZE);
	printf("Current total free memory : %9.2f K-bytes\n",free_f);
	printf("Largest free area :         %9.2f K-bytes\n",lfree_f);
	printf("Number of free area(s) :         %d\n",nb_area);

}

