static char RcsId[] = "@(#)$Header: dc_devall.c,v 3.1 96/02/27 16:52:37 taurel Exp $";

/* $Log:	dc_devall.c,v $
 * Revision 3.1  96/02/27  16:52:37  16:52:37  taurel (Emmanuel TAUREL)
 * Ported to Solaris.
 * 
 * Revision 3.0  93/05/17  17:34:25  17:34:25  taurel (Emmanuel TAUREL)
 * Created during the port of dc system to SUN (without RTDB).
 *  */

#define _dc_h
#include <API.h>
#undef _dc_h
#include <dc.h>

#include <DevErrors.h>
#include <DevCmds.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

#include <dcP.h>

/* Some global variables */

DevVarStringArray host_dc;

db_resource res1[] = {
	{"host",D_VAR_STRINGARR,&host_dc},
		     };

int res1_size = sizeof(res1) / sizeof(db_resource);


/****************************************************************************
*                                                                           *
*		Code for dc_devall command                                  *
*                        ---------                                          *
*                                                                           *
*    Command rule : To display all the devices registered in the data       *
*		    collector						    *
*                                                                           *
*    Synopsis : dc_devall [-p]						    *
*                                                                           *
****************************************************************************/


main(argc,argv)
int argc;
char *argv[];
{
	int pseudo = False;
	int l;
	long error;

/* Argument test */

	if (argc < 1 || argc > 2) {
		fprintf(stderr,"dc_devall usage : dc_devall [-p]\n");
		exit(-1);
			}

/* Test the verbose option */

	if (argc == 2) {
		l = strlen(argv[1]);
		if (l != 2) {
			fprintf(stderr,"dc_devall usage : dc_devall [-p]\n");
			exit(-1);
			   }
		if (argv[1][0] == '-') {
			if (argv[1][1] == 'p')
				pseudo = True;
			else {
				fprintf(stderr,"dc_devall usage : dc_devall [-p]\n");
				exit(-1);
			      }
					}
		else {
			fprintf(stderr,"dc_devall usage : dc_devall [-p]\n");
			exit(-1);
			}
			}

/* Import static database */

	if (db_import(&error)) {
		fprintf(stderr,"dc_devall : Can't import static database\n");
		fprintf(stderr,"dc_devall : Check your NETHOST environment variable\n");
		exit(-1);
				}

/* Retrieve on which host the data collector is running */

	host_dc.length = 0;
	if (db_getresource("CLASS/DC/1",res1,res1_size,&error)) {
		fprintf(stderr,"dc_devall : Can't retrieve resources\n");
		fprintf(stderr,"dc_devall : Error code : %d\n",error);
		exit(-1);
								  }
	if (host_dc.length == 0) {
		fprintf(stderr,"dc_devall : Resource host not defined\n");
		fprintf(stderr,"dc_devall : Sorry, but I exit !\n");
		exit(-1);
				 }

	devall(pseudo);

}



/****************************************************************************
*                                                                           *
*		Code for devall  function                                   *
*                        ------                                             *
*                                                                           *
*    Function rule : To retrieve the name of all the registered devices and *
*		     print them						    *
*                                                                           *
*    Argin : - The pseudo devices only flag				    *
*                                                                           *
*    Argout : No argout                                                     *
*                                                                           *
****************************************************************************/

devall(pseudo)
int pseudo;
{
	long error;
	int i,j,k,l,ind;
	int tmp_ptr;
	char **dcall[10];
	int dev_numb[10];
	int nb_dc;
	int cptr = 0;
	char **devname_ptr;
	int *dev_host;
	db_devinf_imp *dev_imp_ptr;
	int tmp_ctr;

	nb_dc = host_dc.length;

/* Ask the dc_devall request on every host where a dc is running */

	for (i = 0;i < nb_dc;i++) {
		if (dc_devall(host_dc.sequence[i],&(dcall[i]),&(dev_numb[i]),&error)) {
			fprintf(stderr,"dc_devall : bad answer from %s\n",host_dc.sequence[i]);
			fprintf(stderr,"dc_devall : Sorry, but I exit\n");
			exit(-1);
								}
					   }

/* If the pseudo-device option has been requested by the user, for every
   device registered in the data collector, interrogate the static database
   to know if this device is a real one or a pseudo device */

	if (pseudo == True) {
	for (i = 0;i < nb_dc;i++) {
		tmp_ctr = dev_numb[i];
		dev_numb[i] = 0;
		l = 0;
		for(k = 0; k < tmp_ctr;k++) {
			if (db_dev_import(&(dcall[i][k]),&dev_imp_ptr,1,&error)) {
				if (error == DbErr_DeviceNotDefined) {
					strcpy(dcall[i][l++],dcall[i][k]);
					dev_numb[i]++;	
								     }
				else if (error == DbErr_DeviceNotExported) 
					continue;
				else {
					fprintf(stderr,"dc_devall : Error during static database request\n");
					fprintf(stderr,"dc_devall : Sorry, but I exit\n");
					}
									    }
			free(dev_imp_ptr);
						}
					}
			}

/* Compute the total number of devices defined */

	for (i = 0;i < nb_dc;i++)
		cptr = cptr + dev_numb[i];

/* Allocate memory for only one array with all the pointers to device name and
   for one array with the host associated with each devices */

	if ((devname_ptr = (char **)calloc(cptr,sizeof(char *))) == NULL) {
		fprintf(stderr,"dc_devall : Can't allocate memory\n");
		fprintf(stderr,"dc_devall : Sorry, but I exit\n");
		exit(-1);
								}
	if ((dev_host = (int *)calloc(cptr,sizeof(int))) == NULL) {
		fprintf(stderr,"dc_devall : Can't allocate memory\n");
		fprintf(stderr,"dc_devall : Sorry, but I exit\n");
		exit(-1);
								}
		
/* Build the array with all device name and the array with the associated
   host */

	ind = 0;
	for (i = 0;i < nb_dc;i++) {
		for (k = 0;k < dev_numb[i];k++) {
			devname_ptr[ind] = dcall[i][k];
			dev_host[ind++] = i;
						}
				  }

/* Sort the arrays */

	kern_sort_1(devname_ptr,dev_host,cptr);

/* Display the result */

	if (cptr == 0) {
		if (pseudo == True)
			printf("No pseudo devices are registered in the data collector\n");
		else
			printf("No devices are registered in the data collector\n");
			}
	else {
		if (pseudo == True)
			printf("The following %d pseudo devices are registered in the data collector :\n",cptr);
		else
			printf("The following %d devices are registered in the data collector :\n",cptr);
		for (i = 0;i < cptr;i++)
			printf("  %s on %s\n",devname_ptr[i],host_dc.sequence[dev_host[i]]);
	     }

}



/****************************************************************************
*                                                                           *
*		Code for kern_sort_1 function                               *
*                        -----------                                        *
*                                                                           *
*    Function rule : To sort an array of strings. The sort is done with the *
*		     strcmp function. The algorithm come from the famous    *
*	 	     Kernighan and Ritchie book (chapter 5)		    *
*                                                                           *
*    Argin : - The address of the array of strings pointers		    *
*	     - The number of elements in this array			    *
*                                                                           *
*    Argout : No argout                                                     *
*                                                                           *
****************************************************************************/
#ifdef __STDC__
kern_sort_1(char **tab,int *tab_num,int n)
#else
kern_sort(tab,tab_num,n)
char *tab[];
int *tab_num;
int n;
#endif /* __STDC__ */
{

	int gap,i,j;
	char *temp;
	int tmp;

	for (gap = n/2;gap > 0;gap /= 2) {
		for (i = gap;i < n;i++) {
			for (j = i - gap;j >=0; j -= gap) {
				if (strcmp(tab[j],tab[j + gap]) <= 0) 
					break;
				else {
					temp = tab[j];
					tab[j] = tab[j + gap];
					tab[j + gap] = temp;

					tmp = tab_num[j];
					tab_num[j] = tab_num[j + gap];
					tab_num[j + gap] = tmp;
					}
							}
					}
					}
}

