static char RcsId[]           = 
"@(#)$Header: DevServerSig.c,v 8.18 2000/11/12 13:24:03 goetz Rel $";

/*+*******************************************************************

 File:          DevServerSignal.c

 Project:       Device Servers with SUN-RPC

 Description:   Device server signal handling function ds__signal
		gives a unique signal handling interface in UNIX
		style for servers running under HPUX, SUN and OS9.

 Author(s):	Jens Meyer

 Original:	June 1991


 $Revision: 8.18 $
 $Date: 2000/11/12 13:24:03 $
 $Author: goetz $

 $Log:	DevServerSig.c,v $
 * Revision 8.18  2000/11/12  13:24:03  13:24:03  goetz (Andy Goetz)
 * added dynamic error handling; improved TANGO error treatment
 * 
 Revision 8.17  1900/09/26 13:36:37  goetz
 tango_dev_putget() and tango_dev_putget_raw() implement immediate reconnection

 * Revision 8.16  2000/09/25  14:50:16  14:50:16  goetz (Andy Goetz)
 * tango_api implements TANGO_HOST, stateless import and reimport
 * 
 * Revision 8.15  20/0./7.  1.:6.:9.  1.:6.:9.  goetz (Andy Goetz)
 * changed from tango database to host mysql, added support for float and double arrays
 * 
 * Revision 8.14  20/0./6.  2.:4.:0.  2.:4.:0.  goetz (Andy Goetz)
 * fixed bug in dev_event_listen() which caused server to crash
 * 
 Revision 8.13  2000/06/02 21:56:53  goetz
 _DEVICE_H now _TANGO_DEVICE_H in Device.H; (char*)taco_tango

 Revision 8.12  2000/06/02 15:58:11  goetz
 dev_event_fire() now device specific; ported to SuSE V6.4

 Revision 8.11  2000/05/31 07:47:58  goetz
 tango_api has local copies of argc and argv, ported to HP-UX

 * Revision 8.10  2000/05/29  21:39:24  21:39:24  goetz (Andrew GOETZ)
 * fixed prototyping problems with C++ on HP-UX
 * 
 * Revision 8.9  2000/05/29  18:13:33  18:13:33  goetz (Andrew GOETZ)
 * fixed bug in dev_import_timeout() which prevented timeouts < 2s
 * 
 Revision 8.8  2000/05/02 15:32:18  goetz
 added prototype for tsleep() for OS9 C++

 * Revision 8.7  2000/05/02  14:19:40  14:19:40  goetz (Andy Goetz)
 * removed check for device server running on different host
 * 
 * Revision 8.6  2000/05/02  13:29:33  13:29:33  goetz (Andy Goetz)
 * added random sleep to gettransient + 3 retries
 * 
 Revision 8.5  2000/03/27 17:13:45  goetz
 declared pmap_getmaps() as external C function for OS9 C++

 Revision 8.4  2000/03/13 14:50:02  goetz
 import timeout now programmable using dev_import_timeout()

 Revision 8.3  2000/03/13 10:31:35  goetz
 added Jens' modifications to fix bug in local putget

 Revision 8.2  2000/03/10 17:01:23  goetz
 dev_synch() now excludes udp clients and new imports

 Revision 8.1  2000/01/18 16:48:52  goetz
 tango_dev_import() now only called in dev_import if -DTANGO

 Revision 8.0  1999/12/28 14:18:31  goetz
 added TANGO support for TACO dev_xxx() calls via -DTANGO for C++

 Revision 7.10  1999/11/25 08:27:13  goetz
 replaced fprintf(stderr) with printf; made startup() C++ compatible

 Revision 7.9  1999/11/22 20:18:59  goetz
 removed const from gettransient() prototype

 Revision 7.8  1999/11/21 20:45:37  goetz
 included all M.Diehl's patches (major changes to gettransient() + main())

 Revision 7.7  1999/11/18 22:29:02  goetz
 fixed event multi-client bug, free client handle after event_listen, timeout in dev_synch()

 Revision 7.6  1999/11/01 19:05:16  goetz
 make local copy of user name returned by getpwuid() in sec_api.c

 Revision 7.5  1999/08/06 17:44:16  goetz
 removed usage of varargs for g++ on solaris and hpux

 * Revision 7.4  99/07/09  05:15:27  05:15:27  goetz (Andy Goetz)
 * added M.Diehl's patch to DevServerSig.c to exit() after calling unregister_server()
 * 
 Revision 7.3  1999/06/07 15:27:04  goetz
 fixed bug with multi-nethost reimport, device name stored with nethost

 Revision 7.2  1999/05/12 15:22:06  goetz
 changed dev_event_fire() to void; fixed bug in dev_event_unlisten()

 * Revision 7.1  99/05/11  15:59:54  15:59:54  goetz (Andy Goetz)
 * replace static declaration of event_client[] array by malloc()
 * 
 Revision 7.0  1999/04/26 07:30:45  goetz
 implemented user events (added event_api.c)

 Revision 6.15  1999/03/27 09:00:24  goetz
 asynch_cleanup() only checks for asynch clients; C++ returns output arguments if DS_WARNING

 * Revision 6.14  99/02/27  15:21:24  15:21:24  goetz (Andy Goetz)
 * fixed reimport bug; disabled reimport for rpc version 1
 * 
 Revision 6.13  1999/02/05 00:50:31  goetz
 fixed reimport socket+memory leak; ported to aCC on HPUX; suppressed rpc errors

 * Revision 6.12  99/01/18  21:39:08  21:39:08  goetz (Andy Goetz)
 * suppressed test for RPC_TIMEDOUT in svc_check()
 * 
 * Revision 6.11  99/01/14  23:14:58  23:14:58  goetz (Andy Goetz)
 * dbase timeout = 4 s; unregister ver. 1; svc_check() handles RPC_TIMEDOUT
 * 
 * Revision 6.10  98/12/22  10:29:50  10:29:50  taurel (E.Taurel)
 * Added support for Solaris and HP C++ native compiler. Remove K_R C support
 * 
 * Revision 6.9  98/12/15  14:05:11  14:05:11  goetz (Andy Goetz)
 * unregister RPC; use pgm no. 1 as flag; dev_pending() checks timeout; extern C prototype
 * 
 * Revision 6.8  98/11/20  14:35:39  14:35:39  goetz (Andy Goetz)
 * unregister API_VERSION (4) correctly now + check return value of svc_register()
 * 
 * Revision 6.7  98/11/20  10:35:06  10:35:06  goetz (Andy Goetz)
 * improved gettrans_ut(); multi-config_flags=0; removde static client_data; fixed linux select() bug; only register pgm # 0,4,5; portmap address == 111
 * 
 * Revision 6.6  98/09/24  09:25:13  09:25:13  goetz (Andy Goetz)
 * fixed stupid type which reintroduced asynchronous memory leak
 * 
 * Revision 6.5  98/08/26  16:20:37  16:20:37  goetz (Andy Goetz)
 * added dynamic NETHOST allocation, fixed bug in db_setup_multi, ported to Irix 6.4
 * 
 * Revision 6.4  98/04/29  10:21:26  10:21:26  goetz (Andy Goetz)
 * asynchronous - memory leak fixed, OS9 bug fixed, stale handle cleanup, pending=300
 * 
 * Revision 6.3  97/12/10  15:28:36  15:28:36  meyer (J.Meyer)
 * Changed select() timeout in rpc_check_host() to 200ms
 * 
 * Revision 6.2  97/12/01  12:59:19  12:59:19  goetz (Andy Goetz)
 * intermediate checkin before opening 5.14.1 branch
 * 
 * Revision 6.1  97/11/20  21:49:28  21:49:28  goetz (Andy Goetz)
 * main() continue even if cannot register asynch rpc
 * 
 * Revision 6.0  97/11/03  17:22:30  17:22:30  goetz (Andy Goetz)
 * merged synchronous and asynchronous branches
 * 
 Revision 5.15  1997/10/24 15:27:02  klotz
 ported to Windows NT 4.0 + NMSDK 5.0 ; tested with TextTalkds ; new DevServerMain.c

 * Revision 5.14  97/09/25  17:36:43  17:36:43  goetz (Andy Goetz)
 * fixed
 * 
 Revision 5.13  1997/09/03 17:34:36  meyer
 Added casting for ucc++ in DevServerSig.c

 * Revision 5.12  97/09/03  15:54:12  15:54:12  meyer (J.Meyer)
 * Changed OS9 signal handling from intercept() to signal().
 * 
 * Revision 5.11  97/08/05  14:19:31  14:19:31  goetz (Andy Goetz)
 * ported to VxWork 5.2, pgm. no. based on CRC, -m suppressed, -ve errors bug fix
 * 
 * Revision 5.10  97/03/14  17:26:12  17:26:12  dserver ()
 * fixed bug with open file handles after free
 * 
 * Revision 5.8.1.4  97/03/14  17:24:52  17:24:52  goetz (Andy Goetz)
 * fixed bug with open file handles after free
 * 
 * Revision 5.9  97/03/13  11:17:15  11:17:15  klotz (W.D. Klotz)
 * first part of NT4.0 port
 * 
 * Revision 5.8  97/01/31  12:06:24  12:06:24  goetz (Andy Goetz)
 * dev_protocol(), Linux+security bug fixes, dev_import() ignores timeout on NULL procedure, svc_run for OS9
 * 
 * Revision 5.7  97/01/14  08:57:20  08:57:20  goetz (Andy Goetz)
 * added stateless to dev_free(),_raw(),_asyn(),_protocol(),_timeout()
 * 
 * Revision 5.6  97/01/12  18:33:40  18:33:40  goetz (Andy Goetz)
 * dev_import() now stateless i.e. import works even if server is not running
 * 
 * Revision 5.5  97/01/08  17:02:29  17:02:29  goetz (Andy Goetz)
 * Ported to Linux (2.0.9)
 * 
 * Revision 5.4  96/11/27  09:58:15  09:58:15  goetz (Andy Goetz)
 * removed rpc admin interface from DevServerMain.c; putenv() suppressed for _UCC
 * 
 * Revision 5.3  96/11/26  16:24:41  16:24:41  goetz (Andy Goetz)
 * fixed bug (i_nethost=0) in dev_import_local()
 * 
 * Revision 5.2  96/11/26  13:31:04  13:31:04  goetz (Andy Goetz)
 * OICDevice (C++ wrapper for OIC) added + fixed multi-nethost memory leaks
 * 
 * Revision 5.1  96/11/04  11:00:07  11:00:07  goetz (Andy Goetz)
 * added multi nethost support
 * 
 * 

 Copyright (c) 1990-1997 by  European Synchrotron Radiation Facility,
			     Grenoble, France

*******************************************************************-*/

#include <signal.h>
#include <API.h>
#include <ApiP.h>
#include <DevServer.h>
#include <DevErrors.h>
#include <DevSignal.h>

#include <rpc/pmap_clnt.h>

/*
 *  table of signal handler pointers
 */

#ifdef __cplusplus
static void 	(*sig_tab [NUSIG])(int) = {(void (*)(int))SIG_DFL};
#else
static void 	(*sig_tab [NUSIG])() = {SIG_DFL};
#endif

/*
 * global external containing all device server config info
 */

extern configuration_flags config_flags;

/*+**********************************************************************
 Function   :  	extern long ds__signal()

 Description: 	A general device server signal handling interface for
		HPUX, SUN and OS9. Based on the UNIX way of treating
		signals.
		Activated signal handling funcion pointers are stored 
		in the global pointer table sig_tab.
		Actions like SIG_DFL and SIG_IGN are available for
		all systems.
		The related include file : DevSignal.h

 Arg(s) In  :	int sig          - signal
            :	void (*action)() - pointer to function that will be
				   called upon the receipt of signal sig.

 Arg(s) Out :   long *error - Will contain an appropriate error
			      code if the corresponding call
			      returns a non-zero value.

 Return(s)  :   DS_OK or DS_NOTOK
***********************************************************************-*/

#ifdef __cplusplus
long ds__signal (int sig, void (*action)(int), long *error)
#else
long ds__signal (int sig, void (*action)(), long *error)
#endif
{
	*error = 0;

	/*
	 *  check limits for valid signals
	 */

#if defined (unix)
	if ( sig<1 || sig>=NUSIG)
#elif defined(_NT)
	if ( sig<SIGINT || sig>=NUSIG)
#else
	if ( sig<0 || sig>=NUSIG)
#endif /* unix */
	   {
	   *error = DevErr_SignalOutOfRange;
	   return (-1);
	   }

	/*
	 *  store action in global table and acitvate
	 *  the handler.
	 */

	sig_tab[sig] 	= action;

	/*
	 *  check that the main quit signals will not be deactivated
	 */

#ifdef __cplusplus
	if ( action == (void (*)(int)) SIG_DFL || 
	     action == (void (*)(int))SIG_IGN)
#else
	if ( action == SIG_DFL || action == SIG_IGN)
#endif
	   {
	   if ( sig!=SIGHUP && sig!=SIGINT && sig!=SIGQUIT && sig!=SIGTERM )
	      {
#ifdef __cplusplus
	      if ( (void (*) (int)) signal (sig, action) == 
					   (void (*)(int)) SIG_ERR )
#else
	      if ( (void (*) (int)) signal (sig, action) == SIG_ERR )
#endif
		 {
	         *error = DevErr_CannotSetSignalHandler;
	         return (-1);
		 }
	      }
	   }
	else
	   {
	   /*
	    *  activate signal
	    */

#ifdef __cplusplus
	   if ( (void (*) (int)) signal (sig, main_signal_handler) == 
						(void (*)(int)) SIG_ERR )
#else
	   if ( (void (*) (int)) signal (sig, main_signal_handler) == SIG_ERR )
#endif
	      {
	      *error = DevErr_CannotSetSignalHandler;
	      return (-1);
	      }
	   }

	return (0);
}


/*+**********************************************************************
 Function   : 	extern void main_signal_handler ()

 Description:	A global device server signal handler which catches
		in any case all main quit/kill signals for a proper
		server exit and executes all other signal actions
		activated by  ds__signal() calls.

 Arg(s) In  :	int signo - signal

 Arg(s) Out : 	none

 Return(s)  :   DS_OK or DS_NOTOK
***********************************************************************-*/

void main_signal_handler (int signo)
{
	/*printf("main_signal_handler(): called with signo=%d ...\n",signo);*/

	/*
	 *  check limits for valid signals
	 */

#if defined (unix)
	if ( signo<1 || signo>=NUSIG)
#elif defined(_NT)
        if ( signo< SIGINT || signo>=NUSIG)
#else
	if ( signo<0 || signo>=NUSIG)
#endif /* unix */
	   {
	   return;
	   }
	
 	/*
	 *  call of internal device server signal handling function
	 *  related to signo.
	 */

#ifdef __cplusplus
	if ( sig_tab[signo] != (void (*) (int)) SIG_DFL && 
	     sig_tab[signo] != (void (*) (int)) SIG_IGN )
#else
	if ( sig_tab[signo] != (void (*) ()) SIG_DFL && 
	     sig_tab[signo] != (void (*) ()) SIG_IGN )
#endif
	   {
	   sig_tab[signo] (signo);
	   }

	/*
	 *  filter signals for quitting the server
	 */

#if defined (_NT)
	if (signo==SIGINT || signo==SIGTERM || signo==SIGABRT || 
	      signo==SIGBREAK)
#else
	if (signo==SIGQUIT || signo==SIGINT || signo==SIGHUP ||
	      signo==SIGTERM || signo==SIGABRT)
#endif /* _NT */
     	   {
      	   unregister_server ();
      	   /*
      	    * now we exit after returning from unregister_server()
      	    * this flawless change allows to use unregister_server() at
      	    * any instant without unwanted server exit - what a deal
      	    */
      	    
      	    exit(1);
	   }

	/* 
	 *  Set up signal handler again
	 */

	(void) signal (signo, main_signal_handler);
}


/*+**********************************************************************
 Function   :   extern void unregister_server()

 Description:   Unregisters the device server from the
		static database and the portmapper and
		closes open handles to database and messages
		services.

 Arg(s) In  :   none

 Arg(s) Out :   none

 Return(s)  :   none
***********************************************************************-*/

void unregister_server (void)
{
	long error = 0;


/*
 * if this is a bona fida device server then
 *
 *  unregister server from database device table
 */

	if (config_flags.device_server == True)
	{
   		if ( db_svc_unreg (config_flags.server_name,
			   	&error) < 0 )
	   	{
	   		dev_printerror_no (SEND,"db_svc_unreg failed",error);
	   	}		

	/*
	 *  destroy open client handles to message and database servers

	 	clnt_destroy (db_info.conf->clnt);
	 	clnt_destroy (msg_info.conf->clnt);
	 */

	/*
	 * unregister synchronous version (4) of server from portmapper
	 */
		pmap_unset (config_flags.prog_number, API_VERSION);
	}
	/*
 	 * unregister the asynchronous version (5) of the server from portmapper
 	 */
		pmap_unset (config_flags.prog_number, ASYNCH_API_VERSION);
	/*
	 *  finally unregister version (1) used by gettransient_ut()
	 */
		pmap_unset (config_flags.prog_number, DEVSERVER_VERS);
	
/*
 * returning here and calling exit() later from main_signal_handler() will
 * permit us to call unregister_server() from a different signal handler
 * and continue to do something useful afterwards
 *
 *	exit(1);
 */
}
