static char RcsId[] = "$Header: startup.C,v 1.2 95/07/28 13:11:34 goetz Exp $";

//+**********************************************************************
//
// File:	main.c
//
// Project:	Device Servers in C++
//
// Description:	main source code file for testing the device server base 
//		class in C++ (Device).
//
// Author(s):	Andy Goetz
//
// Original:	April 1995
//
// $Revision: 1.2 $
//
// $Date: 95/07/28 13:11:34 $
//
// $Author: goetz $
//
// $Log:	startup.C,v $
Revision 1.2  95/07/28  13:11:34  13:11:34  goetz (Andy Goetz)
checking in before I disappear into the African dust ...

// Revision 1.1  95/07/18  12:37:19  12:37:19  goetz (Andy Goetz)
// Initial revision
// 
//
//+**********************************************************************
		
#include <iostream.h>

#include <API.h>
#include <Device.H>
#include <DevServer.h>

extern "C" long startup(char *svr_name, long *error);

long startup(char *svr_name, long *error)
{
   Device *device;
   short state;
   long status;
   void *vargin, *vargout;

   printf ("startup++() program to test dserver++ (server name = %s)\n",svr_name);

//
// cannot instantiate Device class because it is an abstract class
//
// device = new Device("id/device++/1",error);
//

//
// test calling Device::State via Device::Command method
//
   device->Command(DevState, vargin, D_VOID_TYPE, vargout, D_SHORT_TYPE, error);

//
// export the device onto the network
//
   status = dev_export((char*)device->name,(Device*)device,(long*)error);

   printf("startup++() dev_export() returned %d (error = %d)\n",status,*error);

   return(DS_OK);
}
