static char RcsId[] = "$Header: db_servdel.cpp,v 6.0 98/08/14 10:58:34 taurel Rel $";

/* $Log:	db_servdel.cpp,v $
Revision 6.0  98/08/14  10:58:34  10:58:34  taurel (E.Taurel)
New utilities release which are server oriented
 */

/* TACO include file */

#include <API.h>

/* Include files */

#include <string.h>
#include <unistd.h>

#include <iostream.h>
#include <string>


/****************************************************************************
*                                                                           *
*		Code for db_servdel command                                 *
*                        ---------                                          *
*                                                                           *
*    Command rule : To delete all the devices and their resources from the  *
*		    database. 						    *
*                   The -r option is used if the user does not want device  *
*		    resources to be also deleted			    *
*                                                                           *
*    Synopsis : db_servdel [-r] <full server name>               	    *
*                                                                           *
****************************************************************************/


int main(int argc,char *argv[])
{
	long i;
	long error,res;
	long del_res = True;
	long opt = False;
	long errflag = False;
	extern int optopt;
	int c;

//
// Argument test and device name structure
//

	if ((argc < 2) || (argc > 3))
	{
		cerr << "db_servdel usage : db_servdel [-r] <full device server name>" << endl;
		exit(-1);
	}

	while ((c = getopt(argc,argv,"r")) != -1)
	{
		switch (c)
		{
		case 'r':
			del_res = False;
			opt = True;
			break;
			
		case '?':
			errflag = True;
			break;
		}
	}
	if (errflag == True)
	{
		cerr << "db_servdel usage : db_servdel [-r] <full device server name>" << endl;
		exit(-1);
	}

	string full_ds_name;
	if (opt == True)			
		full_ds_name = argv[2];
	else
		full_ds_name = argv[1];

#ifdef DEBUG
	cout  << "Full device server name : " << full_ds_name << endl;
#endif /* DEBUG */

	i = 0;
	NB_CHAR(i,full_ds_name.c_str(),'/');
	if (i != 1)
	{
		cerr << "db_servdel : Bad full device server name" << endl;
		exit(-1);
	}
	
//
// Extract device server and personal name from full device server
// name
//

	string::size_type pos,start;

	if ((pos = full_ds_name.find('/')) == string::npos)
	{
		cout << "db_servdel : Can't split full device server" << endl;
		exit(-1);
	}
	
	string ds_name(full_ds_name,0,pos);
	
	pos++;
	start = pos;	
	string pers_name(full_ds_name,start,full_ds_name.size() - start);
	
#ifdef DEBUG
	cout << "DS name : " << ds_name << endl;
	cout << "Pers. name : " << pers_name << endl;
#endif /* DEBUG */

//
// Connect to database server
//

	if (db_import(&error) == -1)
	{
		cerr << "db_devinfo : Impossible to connect to database server" << endl;
		exit(-1);
	}

//
// Ask database server to remove device
//

	res = db_servdelete(ds_name.c_str(),pers_name.c_str(),del_res,&error);	

//
// Display error message if the call fails
//

	if (res == -1)
	{
		if (error == DbErr_DeviceServerNotDefined)
		{
			cerr << "Server " << full_ds_name << " does not have any device in database" << endl;
		}
		else
		{
			cerr << "The call to database server failed with error " << error << endl;
			cerr << "Error message : " << dev_error_str(error) << endl;
		}
		exit(-1);
	}

}


