static char RcsId[] =
"@(#)$Header: /segfs/dserver/dev/system/xdr/src/RCS/haz_xdr.c,v 5.18 1999/07/08 14:10:46 goetz Rel $";

/*+*******************************************************************

 File:          haz_xdr.c

 Project:       Device Servers with sun-rpc

 Description:   xdr_routines for hazemeyer powersupply types.

 Author(s):     Jens Meyer

 Original:      January 1991

$Revision: 5.18 $
$Date: 1999/07/08 14:10:46 $

$Author: goetz $

$Log: haz_xdr.c,v $
Revision 5.18  1999/07/08 14:10:46  goetz
changed _LPfd_set type for Linux in macros.h

Revision 5.17  1998/05/25 17:59:37  klotz
fixed C++ prototypes in api_xdr.h

Revision 5.16  1998/04/29 10:23:59  goetz
macros.h - added __STDCPP__ for HP C++ compiler (aCC)

 * Revision 5.15  97/12/01  15:16:15  15:16:15  klotz (W.D. Klotz)
 * WIN_NT_95_released_NOV_97
 * 
 * Revision 4.34  97/01/30  13:58:35  13:58:35  goetz (Andy Goetz)
 * removed dev_printdebug() from DevXdrKernel.h
 * 
 * Revision 4.33  97/01/09  10:08:40  10:08:40  goetz (Andy Goetz)
 * (xdrproc_t) castings added to maxe_xdr, ram_xdr, thc_xdr, seism_xdr
 * 
 * Revision 4.32  97/01/08  16:48:28  16:48:28  goetz (Andy Goetz)
 * Ported to Linux (2.0.9)
 * 
Revision 4.31  1996/11/18 17:28:45  goetz
Check

 * Revision 4.28  96/10/21  16:22:18  16:22:18  taurel (E.Taurel)
 * Check_in_after_port_to_OS9/ISP_2.1_and_OS9/RPC1.4
 * 
 * Revision 4.27  96/09/17  16:40:03  16:40:03  klotz (W.D. Klotz)
 * WD Klotz: tested NT build  
 * 
 * Revision 4.26  96/07/19  10:00:59  10:00:59  taurel (E.Taurel)
 * Some_change_in_macros.h_for_the_API_port_to_OS-9_Ultra_C++
 * 
 * Revision 4.25  96/06/07  16:23:03  16:23:03  meyer (J.Meyer)
 * Corrected_elif_to_else_in_macros.h
 * 
 * Revision 4.24  96/06/05  15:01:36  15:01:36  meyer (J.Meyer)
 * Corrected_macros.h
 * 
 * Revision 4.23  96/06/03  13:10:15  13:10:15  meyer (J.Meyer)
 * Cleaned-up_MSDOS_and_added_porting_options_for_Windows_NT.
 * 
 * Revision 4.22  96/05/23  11:07:21  11:07:21  taurel (E.Taurel)
 * Added_some_definitions_for_C++_in_API_xdr.h_file
 * 
 * Revision 4.21  96/05/06  18:37:35  18:37:35  meyer (J.Meyer)
 * Fortran_compatibility_for:_dev_xdr.h,macros.h,maxe_xdr.h
 * 
 * Revision 4.20  96/02/27  13:31:35  13:31:35  meyer (J.Meyer)
 * Deleted_Cross_References_To_DSAPI_Library
 * 
 * Revision 4.19  96/01/11  17:40:20  17:40:20  meyer (Jens Meyer)
 * Added_#define_PORTMAP_to_macros.h.
 * 
 * Revision 4.18  95/12/21  10:33:26  10:33:26  meyer (Jens Meyer)
 * Corrected length calculation for D_VAR_MSTATARR.
 * 
 * Revision 4.17  95/08/02  16:05:12  16:05:12  meyer (Jens Meyer)
 * Corrected DevXdrKernel.h after C++ implementation.
 * 
 * Revision 4.15  95/03/02  10:27:49  10:27:49  meyer (Jens Meyer)
 * Added D_VAR_SFRPARR type to the kernel.
 * 
 * Revision 4.14  95/02/20  09:56:36  09:56:36  meyer (Jens Meyer)
 * Passed the compilers for HPUX, SUNOS and UCC after the first windows check in.
 * 
 * Revision 4.13  95/02/10  17:18:54  17:18:54  meyer (Jens Meyer)
 * Deleted
 * 
 * Revision 4.12  95/02/01  14:26:53  14:26:53  klotz (W.D. Klotz)
 * WDK: first successfull compile of dbase, api, xdr on WIN16/3.1
 * 
 * Revision 4.11  95/01/03  13:19:16  13:19:16  meyer (Jens Meyer)
 * Repared bug in dev_cmd_query() for version 3!
 * 
 * Revision 4.10  94/12/08  15:24:48  15:24:48  meyer (Jens Meyer)
 * Changed _manager_data in API_xdr and added old version to API_xdr_vers3.
 * 
 * Revision 4.9  94/11/28  17:04:09  17:04:09  meyer (Jens Meyer)
 * Data types for compatibility with library version 3.x
 * 
 * Revision 4.8  94/08/16  16:59:26  16:59:26  meyer (Jens Meyer)
 * Corrected error in ws_xdr.h
 * 
 * Revision 4.7  94/08/16  16:34:21  16:34:21  meyer (Jens Meyer)
 * Added define for MAX_RESOURCE_FIELD_LENGTH to macros.h
 * 
 * Revision 4.6  94/08/12  15:07:35  15:07:35  meyer (Jens Meyer)
 * Added valriable arguments to all API RPC structures.
 * 
 * Revision 4.5  94/07/20  18:15:37  18:15:37  meyer (Jens Meyer)
 * Changed include files in macros.h!
 * 
 * Revision 4.4  94/07/20  08:55:44  08:55:44  meyer (Jens Meyer)
 * All XDR functions with prototypes!
 * 
 * Revision 4.3  94/07/18  18:50:47  18:50:47  meyer (Jens Meyer)
 * Had to change macros.h, because #define must be in the first column!
 * 
 * Revision 4.2  94/07/18  18:22:11  18:22:11  meyer (Jens Meyer)
 * First test with PC macros for the XDR kernel.
 * 
 * Revision 4.1  94/05/02  10:50:40  10:50:40  meyer (Jens Meyer)
 * For Security System without connection count.
 * 
 * Revision 4.0  94/03/14  18:17:24  18:17:24  meyer (Jens Meyer)
 * Library version with Security System.
 * 
 * Revision 3.50  94/03/12  14:36:18  14:36:18  meyer (Jens Meyer)
 * Changed API xdr structures for security.
 * 
 * Revision 3.35  94/03/03  10:52:02  10:52:02  taurel (Emmanuel TAUREL)
 * Added unsigned long array type in the XDRkernel
 * 
 * Revision 3.34  94/03/03  10:28:55  10:28:55  taurel (Emmanuel TAUREL)
 * Added the unsigned long array type in
 * XDR kernel (LC and ET).
 * 
 * Revision 3.33  94/01/12  16:34:17  16:34:17  meyer (Jens Meyer)
 * Global XDR type array for data collector access
 * 
 * Revision 3.31  93/12/02  09:38:51  09:38:51  meyer (Jens Meyer)
 * New release with small XDR data type kernel.
 * 
 * Revision 1.1  93/11/15  11:05:03  11:05:03  meyer (Jens Meyer)
 * Initial revision
 * 

Copyright (c) 1990 by European Synchrotron Radiation Facility,
		      Grenoble, France

*******************************************************************-*/

#include <dev_xdr.h>
#include <haz_xdr.h>


bool_t
xdr_DevHazStatus(xdrs, objp)
	XDR *xdrs;
	DevHazStatus *objp;
{
	if (!xdr_char(xdrs, &objp->Power)) {
		return (FALSE);
	}
	if (!xdr_char(xdrs, &objp->Remote)) {
		return (FALSE);
	}
	if (!xdr_char(xdrs, &objp->Aux)) {
		return (FALSE);
	}
	if (!xdr_char(xdrs, &objp->Stat)) {
		return (FALSE);
	}
	if (!xdr_char(xdrs, &objp->Phase)) {
		return (FALSE);
	}
	if (!xdr_char(xdrs, &objp->Mains)) {
		return (FALSE);
	}
	if (!xdr_char(xdrs, &objp->PassivFilt)) {
		return (FALSE);
	}
	if (!xdr_char(xdrs, &objp->ActivFilt)) {
		return (FALSE);
	}
	if (!xdr_char(xdrs, &objp->Doors)) {
		return (FALSE);
	}
	if (!xdr_char(xdrs, &objp->Synchro)) {
		return (FALSE);
	}
	if (!xdr_char(xdrs, &objp->IMains)) {
		return (FALSE);
	}
	if (!xdr_char(xdrs, &objp->Loop)) {
		return (FALSE);
	}
	if (!xdr_char(xdrs, &objp->Waterflow)) {
		return (FALSE);
	}
	if (!xdr_char(xdrs, &objp->OverTemp)) {
		return (FALSE);
	}
	if (!xdr_char(xdrs, &objp->DCCTsat)) {
		return (FALSE);
	}
	if (!xdr_char(xdrs, &objp->OverVolt)) {
		return (FALSE);
	}
	if (!xdr_char(xdrs, &objp->OverCurrent)) {
		return (FALSE);
	}
	if (!xdr_char(xdrs, &objp->EarthFault)) {
		return (FALSE);
	}
	if (!xdr_char(xdrs, &objp->User1)) {
		return (FALSE);
	}
	if (!xdr_char(xdrs, &objp->User2)) {
		return (FALSE);
	}
	if (!xdr_char(xdrs, &objp->User3)) {
		return (FALSE);
	}
	if (!xdr_char(xdrs, &objp->Transformer)) {
		return (FALSE);
	}
	if (!xdr_char(xdrs, &objp->TOilTemp)) {
		return (FALSE);
	}
	return (TRUE);
}


long
xdr_length_DevHazStatus(objp)
        DevHazStatus *objp;
        {
        long  length = 0;

        length = length + xdr_length_DevChar (&objp->Power);
        length = length + xdr_length_DevChar (&objp->Remote);
        length = length + xdr_length_DevChar (&objp->Aux);
        length = length + xdr_length_DevChar (&objp->Stat);
        length = length + xdr_length_DevChar (&objp->Phase);
        length = length + xdr_length_DevChar (&objp->Mains);
        length = length + xdr_length_DevChar (&objp->PassivFilt);
        length = length + xdr_length_DevChar (&objp->ActivFilt);
        length = length + xdr_length_DevChar (&objp->Doors);
        length = length + xdr_length_DevChar (&objp->Synchro);
        length = length + xdr_length_DevChar (&objp->IMains);
        length = length + xdr_length_DevChar (&objp->Loop);
        length = length + xdr_length_DevChar (&objp->Waterflow);
        length = length + xdr_length_DevChar (&objp->OverTemp);
        length = length + xdr_length_DevChar (&objp->DCCTsat);
        length = length + xdr_length_DevChar (&objp->OverVolt);
        length = length + xdr_length_DevChar (&objp->OverCurrent);
        length = length + xdr_length_DevChar (&objp->EarthFault);
        length = length + xdr_length_DevChar (&objp->User1);
        length = length + xdr_length_DevChar (&objp->User2);
        length = length + xdr_length_DevChar (&objp->User3);
        length = length + xdr_length_DevChar (&objp->Transformer);
        length = length + xdr_length_DevChar (&objp->TOilTemp);

        return (length);
}


