static char RcsId[] =
"@(#)$Header: daemon_xdr.c,v 4.13 95/02/10 17:18:59 meyer Rel $";

/*+*******************************************************************

 File:          daemon_xdr.c

 Project:       Device Servers with sun-rpc

 Description:   xdr_routines for update daemon types.

 Author(s):     Jens Meyer

 Original:      July 1992

$Revision: 4.13 $
$Date: 95/02/10 17:18:59 $

$Author: meyer $

$Log:	daemon_xdr.c,v $
 * Revision 4.13  95/02/10  17:18:59  17:18:59  meyer (J.Meyer)
 * Deleted
 * 
 * Revision 4.12  95/02/01  14:26:49  14:26:49  klotz (W.D. Klotz)
 * WDK: first successfull compile of dbase, api, xdr on WIN16/3.1
 * 
 * Revision 4.11  95/01/03  13:19:20  13:19:20  meyer (Jens Meyer)
 * Repared bug in dev_cmd_query() for version 3!
 * 
 * Revision 4.10  94/12/08  15:24:51  15:24:51  meyer (Jens Meyer)
 * Changed _manager_data in API_xdr and added old version to API_xdr_vers3.
 * 
 * Revision 4.9  94/11/28  17:04:13  17:04:13  meyer (Jens Meyer)
 * Data types for compatibility with library version 3.x
 * 
 * Revision 4.8  94/08/16  16:59:29  16:59:29  meyer (Jens Meyer)
 * Corrected error in ws_xdr.h
 * 
 * Revision 4.7  94/08/16  16:34:25  16:34:25  meyer (Jens Meyer)
 * Added define for MAX_RESOURCE_FIELD_LENGTH to macros.h
 * 
 * Revision 4.6  94/08/12  15:07:39  15:07:39  meyer (Jens Meyer)
 * Added valriable arguments to all API RPC structures.
 * 
 * Revision 4.5  94/07/20  18:15:41  18:15:41  meyer (Jens Meyer)
 * Changed include files in macros.h!
 * 
 * Revision 4.4  94/07/20  08:55:40  08:55:40  meyer (Jens Meyer)
 * All XDR functions with prototypes!
 * 
 * Revision 4.3  94/07/18  18:50:50  18:50:50  meyer (Jens Meyer)
 * Had to change macros.h, because #define must be in the first column!
 * 
 * Revision 4.2  94/07/18  18:22:07  18:22:07  meyer (Jens Meyer)
 * First test with PC macros for the XDR kernel.
 * 
 * Revision 4.1  94/05/02  10:50:44  10:50:44  meyer (Jens Meyer)
 * For Security System without connection count.
 * 
 * Revision 4.0  94/03/14  18:17:29  18:17:29  meyer (Jens Meyer)
 * Library version with Security System.
 * 
 * Revision 3.50  94/03/12  14:36:22  14:36:22  meyer (Jens Meyer)
 * Changed API xdr structures for security.
 * 
 * Revision 3.35  94/03/03  10:52:06  10:52:06  taurel (Emmanuel TAUREL)
 * Added unsigned long array type in the XDRkernel
 * 
 * Revision 3.34  94/03/03  10:28:58  10:28:58  taurel (Emmanuel TAUREL)
 * Added the unsigned long array type in
 * XDR kernel (LC and ET).
 * 
 * Revision 3.33  94/01/12  16:34:21  16:34:21  meyer (Jens Meyer)
 * Global XDR type array for data collector access
 * 
 * Revision 3.31  93/12/02  09:38:55  09:38:55  meyer (Jens Meyer)
 * New release with small XDR data type kernel.
 * 
 * Revision 1.1  93/11/16  10:55:11  10:55:11  meyer (Jens Meyer)
 * Initial revision
 * 

Copyright (c) 1990 by European Synchrotron Radiation Facility,
		      Grenoble, France

*******************************************************************-*/

#include <dev_xdr.h>
#include <daemon_xdr.h>

bool_t
xdr_DevDaemonStatus(xdrs, objp)
	XDR *xdrs;
	DevDaemonStatus *objp;
{
	if (!xdr_char(xdrs, &objp->BeingPolled)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->PollFrequency)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->TimeLastPolled)) {
		return (FALSE);
	}
	if (!xdr_char(xdrs, &objp->PollMode)) {
		return (FALSE);
	}
	if (!xdr_char(xdrs, &objp->DeviceAccessError)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->ErrorCode)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->LastCommandStatus)) {
		return (FALSE);
	}
	if (!xdr_char(xdrs, &objp->ContinueAfterError)) {
		return (FALSE);
	}
	return (TRUE);
}

long
xdr_length_DevDaemonStatus(objp)
        DevDaemonStatus *objp;
        {
        long  length = 0;

        length = length + xdr_length_DevChar (&objp->BeingPolled);
        length = length + xdr_length_DevLong (&objp->PollFrequency);
        length = length + xdr_length_DevLong (&objp->TimeLastPolled);
        length = length + xdr_length_DevChar (&objp->PollMode);
        length = length + xdr_length_DevChar (&objp->DeviceAccessError);
        length = length + xdr_length_DevLong (&objp->ErrorCode);
        length = length + xdr_length_DevLong (&objp->LastCommandStatus);
        length = length + xdr_length_DevChar (&objp->ContinueAfterError);

        return (length);
}



bool_t
xdr_DevDaemonData(xdrs, objp)
	XDR *xdrs;
	DevDaemonData *objp;
{
	if (!xdr_long(xdrs, &objp->ddid)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->long_data)) {
		return (FALSE);
	}
	if (!xdr_string(xdrs, &objp->string_data, ~0)) {
		return (FALSE);
	}

	return (TRUE);
}

long
xdr_length_DevDaemonData(objp)
        DevDaemonData *objp;
        {
        long  length = 0;

        length = length + xdr_length_DevLong (&objp->ddid);
        length = length + xdr_length_DevLong (&objp->long_data);
        length = length + xdr_length_DevString (&objp->string_data);

        return (length);
}
