
static char RcsId[] =
"@(#)$Header: /segfs/dserver/dev/system/xdr/src/RCS/api_xdr.c,v 5.18 1999/07/08 14:10:46 goetz Rel $";
/*+*******************************************************************

 File:          api_xdr.c

 Project:       Device Servers with sun-rpc

 Description:   xdr_routines for API-library functions.

 Author(s): 	Jens Meyer

 Original:      January 1991


$Revision: 5.18 $
$Date: 1999/07/08 14:10:46 $

$Author: goetz $

$Log: api_xdr.c,v $
Revision 5.18  1999/07/08 14:10:46  goetz
changed _LPfd_set type for Linux in macros.h

Revision 5.17  1998/05/25 17:59:33  klotz
fixed C++ prototypes in api_xdr.h

Revision 5.16  1998/04/29 10:23:55  goetz
macros.h - added __STDCPP__ for HP C++ compiler (aCC)

 * Revision 5.15  97/12/01  15:16:01  15:16:01  klotz (W.D. Klotz)
 * WIN_NT_95_released_NOV_97
 * 
 * Revision 4.34  97/01/30  13:58:32  13:58:32  goetz (Andy Goetz)
 * removed dev_printdebug() from DevXdrKernel.h
 * 
 * Revision 4.33  97/01/09  10:08:37  10:08:37  goetz (Andy Goetz)
 * (xdrproc_t) castings added to maxe_xdr, ram_xdr, thc_xdr, seism_xdr
 * 
 * Revision 4.32  97/01/08  16:48:26  16:48:26  goetz (Andy Goetz)
 * Ported to Linux (2.0.9)
 * 
Revision 4.31  1996/11/18 17:28:42  goetz
Check

 * Revision 4.28  96/10/21  16:22:13  16:22:13  taurel (E.Taurel)
 * Check_in_after_port_to_OS9/ISP_2.1_and_OS9/RPC1.4
 * 
 * Revision 4.27  96/09/17  16:39:41  16:39:41  klotz (W.D. Klotz)
 * WD Klotz: tested NT build  
 * 
 * Revision 4.26  96/07/19  10:00:55  10:00:55  taurel (E.Taurel)
 * Some_change_in_macros.h_for_the_API_port_to_OS-9_Ultra_C++
 * 
 * Revision 4.25  96/06/07  16:23:01  16:23:01  meyer (J.Meyer)
 * Corrected_elif_to_else_in_macros.h
 * 
 * Revision 4.24  96/06/05  15:01:32  15:01:32  meyer (J.Meyer)
 * Corrected_macros.h
 * 
 * Revision 4.23  96/06/03  13:10:13  13:10:13  meyer (J.Meyer)
 * Cleaned-up_MSDOS_and_added_porting_options_for_Windows_NT.
 * 
 * Revision 4.22  96/05/23  11:07:16  11:07:16  taurel (E.Taurel)
 * Added_some_definitions_for_C++_in_API_xdr.h_file
 * 
 * Revision 4.21  96/05/06  18:37:32  18:37:32  meyer (J.Meyer)
 * Fortran_compatibility_for:_dev_xdr.h,macros.h,maxe_xdr.h
 * 
 * Revision 4.20  96/02/27  13:31:33  13:31:33  meyer (J.Meyer)
 * Deleted_Cross_References_To_DSAPI_Library
 * 
 * Revision 4.19  96/01/11  17:40:18  17:40:18  meyer (Jens Meyer)
 * Added_#define_PORTMAP_to_macros.h.
 * 
 * Revision 4.18  95/12/21  10:33:21  10:33:21  meyer (Jens Meyer)
 * Corrected length calculation for D_VAR_MSTATARR.
 * 
 * Revision 4.17  95/08/02  16:05:09  16:05:09  meyer (Jens Meyer)
 * Corrected DevXdrKernel.h after C++ implementation.
 * 
 * Revision 4.15  95/03/02  10:27:44  10:27:44  meyer (Jens Meyer)
 * Added D_VAR_SFRPARR type to the kernel.
 * 
 * Revision 4.14  95/02/20  09:56:29  09:56:29  meyer (Jens Meyer)
 * Passed the compilers for HPUX, SUNOS and UCC after the first windows check in.
 * 
 * Revision 4.13  95/02/10  17:18:48  17:18:48  meyer (Jens Meyer)
 * Deleted
 * 
 * Revision 4.12  95/02/01  14:26:38  14:26:38  klotz (W.D. Klotz)
 * WDK: first successfull compile of dbase, api, xdr on WIN16/3.1
 * 
 * Revision 4.11  95/01/03  13:19:10  13:19:10  meyer (Jens Meyer)
 * Repared bug in dev_cmd_query() for version 3!
 * 
 * Revision 4.10  94/12/08  15:24:42  15:24:42  meyer (Jens Meyer)
 * Changed _manager_data in API_xdr and added old version to API_xdr_vers3.
 * 
 * Revision 4.9  94/11/28  17:04:04  17:04:04  meyer (Jens Meyer)
 * Data types for compatibility with library version 3.x
 * 
 * Revision 4.8  94/08/16  16:59:22  16:59:22  meyer (Jens Meyer)
 * Corrected error in ws_xdr.h
 * 
 * Revision 4.7  94/08/16  16:34:17  16:34:17  meyer (Jens Meyer)
 * Added define for MAX_RESOURCE_FIELD_LENGTH to macros.h
 * 
 * Revision 4.6  94/08/12  15:07:31  15:07:31  meyer (Jens Meyer)
 * Added valriable arguments to all API RPC structures.
 * 
 * Revision 4.5  94/07/20  18:15:34  18:15:34  meyer (Jens Meyer)
 * Changed include files in macros.h!
 * 
 * Revision 4.4  94/07/20  08:55:31  08:55:31  meyer (Jens Meyer)
 * All XDR functions with prototypes!
 * 
 * Revision 4.3  94/07/18  18:50:43  18:50:43  meyer (Jens Meyer)
 * Had to change macros.h, because #define must be in the first column!
 * 
 * Revision 4.2  94/07/18  18:21:57  18:21:57  meyer (Jens Meyer)
 * First test with PC macros for the XDR kernel.
 * 
 * Revision 4.1  94/05/02  10:50:36  10:50:36  meyer (Jens Meyer)
 * For Security System without connection count.
 * 
 * Revision 4.0  94/03/14  18:17:20  18:17:20  meyer (Jens Meyer)
 * Library version with Security System.
 * 
 * Revision 3.50  94/03/12  14:36:14  14:36:14  meyer (Jens Meyer)
 * Changed API xdr structures for security.
 * 
 * Revision 3.35  94/03/03  10:51:58  10:51:58  taurel (Emmanuel TAUREL)
 * Added unsigned long array type in the XDRkernel
 * 
 * Revision 3.34  94/03/03  10:28:51  10:28:51  taurel (Emmanuel TAUREL)
 * Added the unsigned long array type in
 * XDR kernel (LC and ET).
 * 
 * Revision 3.33  94/01/12  16:34:13  16:34:13  meyer (Jens Meyer)
 * Global XDR type array for data collector access
 * 
 * Revision 3.31  93/12/02  09:38:34  09:38:34  meyer (Jens Meyer)
 * New release with small XDR data type kernel.
 * 
 * Revision 1.1  93/11/10  15:36:57  15:36:57  meyer (Jens Meyer)
 * Initial revision
 * 
 * Revision 3.24  93/10/29  17:03:35  17:03:35  meyer (Jens Meyer)
 * Added length calculation for Rad. Monitor types
 * 
 * Revision 3.23  93/10/13  12:58:03  12:58:03  meyer (Jens Meyer)
 * Changed structures in pin_xdr.*
 * 
 * Revision 3.22  93/08/25  09:40:03  09:40:03  meyer (Jens Meyer)
 * Length calculation of D_VAR_MSTATARR was deleted in revision 3.14
 * 
 * Revision 3.21  93/06/25  11:16:06  11:16:06  meyer (Jens Meyer)
 * Corrected bug in BPM length calculation
 * 
 * Revision 3.20  93/06/24  18:10:20  18:10:20  meyer (Jens Meyer)
 * BPM XDR-length calculation
 * 
 * Revision 3.17  93/06/24  18:08:16  18:08:16  meyer (Jens Meyer)
 * New Pinhole XDR Types.
 * 
 * Revision 3.16  93/06/07  09:04:51  09:04:51  meyer (Jens Meyer)
 * Added GRP xdr types.
 * 
 * Revision 3.15  93/06/04  14:12:22  14:12:22  domingue ( Marie-Christine Dominguez)
 * Changed m4_xdr types.
 * 
 * Revision 3.14  93/05/27  12:59:01  12:59:01  meyer (Jens Meyer)
 * Added m4_xdr types and corrected icv101_xdr.
 * 
 * Revision 3.13  93/05/13  11:13:57  11:13:57  taurel (Emmanuel TAUREL)
 * Fix bug in daemon_data xdr function
 * 
 * Revision 3.12  93/04/28  08:28:29  08:28:29  meyer (Jens Meyer)
 * Added length calculation for BPSS structures
 * 
 * Revision 3.11  93/03/11  16:53:17  16:53:17  meyer (Jens Meyer)
 * Corrected length calculation for D_VAR_MSTATARR
 * 
 * Revision 3.10  93/03/10  08:44:50  08:44:50  meyer (Jens Meyer)
 * Added new type D_VAR_MSTATARR.
 * 

 Copyright (c) 1990 by European Synchrotron Radiation Facility,
		       Grenoble, France

*******************************************************************-*/

#include <DevXdrKernel.h>
#include <macros.h>

/*
 * Xdr_routines for variable argument passing for API calls.
 * Will avoid recompilation of the system when adding variables.
 */

bool_t
xdr_DevVarArgument (xdrs, objp)
	XDR *xdrs;
	DevVarArgument *objp;
{
        DevDataListEntry        data_type;
        long                    error;

        if (!xdr_long(xdrs, &objp->argument_type)) {
                return (FALSE);
        }

        /*
         * Get the XDR data type from the loaded type list
         */

        if ( xdr_get_type(objp->argument_type, &data_type, &error) == DS_NOTOK)
           {
		   char msg[512];
		   sprintf(msg,"xdr_DevVarArgument() : error = %d", error);
#ifdef _NT
		   PRINTF(msg);
#else
		   fprintf (stderr, "%s\n", msg);
#endif
           return (FALSE);
           }

        if (!xdr_pointer(xdrs, (char **)&objp->argument,
                         data_type.size,
                         (xdrproc_t)data_type.xdr )) {
                return (FALSE);
        }
	return (TRUE);
}


bool_t
xdr_DevVarArgumentArray(xdrs, objp)
        XDR *xdrs;
        DevVarArgumentArray *objp;
{
        if (!xdr_array(xdrs, (caddr_t *)&objp->sequence,
            (u_int *)&objp->length, MAXU_INT, sizeof(DevVarArgument), 
	    (xdrproc_t)xdr_DevVarArgument)) {
                return (FALSE);
        }
        return (TRUE);
}


/*
 *  xdr_routines for data structures used in the dev_putget(),
 *  dev_put() and dev_putget_raw() calls.
 */


bool_t
xdr__server_data(xdrs, objp)
	XDR *xdrs;
	_server_data *objp;
{
	DevDataListEntry	data_type;
	long			error;	

	if (!xdr_long(xdrs, &objp->ds_id)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->cmd)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->argin_type)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->argout_type)) {
		return (FALSE);
	}

	/*
	 * Get the XDR data type from the loaded type list
	 */

	if ( xdr_get_type(objp->argin_type, &data_type, &error) == DS_NOTOK)
	   {
	   char msg[512];
	   sprintf (msg, "xdr__server_data() : error = %d", error);
#ifdef _NT
	   PRINTF(msg);
#else
	   fprintf (stderr, "%s\n", msg);
#endif
	   return (FALSE);
	   }

	if (!xdr_pointer(xdrs, (char **)&objp->argin, 
			 data_type.size,
			 (xdrproc_t)data_type.xdr )) {
		return (FALSE);
  	}

	if (!xdr_long(xdrs, &objp->access_right)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->client_id)) {
		return (FALSE);
	}
        if (!xdr_DevVarArgumentArray(xdrs, &objp->var_argument)) {
                return (FALSE);
        }
 	return (TRUE);
}


bool_t
xdr__client_data(xdrs, objp)
	XDR *xdrs;
	_client_data *objp;
{
	DevDataListEntry	data_type;
	long			error;	

	if (!xdr_long(xdrs, &objp->status)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->error)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->argout_type)) {
		return (FALSE);
	}

	/*
	 * Get the XDR data type from the loaded type list
	 */

	if ( xdr_get_type(objp->argout_type, &data_type, &error) == DS_NOTOK)
	   {
	   char msg[512];
	   sprintf (msg, "xdr__client_data() : error = %d", error);
#ifdef _NT
	   PRINTF(msg);
#else
	   fprintf (stderr, "%s\n", msg);
#endif

	   objp->argout   = NULL;
	   data_type.size = 0;
	   data_type.xdr  = (DevDataFunction)xdr_void;
	   }

	if (!xdr_pointer(xdrs, (char **)&objp->argout,
			 data_type.size,
			 (xdrproc_t)data_type.xdr )) {
	  	return (FALSE);
	}

        if (!xdr_DevVarArgumentArray(xdrs, &objp->var_argument)) {
                return (FALSE);
        }
  	return (TRUE);
}



/*
 *  xdr function used by dev_putget_raw to decode return
 *  arguments of a device server in raw opaque format.
 */

bool_t
xdr__client_raw_data(xdrs, objp)
	XDR *xdrs;
	_client_raw_data *objp;
{
	DevOpaque 		*opaque;
	DevDataListEntry	data_type;
	long			error;	

	if (!xdr_long(xdrs, &objp->status)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->error)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->deser_argout_type)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->xdr_length)) {
		return (FALSE);
	}
	/*  On the server side encode the data with the data
	 *  type specified for the command as return argument.
	 */
	if ( xdrs->x_op == XDR_ENCODE )
	   {
	   /*
	    * Get the XDR data type from the loaded type list
	    */

	   if ( xdr_get_type(objp->ser_argout_type, &data_type, &error) 
		== DS_NOTOK)
	      {
		  char msg[512];
	      sprintf (msg, "xdr__client_raw_data() : error = %d", error);
#ifdef _NT
		  PRINTF(msg);
#else
	      fprintf (stderr, "%s\n", msg);
#endif
	      return (FALSE);
	      }

	   if (!xdr_pointer(xdrs, (char **)&objp->argout,
			    data_type.size,
			    (xdrproc_t)data_type.xdr )) {
	  	   return (FALSE);
	   }
	   }
	else
	   {
	   /*
	    *  On the client side decode the arguments as a
	    *  stream of bytes with the length calculated
	    * on the server side (xdr_length).
	    */

	   /*
	    * Get the XDR data type from the loaded type list
	    */

	   if ( xdr_get_type(objp->deser_argout_type, &data_type, &error) 
		== DS_NOTOK)
	      {
		  char msg[512];
	      sprintf (msg, "xdr__client_raw_data() : error = %d", error);
#ifdef _NT
		  PRINTF(msg);
#else
	      fprintf (stderr, "%s\n", msg);
#endif
	      return (FALSE);
	      }

	   opaque = (DevOpaque *)objp->argout;
	   opaque->length       = objp->xdr_length;

	   if (!xdr_pointer(xdrs, (char **)&objp->argout,
			    data_type.size,
		  	    (xdrproc_t)xdr_DevOpaqueRaw )) {
	  	   return (FALSE);
	   }
	   }

        if (!xdr_DevVarArgumentArray(xdrs, &objp->var_argument)) {
                return (FALSE);
        }
  	return (TRUE);
}


bool_t
xdr_DevOpaqueRaw(xdrs, objp)
	XDR *xdrs;
	DevOpaque *objp;
{
	if (xdrs->x_op == XDR_FREE)
	   {
	   free (objp->sequence);
	   }

	if (objp->sequence == 0)
	   {
	   objp->sequence = (char *)malloc (objp->length);
	   }

	if (!xdr_opaque(xdrs, (caddr_t)objp->sequence, objp->length)) {
		   return (FALSE);
	}
	return (TRUE);
}




/*
 *  internal xdr_routines for device service  
 */

bool_t
xdr__dev_import_in(xdrs, objp)
	XDR *xdrs;
	_dev_import_in *objp;
{
        if (!xdr_string(xdrs, &objp->device_name, MAXU_INT)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->access_right)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->client_id)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->connection_id)) {
		return (FALSE);
	}
	if (!xdr_DevVarArgumentArray(xdrs, &objp->var_argument)) {
		return (FALSE);
	}
	return (TRUE);
}


bool_t
xdr__dev_import_out(xdrs, objp)
	XDR *xdrs;
	_dev_import_out *objp;
{
        if (!xdr_opaque(xdrs, (caddr_t)objp->server_name, LONG_NAME_SIZE)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->ds_id)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->status)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->error)) {
		return (FALSE);
	}
	if (!xdr_DevVarArgumentArray(xdrs, &objp->var_argument)) {
		return (FALSE);
	}
	return (TRUE);
}



bool_t
xdr__dev_free_in(xdrs, objp)
	XDR *xdrs;
	_dev_free_in *objp;
{
	if (!xdr_long(xdrs, &objp->ds_id)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->access_right)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->client_id)) {
		return (FALSE);
	}
	if (!xdr_DevVarArgumentArray(xdrs, &objp->var_argument)) {
		return (FALSE);
	}
	return (TRUE);
}


bool_t
xdr__dev_free_out(xdrs, objp)
	XDR *xdrs;
	_dev_free_out *objp;
{
	if (!xdr_long(xdrs, &objp->status)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->error)) {
		return (FALSE);
	}
	if (!xdr_DevVarArgumentArray(xdrs, &objp->var_argument)) {
		return (FALSE);
	}
	return (TRUE);
}



bool_t
xdr__server_admin(xdrs, objp)
	XDR *xdrs;
	_server_admin *objp;
{
	if (!xdr_long(xdrs, &objp->cmd)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->debug_bits)) {
		return (FALSE);
	}
	return (TRUE);
}




/*
 *  xdr_routines for dev_cmd_query()  
 */

bool_t
xdr__dev_query_in(xdrs, objp)
	XDR *xdrs;
	_dev_query_in *objp;
{
	if (!xdr_long(xdrs, &objp->ds_id)) {
		return (FALSE);
	}
	if (!xdr_DevVarArgumentArray(xdrs, &objp->var_argument)) {
		return (FALSE);
	}
	return (TRUE);
}	



bool_t
xdr__dev_cmd_info(xdrs, objp)
	XDR *xdrs;
	_dev_cmd_info *objp;
{
	if (!xdr_long(xdrs, &objp->cmd)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->in_type)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->out_type)) {
		return (FALSE);
	}
	return (TRUE);
}



bool_t
xdr__dev_query_out(xdrs, objp)
	XDR *xdrs;
	_dev_query_out *objp;
{
	if (!xdr_array(xdrs, (caddr_t *)&objp->sequence,
            (u_int *)&objp->length, MAXU_INT, sizeof(_dev_cmd_info),
	     (xdrproc_t)xdr__dev_cmd_info)) {
		return (FALSE);
	}
	if (!xdr_opaque(xdrs, (caddr_t)objp->class_name, SHORT_NAME_SIZE)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->error)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->status)) {
		return (FALSE);
	}
	if (!xdr_DevVarArgumentArray(xdrs, &objp->var_argument)) {
		return (FALSE);
	}
	return (TRUE);
}	




/*
 *  internal xdr_routines for message service data transfer 
 */

bool_t
xdr__msg_data(xdrs, objp)
	XDR *xdrs;
	_msg_data *objp;
{
        if (!xdr_string(xdrs, &objp->devserver_name, MAXU_INT)) {
		return (FALSE);
	}
        if (!xdr_string(xdrs, &objp->host_name, MAXU_INT)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->prog_number)) {
		return (FALSE);
	}
        if (!xdr_string(xdrs, &objp->display, MAXU_INT)) {
		return (FALSE);
	}
	if (!xdr_short(xdrs, &objp->type_of_message)) {
		return (FALSE);
	}
        if (!xdr_string(xdrs, &objp->message_buffer, MAXU_INT)) {
		return (FALSE);
	}
	return (TRUE);
}



bool_t
xdr__msg_out(xdrs, objp)
	XDR *xdrs;
	_msg_out *objp;
{
	if (!xdr_long(xdrs, &objp->status)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->error)) {
		return (FALSE);
	}
	return (TRUE);
}




/*
 *  internal xdr_routines for network manager service data transfer 
 */

bool_t
xdr__register_data(xdrs, objp)
	XDR *xdrs;
	_register_data *objp;
{
	if (!xdr_string(xdrs, &objp->host_name, MAXU_INT)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->prog_number)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->vers_number)) {
		return (FALSE);
	}
	return (TRUE);
}



bool_t
xdr__manager_data(xdrs, objp)
	XDR *xdrs;
	_manager_data *objp;
{
	if (!xdr__register_data(xdrs, &objp->msg_info)) {
		return (FALSE);
	}
	if (!xdr__register_data(xdrs, &objp->db_info)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->status)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->error)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->security)) {
		return (FALSE);
	}
	if (!xdr_DevVarArgumentArray(xdrs, &objp->var_argument)) {
		return (FALSE);
	}
	return (TRUE);
}



bool_t
xdr__msg_manager_data(xdrs, objp)
	XDR *xdrs;
	_msg_manager_data *objp;
{
	if (!xdr_string(xdrs, &objp->dshome, MAXU_INT)) {
		return (FALSE);
	}
	if (!xdr_string(xdrs, &objp->display, MAXU_INT)) {
		return (FALSE);
	}
	return (TRUE);
}

