
/*+*******************************************************************

 File:          daemon_xdr.h

 Project:       Device Servers with sun-rpc

 Description:   Include file for XDR definitions
		of the Update Daemon data types.

 Author(s):  	Jens Meyer

 Original:	July 1992


 $Revision: 4.13 $
 $Date: 1995/02/10 17:19:20 $

 $Author: meyer $

 $Log: daemon_xdr.h,v $
 Revision 4.13  1995/02/10 17:19:20  meyer
 Deleted

 * Revision 4.12  95/02/01  14:27:24  14:27:24  klotz (W.D. Klotz)
 * WDK: first successfull compile of dbase, api, xdr on WIN16/3.1
 * 
 * Revision 4.11  95/01/03  13:19:40  13:19:40  meyer (Jens Meyer)
 * Repared bug in dev_cmd_query() for version 3!
 * 
 * Revision 4.10  94/12/08  15:25:11  15:25:11  meyer (Jens Meyer)
 * Changed _manager_data in API_xdr and added old version to API_xdr_vers3.
 * 
 * Revision 4.9  94/11/28  17:04:34  17:04:34  meyer (Jens Meyer)
 * Data types for compatibility with library version 3.x
 * 
 * Revision 4.8  94/08/16  16:59:48  16:59:48  meyer (Jens Meyer)
 * Corrected error in ws_xdr.h
 * 
 * Revision 4.7  94/08/16  16:34:43  16:34:43  meyer (Jens Meyer)
 * Added define for MAX_RESOURCE_FIELD_LENGTH to macros.h
 * 
 * Revision 4.6  94/08/12  15:07:59  15:07:59  meyer (Jens Meyer)
 * Added valriable arguments to all API RPC structures.
 * 
 * Revision 4.5  94/07/20  18:15:59  18:15:59  meyer (Jens Meyer)
 * Changed include files in macros.h!
 * 
 * Revision 4.4  94/07/20  08:56:13  08:56:13  meyer (Jens Meyer)
 * All XDR functions with prototypes!
 * 
 * Revision 4.3  94/07/18  18:51:07  18:51:07  meyer (Jens Meyer)
 * Had to change macros.h, because #define must be in the first column!
 * 
 * Revision 4.2  94/07/18  18:22:39  18:22:39  meyer (Jens Meyer)
 * First test with PC macros for the XDR kernel.
 * 
 * Revision 4.1  94/05/02  10:51:00  10:51:00  meyer (Jens Meyer)
 * For Security System without connection count.
 * 
 * Revision 4.0  94/03/14  18:17:44  18:17:44  meyer (Jens Meyer)
 * Library version with Security System.
 * 
 * Revision 3.50  94/03/12  14:36:37  14:36:37  meyer (Jens Meyer)
 * Changed API xdr structures for security.
 * 
 * Revision 3.35  94/03/03  10:52:23  10:52:23  taurel (Emmanuel TAUREL)
 * Added unsigned long array type in the XDRkernel
 * 
 * Revision 3.34  94/03/03  10:29:13  10:29:13  taurel (Emmanuel TAUREL)
 * Added the unsigned long array type in
 * XDR kernel (LC and ET).
 * 
 * Revision 3.33  94/01/12  16:34:39  16:34:39  meyer (Jens Meyer)
 * Global XDR type array for data collector access
 * 
 * Revision 3.31  93/12/02  09:39:18  09:39:18  meyer (Jens Meyer)
 * New release with small XDR data type kernel.
 *
 * Revision 1.1  93/11/16  17:03:11  17:03:11  meyer (Jens Meyer)
 * Initial revision
 * 

 Copyright (c) 1990 by European Synchrotron Radiation Facility,
		       Grenoble, France

*******************************************************************-*/

#ifndef _daemon_xdr_h
#define _daemon_xdr_h


/*
 *  definitions for the update daemon
 */

struct DevDaemonStatus {
   	char BeingPolled;
	long PollFrequency;
 	long TimeLastPolled;
    	char PollMode;
    	char DeviceAccessError;
  	long ErrorCode;
    	long LastCommandStatus;
	char ContinueAfterError;
};
typedef struct DevDaemonStatus 	DevDaemonStatus;
bool_t 	_DLLFunc xdr_DevDaemonStatus PT_((_LPXDR xdrs, DevDaemonStatus _Far *objp));
long 	_DLLFunc xdr_length_DevDaemonStatus PT_((DevDaemonStatus _Far *objp));
#define D_DAEMON_STATUS         43
#define LOAD_DAEMON_STATUS(A)   xdr_load_type ( D_DAEMON_STATUS, \
                                                xdr_DevDaemonStatus, \
                                                sizeof(DevDaemonStatus), \
                                                xdr_length_DevDaemonStatus, \
                                                A )


struct DevDaemonData {
   	long ddid;
      	long long_data;
	char *string_data;
};
typedef struct DevDaemonData 	DevDaemonData;
bool_t 	_DLLFunc xdr_DevDaemonData PT_((_LPXDR xdrs, DevDaemonData _Far *objp));
long 	_DLLFunc xdr_length_DevDaemonData PT_((DevDaemonData _Far *objp));
#define D_DAEMON_DATA           44
#define LOAD_DAEMON_DATA(A)   	xdr_load_type ( D_DAEMON_DATA, \
                                                xdr_DevDaemonData, \
                                                sizeof(DevDaemonData), \
                                                xdr_length_DevDaemonData, \
                                                A )

#endif /* _daemon_xdr_h */

