/****************************************************************************

 File          :  xdev_gui.h

 Project       :  Xdevmenu application (new generation made by BX)

 Description   :  The header file containing all functions and data types
                  exported to the reste of the application by xdev_gui.c module.

 Author        :  Builder Xcessory then completed by Faranguiss Poncet

 Original      :  February 1997

 $Revision: 4.0 $				$Author: poncet $
 $Date: 99/06/30 09:46:30 $					$State: Rel $

 $Log:	xdev_gui.h,v $
 * Revision 4.0  99/06/30  09:46:30  09:46:30  poncet (F.Poncet)
 * Added a special case of treatement for the command "DevReadSigValues".
 * If this command with an output type of D_VAR_FLOATARR or
 * D_VAR_DOUBLEARR exists and the corresponding "DevGetSigConfig" exists
 * and returns coherent infos in that case when the user clicks on
 * "DevReadSigValues" : 1)dev_put_get_ascii fron libascapi.a is not called.
 * 2)dev_put_get is called directly  3) the output is interpreted according
 * to the info got from DevGetSigConfig (during import).
 * 4) the format (sprintf) used is also taken from sigconfig info.
 * 5) the output is displayed with this interpretation.
 * 
 * Revision 3.5  98/06/17  13:46:09  13:46:09  poncet (F.Poncet)
 * Three new data types added for the input argument of a command.
 * These types are : DevMotorLong, DevMotorFloat and DevMulMove used by
 * MAXE device servers.
 * 
 * Revision 3.4  97/05/05  19:03:25  19:03:25  poncet (F.Poncet)
 * Several bugs in 3.3 fixed in 3.4.
 * This 3.4 version needs libascapi.1.7.sl and libtcapi.1.6.sl to run correctly.
 * The "Close device" function now do a dev_free on the "xdevmenu" DS handle
 * of the device and also asks the libascapi.sl to do a dev_free of the
 * hidden DS handle of the same device.
 * 
 * Revision 3.3  97/04/01  16:49:36  16:49:36  poncet (F.Poncet)
 * Bug fixed. Description of the bug : For large output arguments (example :
 * arrays of strings) the xdevmenu 3.2 core dumps. This bug is now fixed in
 * 3.3 version.
 * 
 * Revision 3.2  97/03/18  17:09:05  17:09:05  poncet (F.Poncet)
 * Small bugs fixed such as :
 *       - bad fonts in Commands and Timeout SelectionDialog windows.
 *       - when a command has an output parameter name defined the value of the
 *         output argument does not stick anymore to the name of this arg.
 * Added the time of the execution of a command even if it failed.
 * 
 * Found a solution to the BIG BUG in the BX 4.0 generation of the resource
 * file. Added three lines in XDevmenu resource file in the "top user code
 * block" to work around this BX 4.0 bug (this bug did not existe in BX 3.1).
 * 
 * Revision 3.1  97/03/13  11:12:17  11:12:17  poncet (F.Poncet)
 * Changed the User Interface of Xdevmenu to meet the remarks and the users'
 * requirements. The output and errors from a command are now all in the
 * main window only.
 * 
 * Revision 3.0  97/02/27  11:47:01  11:47:01  poncet (F.Poncet)
 * New BX based Xdevmenu : Initial version.
 * The old uil based revisions are under another directory : "src_2.9+earlier".
 * 


 Copyright (c) 1997 by European Synchrotron Radiation Facility,
		       Grenoble, France

                       All Rights Reserved

****************************************************************************/


#ifndef _xdev_gui_h
#define _xdev_gui_h


#include <Xm/Xm.h>
#include "xdev_const.h"


#define GUI_MAX_WIDGETS                50



/*Widget  gui_widget_array[GUI_MAX_WIDGETS];*/


/*
 * Functions to export to outside of the module
 */


long gui_init();

void gui_fill_dev_list(unsigned int, char  ** );

void gui_display_error(char *);

void gui_error_out(int, char *, char *, char *);

void gui_add_device(char  *, int );

void gui_select_device(int );

void gui_show_cmds(char **, int );

int gui_get_selected_dev();

void gui_display_arg_out(char  *, char  *, long , char  *, char  *);

void gui_display_argin_window(int , char *, long );

long gui_get_selected_dev_cmd(int *, int *);

void gui_remove_device(int );


#endif /* _xdev_gui_h */

