/*+*******************************************************************

 File:          BlcDsNumbers.h

 Project:       Device Servers with SUN-RPC

 Description:   Include file with the definitions for all 
		device server classes of the BLC group 

 Author(s):     Christine Dominguez

 Original:      July 1993


 $Revision: 3.57 $
 $Date: 2000/07/24 13:45:35 $

 $Author: claustre $

 $Log: BlcDsNumbers.h,v $
 Revision 3.57  2000/07/24 13:45:35  claustre
 added Scanner base number, first scanner server is for the MAR345 Image Plate detector

 Revision 3.56  2000/07/19 07:15:27  perez
 added Wafer base number

 Revision 3.55  2000/01/29 07:31:57  goetz
 added LabView base number

 Revision 3.54  2000/01/17 15:12:03  goetz
 added medoptics base number

 * Revision 3.53  99/10/11  13:55:14  13:55:14  goetz (Andy Goetz)
 * added DevXiaBase for Paolo Mangiagalli
 * 
 Revision 3.52  1999/05/18 13:09:17  goetz
 added Oms base

 Revision 3.51  1999/04/23 14:16:10  goetz
 added ImagePro base

 * Revision 3.50  98/08/19  11:16:17  11:16:17  goetz (Andy Goetz)
 * added DevCCDCameraBase for generic CCD device servers
 * 
 * Revision 3.49  98/08/12  14:15:58  14:15:58  beteva (A.Beteva)
 * Added PiezoControl base definition
 * 
 * Revision 3.48  98/07/24  09:57:20  09:57:20  goetz (Andy Goetz)
 * added DevIK320Base for Heidenhain IK320 VME-based high resolution encoder
 * 
 * Revision 3.47  98/06/26  12:56:05  12:56:05  perez (Manuel.Perez)
 * added DevPCExpBase for PHI'S Hemispherical electron analyser
 * 
 * Revision 3.46  1998/05/13  09:04:14  perez
 * added DevFastScanBase for Image Plate FastScanner on Windows NT
 *
 * Revision 3.45  1998/03/10  16:36:56  beteva
 * added LEYBOLD Instruments base definition
 *
 * Revision 3.44  97/12/04  16:18:00  16:18:00  goetz (Andy Goetz)
 * added DevSensiCamBase for Sensicam CCD camera on Windows 95
 * 
 * Revision 3.43  97/10/16  16:28:53  16:28:53  goetz (Andy Goetz)
 * added DevMarCCDBase for Mar CCD scanner on GNU/Linux
 * 
 Revision 3.42  1997/09/19 13:54:58  perez
 add DevPPSbase

 * Revision 3.41  1997/01/30  13:46:24  domingue
 * add DevIpmcBase
 *
 * Revision 3.40  96/10/15  15:20:02  15:20:02  beteva (A.Beteva)
 * added DevAdc150Base
 * 
 * Revision 3.39  96/05/14  08:39:46  08:39:46  meyer (J.Meyer)
 * Added brackets around base definition.
 * 
 * Revision 3.38  96/05/06  18:39:27  18:39:27  meyer (J.Meyer)
 * Fortran compatible include file.
 * 
 * Revision 3.37  96/02/12  12:16:25  12:16:25  veuillen (Jm.Veuillen)
 * left unchanged
 * 
 * Revision 3.36  96/02/01  13:54:08  13:54:08  perez ()
 * Add DevGalilBase
 * 
 * Revision 3.35  96/02/01  13:52:30  13:52:30  perez ()
 * Add Pgblazers by JMV.
 * 
 * Revision 3.34  95/05/29  10:21:56  10:21:56  domingue (MC Dominguez)
 * remove last Wxbpm base because was already there !!
 * 
 * Revision 3.33  95/05/29  10:19:44  10:19:44  domingue (M.C Dominguez)
 * add Wxbpm new base
 * 
 * Revision 3.32  94/10/25  17:42:03  17:42:03  domingue (M.C Dominguez)
 * add Maxe base for new commands
 * 
 * Revision 3.31  94/08/31  10:51:53  10:51:53  pepellin (Gilbert Pepellin)
 * Add DevWxbpmBase
 * 
 * Revision 3.30  94/05/26  10:24:17  10:24:17  domingue (M.C Dominguez)
 * Add DevIcvDacBase and SigApiBase 
 * 
 * Revision 3.29  94/04/18  15:07:25  15:07:25  dserver ()
 * VIP added by JMV
 * 
 * Revision 3.28  94/01/17  10:38:43  10:38:43  goetz (Andy Goetz)
 * added Serial Line class base number
 * 
 * Revision 1.1  94/01/05  09:35:02  09:35:02  goetz (Andy Goetz)
 * Initial revision
 * 
 * Revision 3.26  1993/12/14  08:46:00  domingue
 * Add Upm60 and Hbmsh servers
 *
 * Revision 3.25  1993/09/24  17:24:36  meyer
 * Release with error and command resources.
 *
 * Revision 1.1  93/09/08  13:03:20  13:03:20  domingue ( Marie-Christine Dominguez)
 * Initial revision
 * 

 Copyright (c) 1990 by European Synchrotron Radiation Facility,
		       Grenoble, France

********************************************************************-*/

#ifndef _BlcDsNumbers_h
#define _BlcDsNumbers_h

#include <DserverTeams.h>

/*------- M4 device server---------*/
#define DevM4Base     	      (BlcTeamNumber + DS_LSHIFT(1, DS_IDENT_SHIFT)) 
/*------- Upm60 device server---------*/
#define DevUpm60Base          (BlcTeamNumber + DS_LSHIFT(2, DS_IDENT_SHIFT))
/*------- Hbm with share memory device server---------*/
#define DevHbmshBase          (BlcTeamNumber + DS_LSHIFT(3, DS_IDENT_SHIFT))
/*------- Serial line device server---------*/
#define DevSerBase            (BlcTeamNumber + DS_LSHIFT(4, DS_IDENT_SHIFT))
/*------- Varian ion pump device server---------*/
#define DevVipBase            (BlcTeamNumber + DS_LSHIFT(5, DS_IDENT_SHIFT))
/*------- IcvDac device server---------*/
#define DevIcvDacBase	      (BlcTeamNumber + DS_LSHIFT(6, DS_IDENT_SHIFT))
/*------- SigApi (Signal monitoring) ---------*/
#define SigApiBase	      (BlcTeamNumber + DS_LSHIFT(7, DS_IDENT_SHIFT))
/*------- Wxbpm device server --------*/
#define DevWxbpmBase	      (BlcTeamNumber + DS_LSHIFT(8, DS_IDENT_SHIFT))
/*------- Maxe device server  new commands--------*/
#define DevMaxeBase	      (BlcTeamNumber + DS_LSHIFT(9, DS_IDENT_SHIFT))
/*------- Balzers pressure gauge device server---------*/
#define DevPgbalzersBase      (BlcTeamNumber + DS_LSHIFT(10, DS_IDENT_SHIFT))
/*------- Galil DC motor controller device server ---------*/
#define DevGalilBase   	      (BlcTeamNumber + DS_LSHIFT(11, DS_IDENT_SHIFT))
/*------- Adc150 (ICV150 ADC) device server ---------*/
#define DevAdc150Base         (BlcTeamNumber + DS_LSHIFT(12, DS_IDENT_SHIFT))
/*------- Ipmc device server ---------*/
#define DevIpmcBase           (BlcTeamNumber + DS_LSHIFT(13, DS_IDENT_SHIFT))
/*------- Medical Chair device server ---------*/
#define DevPPSBase            (BlcTeamNumber + DS_LSHIFT(14, DS_IDENT_SHIFT))
/*------- Mars CCD scanner on GNU/Linux--------*/
#define DevMarCCDBase         (BlcTeamNumber + DS_LSHIFT(15, DS_IDENT_SHIFT))
/*------- LYBOLD Instruments device server --------*/
#define DevLeyboldBase       (BlcTeamNumber + DS_LSHIFT(16, DS_IDENT_SHIFT))
/*------- Sensicam CCD camera on Windows 95--------*/
#define DevSensiCamBase       (BlcTeamNumber + DS_LSHIFT(17, DS_IDENT_SHIFT))
/*------- Image Plate FastScanner on Windows NT--------*/
#define DevFastScanBase       (BlcTeamNumber + DS_LSHIFT(18, DS_IDENT_SHIFT))
/*------- PHI's Hemispherical Electron Analyser on Windows95--------*/
#define DevPCExpBase       (BlcTeamNumber + DS_LSHIFT(19, DS_IDENT_SHIFT))
/*------- Heidenhain IK320 high resolution VME encoder on Linux/m68k --------*/
#define DevIK320Base       (BlcTeamNumber + DS_LSHIFT(20, DS_IDENT_SHIFT))
/*------- PiezoControl device server --------*/
#define DevPiezoCtrlBase   (BlcTeamNumber + DS_LSHIFT(21, DS_IDENT_SHIFT))
/*------- CCD Camera device server(s) --------*/
#define DevCCDCameraBase   (BlcTeamNumber + DS_LSHIFT(22, DS_IDENT_SHIFT))
/*------- ImagePro image analysis device server --------*/
#define DevImageProBase   (BlcTeamNumber + DS_LSHIFT(23, DS_IDENT_SHIFT))
/*------- Oregon stepper motor device server --------*/
#define DevOmsBase   (BlcTeamNumber + DS_LSHIFT(24, DS_IDENT_SHIFT))
/*------- Xia device server for Paolo Mangiagalli -------*/
#define DevXiaBase   (BlcTeamNumber + DS_LSHIFT(25, DS_IDENT_SHIFT))
/*-------MedOptics device server -------*/
#define DevMedOpticsBase   (BlcTeamNumber + DS_LSHIFT(26, DS_IDENT_SHIFT))
/*-------LabView device server -------*/
#define DevLabViewBase   (BlcTeamNumber + DS_LSHIFT(27, DS_IDENT_SHIFT))
/*-------MEDEA wafer handler device server -------*/
#define DevWaferBase   (BlcTeamNumber + DS_LSHIFT(28, DS_IDENT_SHIFT))
/*-------Scanner detector device server(s) -------*/
#define DevScannerBase   (BlcTeamNumber + DS_LSHIFT(29, DS_IDENT_SHIFT))

#endif	/* _BlcDsNumbers_h */
