/*static char RcsId[] = "$Header: MDSSignal.h,v 5.14 99/10/13 15:02:29 pons Exp $ ";*/
/*********************************************************************
 *
 * File:	MDSSignal.h
 *
 * Project:	Multi Signal Device Server
 *
 * Description:	Device Server Class which is a top Layer of DSSignal
 		Class to handle multiple signals.
 *		
 *
 * Author(s):	Ingrid Fladmark
 *
 * Original:	24th of january 1997
 *
 * $Log:	MDSSignal.h,v $
 * Revision 5.14  99/10/13  15:02:29  15:02:29  pons ()
 * Correction for OS9 compilation (strdup)
 * 
 * Revision 5.13  99/10/11  17:06:03  17:06:03  pons ()
 * Correction for multi-nethost
 * 
 * Revision 5.12  99/08/20  17:29:46  17:29:46  pons ()
 * Multi Nethost support
 * 
 * Revision 5.11  99/02/12  14:38:00  14:38:00  pons ()
 * Correction
 * 
 * Revision 5.10  99/02/05  17:39:51  17:39:51  pons ()
 * Correction
 * 
 * Revision 5.9  99/02/05  16:52:00  16:52:00  pons ()
 * Add dev_get_sig_list() , dev_get_sig_config_from_name()
 * 
 * Revision 5.8  99/02/04  17:40:38  17:40:38  pons ()
 * Fast implementation of dev_get_sig_config
 * 
 * Revision 5.7  98/10/06  16:53:16  16:53:16  meyer (J.Meyer)
 * Added error if no signal list is defined.
 * 
 * Revision 5.5  97/12/05  15:45:41  15:45:41  meyer (J.Meyer)
 * Corrected missing return in dev_get_sig_config()
 * 
 * Revision 5.4  97/12/05  10:02:26  10:02:26  meyer (J.Meyer)
 * Added dev_get_sig_config and DevGetSigObject methode
 * 
 * Revision 5.3  97/07/08  09:26:37  09:26:37  meyer (J.Meyer)
 * Corrected bug in read properties() and added reading of a signal list for the class.
 * 
 * Revision 5.2  97/06/10  13:53:18  13:53:18  meyer (J.Meyer)
 * Found another memory leak in read_alarms().
 * 
 * Revision 5.1  97/06/10  11:09:49  11:09:49  meyer (J.Meyer)
 * Corrected RCS header.
 * 
 * Revision 5.0  97/06/10  11:04:46  11:04:46  meyer (J.Meyer)
 * Corrected memory leak in read_alarms().
 * 
 * Revision 1.1  97/06/10  10:29:07  10:29:07  fladmark (I.Fladmark)
 * Initial revision
 * 
 *
 * Copyright(c) 1994 by European Synchrotron Radiation Facility, 
 *                     Grenoble, France
 *
 * File generated by the Automatic Class Generation Tool,  2.4 
 * (Fri Jan 24 11:57:56 1997).
 *
 *********************************************************************/

#ifndef _MDSSIGNAL_H
#define _MDSSIGNAL_H

#include <CntrlDsNumbers.h>

typedef struct _MDSSignalClassRec *MDSSignalClass;
typedef struct _MDSSignalRec *MDSSignal;

extern MDSSignalClass mDSSignalClass;

#define DevMethodCheckAlarms    	DevMSignalBase + 1
#define DevMethodReadAlarms    		DevMSignalBase + 2
#define DevMethodSignalsReset   	DevMSignalBase + 3
#define DevMethodGetSigObject		DevMSignalBase + 4

/*************************************************************************
 * Example of definition of errors which are not belonging to DevErrors.h
 * See DSN096.
 *************************************************************************
 */

#define DevErr_SignalNameNotFound    	DevMSignalBase + 1
#define DevErr_SignalListNotFound    	DevMSignalBase + 2

/*
 * Prototype of extraction function for signal configuration.
 * Defined in module MDSSignal_config.c
 */

long dev_get_sig_config (char *device_name, DevVarStringArray *argout,
                         long *error);

long dev_get_sig_list (char *device_name, DevVarStringArray *argout, 
		       long *error);

long dev_get_sig_config_from_name (char *device_name, char *signal_name , 
		                   DevVarStringArray *argout, long *error);

#endif /*_MDSSIGNAL_H*/
