static char RcsId[]         = 
"@(#)$Header: DevServerMain.c,v 8.18 2000/11/12 13:24:03 goetz Rel $";

/*+*******************************************************************

 File       :  	DevServerMain.c

 Project    : 	Device Servers with sun-rpc

 Description:   Main programm for all device servers

 Author(s)  :	Jens Meyer

 Original   :	March 1991


 $Revision: 8.18 $
 $Date: 2000/11/12 13:24:03 $
 $Author: goetz $

 $Log:	DevServerMain.c,v $
 * Revision 8.18  2000/11/12  13:24:03  13:24:03  goetz (Andy Goetz)
 * added dynamic error handling; improved TANGO error treatment
 * 
 Revision 8.17  1900/09/26 13:36:36  goetz
 tango_dev_putget() and tango_dev_putget_raw() implement immediate reconnection

 * Revision 8.16  2000/09/25  14:50:16  14:50:16  goetz (Andy Goetz)
 * tango_api implements TANGO_HOST, stateless import and reimport
 * 
 * Revision 8.15  20/0./7.  1.:6.:9.  1.:6.:9.  goetz (Andy Goetz)
 * changed from tango database to host mysql, added support for float and double arrays
 * 
 * Revision 8.14  20/0./6.  2.:4.:0.  2.:4.:0.  goetz (Andy Goetz)
 * fixed bug in dev_event_listen() which caused server to crash
 * 
 Revision 8.13  2000/06/02 21:56:51  goetz
 _DEVICE_H now _TANGO_DEVICE_H in Device.H; (char*)taco_tango

 Revision 8.12  2000/06/02 15:58:09  goetz
 dev_event_fire() now device specific; ported to SuSE V6.4

 Revision 8.11  2000/05/31 07:47:56  goetz
 tango_api has local copies of argc and argv, ported to HP-UX

 * Revision 8.10  2000/05/29  21:39:22  21:39:22  goetz (Andrew GOETZ)
 * fixed prototyping problems with C++ on HP-UX
 * 
 * Revision 8.9  2000/05/29  18:13:32  18:13:32  goetz (Andrew GOETZ)
 * fixed bug in dev_import_timeout() which prevented timeouts < 2s
 * 
 Revision 8.8  2000/05/02 15:32:16  goetz
 added prototype for tsleep() for OS9 C++

 * Revision 8.7  2000/05/02  14:19:38  14:19:38  goetz (Andy Goetz)
 * removed check for device server running on different host
 * 
 * Revision 8.6  2000/05/02  13:29:31  13:29:31  goetz (Andy Goetz)
 * added random sleep to gettransient + 3 retries
 * 
 Revision 8.5  2000/03/27 17:13:45  goetz
 declared pmap_getmaps() as external C function for OS9 C++

 Revision 8.4  2000/03/13 14:50:02  goetz
 import timeout now programmable using dev_import_timeout()

 Revision 8.3  2000/03/13 10:31:35  goetz
 added Jens' modifications to fix bug in local putget

 Revision 8.2  2000/03/10 17:01:23  goetz
 dev_synch() now excludes udp clients and new imports

 Revision 8.1  2000/01/18 16:48:50  goetz
 tango_dev_import() now only called in dev_import if -DTANGO

 Revision 8.0  1999/12/28 14:18:31  goetz
 added TANGO support for TACO dev_xxx() calls via -DTANGO for C++

 Revision 7.10  1999/11/25 08:27:13  goetz
 replaced fprintf(stderr) with printf; made startup() C++ compatible

 Revision 7.9  1999/11/22 20:18:59  goetz
 removed const from gettransient() prototype

 Revision 7.8  1999/11/21 20:45:37  goetz
 included all M.Diehl's patches (major changes to gettransient() + main())

 Revision 7.7  1999/11/18 22:29:01  goetz
 fixed event multi-client bug, free client handle after event_listen, timeout in dev_synch()

 Revision 7.6  1999/11/01 19:05:16  goetz
 make local copy of user name returned by getpwuid() in sec_api.c

 Revision 7.5  1999/08/06 17:44:14  goetz
 removed usage of varargs for g++ on solaris and hpux

 * Revision 7.4  99/07/09  05:15:27  05:15:27  goetz (Andy Goetz)
 * added M.Diehl's patch to DevServerSig.c to exit() after calling unregister_server()
 * 
 Revision 7.3  1999/06/07 15:27:02  goetz
 fixed bug with multi-nethost reimport, device name stored with nethost

 Revision 7.2  1999/05/12 15:22:04  goetz
 changed dev_event_fire() to void; fixed bug in dev_event_unlisten()

 * Revision 7.1  99/05/11  15:59:51  15:59:51  goetz (Andy Goetz)
 * replace static declaration of event_client[] array by malloc()
 * 
 Revision 7.0  1999/04/26 07:30:44  goetz
 implemented user events (added event_api.c)

 Revision 6.15  1999/03/27 09:00:22  goetz
 asynch_cleanup() only checks for asynch clients; C++ returns output arguments if DS_WARNING

 * Revision 6.14  99/02/27  15:21:22  15:21:22  goetz (Andy Goetz)
 * fixed reimport bug; disabled reimport for rpc version 1
 * 
 Revision 6.13  1999/02/05 00:50:29  goetz
 fixed reimport socket+memory leak; ported to aCC on HPUX; suppressed rpc errors

 * Revision 6.12  99/01/18  21:39:06  21:39:06  goetz (Andy Goetz)
 * suppressed test for RPC_TIMEDOUT in svc_check()
 * 
 * Revision 6.11  99/01/14  23:14:55  23:14:55  goetz (Andy Goetz)
 * dbase timeout = 4 s; unregister ver. 1; svc_check() handles RPC_TIMEDOUT
 * 
 * Revision 6.10  98/12/22  10:29:48  10:29:48  taurel (E.Taurel)
 * Added support for Solaris and HP C++ native compiler. Remove K_R C support
 * 
 * Revision 6.9  98/12/15  14:05:09  14:05:09  goetz (Andy Goetz)
 * unregister RPC; use pgm no. 1 as flag; dev_pending() checks timeout; extern C prototype
 * 
 * Revision 6.8  98/11/20  14:35:38  14:35:38  goetz (Andy Goetz)
 * unregister API_VERSION (4) correctly now + check return value of svc_register()
 * 
 * Revision 6.7  98/11/20  10:35:03  10:35:03  goetz (Andy Goetz)
 * improved gettrans_ut(); multi-config_flags=0; removde static client_data; fixed linux select() bug; only register pgm # 0,4,5; portmap address == 111
 * 
 * Revision 6.6  98/09/24  09:25:11  09:25:11  goetz (Andy Goetz)
 * fixed stupid type which reintroduced asynchronous memory leak
 * 
 * Revision 6.5  98/08/26  16:20:36  16:20:36  goetz (Andy Goetz)
 * added dynamic NETHOST allocation, fixed bug in db_setup_multi, ported to Irix 6.4
 * 
 * Revision 6.4  98/04/29  10:21:24  10:21:24  goetz (Andy Goetz)
 * asynchronous - memory leak fixed, OS9 bug fixed, stale handle cleanup, pending=300
 * 
 * Revision 6.3  97/12/10  15:28:35  15:28:35  meyer (J.Meyer)
 * Changed select() timeout in rpc_check_host() to 200ms
 * 
 * Revision 6.2  97/12/01  12:59:17  12:59:17  goetz (Andy Goetz)
 * intermediate checkin before opening 5.14.1 branch
 * 
 * Revision 6.1  97/11/20  21:49:27  21:49:27  goetz (Andy Goetz)
 * main() continue even if cannot register asynch rpc
 * 
 * Revision 6.0  97/11/03  17:22:28  17:22:28  goetz (Andy Goetz)
 * merged synchronous and asynchronous branches
 * 
 Revision 5.15  1997/10/24 15:27:02  klotz
 ported to Windows NT 4.0 + NMSDK 5.0 ; tested with TextTalkds ; new DevServerMain.c

 * Revision 5.14  97/09/25  17:36:42  17:36:42  goetz (Andy Goetz)
 * fixed
 * 
 Revision 5.13  1997/09/03 17:34:35  meyer
 Added casting for ucc++ in DevServerSig.c

 * Revision 5.12  97/09/03  15:54:11  15:54:11  meyer (J.Meyer)
 * Changed OS9 signal handling from intercept() to signal().
 * 
 * Revision 5.11  97/08/05  14:19:28  14:19:28  goetz (Andy Goetz)
 * ported to VxWork 5.2, pgm. no. based on CRC, -m suppressed, -ve errors bug fix
 * 
 * Revision 5.10  97/03/14  17:26:11  17:26:11  dserver ()
 * fixed bug with open file handles after free
 * 
 * Revision 5.8.1.4  97/03/14  17:24:50  17:24:50  goetz (Andy Goetz)
 * fixed bug with open file handles after free
 * 
 * Revision 5.9  97/03/13  11:17:14  11:17:14  klotz (W.D. Klotz)
 * first part of NT4.0 port
 * 
 * Revision 5.8  97/01/31  12:06:23  12:06:23  goetz (Andy Goetz)
 * dev_protocol(), Linux+security bug fixes, dev_import() ignores timeout on NULL procedure, svc_run for OS9
 * 
 * Revision 5.7  97/01/14  08:57:19  08:57:19  goetz (Andy Goetz)
 * added stateless to dev_free(),_raw(),_asyn(),_protocol(),_timeout()
 * 
 * Revision 5.6  97/01/12  18:33:39  18:33:39  goetz (Andy Goetz)
 * dev_import() now stateless i.e. import works even if server is not running
 * 
 * Revision 5.5  97/01/08  17:02:28  17:02:28  goetz (Andy Goetz)
 * Ported to Linux (2.0.9)
 * 
 * Revision 5.4  96/11/27  09:58:14  09:58:14  goetz (Andy Goetz)
 * removed rpc admin interface from DevServerMain.c; putenv() suppressed for _UCC
 * 
 * Revision 5.3  96/11/26  16:24:40  16:24:40  goetz (Andy Goetz)
 * fixed bug (i_nethost=0) in dev_import_local()
 * 
 * Revision 5.2  96/11/26  13:31:03  13:31:03  goetz (Andy Goetz)
 * OICDevice (C++ wrapper for OIC) added + fixed multi-nethost memory leaks
 * 
 * Revision 5.1  96/11/04  11:00:06  11:00:06  goetz (Andy Goetz)
 * added multi nethost support
 * 

 Copyright (c) 1990-1997 by  European Synchrotron Radiation Facility,
			     Grenoble, France

*******************************************************************-*/

#include <API.h>
#include <ApiP.h>
#include <Admin.h>
#include <DevServer.h>
#include <DevServerP.h>
#include <DevSignal.h>
#include <DevErrors.h>
#if defined _NT
#include <pmapprot.h>
#include <pmapclnt.h>
#include <process.h>
/* #define NODATETIMEPICK to avoid compiler error. (I hate MicroSoft!)*/
#define NODATETIMEPICK
#include <commctrl.h>
#undef NODATETIMEPICK
#else
#include <rpc/pmap_clnt.h>
#endif	/* _NT */
#ifdef _UCC
#include <errno.h>
#include <rpc/rpc.h>
#endif /* _UCC */
#ifdef vxworks
#include <taskLib.h>
#endif /* vxworks */
#include <stdlib.h>
/*
 * M. Diehl, 22.7.1999
 * includes added to make the gethostbyname-patch working, see later
 * not tested on these platforms (in fact, only on Linux)
 */

#if ( OSK | _OSK )
#include <inet/netdb.h>
#else
#if !defined vxworks
#include <netdb.h>
#endif /* !vxworks */
#endif /* OSK | _OSK */

/* end of added includes */

/*
 * For compatibility with version 3 clients.
 * In external module ds_prog_vers3.c
 */

void _WINAPI devserver_prog_1	PT_( (struct svc_req *rqstp,SVCXPRT *transp) );
long minimal_access      = WRITE_ACCESS;


static void _WINAPI devserver_prog_4	PT_( (struct svc_req *rqstp,SVCXPRT *transp) );
static long svc_check 		PT_( (long *error) );


/****************************************
 *          Globals                     *
 ****************************************/

/*
 *  Type for global state flags for the current
 *  server or client status is defined in API.h 
 */

/*
 *  Configuration flags
 */

extern configuration_flags      config_flags;

/*
 *  Communication sockets
 */
 
static int	udp_socket;
static int	tcp_socket;

long synch_svc_udp_sock;
long synch_svc_tcp_sock;

/*
 * debug flag
 */

extern long debug_flag;

/*
 * VXWORKS and NOMAIN routine to create a device server - device_server()
 */

#if defined (vxworks) || (NOMAIN)
#ifdef __cplusplus
void device_server (char *server_name, char *pers_name)
#else /* __cplusplus */
void device_server (server_name, pers_name)
char *server_name; 
char *pers_name;
#endif /* __cplusplus */
{
        SVCXPRT *transp;
        SVCXPRT *transp_tcp;
        char    host_name [19];
        char    dsn_name [37];
        char    *proc_name;
        char    *display;

        char                    res_path [80];
        char                    res_name[80];
        DevVarStringArray       default_access;
        db_resource             res_tab;

        long    prog_number;
        long    status;
        long    error = 0;
        int     pid = 0;
        short   m_opt = False;
        short   s_opt = True;
        short   sig;
        short   i;

        /*
         *  read device server's class name and personal name
         *  check for lenght of names : server process name <= 23 char
         *                              personal name       <= 11 char
         */

        proc_name = server_name;

        if ( strlen(proc_name) > 23 )
           {
           printf ( "Filename too long : server_name <= 23 char\n");
           exit (-1);
           }

        if ( strlen(pers_name) > 11 )
           {
           printf ( "Personal DS_name too long : personal_dsname <= 11 char\n");
           exit (-1);
           }

	memset  (dsn_name,0,sizeof(dsn_name));
	strncat (dsn_name , proc_name, 23);
	strncat (dsn_name , "/", 1);
	strncat (dsn_name , pers_name, 11);

#ifdef vxworks
/*
 * call rpcTaskInit() to initialise task-specific data structures 
 * required by RPC (cf. VxWorks Reference manual pg. 1-203). 
 * Failure to do so will result in the task crashing the first
 * time a call to is made to an RPC function
 */
	rpcTaskInit();
#endif /* vxworks */

#else /* vxworks || NOMAIN */

/**/
#ifndef _NT
#ifdef __cplusplus
int main (int argc, char **argv)
#else  /* c++ */
int main (argc,argv)
/*+**********************************************************************
 Function   :   main()

 Description:   Main routine for all device servers.
	    :   Checks wether a device server with the
		same name is already running. 
	    :	Opens a connection to the static database and
		to a message service.
            :   Registers the server on a transient program
		number to the portmapper.

 Arg(s) In  :   char *argv[1] - personal name for the device server.

 Return(s)  :   exit(1) or exit(-1)
***********************************************************************-*/
	int     argc;		/* */
	char    **argv;		/* */
#endif  /* c++ */

#else  /* _NT */
#define TITLE_STR "TACO Device Server for Windows NT"
#define	MB_ERR		(MB_OK | MB_ICONEXCLAMATION)
#define	MB_INFO		(MB_OK | MB_ICONINFORMATION)
/*
 * globals
 */
#include "resource.h"

HWND hMainWnd;
HANDLE hMainInstance;
char* szAppName;
static char **argv;
static int argc=0;
HANDLE hConOut;
long (*DelayedStartup)() = NULL;
/*
 * the dialog procedure
 */
BOOL CALLBACK
MainDialogProc(HWND hwndDlg,
			   UINT uMsg,
			   WPARAM wParam,
			   LPARAM lParam);

/*
 * the main
 */
int WINAPI
WinMain(
		HINSTANCE hThisInst, 
		HINSTANCE hPrevInst, 
		LPSTR lpszArgs, 
		int nWinMode)
#endif /* _NT */

{
	SVCXPRT *transp;
	SVCXPRT *transp_tcp;
	char    host_name [19];
	char	dsn_name [37];
	char	*proc_name;
	char	*display;

	char    		res_path [80];
	char    		res_name[80];
	DevVarStringArray	default_access;
	db_resource   		res_tab;

	unsigned long  	prog_number;
	long	status;
	long 	error = 0;
	int	pid = 0;
	short	m_opt = False;
	short	s_opt = True;
	short	i;

	/*debug_flag = (DEBUG_ON_OFF | DBG_ASYNCH);*/
#ifdef _NT
	WSADATA wsadata;
	
	hMainInstance= hThisInst;
	
	if ((WSAStartup(0x0101, (LPWSADATA)&wsadata) != 0) &&
	    (WSAStartup(0x0001, (LPWSADATA)&wsadata) != 0)) {
		MessageBox((HWND)NULL, "Failed to start WinSock",
			TITLE_STR, MB_ERR);
		return(FALSE);
	}

	/*
	 * create a console window to receive 'printf' messages
	 */
	FreeConsole();
	AllocConsole();
	hConOut= GetStdHandle(STD_OUTPUT_HANDLE);

	{
		/*
		 * parse NT's command-line into argv and argc
		 */
		char *token[64];
		char* command_line= GetCommandLine();
		int cnt=0;
		char fname[_MAX_FNAME];
		char* path;

		/* program name */
		path= strtok(command_line, " ");
		_splitpath( path, NULL, NULL, fname, NULL );
		szAppName= malloc (strlen(fname)+1);
		strcpy(szAppName, fname);
		token[cnt]= szAppName;
		
		/* further arguments */
		if(NULL != lpszArgs) {  
			command_line= (char*) malloc (strlen(lpszArgs)+1);
			strcpy(command_line, lpszArgs);
			/* first argument */
			token[++cnt]= strtok(command_line, " ");
			do {
			/* next arguments */
			token[++cnt]= strtok(NULL, " ");
			} while(NULL != token[cnt]); 
		} else {
			cnt=1;
			}
		argc= cnt;
		argv= (char**) malloc (sizeof(char**)*argc);
		while(cnt>0) {
			cnt--;
			argv[cnt]=token[cnt];
		}

		if(argc < 2) {
			char msg[1024];
			sprintf (msg,"usage :  %s personal_name {-m} {-s}\n",argv[0]);
			MessageBox((HWND)NULL, msg, TITLE_STR, MB_INFO);
			return(FALSE);
		}

		if(0 !=(proc_name = (char *)strrchr (argv[0],'\\'))) {
			if(0 == strncmp(proc_name+strlen(proc_name)-4,".exe",4))
	    		proc_name[strlen(proc_name)-4]='\0';
			}
	}
#else   /* _NT */

	/*
	 *  read device server's class name and personal name
	 *  check for lenght of names : server process name <= 23 char
	 *                              personal name       <= 11 char
	 */


	if (argc < 2)
	   {
	   printf ("usage :  %s personal_name {-m} {-s}\n",argv[0]);
	   exit (1);
	   }
#endif  /* _NT */

#if defined (unix)
  	proc_name = (char *)strrchr (argv[0],'/');
#endif	/*unix*/
#if ( OSK || _OSK )
#ifdef __cplusplus
	proc_name = (char *)strrchr (argv[0],'/');
#else
	proc_name = (char *)rindex (argv[0],'/');
#endif
#endif /* OSK || _OSK */

	if (proc_name == NULL)
	   {
      	   proc_name = argv[0];
	   } else  {
           proc_name++;
  		  }

	if ( strlen(proc_name) > 23 )
	   {
		char msg[]="Filename to long : server_name <= 23 char\n";
#ifdef _NT
		MessageBox((HWND)NULL, msg, TITLE_STR, MB_INFO);
		return(FALSE);
#else
	   printf (msg);
	   exit (-1);
#endif
	   }

	if ( strlen(argv[1]) > 11 )
	   {
		char msg[]= "Personal DS_name to long : personal_dsname <= 11 char\n";
#ifdef _NT
		MessageBox((HWND)NULL, msg, TITLE_STR, MB_INFO);
		return(FALSE);
#else
	   printf (msg); 
	   exit (-1);
#endif
	   }

	/*
	 *  read options for device server start
	 */

	if (argc > 2)
	   {
	   for (i=2; i<(argc); i++)
	      {
	      if (strcmp (argv[i],"-m") == 0)
		 m_opt = False;
	      if (strcmp (argv[i],"-s") == 0)
		 s_opt = False;
	      }
	   }
	memset  (dsn_name,0,sizeof(dsn_name));
	strncat (dsn_name , proc_name, 23);
	strncat (dsn_name , "/", 1);
	strncat (dsn_name , argv[1], 11);

#endif /* vxworks || NOMAIN */
	/*
	 *  get process ID, host_name 
	 *  and create device server network name
	 */

#if defined (_NT)
        pid = _getpid ();
#else
#if !defined (vxworks)
        pid = getpid ();
#else  /* !vxworks */
        pid = taskIdSelf ();
#endif /* !vxworks */
#endif
/*
 * M. Diehl, 22.7.1999
 * We have to take care here, since hostname might be set to the FQDN thus
 * gethostname() returns "host.and.complete.domain" which may easily exceed
 * the 19 characters reserved for it!
 * There are 3 possible solutions:
 * 1) General extension of sizeof(host_name) reasonably beyond 19 characters
 * 2) Extracting the hostname from the FQDN
 * 3) Switching to an IP-String
 *
 * Here are some ideas on that:
 *
 * 1) Is obviously the best way, especially as there are several limitations
 *    to SHORT_NAME_SIZE=32 in quite a number of files. However this implies
 *    some major issues with respect to DBM and platform independence.
 * 2) Means switching to the intended behaviour and is rather easy to
 *    achieve. However this will fail, if the host (on which the device
 *    server is running e.g.) is not in our search domain - which is
 *    a disadvantage of the current implementation anyway, I believe.
 * 3) Replacing the hostname by it's IP-String-Quad (if it won't fit into
 *    19 characters) is possible without any changes at DBM code and
 *    should work in all situations. The disadvantage however is,
 *    that db_tools show up with xxx.xxx.xxx.xxx values instead of
 *    well-known hostnames, so one might have to use nslookup.
 *
 * What follows realizes suggestion 3) using some code from sec_api.c
 * with respect to different IP-retrieving for VxWorks and the rest of the
 * world. However, one has to keep in mind, that a bunch of other stuff
 * will fail, if FQDN exceeds SHORT_NAME_SIZE=32 - which is not too hard!
 */
 
	if( gethostname(host_name, 19) != 0 )
	{
		char            hostname[200];     /* hopefully enough! */
		char		ip_str[SHORT_NAME_SIZE];
#if !defined vxworks
		struct hostent	*host_info;
#else  /* !vxworks */
		union 		{ int    int_addr;
	  			  u_char char_addr[4];}  host_addr;
#endif /* !vxworks */

		
		if( gethostname(hostname,sizeof(hostname)) != 0 )
		{
			printf("unable to retrieve hostname!\n");
			exit(-1);
		}
/*#ifdef EBUG		
		printf("long hostname found - FQDN = %s\n", hostname);
#endif*/

#if !defined vxworks
		if ( (host_info = gethostbyname(hostname)) == NULL )
		{
			printf("unable to get IP for host %s\n",
				hostname);
			exit(-1);
		}

		sprintf (ip_str,"%d.%d.%d.%d",
		    (u_char) host_info->h_addr[0],
		    (u_char) host_info->h_addr[1],
		    (u_char) host_info->h_addr[2],
		    (u_char) host_info->h_addr[3]);
#else  /* !vxworks */
		host_addr.int_addr = hostGetByName(hostname);
		sprintf (ip_str,"%d.%d.%d.%d",
		    (u_char) host_addr.char_addr[0],
		    (u_char) host_addr.char_addr[1],
		    (u_char) host_addr.char_addr[2],
		    (u_char) host_addr.char_addr[3]);
#endif /* !vxworks */

/*#ifdef EBUG
		printf("using IP-addr-quad %s\n", ip_str);
#endif*/
		strncpy(host_name,ip_str,19);
	}
/*#ifdef EBUG
	printf( "using hostname: %s\n", host_name);
#endif*/

   TOLOWER(dsn_name);
   TOLOWER(host_name);
	sprintf (config_flags.server_name,"%s", dsn_name); 
	sprintf (config_flags.server_host,"%s", host_name); 

	/*
	 * install signal handling for HPUX, SUN, OS9
	 */

	(void) signal(SIGINT,  main_signal_handler);
	(void) signal(SIGTERM, main_signal_handler);
        (void) signal(SIGABRT, main_signal_handler);

#if defined (unix)
	(void) signal(SIGQUIT, main_signal_handler);
/*
 * SIGHUP and SIGPIPE are now caught in the main signal handler
 * which will simply return. This is needed for asynchronous
 * clients and servers to detect a server/client going down.
 *
 * andy 8may97
 */
	(void) signal(SIGHUP,  main_signal_handler);
	(void) signal(SIGPIPE, main_signal_handler);
#endif /* unix */

#if defined (_NT)
        (void) signal(SIGBREAK,main_signal_handler);
#endif /* _NT */

#if ( OSK || _OSK )
	(void) signal(SIGQUIT, main_signal_handler);
#endif /* OSK || _OSK */


/*
 *  import database server  
 */

	if ( db_import (&error) < 0 )
	   {
	   dev_printerror_no (SEND,"db_import failed",error);
	   exit(-1);
	   }		


/*
 *  check wether an old server with the same name
 *  is mapped to portmap or still running
 */

	if ( svc_check(&error) < 0 )
	   {
	   dev_printerror_no (SEND,"svc_check()",error);
	   exit(-1);
	   }		


/*
 * If the security system is switched on, read the minimal
 * access right for version 3 clients from the 
 * security database.
 */

       if ( config_flags.security == True )
	   {
	   default_access.length   = 0;
	   default_access.sequence = NULL;

       	   sprintf (res_name, "default");
	   res_tab.resource_name = res_name;
	   res_tab.resource_type = D_VAR_STRINGARR;
	   res_tab.resource_adr  = &default_access;

	   sprintf (res_path, "SEC/MINIMAL/ACC_RIGHT");

	   if (db_getresource (res_path, &res_tab, 1, &error) == DS_NOTOK)
	      {
	      dev_printerror_no (SEND,
	      "db_getresource() get default security access right\n",error);
	      exit (-1);
	      }

/*
 * Transform the string array into an access right value.
 */

           if ( default_access.length > 0 )
	      {
              for (i=0; i<SEC_LIST_LENGTH; i++)
                 {
                 if (strcmp (default_access.sequence[0], 
			     DevSec_List[i].access_name) == 0)
                    {
                    minimal_access = DevSec_List[i].access_right;
                    break;
                    }
                 }

              if ( i == SEC_LIST_LENGTH )
                 {
                 minimal_access = NO_ACCESS;
                 }
	      }	 
	   else 
	      {
              minimal_access = NO_ACCESS;
	      }

	   free_var_str_array (&default_access);
	   }

/*
 * let portmapper choose port numbers for services 
 */
        udp_socket = RPC_ANYSOCK;
        tcp_socket = RPC_ANYSOCK;

    /*
	 *  create server handle and register to portmap
	 */

	/*
	 *  register udp port
	 */
	transp = svcudp_create (udp_socket);
	if (transp == NULL) 
		{
		char msg[]="Cannot create udp service, exiting...\n";
#if defined(_NT)
			MessageBox((HWND)NULL, msg, TITLE_STR, MB_ERR);
            /*raise(SIGABRT);*/
			return (FALSE);
#else
			printf (msg);
            kill (pid,SIGQUIT);
#endif
		}
	/*
	 *  make 3 tries to get transient progam number
	 */
	 
	synch_svc_udp_sock = -1;

	for (i=0; i<3; i++)
	{
		prog_number = gettransient(dsn_name);
		if( prog_number == 0 )
		{
	  		dev_printerror_no(SEND,"gettransient: no free programm nnumber\n",error);
	  		exit(-1);
		}

	/*
	 * Write the device server identification to the global
	 * configuration structure.
	 */

		config_flags.prog_number = prog_number;
		/*config_flags.vers_number = DEVSERVER_VERS;*/
		config_flags.vers_number = API_VERSION;


		if (!svc_register(transp, prog_number, API_VERSION, 
			  	devserver_prog_4, IPPROTO_UDP)) 
		{
			char msg[]="Unable to register server (UDP,4), retry...\n"; 
#if defined(_NT)
			MessageBox((HWND)NULL, msg, TITLE_STR, MB_ERR);
			return(FALSE);
#else
			printf (msg); 
#endif
		}
		else
		{
/*
 * keep the socket, we need it later for dev_synch();
 */
			udp_socket = transp->xp_sock;
			synch_svc_udp_sock = transp->xp_sock;
			break;
		}
	}
	if (synch_svc_udp_sock == -1)
	{
		char msg[]="Unable to register server (UDP,4), exiting...\n"; 
#if defined(_NT)
		MessageBox((HWND)NULL, msg, TITLE_STR, MB_ERR);
		return(FALSE);
#else
		printf (msg); 
		kill(pid, SIGQUIT);
#endif
	}

/*
 *  register tcp port
 */
	transp_tcp = svctcp_create(tcp_socket,0,0);
	if (transp_tcp == NULL) 
		{
		char msg[]= "Cannot create tcp service, exiting...\n";
#if defined(_NT)
			MessageBox((HWND)NULL, msg, TITLE_STR, MB_ERR);
            /*raise(SIGABRT);*/
			return (FALSE);
#else
			printf (msg); 
			kill (pid,SIGQUIT);
#endif
		}

        if (!svc_register(transp_tcp, prog_number, API_VERSION,
			  devserver_prog_4, IPPROTO_TCP))
		{
	    char msg[]= "Unable to register server (TCP,4), exiting...\n";
#if defined(_NT)
			MessageBox((HWND)NULL, msg, TITLE_STR, MB_ERR);
            *raise(SIGABRT);*
			return (FALSE);
#else
			printf (msg); 
			kill (pid,SIGQUIT);
#endif
		}

/*
 * keep the socket, we need it later
 */
	tcp_socket = transp_tcp->xp_sock;
	synch_svc_tcp_sock = transp_tcp->xp_sock;
/*
 * if the process has got this far then it is a bona-fida device server 
 * set the appropiate flag
 */
	config_flags.device_server = True;

/*
 * Register the asynchronous rpc service so that the device server
 * can receive asynchronous calls from clients. The asynchronous
 * calls are sent as batched tcp requests without wait. The server
 * will return the results to the client asynchronously using batched
 * tcp.
 */
	status = asynch_rpc_register(&error);
	if (status != DS_OK)
	{
		dev_printerror_no (SEND,"failed to register asynchronus rpc",error);
/* 
 * DO NOT abort server, continue (without asynchronous server) ...
 *
#if defined (_NT)
		raise(SIGABRT);
#else
		kill (pid,SIGQUIT);
#endif
 */
	}

/*
 *  startup device server
 */

	if (s_opt == True)
	   {
           /*
            * Set the startup configuration flag to SERVER_STARTUP
            * during the startup phase.
            */

           config_flags.startup = SERVER_STARTUP;

	   status = startup(config_flags.server_name,&error);
	   if ( status < 0 )
	      {
	      dev_printerror_no (SEND,"startup failed",error);
#if defined(_NT)
              raise(SIGABRT);
#else
              kill (pid,SIGQUIT);
#endif
	      }		

/*
 *  if ds__svcrun() is used, the server can return from
 *  the startup function with status=1 to avoid svc_run()
 *  and to do a proper exit.
 */
	   if ( status == 1 )
	      {
#if defined(_NT)
                raise(SIGABRT);
#else
                kill (pid,SIGQUIT);
#endif
	      }

	   config_flags.startup = True;
	   }

#ifndef _NT
/*
 *  set server into wait status
 */

	svc_run();
	{
		char msg[]= "svc_run returned\n";
		printf (msg); 
		kill (pid,SIGQUIT);
	}
#else   /* _NT */
/*
 * show up the main dialog
 */
	DialogBox(hMainInstance, 
		MAKEINTRESOURCE(MAINDLG), NULL, (DLGPROC) MainDialogProc);

/*
 * clean up
 */

/* 
 * RPC and portmapper stuff.
 */
	svc_unregister(prog_number, DEVSERVER_VERS);
	svc_unregister(prog_number, API_VERSION);
	svc_unregister(prog_number, ASYNCH_API_VERSION);
	svc_destroy(transp);
	svc_destroy(transp_tcp);
/*
 * Winsock cleanup.
 */
	WSACleanup();
/* 
 * WIN32: end the process and all its threads.
 */
	ExitProcess(0);
	return (0);
#endif
}

#ifdef _NT
BOOL CALLBACK
MainDialogProc(HWND hwndDlg,
			   UINT uMsg,
			   WPARAM wParam,
			   LPARAM lParam)
{
	HCURSOR oldcr;

	switch(uMsg) {
	case WM_INITDIALOG:
		hMainWnd= hwndDlg;    /* the main window */
		InitCommonControls();
		/*
		 * insert initialization code here
		 */
		if (NULL == DelayedStartup)
			return (TRUE);
		else {
			SetCapture(hwndDlg);
			oldcr= SetCursor(LoadCursor((HANDLE)NULL, IDC_WAIT));
			if(-1 != (*DelayedStartup)()) {
				SetCursor(oldcr);
				ReleaseCapture();
				return (TRUE);
			}
		}
	case WM_CLOSE:
		/*
		 * all done with server
		 */
		EndDialog(hwndDlg, TRUE);
		return (TRUE);
	default:
		/*
		 * unknown message
		 */
		return (FALSE);
	}  /* switch */
}
#endif  /* _NT */


/*+**********************************************************************
 Function   :   static void devserver_prog_4()

 Description:   Entry point for received RPCs.
	    :   Switches to the wished remote procedure.

 Arg(s) In  :   struct svc_rep *rqstp - RPC request handle
	    :   SVCXPRT *transp       - Service transport handle

 Arg(s) Out :   none

 Return(s)  :   none
***********************************************************************-*/

static void _WINAPI devserver_prog_4 (struct svc_req *rqstp, SVCXPRT *transp) 
{
	char	*help_ptr;
	int	pid = 0;

	union {
		_dev_import_in	rpc_dev_import_4_arg;
		_dev_free_in 	rpc_dev_free_4_arg;
		_server_data 	rpc_dev_putget_4_arg;
		_server_data 	rpc_dev_put_4_arg;
                _dev_query_in   rpc_dev_query_cmd_4_arg;
/*
 * RPC ADMIN service disabled temporarily, to be reimplemented later
 *
 * - andy 26nov96
 *
 *		long 		rpc_admin_import_4_arg;
 *		_server_admin 	rpc_admin_4_arg;
 */
		_server_data 	rpc_dev_putget_raw_4_arg;
		_server_data 	rpc_dev_put_asyn_4_arg;
	} argument;

	char *result;
	xdrproc_t xdr_argument,xdr_result;
#ifdef __cplusplus
	DevRpcLocalFunc local;
#else
	char *(*local)();
#endif

	/*
	 *  call the right server routine
	 */

	/*printf("devserver_prog_4(): called with rqstp->rq_proc %d\n",rqstp->rq_proc);*/
	switch (rqstp->rq_proc) {
	case NULLPROC:
#ifdef _UCC
		svc_sendreply(transp, (xdrproc_t)xdr_void, (caddr_t)NULL);
#else
		svc_sendreply(transp, (xdrproc_t)xdr_void, NULL);
#endif /* _UCC */
		return;

        case RPC_QUIT_SERVER:
#ifdef _UCC
		svc_sendreply(transp, (xdrproc_t)xdr_void, (caddr_t)NULL);
#else
		svc_sendreply(transp, (xdrproc_t)xdr_void, NULL);
#endif /* _UCC */

#if defined (_NT)
                raise(SIGABRT);
#else  /* _NT */
#if !defined (vxworks)
                pid = getpid ();
#else  /* !vxworks */
                pid = taskIdSelf ();
#endif /* !vxworks */
                kill (pid,SIGQUIT);
#endif /* _NT */
		return;

	case RPC_CHECK:
		help_ptr = &(config_flags.server_name[0]);
		svc_sendreply (transp, (xdrproc_t)xdr_wrapstring, 
			       (caddr_t) &help_ptr);
		return;

	case RPC_DEV_IMPORT:
		xdr_argument = (xdrproc_t)xdr__dev_import_in;
		xdr_result = (xdrproc_t)xdr__dev_import_out;
#ifdef __cplusplus
		local = (DevRpcLocalFunc) rpc_dev_import_4;
#else
		local = (char *(*)()) rpc_dev_import_4;
#endif
		break;

	case RPC_DEV_FREE:
		xdr_argument = (xdrproc_t)xdr__dev_free_in;
		xdr_result = (xdrproc_t)xdr__dev_free_out;
#ifdef __cplusplus
		local = (DevRpcLocalFunc) rpc_dev_free_4;
#else
		local = (char *(*)()) rpc_dev_free_4;
#endif
		break;

	case RPC_DEV_PUTGET:
		xdr_argument = (xdrproc_t)xdr__server_data;
		xdr_result = (xdrproc_t)xdr__client_data;
#ifdef __cplusplus
		local = (DevRpcLocalFunc) rpc_dev_putget_4;
#else
		local = (char *(*)()) rpc_dev_putget_4;
#endif
		break;

	case RPC_DEV_PUT:
		xdr_argument = (xdrproc_t)xdr__server_data;
		xdr_result = (xdrproc_t)xdr__client_data;
#ifdef __cplusplus
		local = (DevRpcLocalFunc) rpc_dev_put_4;
#else
		local = (char *(*)()) rpc_dev_put_4;
#endif
		break;

        case RPC_DEV_CMD_QUERY:
		xdr_argument = (xdrproc_t)xdr__dev_query_in;
		xdr_result = (xdrproc_t)xdr__dev_query_out;
#ifdef __cplusplus
		local = (DevRpcLocalFunc) rpc_dev_cmd_query_4;
#else
		local = (char *(*)()) rpc_dev_cmd_query_4;
#endif
		break;

/*
 * RPC ADMIN service disabled temporarily, to be reimplemented later
 *
 * - andy 26nov96
 *
 *	case RPC_ADMIN_IMPORT:
 *		xdr_argument = xdr_long;
 *		xdr_result = xdr_long;
 *		local = (char *(*)()) rpc_admin_import_4;
 *		break;
 *
 *	case RPC_ADMIN:
 *		xdr_argument = (xdrproc_t)xdr__server_admin;
 *		xdr_result = xdr_long;
 *		local = (char *(*)()) rpc_admin_4;
 *		break;
 */

	case RPC_DEV_PUTGET_RAW:
		xdr_argument = (xdrproc_t)xdr__server_data;
		xdr_result = (xdrproc_t)xdr__client_raw_data;
#ifdef __cplusplus
		local = (DevRpcLocalFunc) rpc_dev_putget_raw_4;
#else
		local = (char *(*)()) rpc_dev_putget_raw_4;
#endif
		break;

	case RPC_DEV_PUT_ASYN:
		/*
		 * Read incoming arguments and send
                 * the reply immediately without waiting
		 * the execution of the function.
		 */
		xdr_argument = (xdrproc_t)xdr__server_data;
		xdr_result = (xdrproc_t)xdr__client_data;
	        /*
	         * Function only for the adminstration and security part
		 * of the asynchronous call.
		 */
#ifdef __cplusplus
		local = (DevRpcLocalFunc) rpc_dev_put_asyn_4;
#else
		local = (char *(*)()) rpc_dev_put_asyn_4;
#endif
	        break;

	case RPC_DEV_PING:
		xdr_argument = (xdrproc_t)xdr__dev_import_in;
		xdr_result = (xdrproc_t)xdr__dev_import_out;
#ifdef __cplusplus
		local = (DevRpcLocalFunc) rpc_dev_ping_4;
#else
		local = (char *(*)()) rpc_dev_ping_4;
#endif
		break;

	default:
		svcerr_noproc(transp);
		return;
	}


	memset(&argument, 0, sizeof(argument));

	if (!svc_getargs(transp, xdr_argument, (caddr_t) &argument)) 
	{
		dev_printerror (SEND,"%s",
		"svcerr_decode : server couldn't decode incoming arguments");
		svcerr_decode(transp);
		return;
	}


	result = (*local)(&argument, rqstp);
	if (result != NULL && !svc_sendreply(transp, xdr_result, (caddr_t)result)) 
	{
		dev_printerror (SEND,"%s",
		"svcerr_systemerr : server couldn't send repply arguments");
		svcerr_systemerr(transp);
	}


	/*
	 * If an asynchronous call was requested, execute now the
	 * command. After the answer was already send back to 
	 * the client.
	 */

	if ( rqstp->rq_proc == RPC_DEV_PUT_ASYN )
	   {
	   rpc_dev_put_asyn_cmd ((_server_data *)&argument);
	   }

	/*
	 * If dev_free() was called AND the server is on OS9 AND tcp
	 * then give OS9 a hand in closing this end of the tcp socket
	 * This fixes a bug in the OS9 (>3.x) implementation which led to
	 * the server blocking for a few seconds when closing a tcp 
	 * connection
	 */

	if (!svc_freeargs(transp, xdr_argument, (caddr_t) &argument)) 
	{
		dev_printerror (SEND,"%s",
		"svc_freeargs : server couldn't free arguments !!");
		return;
	}
}


/*+**********************************************************************
 Function   :   static long svc_check()

 Description:   Checks wether a device server with 
		the same name is already running.

 Arg(s) In  :   none

 Arg(s) Out :   long *error - Will contain an appropriate error
			      code if the corresponding call
			      returns a non-zero value.

 Return(s)  :   DS_OK or DS_NOTOK
***********************************************************************-*/

static long svc_check (long *error)
{
        CLIENT          *clnt;
	enum clnt_stat  clnt_stat;
	char		*host_name;
	char		*svc_name = NULL;
	unsigned int	prog_number;
	unsigned int	vers_number;

	*error = 0;

	if ( db_svc_check (config_flags.server_name,
			   &host_name, &prog_number, &vers_number, error) < 0 )
		return (-1);

   /*
	 * old server already unmapped ?
 	 */

	if ( prog_number == 0 )
	   {
	   return (0);
	   }

/*
 *  was the old server running on the same host ?
 *
 *  DON'T - removed this check it is an OS9 anachronism (andy 2/5/2000)
 *
 *	if (strcmp (config_flags.server_host,host_name) != 0)
 *	   {
 *	   *error = DevErr_ServerRegisteredOnDifferentHost;
 *	   return (-1);
 *	   }
 */

/*
 * force version number to latest API_VERSION [4] , new servers do not
 * support the old DSERVER_VERSION [1] anymore
 */
	vers_number = API_VERSION;

    /*
     *  old server still exists ?
	  */

	clnt = clnt_create (host_name, prog_number,vers_number,"udp");
	if (clnt != NULL)
	   {
           clnt_control (clnt, CLSET_RETRY_TIMEOUT, (char *) &msg_retry_timeout);
	        clnt_control (clnt, CLSET_TIMEOUT, (char *) &msg_timeout);

	   /*
	    *  call device server check function
	    */

           clnt_stat = clnt_call (clnt, RPC_CHECK, (xdrproc_t)xdr_void, NULL,
     				  (xdrproc_t)xdr_wrapstring, (caddr_t) &svc_name, 
			          TIMEVAL(msg_timeout));
 	   if (clnt_stat == RPC_SUCCESS)
	   {
	      if (strcmp (config_flags.server_name,
			  svc_name) == 0)
	         {
	         *error = DevErr_ServerAlreadyExists;
	         clnt_destroy (clnt);
	         return (-1);
		 }
	   }
	   else
	   {
	      if (clnt_stat != RPC_PROCUNAVAIL)
		 {
	         /*pmap_unset (prog_number, DEVSERVER_VERS);*/
	         pmap_unset (prog_number, API_VERSION);
	         pmap_unset (prog_number, ASYNCH_API_VERSION);
		 }
	   }

	   clnt_destroy (clnt);
	   }

	return (0);
}


/*+**********************************************************************
#ifdef _NT
 Function   :   void svc_run ()

 Description:   Windows/NT function to wait forever for rpc requests to a 
		server.  When a request arrives it is dispatched to the 
		server via the rpc call svc_getreqset(). 

		This version specific to Windoes/NT has been written by 
		W-D.Klotz for the Netmanage rpc package.


 Arg(s) In  :   none

 Arg(s) Out :   none

 Return(s)  :   none
 ****************************************************************************
void WINAPI svc_run(void)
{
	LPfd_set readfds;
	int        rc;
	int        not_used;

	for(;;)   {
	readfds= svc_getfdset(); 
	if (( rc= select(not_used, readfds, NULL, NULL, NULL)) == 0) {
	          break;
	} else if (rc>0) {
	          svc_getreqset(readfds);
	} else  {
			char	   errmess[80];

	          if( SOCKET_ERROR == rc ) {
				  sprintf(errmess,"svc_run: select() returned %d, specific error code %d",rc, WSAGetLastError());
			  } else  {
				  sprintf(errmess,"svc_run: select() returned %d",rc);
			  }
			  sprintf("%s, sock_udp= %d  sock_tcp=%d\n", errmess, sock_udp, sock_tcp);
			  MessageBox((HWND)NULL, errmess, TITLE_STR, MB_ERR);
			  return;
		   }
    }
}
#endif     
***********************************************************************-*/


#ifdef _UCC
extern int ds_rpc_svc_fd; /* global variable - client rpc file descriptor */
#define getdtablesize() FD_SETSIZE
#ifdef __STDC__
void svc_run(void)
#else
void svc_run()
/*+**********************************************************************
 Function   :   void svc_run ()

 Description:   OS9 function to wait forever for rpc requests to a server.
		When a request arrives it is dispatched to the server via
		the rpc call svc_getreqset(). 

		This version specific to OS9 has been modelled on the
		example in the "OS9 Network File System/Remote Procedure
		Call User's Manual" pg 2-21 modified by P.Makijarvi. 
		It solves the problem of exiting on receiving a signal.


 Arg(s) In  :   none

 Arg(s) Out :   none

 Return(s)  :   none
***********************************************************************-*/
#endif /* __STDC__ */
{
	fd_set readfds;
	int dtbsz = getdtablesize();
	long i;

	FD_ZERO(&readfds);

	/*printf("svc_run(): arrived ...\n");*/
	
	for (;;)
	{
		readfds = svc_fdset;

		/*printf("svc_run(): readfds 0x%08x before select()\n",readfds);*/
		switch (select(dtbsz,&readfds,(fd_set*)0,(fd_set*)0,(struct timeval*)0))
		{
			case -1 : if ((errno == EINTR) || (errno == EOS_SIGNAL))
				  /*perror("svc_run(): select() returns with error");*/
			 	  continue;

				  /*return;*/

			case 0 : break;

			default : 
/*
 * determine which file descriptor the client has called from, this is
 * needed by OS9 in case it has to close the socket e.g. if dev_free()
 */
				  for (i=0; i<FD_SETSIZE; i++)
				  {
				  	if (FD_ISSET(i,&readfds)) ds_rpc_svc_fd = i;
				  }

				  /*printf("svc_run(): readfds 0x%08x after select(), ds_rpc_svc_fd=%d\n",readfds,ds_rpc_svc_fd);*/
				  svc_getreqset(&readfds);
		}

	}
}
#endif /* _UCC */
