//static char RcsId[] = "$Header: PowerSupply.H,v 1.4 96/07/11 13:37:13 taurel Rel $";

//+**********************************************************************
//
// File:	Device.h
//
// Project:	Device Servers in C++
//
// Description:	public include file containing definitions and declarations 
//		for implementing the device server PowerSupply superclass in C++
//		(DeviceClass).
//
// Author(s):	Andy Goetz
//
// Original:	April 1995
//
// $Revision: 1.4 $
//
// $Date: 96/07/11 13:37:13 $
//
// $Author: taurel $
//
// $Log:	PowerSupply.H,v $
//Revision 1.4  96/07/11  13:37:13  13:37:13  taurel (E.Taurel)
//Ported_to_OS-9_Ultra_C++
//
//Revision 1.3  96/06/17  14:32:09  14:32:09  taurel (E.Taurel)
//Changed comment string for C++ comment style.
//
// Revision 1.2  95/07/28  13:12:09  13:12:09  goetz (Andy Goetz)
// checking in before I disappear into the African dust ...

// Revision 1.1  95/07/20  16:32:10  16:32:10  goetz (Andy Goetz)
// Initial revision
// 
//
//+**********************************************************************
		
class PowerSupply : public Device {


//
// private members
// 

private :

   long ClassInitialise( long *error );
   long GetResources (char *res_name, long *error);

   static short class_inited;
//
// protected members
//

protected:


   float set_val;
   float read_val;
   long channel;
   long n_ave;
   long fault_val;
   float cal_val;
   float conv_val;
   char *conv_unit;
   float set_offset;
   float read_offset;
   float set_u_limit;
   float set_l_limit;
   float idot_limit;
   long polarity;
   float delta_i;
   long time_const;
   long last_set_t;

   long CheckReadValue(DevBoolean *check, long *error);

   virtual long StateMachine( long cmd, long *error) = 0; // pure virtual function
//
// public members
//
public:

     PowerSupply (char *name, long *error);
     ~PowerSupply ();

};
