/*static char RcsId[] =$Header: /segfs/dserver/dev/system/xdr/src/RCS/m4_xdr.c,v 5.18 1999/07/08 14:10:46 goetz Rel $";*/ 

/********************************************************************

 File:          m4_xdr.c

 Project:       4 mirrors device

 Description:   xdr_routines for m4 types.

 Author(s):     Christine Dominguez

 Original:      May 1993

$Log: m4_xdr.c,v $
Revision 5.18  1999/07/08 14:10:46  goetz
changed _LPfd_set type for Linux in macros.h

Revision 5.17  1998/05/25 17:59:46  klotz
fixed C++ prototypes in api_xdr.h

Revision 5.16  1998/04/29 10:24:08  goetz
macros.h - added __STDCPP__ for HP C++ compiler (aCC)

 * Revision 5.15  97/12/01  15:16:19  15:16:19  klotz (W.D. Klotz)
 * WIN_NT_95_released_NOV_97
 * 
 * Revision 4.34  97/01/30  13:58:41  13:58:41  goetz (Andy Goetz)
 * removed dev_printdebug() from DevXdrKernel.h
 * 
 * Revision 4.33  97/01/09  10:08:46  10:08:46  goetz (Andy Goetz)
 * (xdrproc_t) castings added to maxe_xdr, ram_xdr, thc_xdr, seism_xdr
 * 
 * Revision 4.32  97/01/08  16:48:35  16:48:35  goetz (Andy Goetz)
 * Ported to Linux (2.0.9)
 * 
Revision 4.31  1996/11/18 17:28:51  goetz
Check

 * Revision 4.28  96/10/21  16:22:30  16:22:30  taurel (E.Taurel)
 * Check_in_after_port_to_OS9/ISP_2.1_and_OS9/RPC1.4
 * 
 * Revision 4.27  96/09/17  16:40:10  16:40:10  klotz (W.D. Klotz)
 * WD Klotz: tested NT build  
 * 
 * Revision 4.26  96/07/19  10:01:05  10:01:05  taurel (E.Taurel)
 * Some_change_in_macros.h_for_the_API_port_to_OS-9_Ultra_C++
 * 
 * Revision 4.25  96/06/07  16:23:09  16:23:09  meyer (J.Meyer)
 * Corrected_elif_to_else_in_macros.h
 * 
 * Revision 4.24  96/06/05  15:01:45  15:01:45  meyer (J.Meyer)
 * Corrected_macros.h
 * 
 * Revision 4.23  96/06/03  13:10:22  13:10:22  meyer (J.Meyer)
 * Cleaned-up_MSDOS_and_added_porting_options_for_Windows_NT.
 * 
 * Revision 4.22  96/05/23  11:07:30  11:07:30  taurel (E.Taurel)
 * Added_some_definitions_for_C++_in_API_xdr.h_file
 * 
 * Revision 4.21  96/05/06  18:37:40  18:37:40  meyer (J.Meyer)
 * Fortran_compatibility_for:_dev_xdr.h,macros.h,maxe_xdr.h
 * 
 * Revision 4.20  96/02/27  13:31:40  13:31:40  meyer (J.Meyer)
 * Deleted_Cross_References_To_DSAPI_Library
 * 
 * Revision 4.19  96/01/11  17:40:26  17:40:26  meyer (Jens Meyer)
 * Added_#define_PORTMAP_to_macros.h.
 * 
 * Revision 4.18  95/12/21  10:33:39  10:33:39  meyer (Jens Meyer)
 * Corrected length calculation for D_VAR_MSTATARR.
 * 
 * Revision 4.17  95/08/02  16:05:18  16:05:18  meyer (Jens Meyer)
 * Corrected DevXdrKernel.h after C++ implementation.
 * 
 * Revision 4.15  95/03/02  10:28:02  10:28:02  meyer (Jens Meyer)
 * Added D_VAR_SFRPARR type to the kernel.
 * 
 * Revision 4.14  95/02/20  09:56:53  09:56:53  meyer (Jens Meyer)
 * Passed the compilers for HPUX, SUNOS and UCC after the first windows check in.
 * 
 * Revision 4.13  95/02/10  17:19:08  17:19:08  meyer (Jens Meyer)
 * Deleted
 * 
 * Revision 4.12  95/02/01  14:26:56  14:26:56  klotz (W.D. Klotz)
 * WDK: first successfull compile of dbase, api, xdr on WIN16/3.1
 * 
 * Revision 4.11  95/01/03  13:19:29  13:19:29  meyer (Jens Meyer)
 * Repared bug in dev_cmd_query() for version 3!
 * 
 * Revision 4.10  94/12/08  15:25:00  15:25:00  meyer (Jens Meyer)
 * Changed _manager_data in API_xdr and added old version to API_xdr_vers3.
 * 
 * Revision 4.9  94/11/28  17:04:22  17:04:22  meyer (Jens Meyer)
 * Data types for compatibility with library version 3.x
 * 
 * Revision 4.8  94/08/16  16:59:39  16:59:39  meyer (Jens Meyer)
 * Corrected error in ws_xdr.h
 * 
 * Revision 4.7  94/08/16  16:34:34  16:34:34  meyer (Jens Meyer)
 * Added define for MAX_RESOURCE_FIELD_LENGTH to macros.h
 * 
 * Revision 4.6  94/08/12  15:07:50  15:07:50  meyer (Jens Meyer)
 * Added valriable arguments to all API RPC structures.
 * 
 * Revision 4.5  94/07/20  18:15:49  18:15:49  meyer (Jens Meyer)
 * Changed include files in macros.h!
 * 
 * Revision 4.4  94/07/20  08:55:46  08:55:46  meyer (Jens Meyer)
 * All XDR functions with prototypes!
 * 
 * Revision 4.3  94/07/18  18:50:58  18:50:58  meyer (Jens Meyer)
 * Had to change macros.h, because #define must be in the first column!
 * 
 * Revision 4.2  94/07/18  18:22:14  18:22:14  meyer (Jens Meyer)
 * First test with PC macros for the XDR kernel.
 * 
 * Revision 4.1  94/05/02  10:50:51  10:50:51  meyer (Jens Meyer)
 * For Security System without connection count.
 * 
 * Revision 4.0  94/03/14  18:17:36  18:17:36  meyer (Jens Meyer)
 * Library version with Security System.
 * 
 * Revision 3.50  94/03/12  14:36:29  14:36:29  meyer (Jens Meyer)
 * Changed API xdr structures for security.
 * 
 * Revision 3.35  94/03/03  10:52:15  10:52:15  taurel (Emmanuel TAUREL)
 * Added unsigned long array type in the XDRkernel
 * 
 * Revision 3.34  94/03/03  10:29:06  10:29:06  taurel (Emmanuel TAUREL)
 * Added the unsigned long array type in
 * XDR kernel (LC and ET).
 * 
 * Revision 3.33  94/01/12  16:34:29  16:34:29  meyer (Jens Meyer)
 * Global XDR type array for data collector access
 * 
 * Revision 3.31  93/12/02  09:39:05  09:39:05  meyer (Jens Meyer)
 * New release with small XDR data type kernel.
 * 
 * Revision 1.1  93/11/16  17:48:04  17:48:04  meyer (Jens Meyer)
 * Initial revision
 * 

Copyright (c) 1990 by European Synchrotron Radiation Facility,
		      Grenoble, France

*******************************************************************-*/

#include <dev_xdr.h>
#include <m4_xdr.h>


/* D_VAR_LONGFLOATSET */

bool_t
xdr_DevVarLongFloatSet(xdrs, objp)
	XDR *xdrs;
	DevVarLongFloatSet *objp;
{
	if (!xdr_long(xdrs, &objp->length)) {
		return (FALSE);
     	}
     	if (!xdr_array(xdrs, (caddr_t *)&objp->axis,
		(u_int *)&objp->length, MAXU_INT, sizeof(long), (xdrproc_t)xdr_long)) {
	  	return (FALSE);
	}
     	if (!xdr_array(xdrs, (caddr_t *)&objp->value,
		(u_int *)&objp->length, MAXU_INT, sizeof(long), (xdrproc_t)xdr_long)) {
	  	return (FALSE);
        }
     	if (!xdr_array(xdrs, (caddr_t *)&objp->valuef,
		(u_int *)&objp->length, MAXU_INT, sizeof(float), (xdrproc_t)xdr_float)) {
	  	return (FALSE);
  	}
       return (TRUE);
}

/* D_VAR_LONGREAD */


bool_t
xdr_DevVarLongRead(xdrs, objp)
	XDR *xdrs;
	DevVarLongRead *objp;
{
	if (!xdr_long(xdrs, &objp->length)) {
		return (FALSE);
     	}
     	if (!xdr_array(xdrs, (caddr_t *)&objp->value,
		(u_int *)&objp->length, MAXU_INT, sizeof(long), (xdrproc_t)xdr_long)) {
	  	return (FALSE);
	}
     	if (!xdr_array(xdrs, (caddr_t *)&objp->stat,
		(u_int *)&objp->length, MAXU_INT, sizeof(long), (xdrproc_t)xdr_long)) {
	  	return (FALSE);
	}
     	if (!xdr_array(xdrs, (caddr_t *)&objp->err,
		(u_int *)&objp->length, MAXU_INT, sizeof(long), (xdrproc_t)xdr_long)) {
	  	return (FALSE);
  	}
       return (TRUE);
}


/* D_VAR_POSREAD */

bool_t
xdr_DevVarPosRead(xdrs, objp)
	XDR *xdrs;
	DevVarPosRead *objp;
{
	if (!xdr_long(xdrs, &objp->length)) {
		return (FALSE);
     	}
     	if (!xdr_array(xdrs, (caddr_t *)&objp->pos,
		(u_int *)&objp->length, MAXU_INT, sizeof(float), (xdrproc_t)xdr_float)) {
	  	return (FALSE);
	}
     	if (!xdr_array(xdrs, (caddr_t *)&objp->stat,
		(u_int *)&objp->length, MAXU_INT, sizeof(long), (xdrproc_t)xdr_long)) {
	  	return (FALSE);
	}
     	if (!xdr_array(xdrs, (caddr_t *)&objp->err,
		(u_int *)&objp->length, MAXU_INT, sizeof(long), (xdrproc_t)xdr_long)) {
	  	return (FALSE);
  	}

       return (TRUE);
}


/* D_VAR_AXEREAD */

bool_t
xdr_DevVarAxeRead(xdrs, objp)
	XDR *xdrs;
	DevVarAxeRead *objp;
{
	if (!xdr_long(xdrs, &objp->length)) {
		return (FALSE);
     	}
     	if (!xdr_array(xdrs, (caddr_t *)&objp->m_pos,
		(u_int *)&objp->length, MAXU_INT, sizeof(float), (xdrproc_t)xdr_float)) {
	  	return (FALSE);
	}
     	if (!xdr_array(xdrs, (caddr_t *)&objp->s_pos,
		(u_int *)&objp->length, MAXU_INT, sizeof(float), (xdrproc_t)xdr_float)) {
	  	return (FALSE);
	}
     	if (!xdr_array(xdrs, (caddr_t *)&objp->m_stat,
		(u_int *)&objp->length, MAXU_INT, sizeof(long), (xdrproc_t)xdr_long)) {
	  	return (FALSE);
	}
     	if (!xdr_array(xdrs, (caddr_t *)&objp->s_stat,
		(u_int *)&objp->length, MAXU_INT, sizeof(long), (xdrproc_t)xdr_long)) {
	  	return (FALSE);
	}
     	if (!xdr_array(xdrs, (caddr_t *)&objp->swit,
		(u_int *)&objp->length, MAXU_INT, sizeof(long), (xdrproc_t)xdr_long)) {
	  	return (FALSE);
	}
     	if (!xdr_array(xdrs, (caddr_t *)&objp->clutch,
		(u_int *)&objp->length, MAXU_INT, sizeof(long), (xdrproc_t)xdr_long)) {
	  	return (FALSE);
	}
     	if (!xdr_array(xdrs, (caddr_t *)&objp->err,
		(u_int *)&objp->length, MAXU_INT, sizeof(long), (xdrproc_t)xdr_long)) {
	  	return (FALSE);
  	}

       return (TRUE);
}

/* D_VAR_PARREAD */

bool_t
xdr_DevVarParRead(xdrs, objp)
	XDR *xdrs;
	DevVarParRead *objp;
{
	if (!xdr_long(xdrs, &objp->length)) {
		return (FALSE);
     	}
     	if (!xdr_array(xdrs, (caddr_t *)&objp->veloc,
		(u_int *)&objp->length, MAXU_INT, sizeof(float), (xdrproc_t)xdr_float)) {
	  	return (FALSE);
	}
     	if (!xdr_array(xdrs, (caddr_t *)&objp->acc,
		(u_int *)&objp->length, MAXU_INT, sizeof(float), (xdrproc_t)xdr_float)) {
	  	return (FALSE);
	}
     	if (!xdr_array(xdrs, (caddr_t *)&objp->fstep,
		(u_int *)&objp->length, MAXU_INT, sizeof(float), (xdrproc_t)xdr_float)) {
	  	return (FALSE);
	}
     	if (!xdr_array(xdrs, (caddr_t *)&objp->hslew,
		(u_int *)&objp->length, MAXU_INT, sizeof(float), (xdrproc_t)xdr_float)) {
	  	return (FALSE);
	}
     	if (!xdr_array(xdrs, (caddr_t *)&objp->backlash,
		(u_int *)&objp->length, MAXU_INT, sizeof(float), (xdrproc_t)xdr_float)) {
	  	return (FALSE);
	}
     	if (!xdr_array(xdrs, (caddr_t *)&objp->stepmode,
		(u_int *)&objp->length, MAXU_INT, sizeof(long), (xdrproc_t)xdr_long)) {
	  	return (FALSE);
	}
     	if (!xdr_array(xdrs, (caddr_t *)&objp->unit,
		(u_int *)&objp->length, MAXU_INT, sizeof(long), (xdrproc_t)xdr_long)) {
	  	return (FALSE);
	}
     	if (!xdr_array(xdrs, (caddr_t *)&objp->err,
		(u_int *)&objp->length, MAXU_INT, sizeof(long), (xdrproc_t)xdr_long)) {
	  	return (FALSE);
  	}

       return (TRUE);
}

/* D_VAR_ERRREAD */


bool_t
xdr_DevVarErrRead(xdrs, objp)
	XDR *xdrs;
	DevVarErrRead *objp;
{
	if (!xdr_long(xdrs, &objp->length)) {
		return (FALSE);
     	}
     	if (!xdr_array(xdrs, (caddr_t *)&objp->err,
		(u_int *)&objp->length, MAXU_INT, sizeof(long), (xdrproc_t)xdr_long)) {
	  	return (FALSE);
  	}

       return (TRUE);
}




