
/*+*******************************************************************

 File:          slit_xdr.h

 Project:       Device Servers with sun-rpc

 Description:   Include file for XDR definitions
		of the SLIT data types.

 Author(s):  	Timo Mettala

 Original:	September 1992


 $Revision: 5.18 $
 $Date: 1999/07/08 14:10:49 $

 $Author: goetz $

 $Log: slit_xdr.h,v $
 Revision 5.18  1999/07/08 14:10:49  goetz
 changed _LPfd_set type for Linux in macros.h

 Revision 5.17  1998/05/25 17:59:59  klotz
 fixed C++ prototypes in api_xdr.h

 Revision 5.16  1998/04/29 10:24:21  goetz
 macros.h - added __STDCPP__ for HP C++ compiler (aCC)

 * Revision 5.15  97/12/01  15:22:46  15:22:46  klotz (W.D. Klotz)
 * WIN_NT_95_released_NOV_97
 * 
 * Revision 4.34  97/01/30  13:58:50  13:58:50  goetz (Andy Goetz)
 * removed dev_printdebug() from DevXdrKernel.h
 * 
 * Revision 4.33  97/01/09  10:08:54  10:08:54  goetz (Andy Goetz)
 * (xdrproc_t) castings added to maxe_xdr, ram_xdr, thc_xdr, seism_xdr
 * 
 * Revision 4.32  97/01/08  16:48:45  16:48:45  goetz (Andy Goetz)
 * Ported to Linux (2.0.9)
 * 
 Revision 4.31  1996/11/18 17:29:00  goetz
 Check

 * Revision 4.28  96/10/21  16:22:46  16:22:46  taurel (E.Taurel)
 * Check_in_after_port_to_OS9/ISP_2.1_and_OS9/RPC1.4
 * 
 * Revision 4.27  96/09/17  16:46:03  16:46:03  klotz (W.D. Klotz)
 * WD Klotz: checked NT build
 * 
 * Revision 4.26  96/07/19  10:01:12  10:01:12  taurel (E.Taurel)
 * Some_change_in_macros.h_for_the_API_port_to_OS-9_Ultra_C++
 * 
 * Revision 4.25  96/06/07  16:23:16  16:23:16  meyer (J.Meyer)
 * Corrected_elif_to_else_in_macros.h
 * 
 * Revision 4.24  96/06/05  15:01:52  15:01:52  meyer (J.Meyer)
 * Corrected_macros.h
 * 
 * Revision 4.23  96/06/03  13:10:30  13:10:30  meyer (J.Meyer)
 * Cleaned-up_MSDOS_and_added_porting_options_for_Windows_NT.
 * 
 * Revision 4.22  96/05/23  11:07:38  11:07:38  taurel (E.Taurel)
 * Added_some_definitions_for_C++_in_API_xdr.h_file
 * 
 * Revision 4.21  96/05/06  18:37:47  18:37:47  meyer (J.Meyer)
 * Fortran_compatibility_for:_dev_xdr.h,macros.h,maxe_xdr.h
 * 
 * Revision 4.20  96/02/27  13:31:47  13:31:47  meyer (J.Meyer)
 * Deleted_Cross_References_To_DSAPI_Library
 * 
 * Revision 4.19  96/01/11  17:40:33  17:40:33  meyer (Jens Meyer)
 * Added_#define_PORTMAP_to_macros.h.
 * 
 * Revision 4.18  95/12/21  10:33:54  10:33:54  meyer (Jens Meyer)
 * Corrected length calculation for D_VAR_MSTATARR.
 * 
 * Revision 4.17  95/08/02  16:05:25  16:05:25  meyer (Jens Meyer)
 * Corrected DevXdrKernel.h after C++ implementation.
 * 
 * Revision 4.15  95/03/02  10:28:22  10:28:22  meyer (Jens Meyer)
 * Added D_VAR_SFRPARR type to the kernel.
 * 
 * Revision 4.14  95/02/20  09:57:23  09:57:23  meyer (Jens Meyer)
 * Passed the compilers for HPUX, SUNOS and UCC after the first windows check in.
 * 
 * Revision 4.13  95/02/10  17:19:29  17:19:29  meyer (Jens Meyer)
 * Deleted
 * 
 * Revision 4.12  95/02/01  14:27:41  14:27:41  klotz (W.D. Klotz)
 * WDK: first successfull compile of dbase, api, xdr on WIN16/3.1
 * 
 * Revision 4.11  95/01/03  13:19:47  13:19:47  meyer (Jens Meyer)
 * Repared bug in dev_cmd_query() for version 3!
 * 
 * Revision 4.10  94/12/08  15:25:16  15:25:16  meyer (Jens Meyer)
 * Changed _manager_data in API_xdr and added old version to API_xdr_vers3.
 * 
 * Revision 4.9  94/11/28  17:04:40  17:04:40  meyer (Jens Meyer)
 * Data types for compatibility with library version 3.x
 * 
 * Revision 4.8  94/08/16  16:59:53  16:59:53  meyer (Jens Meyer)
 * Corrected error in ws_xdr.h
 * 
 * Revision 4.7  94/08/16  16:34:50  16:34:50  meyer (Jens Meyer)
 * Added define for MAX_RESOURCE_FIELD_LENGTH to macros.h
 * 
 * Revision 4.6  94/08/12  15:08:05  15:08:05  meyer (Jens Meyer)
 * Added valriable arguments to all API RPC structures.
 * 
 * Revision 4.5  94/07/20  18:16:04  18:16:04  meyer (Jens Meyer)
 * Changed include files in macros.h!
 * 
 * Revision 4.4  94/07/20  08:56:28  08:56:28  meyer (Jens Meyer)
 * All XDR functions with prototypes!
 * 
 * Revision 4.3  94/07/18  18:51:13  18:51:13  meyer (Jens Meyer)
 * Had to change macros.h, because #define must be in the first column!
 * 
 * Revision 4.2  94/07/18  18:22:56  18:22:56  meyer (Jens Meyer)
 * First test with PC macros for the XDR kernel.
 * 
 * Revision 4.1  94/05/02  10:51:06  10:51:06  meyer (Jens Meyer)
 * For Security System without connection count.
 * 
 * Revision 4.0  94/03/14  18:17:49  18:17:49  meyer (Jens Meyer)
 * Library version with Security System.
 * 
 * Revision 3.50  94/03/12  14:36:44  14:36:44  meyer (Jens Meyer)
 * Changed API xdr structures for security.
 * 
 * Revision 3.35  94/03/03  10:52:28  10:52:28  taurel (Emmanuel TAUREL)
 * Added unsigned long array type in the XDRkernel
 * 
 * Revision 3.34  94/03/03  10:29:18  10:29:18  taurel (Emmanuel TAUREL)
 * Added the unsigned long array type in
 * XDR kernel (LC and ET).
 * 
 * Revision 3.33  94/01/12  16:34:46  16:34:46  meyer (Jens Meyer)
 * Global XDR type array for data collector access
 * 
 * Revision 3.31  93/12/02  09:39:26  09:39:26  meyer (Jens Meyer)
 * New release with small XDR data type kernel.
 * 
 * Revision 1.1  93/12/01  14:19:34  14:19:34  meyer (Jens Meyer)
 * Initial revision
 * 


 Copyright (c) 1992 by European Synchrotron Radiation Facility,
		       Grenoble, France

*******************************************************************-*/

#ifndef _slit_xdr_h
#define _slit_xdr_h

/*
 *  definitions for slits
 */
 struct pslit_head {
       long pmain_st; /* The main device state ( from the state handler):
                         DEVON : all is good for you
                         DEVWARNING : at least on maxe acces failed or
                                      one basic device is DEVFAULT.
                         DEVFAULT : fatal error occured. */
       long dev_diag; /* device diagnostic. When pmain_st is not DEVON
                         The bits are numbered 0 to 23 from the right and
                          the value 1 corresponds to an error state.

                          bit 0 :  ReadState up blade failed.
                          bit 1 :  ReadPosition up blade failed. 
                          bit 2 :  ReadEncPos up blade failed.
                          bit 3 :  ReadSwitches up blade failed.
                          bit 4 :  ReadBrakeState up blade failed
                          bit 5 :  ReadTemperature up blade failed.
                          bit 6 :  ReadState down blade failed.
                          bit 7 :  ReadPosition down blade failed.
                          bit 8 :  ReadEncPos down blade failed.
                          bit 9 :  ReadSwitches down blade failed.
                          bit 10 : ReadBrakeState down blade failed
                          bit 11 : ReadTemperature down blade failed.
                          bit 12 : ReadState front blade failed.
                          bit 13 : ReadPosition front blade failed.
                          bit 14 : ReadEncPos front blade failed.
                          bit 15 : ReadSwitches front blade failed.
                          bit 16 : ReadBrakeState front blade failed
                          bit 17 : ReadTemperature front blade failed.
                          bit 18 : ReadState back blade failed.
                          bit 19 : ReadPosition back blade failed.
                          bit 20 : ReadEncPos back blade failed.
                          bit 21 : ReadSwitches back blade failed.
                          bit 22 : ReadBrakeState back blade failed
                          bit 23 : ReadTemperature back blade failed.

                      */       


       long unit;    /* the current unit :
                        1: STEPS: 2: MM; 3: MICRONS; 4: ROTATIONS;
                        5: DEGREES; 6: ARC_SEC
                     */ 
};
typedef struct pslit_head pslit_head;
bool_t 	_DLLFunc xdr_pslit_head PT_((XDR *xdrs, pslit_head *objp));


struct blade_state {
       long values_st; /* availability of each value. 1 if not available
                         00001 mot_pos
                         00010 enc_pos
                         00100 temp
                         01000 brake
                         10000 switch
                       */                       
       long mot_moving; /* 1 if the motor is moving 0 if not */
       float mot_pos;   /* in current unit */
       float enc_pos;   /* in current unit */
       float temp;      /* in degrees */
       long  brake;     /* DEVOPEN | DEVCLOSE | DEVFAULT */
       long  switch_st; /* LIMITSOFF | NEGATLIMIT | POSITLIMIT */
       long tuned;      /* TUNED | NOTTUNED */
};
typedef struct blade_state blade_state;
bool_t 	_DLLFunc xdr_blade_state PT_((XDR *xdrs, blade_state *objp));



struct DevBladeState {
       pslit_head pslit_head;
       blade_state up_state;
       blade_state do_state;
       blade_state fr_state;      
       blade_state ba_state;
};
typedef struct DevBladeState  	DevBladeState;
bool_t 	_DLLFunc xdr_DevBladeState PT_((XDR *xdrs, DevBladeState *objp));
#define D_BLADE_STATE           51
#define LOAD_BLADE_STATE(A)     xdr_load_type ( D_BLADE_STATE, \
                                                xdr_DevBladeState, \
                                                sizeof(DevBladeState), \
                                                NULL, \
                                                A )


struct pslit_state{
     long values_st; /* availability of each value. 1 if not available 
                       00000001 : gap
                       00000010 : offset
                       00000100 : temp_1 (up or front)
                       00001000 : temp_2 (down or back )
                       00010000 : brake_1 (up or front)
                       00100000 : brake_2 (down or back)
                       01000000 : switch_1 (up or front)
                       10000000 : switch_2 (down or back)
                       */ 
     float gap;      /* in current unit */
     float offset;   /* in current unit */
     float temp_1;   /* up or front blade in degrees */
     float temp_2;   /* down or back blade in degrees */
     long brake_1;   /* up or front blade: DEVOPEN | DEVCLOSE | DEVFAULT */
     long brake_2;   /* down or back DEVOPEN | DEVCLOSE | DEVFAULT */
     long switch_1;  /* up or front  LIMITSOFF | NEGATLIMIT | POSITLIMIT */
     long switch_2;  /* down or back LIMITSOFF | NEGATLIMIT | POSITLIMIT */
};

typedef struct pslit_state pslit_state; 
bool_t 	_DLLFunc xdr_pslit_state PT_((XDR *xdrs, pslit_state *objp));

struct DevPslitState {
 	pslit_head pslit_head;
        pslit_state vertical;
        pslit_state horizontal;
};
typedef struct  DevPslitState  	DevPslitState;
bool_t 	_DLLFunc xdr_DevPslitState PT_((XDR *xdrs, DevPslitState *objp));
#define D_PSLIT_STATE           52
#define LOAD_PSLIT_STATE(A)     xdr_load_type ( D_PSLIT_STATE, \
                                                xdr_DevPslitState, \
                                                sizeof(DevPslitState), \
                                                NULL, \
                                                A )

#endif /* _slit_xdr_h */

