
/*+*******************************************************************

 File:          bpm_xdr.h

 Project:       Device Servers with sun-rpc

 Description:   Include file for XDR definitions 
		of the Beam Position Monitor data
		types.

 Author(s):  	Jens Meyer

 Original:	July 1992


 $Revision: 5.18 $
 $Date: 1999/07/08 14:10:49 $

 $Author: goetz $

 $Log: bpm_xdr.h,v $
 Revision 5.18  1999/07/08 14:10:49  goetz
 changed _LPfd_set type for Linux in macros.h

 Revision 5.17  1998/05/25 17:59:50  klotz
 fixed C++ prototypes in api_xdr.h

 Revision 5.16  1998/04/29 10:24:12  goetz
 macros.h - added __STDCPP__ for HP C++ compiler (aCC)

 * Revision 5.15  97/12/01  15:22:15  15:22:15  klotz (W.D. Klotz)
 * WIN_NT_95_released_NOV_97
 * 
 * Revision 4.34  97/01/30  13:58:44  13:58:44  goetz (Andy Goetz)
 * removed dev_printdebug() from DevXdrKernel.h
 * 
 * Revision 4.33  97/01/09  10:08:49  10:08:49  goetz (Andy Goetz)
 * (xdrproc_t) castings added to maxe_xdr, ram_xdr, thc_xdr, seism_xdr
 * 
 * Revision 4.32  97/01/08  16:48:39  16:48:39  goetz (Andy Goetz)
 * Ported to Linux (2.0.9)
 * 
 Revision 4.31  1996/11/18 17:28:54  goetz
 Check

 * Revision 4.28  96/10/21  16:22:37  16:22:37  taurel (E.Taurel)
 * Check_in_after_port_to_OS9/ISP_2.1_and_OS9/RPC1.4
 * 
 * Revision 4.27  96/09/17  16:45:40  16:45:40  klotz (W.D. Klotz)
 * WD Klotz: checked NT build
 * 
 * Revision 4.26  96/07/19  10:01:07  10:01:07  taurel (E.Taurel)
 * Some_change_in_macros.h_for_the_API_port_to_OS-9_Ultra_C++
 * 
 * Revision 4.25  96/06/07  16:23:11  16:23:11  meyer (J.Meyer)
 * Corrected_elif_to_else_in_macros.h
 * 
 * Revision 4.24  96/06/05  15:01:47  15:01:47  meyer (J.Meyer)
 * Corrected_macros.h
 * 
 * Revision 4.23  96/06/03  13:10:25  13:10:25  meyer (J.Meyer)
 * Cleaned-up_MSDOS_and_added_porting_options_for_Windows_NT.
 * 
 * Revision 4.22  96/05/23  11:07:33  11:07:33  taurel (E.Taurel)
 * Added_some_definitions_for_C++_in_API_xdr.h_file
 * 
 * Revision 4.21  96/05/06  18:37:42  18:37:42  meyer (J.Meyer)
 * Fortran_compatibility_for:_dev_xdr.h,macros.h,maxe_xdr.h
 * 
 * Revision 4.20  96/02/27  13:31:43  13:31:43  meyer (J.Meyer)
 * Deleted_Cross_References_To_DSAPI_Library
 * 
 * Revision 4.19  96/01/11  17:40:28  17:40:28  meyer (Jens Meyer)
 * Added_#define_PORTMAP_to_macros.h.
 * 
 * Revision 4.18  95/12/21  10:33:44  10:33:44  meyer (Jens Meyer)
 * Corrected length calculation for D_VAR_MSTATARR.
 * 
 * Revision 4.17  95/08/02  16:05:20  16:05:20  meyer (Jens Meyer)
 * Corrected DevXdrKernel.h after C++ implementation.
 * 
 * Revision 4.15  95/03/02  10:28:07  10:28:07  meyer (Jens Meyer)
 * Added D_VAR_SFRPARR type to the kernel.
 * 
 * Revision 4.14  95/02/20  09:57:03  09:57:03  meyer (Jens Meyer)
 * Passed the compilers for HPUX, SUNOS and UCC after the first windows check in.
 * 
 * Revision 4.13  95/02/10  17:19:14  17:19:14  meyer (Jens Meyer)
 * Deleted
 * 
 * Revision 4.12  95/02/01  14:27:21  14:27:21  klotz (W.D. Klotz)
 * WDK: first successfull compile of dbase, api, xdr on WIN16/3.1
 * 
 * Revision 4.11  95/01/03  13:19:34  13:19:34  meyer (Jens Meyer)
 * Repared bug in dev_cmd_query() for version 3!
 * 
 * Revision 4.10  94/12/08  15:25:06  15:25:06  meyer (Jens Meyer)
 * Changed _manager_data in API_xdr and added old version to API_xdr_vers3.
 * 
 * Revision 4.9  94/11/28  17:04:28  17:04:28  meyer (Jens Meyer)
 * Data types for compatibility with library version 3.x
 * 
 * Revision 4.8  94/08/16  16:59:43  16:59:43  meyer (Jens Meyer)
 * Corrected error in ws_xdr.h
 * 
 * Revision 4.7  94/08/16  16:34:38  16:34:38  meyer (Jens Meyer)
 * Added define for MAX_RESOURCE_FIELD_LENGTH to macros.h
 * 
 * Revision 4.6  94/08/12  15:07:54  15:07:54  meyer (Jens Meyer)
 * Added valriable arguments to all API RPC structures.
 * 
 * Revision 4.5  94/07/20  18:15:54  18:15:54  meyer (Jens Meyer)
 * Changed include files in macros.h!
 * 
 * Revision 4.4  94/07/20  08:56:09  08:56:09  meyer (Jens Meyer)
 * All XDR functions with prototypes!
 * 
 * Revision 4.3  94/07/18  18:51:02  18:51:02  meyer (Jens Meyer)
 * Had to change macros.h, because #define must be in the first column!
 * 
 * Revision 4.2  94/07/18  18:22:35  18:22:35  meyer (Jens Meyer)
 * First test with PC macros for the XDR kernel.
 * 
 * Revision 4.1  94/05/02  10:50:55  10:50:55  meyer (Jens Meyer)
 * For Security System without connection count.
 * 
 * Revision 4.0  94/03/14  18:17:40  18:17:40  meyer (Jens Meyer)
 * Library version with Security System.
 * 
 * Revision 3.50  94/03/12  14:36:33  14:36:33  meyer (Jens Meyer)
 * Changed API xdr structures for security.
 * 
 * Revision 3.35  94/03/03  10:52:18  10:52:18  taurel (Emmanuel TAUREL)
 * Added unsigned long array type in the XDRkernel
 * 
 * Revision 3.34  94/03/03  10:29:09  10:29:09  taurel (Emmanuel TAUREL)
 * Added the unsigned long array type in
 * XDR kernel (LC and ET).
 * 
 * Revision 3.33  94/01/12  16:34:33  16:34:33  meyer (Jens Meyer)
 * Global XDR type array for data collector access
 * 
 * Revision 3.31  93/12/02  09:39:12  09:39:12  meyer (Jens Meyer)
 * New release with small XDR data type kernel.
 * 
 * Revision 1.1  93/11/16  11:30:10  11:30:10  meyer (Jens Meyer)
 * Initial revision
 * 

 Copyright (c) 1990 by European Synchrotron Radiation Facility,
		       Grenoble, France

*******************************************************************-*/

#ifndef _bpm_xdr_h
#define _bpm_xdr_h

/*
 * definitions for Beam Position Monitor types
 */

typedef float DevBpmElec [4];
bool_t _DLLFunc xdr_DevBpmElec PT_((XDR *xdrs, DevBpmElec objp));
long   _DLLFunc xdr_length_DevBpmElec PT_((DevBpmElec objp));



struct DevBpmMeasHead {
	unsigned short 	mn;
	unsigned short 	gms;
        struct {
		u_int 	    length;
		DevBpmElec *sequence;
	} momint;
};
typedef struct DevBpmMeasHead DevBpmMeasHead;
bool_t _DLLFunc xdr_DevBpmMeasHead PT_((XDR *xdrs, DevBpmMeasHead *objp));
long   _DLLFunc xdr_length_DevBpmMeasHead PT_((DevBpmMeasHead *objp));

struct DevBpmPos { 
	unsigned short 	mms;
	float 		xcoord;
	float 		zcoord;
};
typedef struct DevBpmPos DevBpmPos;
bool_t _DLLFunc xdr_DevBpmPos PT_((XDR *xdrs, DevBpmPos *objp));
long   _DLLFunc xdr_length_DevBpmPos PT_((DevBpmPos *objp));

struct DevBpmPosMeasure { 
	DevBpmMeasHead 	meashead;
	struct {
		u_int 	    length;
		DevBpmPos  *sequence;
	} posdata;
};
typedef struct DevBpmPosMeasure DevBpmPosMeasure;
bool_t _DLLFunc xdr_DevBpmPosMeasure PT_((XDR *xdrs,DevBpmPosMeasure *objp));
long   _DLLFunc xdr_length_DevBpmPosMeasure PT_((DevBpmPosMeasure *objp));



struct DevBpmElecMeasure { 
	DevBpmMeasHead 	meashead;
        struct {
		u_int 	    length;
		DevBpmElec *sequence;
	} elecdata;
};
typedef struct DevBpmElecMeasure DevBpmElecMeasure;
bool_t _DLLFunc xdr_DevBpmElecMeasure
		PT_((XDR *xdrs, DevBpmElecMeasure *objp));
long   _DLLFunc xdr_length_DevBpmElecMeasure PT_((DevBpmElecMeasure *objp));

struct DevBpmMeasParm { 
	long expbeamint;
	long timewind;
	long delaytim[6];
};
typedef struct DevBpmMeasParm DevBpmMeasParm;
bool_t _DLLFunc xdr_DevBpmMeasParm PT_((XDR *xdrs, DevBpmMeasParm *objp));
long   _DLLFunc xdr_length_DevBpmMeasParm PT_((DevBpmMeasParm *objp));

struct DevBpmInjectHead	{ 
	unsigned short min;
	unsigned long  gis;
	DevBpmMeasParm bpm_measpar;
};
typedef struct DevBpmInjectHead DevBpmInjectHead;
bool_t _DLLFunc xdr_DevBpmInjectHead
		PT_((XDR *xdrs, DevBpmInjectHead *objp));
long   _DLLFunc xdr_length_DevBpmInjectHead PT_((DevBpmInjectHead *objp));



struct DevBpmPosField { 
	DevBpmInjectHead injhead;
	struct 	{
		u_int 		 length;
	  	DevBpmPosMeasure *sequence;
		} posmeas;
};
typedef struct DevBpmPosField 	DevBpmPosField;
bool_t 	_DLLFunc xdr_DevBpmPosField PT_((XDR *xdrs, DevBpmPosField *objp));
long   	_DLLFunc xdr_length_DevBpmPosField PT_((DevBpmPosField *objp));
#define D_BPM_POSFIELD          13
#define LOAD_BPM_POSFIELD(A)    xdr_load_type ( D_BPM_POSFIELD, \
                                                xdr_DevBpmPosField, \
                                                sizeof(DevBpmPosField), \
                                                xdr_length_DevBpmPosField, \
                                                A )


struct DevBpmElecField { 
	DevBpmInjectHead injhead;
	struct 	{
		u_int 		  length;
		DevBpmElecMeasure *sequence;
		} elecmeas;
};
typedef struct DevBpmElecField 	DevBpmElecField;
bool_t 	_DLLFunc xdr_DevBpmElecField PT_((XDR *xdrs, DevBpmElecField *objp));
long   	_DLLFunc xdr_length_DevBpmElecField PT_((DevBpmElecField *objp));
#define D_BPM_ELECFIELD         14
#define LOAD_BPM_ELECFIELD(A)    xdr_load_type ( D_BPM_ELECFIELD, \
                                                xdr_DevBpmElecField, \
                                                sizeof(DevBpmElecField), \
                                                xdr_length_DevBpmElecField, \
                                                A )


#endif /* _bpm_xdr_h */

