/****************************************************************************

 File          :   test_asc_dyn.c

 Project       :   ASCII based interface to device server API

 Description   :   The code for a C program (main) which test the shared
                   library libascapi.sl

 Author        :   Faranguiss Poncet

 Original      :   November 1996

 $Revision: 1.7 $                               $Author: poncet $
 $Date: 97/04/10 15:49:23 $                                     $State: Rel $

 $Log:	test_asc_dyn.c,v $
 * Revision 1.7  97/04/10  15:49:23  15:49:23  poncet (F.Poncet)
 * Unchanged. Archived for compatible revision numbers with libascapi.sl.
 * 
 * Revision 1.6  97/03/21  14:35:36  14:35:36  poncet (F.Poncet)
 * File Unchanged. Archived for compatible revision numbers with ascapi lib.
 * 
 * Revision 1.5  97/02/18  13:47:32  13:47:32  poncet (F.Poncet)
 * File not changed. Archived for compatible revision numbers.
 * 
 * Revision 1.4  97/01/21  16:01:16  16:01:16  poncet (F.Poncet)
 * File rearchived to initialize the first officially released version.
 * 
 * Revision 1.4  97/01/10  13:12:31  13:12:31  poncet (F.Poncet)
 * The typing of the input argument is now handled better, using "gets"
 * instead of scanf.
 * 
 * Revision 1.3  97/01/08  14:04:59  14:04:59  poncet (F.Poncet)
 * The name of the three functions have changed from (asc_dev_get, asc_dev_put,
 * asc_dev_putget) to (dev_get_ascii, dev_put_ascii, dev_putget_ascii)
 * respectively.
 * 
 * Revision 1.2  97/01/07  17:49:14  17:49:14  poncet (F.Poncet)
 * The two functions "dev_put_ascii" and "dev_putget_ascii" have been added into
 * the library. The test_asc_dyn.c now makes use of these new functions.
 * 
 * Revision 1.1  96/11/25  18:16:31  18:16:31  poncet (F.Poncet)
 * Initial revision
 * 

 Copyright (c) 1996 by European Synchrotron Radiation Facility,
                       Grenoble, France

                       All Rights Reserved

****************************************************************************/

#include <stdlib.h>
#include <string.h>
#include <errno.h>

#include <API.h>
#include <asc_api.h>

#ifdef __hpux
#include <dl.h>
#else
#include <dlfcn.h>
#endif /* __hpux */


#ifdef __hpux
shl_t ASC_shl;
#else
void *ASC_shl;
#endif /* __hpux */




main ()
{
   long                        err;
   db_resource                 res;
   char                        *lib_path;
   char                        *dev_name;

   char                        func_name[101];
   long                        (*p_get_func)();
   long                        (*p_put_func)();
   long                        (*p_putget_func)();

   char                        device_name[101];
   char                        command_name[101];
   char                        in_arg[501];
   char                        out_str[3001];
   char                        err_str[1001];
   char                        *out_param, *err_param;
   long                        get_status;




   /*** Try to find the path for the type conversion library in Data Base ***/
   if (db_import(&err))
   {
      printf("test_asc_dev : Cannot import static database to find libpath.\n");
      printf("test_asc_dev : program aborted.\n");
      exit(-1);
   }
#ifdef __hpux
   dev_name = "sys/libasc/s700";
#else
   dev_name = "sys/libasc/solaris";
#endif /* __hpux */
   lib_path = NULL;
   res.resource_name = "path";
   res.resource_adr = &lib_path;
   res.resource_type = D_STRING_TYPE;
   db_getresource(dev_name,&res,1,&err);

   /*** Did not find the libpath in static database so set it to default ***/
   if (lib_path == (char *)NULL)
#ifdef __hpux
      lib_path = ASC_HPUX_DEF_PATH;
#else
      lib_path = ASC_SOLARIS_DEF_PATH;
#endif /* __hpux */


   /*** Load the ascii dev api  shared library ***/

#ifdef __hpux
   ASC_shl = shl_load(lib_path,BIND_IMMEDIATE,0);
   if (ASC_shl == NULL)
   {
      printf("test_asc_dev : Cannot load the ascii dev api shared library.\n");
 printf("test_asc_dev : errno = %d\n", errno);
      printf("test_asc_dev : lib_path = %s\n", lib_path);
      printf("test_asc_dev : program aborted.\n");
      exit(-1);
   }
#else
   ASC_shl = dlopen(lib_path,1);
   if (ASC_shl == NULL)
   {
      printf("test_asc_dev : Cannot load the ascii dev api shared library.\n");
      printf("test_asc_dev : lib_path = %s\n", lib_path);
      printf("test_asc_dev : program aborted.\n");
      exit(-1);
   }
#endif /* __hpux */


   /*** Find the dev_get function in the ascii dev api dynamic lib ***/

   strcpy (func_name, ASC_GET_FUNCTION);
#ifdef __hpux
   if (shl_findsym(&ASC_shl, func_name, TYPE_PROCEDURE, &p_get_func) == -1)
   {
      printf("test_asc_dev : cannot resolve symbol = %s\n", func_name);
      p_get_func = NULL;
   }
#else
   p_get_func = (long (*)()) dlsym(ASC_shl, func_name);
   if (p_get_func == NULL)
   {
      printf("test_asc_dev : cannot resolve symbol = %s\n", func_name);
   };
#endif /* __hpux */



   /*** Find the dev_put function in the ascii dev api dynamic lib ***/

   strcpy (func_name, ASC_PUT_FUNCTION);
#ifdef __hpux
   if (shl_findsym(&ASC_shl, func_name, TYPE_PROCEDURE, &p_put_func) == -1)
   {
      printf("test_asc_dev : cannot resolve symbol = %s\n", func_name);
      p_put_func = NULL;
   }
#else
   p_put_func = (long (*)()) dlsym(ASC_shl, func_name);
   if (p_put_func == NULL)
   {
      printf("test_asc_dev : cannot resolve symbol = %s\n", func_name);
   };
#endif /* __hpux */




   /*** Find the dev_putget function in the ascii dev api dynamic lib ***/

   strcpy (func_name, ASC_PUTGET_FUNCTION);
#ifdef __hpux
   if (shl_findsym(&ASC_shl, func_name, TYPE_PROCEDURE, &p_putget_func) == -1)
   {
      printf("test_asc_dev : cannot resolve symbol = %s\n", func_name);
      p_putget_func = NULL;
   }
#else
   p_putget_func = (long (*)()) dlsym(ASC_shl, func_name);
   if (p_putget_func == NULL)
   {
      printf("test_asc_dev : cannot resolve symbol = %s\n", func_name);
   };
#endif /* __hpux */





   printf("\n\nLet's first try the dev_get_ascii command.\n\n");

 
   while (1)
   {
      printf("\n\nType in the name of the device : ");
      scanf("%s", device_name);

      if (strcmp("END", device_name) == 0)
         break;

      printf("\n\nType in the name of the command : ");
      scanf("%s", command_name);

      printf("Device = %s  ,  ", device_name);
      printf("Command = %s\n", command_name);

      if (p_get_func == NULL)
         break;

      out_str[0] = '\0';
      err_str[0] = '\0';
      out_param = (char *) out_str;
      err_param = (char *) err_str;

      if ( (*p_get_func)(device_name, command_name, &out_param, &err_param) == 0 )
      {
         printf("Youpi! dev_get_ascii succeeded!\n");
         printf("out argument = %s\n", out_str);
      }
      else
      {
         printf("Zut! dev_get_ascii failed!\n");
         printf("error message = %s\n", err_str);
      }
   }




   printf("\n\nNow let's try the dev_put_ascii command.\n\n");

 
   while (1)
   {
      printf("\n\nType in the name of the device : ");
      scanf("%s", device_name);

      if (strcmp("END", device_name) == 0)
         break;

      printf("\n\nType in the name of the command : ");
      scanf("%s", command_name);

      printf("\n\nType in the input argument respecting its format : ");
/*************************************************************************
      scanf("%s", in_arg);  replaced by the 6 following lines.
*************************************************************************/
      gets(in_arg);
      if (gets(in_arg) == NULL)
      {
         printf("test_asc_dyn : gets failed.\n");
         continue;
      }

      printf("Device = %s  ,  ", device_name);
      printf("Command = %s  ,  ", command_name);
      printf("Input Argument = %s\n", in_arg);

      if (p_put_func == NULL)
         break;

      out_str[0] = '\0';
      err_str[0] = '\0';
      out_param = (char *) out_str;
      err_param = (char *) err_str;

      if ( (*p_put_func)(device_name, command_name, in_arg, &err_param) == 0 )
      {
         printf("Youpi! dev_put_ascii succeeded!\n");
         printf("error message = %s\n", err_str);
      }
      else
      {
         printf("Zut! dev_put_ascii failed!\n");
         printf("error message = %s\n", err_str);
      }
   }




   printf("\n\nFinally let's try the dev_putget_ascii command.\n\n");

 
   while (1)
   {
      printf("\n\nType in the name of the device : ");
      scanf("%s", device_name);

      if (strcmp("END", device_name) == 0)
         break;

      printf("\n\nType in the name of the command : ");
      scanf("%s", command_name);

      printf("\n\nType in the input argument respecting its format : ");
/*************************************************************************
      scanf("%s", in_arg);  replaced by the 6 following lines.
*************************************************************************/
      gets(in_arg);
      if (gets(in_arg) == NULL)
      {
         printf("test_asc_dyn : gets failed.\n");
         continue;
      }

      printf("Device = %s  ,  ", device_name);
      printf("Command = %s  ,  ", command_name);
      printf("Input Argument = %s\n", in_arg);

      if (p_putget_func == NULL)
         break;

      out_str[0] = '\0';
      err_str[0] = '\0';
      out_param = (char *) out_str;
      err_param = (char *) err_str;

      if ( (*p_putget_func)(device_name, command_name, in_arg,
                                         &out_param, &err_param) == 0 )
      {
         printf("Youpi! dev_putget_ascii succeeded!\n");
         printf("out argument = %s\n", out_str);
         printf("error message = %s\n", err_str);
      }
      else
      {
         printf("Zut! dev_putget_ascii failed!\n");
         printf("error message = %s\n", err_str);
      }
   }

}


