static char RcsID[]="$Header: dataport_os9.c,v 2.10 98/11/19 16:14:47 taurel Exp $";

/***************************************************************************
 *
 * $Source: /segfs/dserver/system/dataport/src/RCS/dataport_os9.c,v $
 *
 * $Author: taurel $
 * $Date: 98/11/19 16:14:47 $
 *
 * $Log:	dataport_os9.c,v $
 * Revision 2.10  98/11/19  16:14:47  16:14:47  taurel (E.Taurel)
 * No change in OS-9 release. Only change in UNIX release (added a non-blocking
 * call).
 * 
 * Revision 2.9  96/07/17  11:02:09  11:02:09  taurel (E.Taurel)
 * Remove _ev_wait_t definition for OS-9 release
 * 
 * Revision 2.8  96/07/17  10:55:10  10:55:10  taurel (E.Taurel)
 * To get correct version number !!!!!!!!!!!!
 * 
 * Revision 2.7  96/07/17  10:53:01  10:53:01  taurel (E.Taurel)
 * Check out in order to get correct version number in
 * all files.
 * 
 * Revision 2.6  96/01/05  17:30:42  17:30:42  taurel (E.Taurel)
 * Ported to Solaris
 * 
 * Revision 2.5  95/12/22  10:27:42  10:27:42  taurel (Emmanuel TAUREL)
 * Change in UNIX semaphore management to strictly
 * follow the SUN specification of the semctl function.
 * 
 * Revision 2.4  94/11/22  16:19:09  16:19:09  taurel (Emmanuel TAUREL)
 * Change in the OS-9 release of the Closedataport
 * call the munlink function by a munload function
 * 
 * Revision 2.3  94/11/21  16:47:00  16:47:00  taurel (Emmanuel TAUREL)
 * Also remove the test on process ID
 * when the user try to close a dataport.
 * 
 * Revision 2.2  94/09/28  15:42:02  15:42:02  taurel (Emmanuel TAUREL)
 * Change
 * 
 * Revision 2.0  94/08/12  12:45:32  12:45:32  taurel (Emmanuel Taurel)
 * First check in after ET take over this
 * bloody dataport
 * 
 * Revision 1.1  92/06/30  11:05:06  11:05:06  carron (Daevid Carron)
 * Initial revision
 * 
 * Revision 1.1  92/06/11  14:24:31  14:24:31  carron (Daevid Carron)
 * Initial revision
 * 
 * Revision 2.1  91/10/16  10:47:26  10:47:26  carron (Daevid Carron)
 * corrected a bug in CreateDataport which prevented the port
 * from being unlinked.
 * 
 * Revision 2.0  91/09/16  10:58:34  10:58:34  carron (Daevid Carron)
 * Brought all modules involved with NFS RPC servers up to revision 2.0
 * 
 * Revision 1.1  91/08/07  10:06:14  10:06:14  carron (Daevid Carron)
 * Initial revision
 * 
 *
 ***************************************************************************/

#include <stdio.h>
#include <signal.h>

#include <dataport.h>
#include <dataportP.h>
#include <sema.h>
#include <events.h>

#include <errno.h>
#ifdef _UCC
#include <errno_os9.h>
#endif /* _UCC */

static long InitialiseSemaphore();
static long DeinitialiseSemaphore();

extern int errno;



/************************************************************************
 Function   :  extern Dataport *CreateDataport()

 Description:  create a Dataport

 Arg(s) In  :  name      name of Dataport
               size      size of Dataport body

 Return(s)  :  NULL on failure, pointer to Dataport otherwise.
*************************************************************************/
extern Dataport *CreateDataport(name,size)   char   *name;
                                             long   size;
{
   Dataport   *thisdataport;
   unsigned   fullsize;
   short      attr,
              perm;

   long      ret;

   /* verify inputs */
   if(strlen(name)>10)
   {
      printf("can't crate dataport, name too long (max 10 char)\n");
      return(NULL);
   }
   if(size<=0)
      return(NULL);

   /* open a data module for the port */
   fullsize=size+sizeof(Dataport);
   attr=mkattrevs(MA_REENT,1);
   perm=   MP_OWNER_READ|MP_OWNER_WRITE|
         MP_GROUP_READ|MP_GROUP_WRITE|
         MP_WORLD_READ|MP_WORLD_WRITE;

   _mkdata_module(name,fullsize,attr,perm);
   thisdataport=(Dataport *)modlink(name,MT_ANY);

   if(thisdataport==(Dataport *)(-1))
   {
#ifdef EBUG
      fprintf(stderr,"modlink(%s) failed\n",name,fullsize);
#endif
      return(NULL);
   }

   /* initialise values in dataport */

   /* initialise pid entry */
   thisdataport->pid=getpid();

   /* initialise semaphore entry */
   if(InitialiseSemaphore(name,&(thisdataport->sem))!=0)
   {
#ifdef EBUG
      fprintf(stderr,"InitialisedSemaphore() failed\n");
#endif
      /* unlink datamodule */
      munlink(thisdataport);
      return(NULL);
   }

   strcpy(thisdataport->semname,name);

   /* return pointer to initialised dataport */
   return(thisdataport);
}



/************************************************************************
 Function   :  extern long CloseDataport()

 Description:  close Dataport, releasing system resources

 Arg(s) In  :  thisdataport   Dataport to close
	       name	      name of the dataport (used only in UNIX version)

 Return(s)  :  minus one on failure, zero otherwise.
*************************************************************************/
extern long CloseDataport(thisdataport, name)   Dataport *thisdataport;
						char     *name;
{
   long   i;
   long ret;

   /* check process id */
   /* if(getpid()!=thisdataport->pid)
      return(-1);*/

   /* delete the semaphore */
   if(DeinitialiseSemaphore(thisdataport->semname,&(thisdataport->sem))==(-1))
   {
      fprintf(stderr,"DeinitialiseSemaphore() failed\n");
      return(-1);
   }

   /* unlink the data module until it goes away */
     do {
	ret = munload(name,0);
	}while(ret != -1);

   return(0);
}



/************************************************************************
 Function   :  extern Dataport *OpenDataport()

 Description:  link to a Dataport

 Arg(s) In  :  name      name of Dataport
	       size	 not used
 Return(s)  :  NULL on failure, pointer to Dataport otherwise.

*************************************************************************/
extern Dataport *OpenDataport(name, size)   char   *name;
				      long   size;
{
   Dataport *thisdataport;

   thisdataport=(Dataport *)modlink(name,MT_ANY);
   if(thisdataport==(Dataport *)(-1))
   {
      return(NULL);
   }
   return(thisdataport);
}



/************************************************************************
 Function   :  extern long AccessDataport()

 Description:  request exclusive access to a Dataport

 Arg(s) In  :  dp         Dataport

 Return(s)  :  -1 on failure, 0 otherwise.
*************************************************************************/
extern long AccessDataport(dp)   Dataport   *dp;
{
   if(_ev_wait_t(dp->sem,0,32767,OS9_DEADLOCK_WAIT,0)==(-1))
      return(-1);
   return(0);
}



/************************************************************************
 Function   :  extern long ReleaseDataport()

 Description:  relinquish exclusive access to Dataport

 Arg(s) In  :  dp      Dataport

 Return(s)  :  -1 on failure, 0 otherwise.
*************************************************************************/
extern long ReleaseDataport(dp)   Dataport   *dp;
{
   int ret;
   ret=0;
   errno=0;
   ret=_ev_signal(dp->sem,0x8000);

   if(errno!=0)
      return(-1);
   return(0);
}



/************************************************************************
 Function   :  long InitialiseSemaphore()

 Description:  Create an event used as a semaphore

 Arg(s) In  :  name      name of Dataport

 Arg(s) Out :  sem       The semaphore ID

 Return(s)  :  NULL if successful, -1 otherwise.
*************************************************************************/
static long InitialiseSemaphore(name,sem)   char         *name;
                                            Semaphore   *sem;
{
   int semid;

   semid=_ev_creat(0,-1,1,name);
   if (semid == -1)
      return(-1);
   *sem = semid;
   return(0);
}



/************************************************************************
 Function   :  long DeinitialiseSemaphore()

 Description:  Delete the event

 Arg(s) In  :  name      name of Dataport
	       sem	 semaphore ID

 Return(s)  :  NULL on failure, pointer to Dataport otherwise.
*************************************************************************/
static long DeinitialiseSemaphore(name,sem)   char         *name;
                                              Semaphore   *sem;
{
   do
   {
      _ev_unlink(*sem);
   } while(_ev_delete(name)!=(-1));

   return(0);
}

