
/*+*******************************************************************

 File:          DserverTeams.h

 Project:       Device Servers with SUN-RPC

 Description:   Include file with the definitions for all 
		device server programming teams.

 Author(s):     Jens Meyer

 Original:      July 1993


 $Revision: 4.28 $
 $Date: 1999/11/21 14:46:23 $

 $Author: goetz $

 $Log: DserverTeams.h,v $
 Revision 4.28  1999/11/21 14:46:23  goetz
 added FRMTeamNumber

 * Revision 4.26  96/05/30  16:01:41  16:01:41  meyer (J.Meyer)
 * Change hex masks to decimal values for Fortran compilation.
 * 
 * Revision 4.25  96/05/06  18:40:18  18:40:18  meyer (J.Meyer)
 * Fortran compatible include file.
 * 
 * Revision 4.24  95/02/15  18:58:02  18:58:02  dserver ()
 * checked windows version: compiles wthout errors.
 * 
 * Revision 4.7  94/07/20  17:08:22  17:08:22  meyer (Jens Meyer)
 * Version with MSDOS include files.
 * The same version number as API-lib.
 * 
 * Revision 3.28  94/06/15  15:48:02  15:48:02  meyer (Jens Meyer)
 * *** empty log message ***
 * 
 * Revision 3.27  94/02/21  17:44:21  17:44:21  taurel (Emmanuel TAUREL)
 * Added a new number for the system team.
 * 
 * Revision 3.26  93/10/11  11:07:34  11:07:34  taurel (Emmanuel TAUREL)
 * Added definition for the error category and for the warning case.
 * 
 * Revision 3.25  93/09/24  17:25:17  17:25:17  meyer (Jens Meyer)
 * Release with error and command resources.
 * 
 * Revision 3.21  93/08/11  12:11:17  12:11:17  meyer (Jens Meyer)
 * Changed shift bits for Team Number and DS Identification.
 * 
 * Revision 3.20  93/08/10  12:54:25  12:54:25  meyer (Jens Meyer)
 * Database support for commands and errors.
 * 
 * Revision 1.1  93/08/10  11:22:17  11:22:17  meyer ()
 * Initial revision
 * 

 Copyright (c) 1990 by European Synchrotron Radiation Facility,
		       Grenoble, France

********************************************************************-*/

#ifndef _DserverTeams_h
#define _DserverTeams_h

/*
 * Definitions to code and decode the error and command numbers.
 */

#define DS_TEAM_SHIFT   	26
#define DS_IDENT_SHIFT   	18
#define DS_CAT_SHIFT		12

#define DS_TEAM_MASK          63      /* value = 0x3f */
#define DS_IDENT_MASK         255     /* value = 0xff */
#define DS_CAT_MASK           63      /* value = 0x3f */

/**************  Device server development Teams definition  **************/

#define CntrlTeamNumber DS_LSHIFT(1,DS_TEAM_SHIFT) /* CS - Control group */
#define DasTeamNumber   DS_LSHIFT(2,DS_TEAM_SHIFT) /* CS - Data acquisition */
#define ExpTeamNumber   DS_LSHIFT(3,DS_TEAM_SHIFT) /* Experiments-Programming */
#define CrgTeamNumber   DS_LSHIFT(4,DS_TEAM_SHIFT) /* External - CRG */
#define BlcTeamNumber   DS_LSHIFT(5,DS_TEAM_SHIFT) /* CS - Beam Line Control */
#define SysTeamNumber   DS_LSHIFT(6,DS_TEAM_SHIFT) /* CS - System Team */
#define MachTeamNumber  DS_LSHIFT(7,DS_TEAM_SHIFT) /* Machine - Theory Group */
#define FRMTeamNumber   DS_LSHIFT(8,DS_TEAM_SHIFT) /* FRM-II - Garching */

/**************  Device server error category definition  **************/

#define WarningError	63      /* value = 0x3f : Just a warning */

#endif	/* _DserverTeams_h */
