/*+*******************************************************************

 File:          DasDsNumbers.h

 Project:       Device Servers with SUN-RPC

 Description:   Include file with the definitions for all
                DAS projects

 Author(s):     A.Beteva

 Original:      Aug 1993

 $Revision: 3.39 $
 $Date: 1998/10/20 21:12:52 $

 $Author: pons $
 $Log: DasDsNumbers.h,v $
 Revision 3.39  1998/10/20 21:12:52  pons
 Icv101Base definition deleted and moved to CntrlDsNumbers.h

 * Revision 3.38  97/03/26  17:15:23  17:15:23  sever (F.Sever)
 * changing XDS to Xds
 * 
 * Revision 3.37  97/03/26  14:02:42  14:02:42  epaud (F.Epaud)
 * *** empty log message ***
 * 
 * Revision 3.36  1997/03/26  13:37:06  epaud
 * Added
 *  DevXDSBase device server number
 *
 * Revision 3.36  1997/03/26  13:37:06  epaud
 * Added
 *  DevXDSBase device server number
 *
 * Revision 3.35  1996/11/20  16:15:42  sever
 * Added DevV850Base
 *
 * Revision 3.34  96/08/14  16:39:31  16:39:31  beteva (A.Beteva)
 * Added DevScanBase
 * 
 * Revision 3.33  96/06/21  15:34:34  15:34:34  sever (F.Sever)
 * added DevVtdc4Base and DevVccd3Base
 * 
 * Revision 3.32  96/05/14  08:40:19  08:40:19  meyer (J.Meyer)
 * Added brackets around base definition.
 * 
 * Revision 3.31  96/05/13  10:45:24  10:45:24  meyer (J.Meyer)
 * Corrected copy and paste error!!
 * 
 * Revision 3.30  96/05/06  18:40:14  18:40:14  meyer (J.Meyer)
 * Fortran compatible include file.
 * 
 * Revision 3.29  94/05/30  17:32:46  17:32:46  beteva (A.Beteva)
 * changed DevHcBase to DevVhistBase
 * 
 * Revision 3.28  94/05/27  17:54:44  17:54:44  beteva (Antonia Beteva)
 * added VCT6 card
 * 
 * Revision 3.27  94/02/24  13:49:56  13:49:56  taurel
 * Up to date by E.T to stop the different release of this file !
 * 
 * Revision 3.25  93/09/29  20:04:20  20:04:20  beteva (Antonia Beteva)
 * Official release
 * Revision forced to correspond the library one
 * 
 * Revision 1.1  93/09/29  20:03:59  20:03:59  beteva (Antonia Beteva)
 * Initial revision
 * 
 Copyright (c) 1990 by European Synchrotron Radiation Facility,
                       Grenoble, France
********************************************************************-*/

#ifndef _DasDsNumbers_h
#define _DasDsNumbers_h

#include <DserverTeams.h>

/* ESRF-VDL ****************/
#define DevVdlBase       (DasTeamNumber + DS_LSHIFT(1, DS_IDENT_SHIFT))
/* ELTEC-IC40 **************/
#define DevIpcBase       (DasTeamNumber + DS_LSHIFT(2, DS_IDENT_SHIFT))
/* NOVELEC-MCCE ************/
#define DevMcceBase      (DasTeamNumber + DS_LSHIFT(3, DS_IDENT_SHIFT))
/*** ESRF - SKELETON *******/
#define DevSkelBase      (DasTeamNumber + DS_LSHIFT(4, DS_IDENT_SHIFT))
/*** LECROY 1151 - COUNTER */
#define DevCntBase       (DasTeamNumber + DS_LSHIFT(5, DS_IDENT_SHIFT))
/*** ESRF - TDC CI022 ******/
#define DevTdcBase       (DasTeamNumber + DS_LSHIFT(6, DS_IDENT_SHIFT))
/* CAEN V462 - GATEGEN *****/
#define DevGategenBase   (DasTeamNumber + DS_LSHIFT(7, DS_IDENT_SHIFT))
/*** EC740 TFG *************/
#define DevTfgBase       (DasTeamNumber + DS_LSHIFT(9, DS_IDENT_SHIFT))
/*** EC738 MCS *************/
#define DevMcsBase       (DasTeamNumber + DS_LSHIFT(10, DS_IDENT_SHIFT))
/*** VVHIST ****************/
#define DevVhistBase     (DasTeamNumber + DS_LSHIFT(11, DS_IDENT_SHIFT))
/*** HM - MM6326 ***********/
#define DevHmBase        (DasTeamNumber + DS_LSHIFT(12, DS_IDENT_SHIFT))
/*** Delay Line Detector ***/
#define DevDldBase       (DasTeamNumber + DS_LSHIFT(13, DS_IDENT_SHIFT))
/*** Multi Channel Analyser ***/
#define DevMcaBase     	 (DasTeamNumber + DS_LSHIFT(14, DS_IDENT_SHIFT))
/*** GPIB ******************/
#define DevGpibBase	 (DasTeamNumber + DS_LSHIFT(15, DS_IDENT_SHIFT))
/*** ESRF - VCT6 (counter/timer) ******/
#define DevVCT6Base	 (DasTeamNumber + DS_LSHIFT(16, DS_IDENT_SHIFT))
/*** ESRF - TDC CI029 ******/
#define DevNTdcBase	 (DasTeamNumber + DS_LSHIFT(17, DS_IDENT_SHIFT))
/*** ESRF - XFR (data transfer) ******/
#define DevXfrBase	 (DasTeamNumber + DS_LSHIFT(18, DS_IDENT_SHIFT))
/*** ESRF - MemAcq (acq simulator) ******/
#define DevMemacqBase	 (DasTeamNumber + DS_LSHIFT(19, DS_IDENT_SHIFT))
/*** LeCroy - LTDC ******/
#define DevLTDCBase	 (DasTeamNumber + DS_LSHIFT(20, DS_IDENT_SHIFT))
/*** EMBL Xray scanner  ******/
#define DevXrayscanBase	 (DasTeamNumber + DS_LSHIFT(21, DS_IDENT_SHIFT))
/*** ESRF - VTDC4 (4 channel VME TDC)  ******/
#define DevVtdc4Base	 (DasTeamNumber + DS_LSHIFT(22, DS_IDENT_SHIFT))
/*** ESRF - VCCD3 (VME CCD3 camera i/f)  ******/
#define DevVccd3Base	 (DasTeamNumber + DS_LSHIFT(23, DS_IDENT_SHIFT))
/*** Scan based on Vct6 and Vpap device server ******/
#define DevScanBase	 (DasTeamNumber + DS_LSHIFT(24, DS_IDENT_SHIFT))
/*** V850 digital delay generator ******/
#define DevV850Base  (DasTeamNumber + DS_LSHIFT(25, DS_IDENT_SHIFT))
/*** DDA/XDS X-ray Digital Spectroscopy ******/
#define DevXdsBase  (DasTeamNumber + DS_LSHIFT(26, DS_IDENT_SHIFT))

#endif	/* _DasDsNumbers_h */
