static char RcsId[]      =
"@(#)$Header: oic.c,v 8.14 2000/06/22 14:50:32 goetz Rel $";
/*+*******************************************************************

 File:		oic.c

 Project:	Device Servers in C++

 Description:	source code for Objects In C (OIC) a method for creating 
		classes in C. The source code has been derived from the
		version 4.27 of the original file svc_api.c.

 Author(s);	Andy Gotz

 Original:	July 1995

 $Revision: 8.14 $
 $Date: 2000/06/22 14:50:32 $

 $Author: goetz $

 $Log:	oic.c,v $
 * Revision 8.14  2000/06/22  14:50:32  14:50:32  goetz (Andrew GOETZ)
 * fixed bug in dev_event_listen() which caused server to crash
 * 
 Revision 8.13  2000/06/02 21:56:49  goetz
 _DEVICE_H now _TANGO_DEVICE_H in Device.H; (char*)taco_tango

 Revision 8.12  2000/06/02 15:58:06  goetz
 dev_event_fire() now device specific; ported to SuSE V6.4

 Revision 8.11  2000/05/31 07:47:53  goetz
 tango_api has local copies of argc and argv, ported to HP-UX

 * Revision 8.10  2000/05/29  21:39:19  21:39:19  goetz (Andrew GOETZ)
 * fixed prototyping problems with C++ on HP-UX
 * 
 * Revision 8.9  2000/05/29  18:13:29  18:13:29  goetz (Andrew GOETZ)
 * fixed bug in dev_import_timeout() which prevented timeouts < 2s
 * 
 Revision 8.8  2000/05/02 15:32:13  goetz
 added prototype for tsleep() for OS9 C++

 * Revision 8.7  2000/05/02  14:19:35  14:19:35  goetz (Andy Goetz)
 * removed check for device server running on different host
 * 
 * Revision 8.6  2000/05/02  13:29:28  13:29:28  goetz (Andy Goetz)
 * added random sleep to gettransient + 3 retries
 * 
 Revision 8.5  2000/03/27 17:13:45  goetz
 declared pmap_getmaps() as external C function for OS9 C++

 Revision 8.4  2000/03/13 14:50:02  goetz
 import timeout now programmable using dev_import_timeout()

 Revision 8.3  2000/03/13 10:31:35  goetz
 added Jens' modifications to fix bug in local putget

 Revision 8.2  2000/03/10 17:01:23  goetz
 dev_synch() now excludes udp clients and new imports

 Revision 8.1  2000/01/18 16:48:48  goetz
 tango_dev_import() now only called in dev_import if -DTANGO

 Revision 8.0  1999/12/28 14:18:31  goetz
 added TANGO support for TACO dev_xxx() calls via -DTANGO for C++

 Revision 7.10  1999/11/25 08:27:13  goetz
 replaced fprintf(stderr) with printf; made startup() C++ compatible

 Revision 7.9  1999/11/22 20:18:59  goetz
 removed const from gettransient() prototype

 Revision 7.8  1999/11/21 20:45:37  goetz
 included all M.Diehl's patches (major changes to gettransient() + main())

 Revision 7.7  1999/11/18 22:28:59  goetz
 fixed event multi-client bug, free client handle after event_listen, timeout in dev_synch()

 Revision 7.6  1999/11/01 19:05:16  goetz
 make local copy of user name returned by getpwuid() in sec_api.c

 Revision 7.5  1999/08/06 17:44:11  goetz
 removed usage of varargs for g++ on solaris and hpux

 * Revision 7.4  99/07/09  05:15:27  05:15:27  goetz (Andy Goetz)
 * added M.Diehl's patch to DevServerSig.c to exit() after calling unregister_server()
 * 
 Revision 7.3  1999/06/07 15:27:00  goetz
 fixed bug with multi-nethost reimport, device name stored with nethost

 Revision 7.2  1999/05/12 15:22:01  goetz
 changed dev_event_fire() to void; fixed bug in dev_event_unlisten()

 * Revision 7.1  99/05/11  15:59:48  15:59:48  goetz (Andy Goetz)
 * replace static declaration of event_client[] array by malloc()
 * 
 Revision 7.0  1999/04/26 07:30:41  goetz
 implemented user events (added event_api.c)

 Revision 6.15  1999/03/27 09:00:19  goetz
 asynch_cleanup() only checks for asynch clients; C++ returns output arguments if DS_WARNING

 * Revision 6.14  99/02/27  15:21:19  15:21:19  goetz (Andy Goetz)
 * fixed reimport bug; disabled reimport for rpc version 1
 * 
 Revision 6.13  1999/02/05 00:50:26  goetz
 fixed reimport socket+memory leak; ported to aCC on HPUX; suppressed rpc errors

 * Revision 6.12  99/01/18  21:39:02  21:39:02  goetz (Andy Goetz)
 * suppressed test for RPC_TIMEDOUT in svc_check()
 * 
 * Revision 6.11  99/01/14  23:14:52  23:14:52  goetz (Andy Goetz)
 * dbase timeout = 4 s; unregister ver. 1; svc_check() handles RPC_TIMEDOUT
 * 
 * Revision 6.10  98/12/22  10:29:46  10:29:46  taurel (E.Taurel)
 * Added support for Solaris and HP C++ native compiler. Remove K_R C support
 * 
 * Revision 6.9  98/12/15  14:05:03  14:05:03  goetz (Andy Goetz)
 * unregister RPC; use pgm no. 1 as flag; dev_pending() checks timeout; extern C prototype
 * 
 * Revision 6.8  98/11/20  14:35:35  14:35:35  goetz (Andy Goetz)
 * unregister API_VERSION (4) correctly now + check return value of svc_register()
 * 
 * Revision 6.7  98/11/20  10:35:00  10:35:00  goetz (Andy Goetz)
 * improved gettrans_ut(); multi-config_flags=0; removde static client_data; fixed linux select() bug; only register pgm # 0,4,5; portmap address == 111
 * 
 * Revision 6.6  98/09/24  09:25:10  09:25:10  goetz (Andy Goetz)
 * fixed stupid type which reintroduced asynchronous memory leak
 * 
 * Revision 6.5  98/08/26  16:20:34  16:20:34  goetz (Andy Goetz)
 * added dynamic NETHOST allocation, fixed bug in db_setup_multi, ported to Irix 6.4
 * 
 * Revision 6.4  98/04/29  10:21:23  10:21:23  goetz (Andy Goetz)
 * asynchronous - memory leak fixed, OS9 bug fixed, stale handle cleanup, pending=300
 * 
 * Revision 6.3  97/12/10  15:28:33  15:28:33  meyer (J.Meyer)
 * Changed select() timeout in rpc_check_host() to 200ms
 * 
 * Revision 6.2  97/12/01  12:59:15  12:59:15  goetz (Andy Goetz)
 * intermediate checkin before opening 5.14.1 branch
 * 
 * Revision 6.1  97/11/20  21:49:25  21:49:25  goetz (Andy Goetz)
 * main() continue even if cannot register asynch rpc
 * 
 * Revision 6.0  97/11/03  17:22:26  17:22:26  goetz (Andy Goetz)
 * merged synchronous and asynchronous branches
 * 
 Revision 5.15  1997/10/24 15:27:02  klotz
 ported to Windows NT 4.0 + NMSDK 5.0 ; tested with TextTalkds ; new DevServerMain.c

 * Revision 5.14  97/09/25  17:36:40  17:36:40  goetz (Andy Goetz)
 * fixed
 * 
 Revision 5.13  1997/09/03 17:34:33  meyer
 Added casting for ucc++ in DevServerSig.c

 * Revision 5.12  97/09/03  15:54:10  15:54:10  meyer (J.Meyer)
 * Changed OS9 signal handling from intercept() to signal().
 * 
 * Revision 5.11  97/08/05  14:19:26  14:19:26  goetz (Andy Goetz)
 * ported to VxWork 5.2, pgm. no. based on CRC, -m suppressed, -ve errors bug fix
 * 
 * Revision 5.10  97/03/14  17:26:10  17:26:10  dserver ()
 * fixed bug with open file handles after free
 * 
 * Revision 5.8.1.4  97/03/14  17:24:47  17:24:47  goetz (Andy Goetz)
 * fixed bug with open file handles after free
 * 
 * Revision 5.9  97/03/13  11:17:12  11:17:12  klotz (W.D. Klotz)
 * first part of NT4.0 port
 * 
 * Revision 5.8  97/01/31  12:06:21  12:06:21  goetz (Andy Goetz)
 * dev_protocol(), Linux+security bug fixes, dev_import() ignores timeout on NULL procedure, svc_run for OS9
 * 
 * Revision 5.7  97/01/14  08:57:18  08:57:18  goetz (Andy Goetz)
 * added stateless to dev_free(),_raw(),_asyn(),_protocol(),_timeout()
 * 
 * Revision 5.6  97/01/12  18:33:38  18:33:38  goetz (Andy Goetz)
 * dev_import() now stateless i.e. import works even if server is not running
 * 
 * Revision 5.5  97/01/08  17:02:26  17:02:26  goetz (Andy Goetz)
 * Ported to Linux (2.0.9)
 * 
 * Revision 5.4  96/11/27  09:58:12  09:58:12  goetz (Andy Goetz)
 * removed rpc admin interface from DevServerMain.c; putenv() suppressed for _UCC
 * 
 * Revision 5.3  96/11/26  16:24:39  16:24:39  goetz (Andy Goetz)
 * fixed bug (i_nethost=0) in dev_import_local()
 * 
 * Revision 5.2  96/11/26  13:31:01  13:31:01  goetz (Andy Goetz)
 * OICDevice (C++ wrapper for OIC) added + fixed multi-nethost memory leaks
 * 
 * Revision 5.1  96/11/04  11:00:09  11:00:09  goetz (Andy Goetz)
 * added multi nethost support
 * 

 Copyright (c) 19951997 by European Synchrotron Radiation Facility, 
                           Grenoble, France
********************************************************************-*/

/*
 * Include files and Static Routine definitions
 */

#include <API.h>
#include <ApiP.h>
#include <DevServer.h>
#include <DevServerP.h>
#include <DevSignal.h>
#include <Admin.h>
#include <DevErrors.h>

/***************************************************************************
 *                                                                         *
 * the following methods form an integral part of the OIC methodology,     *
 * they have been stored here because all programs using OIC will          *
 * be subclasses of the device servers.                                    *
 *                                                                         *
 * andy goetz jul90                                                        *
 *                                                                         *
 ***************************************************************************/
 
 
/*+**********************************************************************
 Function   :   extern long ds__method_search()

 Description:   device server method searcher for one class

 Arg(s) In  :   DevServerClass ds_class - class of the object.
	    :   DevMethod method        - method to be searched for.

 Arg(s) Out :   DevMethodFunction *function_ptr - function pointer of method.

 Return(s)  :   DS_OK or DS_NOTOK
***********************************************************************-*/

long ds__method_search (void *ptr_ds_class, DevMethod method,
			DevMethodFunction *function_ptr)
{
	register int i;

	DevServerClass  ds_class;
	ds_class = (DevServerClass) ptr_ds_class;


#ifdef EBUG
	dev_printdebug (DBG_TRACE | DBG_DEV_SVR_CLASS,
	    "\nds__method_search() : entering routine\n");
#endif /* EBUG */


	for (i = 0; i < ds_class->devserver_class.n_methods; i++)
	{
		if (method == (ds_class->devserver_class.methods_list[i].method))
		{
			/*
 * found method 
 */
			(*function_ptr) = ds_class->devserver_class.methods_list[i].fn;
			return (DS_OK);
		}
	}

	/*
 * method not found in the method list
 */
	return (DS_NOTOK);
}


/*+**********************************************************************
 Function   :   extern DevMethodFunction ds__method_finder()

 Description:   device server's method finder

 Arg(s) In  :   DevServer ds     - pointer to object.
	    :   DevMethod method - method to be searched for.

 Arg(s) Out :   none

 Return(s)  :   DevMethodFunction - function pointer of method.
***********************************************************************-*/

DevMethodFunction ds__method_finder (void *ptr_ds, DevMethod method)
{
	DevServerClass 	ds_class;
	DevMethodFunction 	method_fn;
	int 			pid = 0;

	DevServer       ds;
	ds = (DevServer) ptr_ds;

	/*
 * this function will be take the place of a method dispatcher
 * in its absence. any object oriented programming style has
 * to have a method dispatcher/finder. this way classes are
 * kept encapsulated and the application send messages to 
 * that class. the method finder will search in the methods
 * list of the devices's class for the method and return the
 * function implementing it. if the method is not implemented
 * the method finder takes DRASTIC action and exits. this
 * has been included in the specification to garantuee that
 * on returning from the method finder the method can be directly
 * executed.
 *
 * a method dispatcher would go further and accept the arguments
 * for the method and dispatch them immediately. for the present
 * this kind of method handler is not implemented. 
 *
 * ds has to be derived from the DevServer class i.e. it is
 * assumed to have a DevServerPart which has a pointer to a
 * subclass of DevServerClass, it in turn has a method list 
 * and a number of methods field.
 *
 * - andy 05jul90
 */

#ifdef EBUG
	dev_printdebug (DBG_TRACE | DBG_DEV_SVR_CLASS,
	    "\nds__method_finder() : entering routine\n");
#endif /* EBUG */

	ds_class = ds->devserver.class_pointer;
	do 
	{
		/*
 * first check if the method is implemented in this class 
 */
		if ( ds__method_search(ds_class,method,&method_fn) == 0 )
		{
			/*
 * found method 
 */
			return(method_fn);
		}

		/*
 * if program arrives here then the method is not implemented in
 * this class. if this is not a root class then go one class higher
 * and repeat the search.
 */
	}   while ((ds_class = ds_class->devserver_class.superclass) != 0);

	ds_class = ds->devserver.class_pointer;
	dev_printerror (WRITE,
	    "ds__method_finder() : requested method (%d) not implemented for this class",
	    (char*)method);
	dev_printerror (SEND, "%s", "Server did an exit !!");

	/*
    *  unregister server and exit
    */

#if !defined (_NT)
#if !defined (vxworks)
        pid = getpid ();
#else  /* !vxworks */
        pid = taskIdSelf ();
#endif /* !vxworks */
	kill (pid,SIGQUIT);
#else
	raise(SIGTERM);
#endif
	return NULL;
}

/*+**********************************************************************
 Function   :   extern long ds__create()

 Description:   creates a device server object.

 Arg(s) In  :   char *name              - name of the object to create.
	    :   DevServerClass ds_class - pointer to the object class.

 Arg(s) Out :   DevServer *ds_ptr - pionter to the new object structure.
	    :	long *error       - Will contain an appropriate error
			  	    code if the corresponding call
				    returns a non-zero value.

 Return(s)  :   DS_OK or DS_NOTOK
***********************************************************************-*/

long ds__create (char *name, void *ptr_ds_class,void *ptr_ds_ptr, long *error)
{
	DevServerClass ds_class_tmp;
	DevMethodFunction method_fn;

	DevServerClass  ds_class;
	DevServer 	*ds_ptr;

	ds_class = (DevServerClass) ptr_ds_class;
	ds_ptr   = (DevServer *)    ptr_ds_ptr;


#ifdef EBUG
	dev_printdebug (DBG_TRACE | DBG_DEV_SVR_CLASS,
	    "\nds__create() : entering routine\n");
#endif /* EBUG */

	*error = 0;

	/*
 * first check if this class and all its superclasses are initialised
 */

	ds_class_tmp = ds_class;
	do 
	{
		if (ds_class_tmp->devserver_class.class_inited != 1)
		{
			if (ds__method_search(ds_class_tmp,DevMethodClassInitialise,&method_fn) == 0)
			{
				/*
 * initialise class
 */
				if ((method_fn) (error) != 0)
				{
					return(-1);
				}
			}
			else
			{
				return(-1);
			}
		}
	}   while ((ds_class_tmp = ds_class_tmp->devserver_class.superclass) != 0);

	if (ds__method_search(ds_class,DevMethodCreate,&method_fn) == 0)
	{
		return((method_fn)(name, ds_ptr, error));
	}

	/*
 * class doesn't have any create method ! what lack of class ?!
 */

	return(-1);
}


