static char RcsId[]      = 
"@(#)$Header: DevServer.c,v 8.14 2000/06/22 14:50:34 goetz Rel $";

/*+*******************************************************************

 File:		DevServer.c

 Project:	Device Servers with SUN-RPC

 Description:	code for implementing the public methods for the 
		device server class.

 Author(s);	Andy Goetz , Jens Meyer

 Original:	June 1990

 $Revision: 8.14 $
 $Date: 2000/06/22 14:50:34 $

 $Author: goetz $

 $Log:	DevServer.c,v $
 * Revision 8.14  2000/06/22  14:50:34  14:50:34  goetz (Andrew GOETZ)
 * fixed bug in dev_event_listen() which caused server to crash
 * 
 Revision 8.13  2000/06/02 21:56:50  goetz
 _DEVICE_H now _TANGO_DEVICE_H in Device.H; (char*)taco_tango

 Revision 8.12  2000/06/02 15:58:08  goetz
 dev_event_fire() now device specific; ported to SuSE V6.4

 Revision 8.11  2000/05/31 07:47:55  goetz
 tango_api has local copies of argc and argv, ported to HP-UX

 * Revision 8.10  2000/05/29  21:39:21  21:39:21  goetz (Andrew GOETZ)
 * fixed prototyping problems with C++ on HP-UX
 * 
 * Revision 8.9  2000/05/29  18:13:31  18:13:31  goetz (Andrew GOETZ)
 * fixed bug in dev_import_timeout() which prevented timeouts < 2s
 * 
 Revision 8.8  2000/05/02 15:32:15  goetz
 added prototype for tsleep() for OS9 C++

 * Revision 8.7  2000/05/02  14:19:37  14:19:37  goetz (Andy Goetz)
 * removed check for device server running on different host
 * 
 * Revision 8.6  2000/05/02  13:29:30  13:29:30  goetz (Andy Goetz)
 * added random sleep to gettransient + 3 retries
 * 
 Revision 8.5  2000/03/27 17:13:45  goetz
 declared pmap_getmaps() as external C function for OS9 C++

 Revision 8.4  2000/03/13 14:50:02  goetz
 import timeout now programmable using dev_import_timeout()

 Revision 8.3  2000/03/13 10:31:35  goetz
 added Jens' modifications to fix bug in local putget

 Revision 8.2  2000/03/10 17:01:23  goetz
 dev_synch() now excludes udp clients and new imports

 Revision 8.1  2000/01/18 16:48:49  goetz
 tango_dev_import() now only called in dev_import if -DTANGO

 Revision 8.0  1999/12/28 14:18:31  goetz
 added TANGO support for TACO dev_xxx() calls via -DTANGO for C++

 Revision 7.10  1999/11/25 08:27:13  goetz
 replaced fprintf(stderr) with printf; made startup() C++ compatible

 Revision 7.9  1999/11/22 20:18:59  goetz
 removed const from gettransient() prototype

 Revision 7.8  1999/11/21 20:45:37  goetz
 included all M.Diehl's patches (major changes to gettransient() + main())

 Revision 7.7  1999/11/18 22:29:00  goetz
 fixed event multi-client bug, free client handle after event_listen, timeout in dev_synch()

 Revision 7.6  1999/11/01 19:05:16  goetz
 make local copy of user name returned by getpwuid() in sec_api.c

 Revision 7.5  1999/08/06 17:44:13  goetz
 removed usage of varargs for g++ on solaris and hpux

 * Revision 7.4  99/07/09  05:15:27  05:15:27  goetz (Andy Goetz)
 * added M.Diehl's patch to DevServerSig.c to exit() after calling unregister_server()
 * 
 Revision 7.3  1999/06/07 15:27:01  goetz
 fixed bug with multi-nethost reimport, device name stored with nethost

 Revision 7.2  1999/05/12 15:22:03  goetz
 changed dev_event_fire() to void; fixed bug in dev_event_unlisten()

 * Revision 7.1  99/05/11  15:59:50  15:59:50  goetz (Andy Goetz)
 * replace static declaration of event_client[] array by malloc()
 * 
 Revision 7.0  1999/04/26 07:30:43  goetz
 implemented user events (added event_api.c)

 Revision 6.15  1999/03/27 09:00:21  goetz
 asynch_cleanup() only checks for asynch clients; C++ returns output arguments if DS_WARNING

 * Revision 6.14  99/02/27  15:21:21  15:21:21  goetz (Andy Goetz)
 * fixed reimport bug; disabled reimport for rpc version 1
 * 
 Revision 6.13  1999/02/05 00:50:28  goetz
 fixed reimport socket+memory leak; ported to aCC on HPUX; suppressed rpc errors

 * Revision 6.12  99/01/18  21:39:04  21:39:04  goetz (Andy Goetz)
 * suppressed test for RPC_TIMEDOUT in svc_check()
 * 
 * Revision 6.11  99/01/14  23:14:54  23:14:54  goetz (Andy Goetz)
 * dbase timeout = 4 s; unregister ver. 1; svc_check() handles RPC_TIMEDOUT
 * 
 * Revision 6.10  98/12/22  10:29:47  10:29:47  taurel (E.Taurel)
 * Added support for Solaris and HP C++ native compiler. Remove K_R C support
 * 
 * Revision 6.9  98/12/15  14:05:06  14:05:06  goetz (Andy Goetz)
 * unregister RPC; use pgm no. 1 as flag; dev_pending() checks timeout; extern C prototype
 * 
 * Revision 6.8  98/11/20  14:35:37  14:35:37  goetz (Andy Goetz)
 * unregister API_VERSION (4) correctly now + check return value of svc_register()
 * 
 * Revision 6.7  98/11/20  10:35:02  10:35:02  goetz (Andy Goetz)
 * improved gettrans_ut(); multi-config_flags=0; removde static client_data; fixed linux select() bug; only register pgm # 0,4,5; portmap address == 111
 * 
 * Revision 6.6  98/09/24  09:25:11  09:25:11  goetz (Andy Goetz)
 * fixed stupid type which reintroduced asynchronous memory leak
 * 
 * Revision 6.5  98/08/26  16:20:35  16:20:35  goetz (Andy Goetz)
 * added dynamic NETHOST allocation, fixed bug in db_setup_multi, ported to Irix 6.4
 * 
 * Revision 6.4  98/04/29  10:21:24  10:21:24  goetz (Andy Goetz)
 * asynchronous - memory leak fixed, OS9 bug fixed, stale handle cleanup, pending=300
 * 
 * Revision 6.3  97/12/10  15:28:34  15:28:34  meyer (J.Meyer)
 * Changed select() timeout in rpc_check_host() to 200ms
 * 
 * Revision 6.2  97/12/01  12:59:17  12:59:17  goetz (Andy Goetz)
 * intermediate checkin before opening 5.14.1 branch
 * 
 * Revision 6.1  97/11/20  21:49:26  21:49:26  goetz (Andy Goetz)
 * main() continue even if cannot register asynch rpc
 * 
 * Revision 6.0  97/11/03  17:22:27  17:22:27  goetz (Andy Goetz)
 * merged synchronous and asynchronous branches
 * 
 Revision 5.15  1997/10/24 15:27:02  klotz
 ported to Windows NT 4.0 + NMSDK 5.0 ; tested with TextTalkds ; new DevServerMain.c

 * Revision 5.14  97/09/25  17:36:41  17:36:41  goetz (Andy Goetz)
 * fixed
 * 
 Revision 5.13  1997/09/03 17:34:34  meyer
 Added casting for ucc++ in DevServerSig.c

 * Revision 5.12  97/09/03  15:54:11  15:54:11  meyer (J.Meyer)
 * Changed OS9 signal handling from intercept() to signal().
 * 
 * Revision 5.11  97/08/05  14:19:27  14:19:27  goetz (Andy Goetz)
 * ported to VxWork 5.2, pgm. no. based on CRC, -m suppressed, -ve errors bug fix
 * 
 * Revision 5.10  97/03/14  17:26:11  17:26:11  dserver ()
 * fixed bug with open file handles after free
 * 
 * Revision 5.8.1.4  97/03/14  17:24:50  17:24:50  goetz (Andy Goetz)
 * fixed bug with open file handles after free
 * 
 * Revision 5.9  97/03/13  11:17:13  11:17:13  klotz (W.D. Klotz)
 * first part of NT4.0 port
 * 
 * Revision 5.8  97/01/31  12:06:22  12:06:22  goetz (Andy Goetz)
 * dev_protocol(), Linux+security bug fixes, dev_import() ignores timeout on NULL procedure, svc_run for OS9
 * 
 * Revision 5.7  97/01/14  08:57:19  08:57:19  goetz (Andy Goetz)
 * added stateless to dev_free(),_raw(),_asyn(),_protocol(),_timeout()
 * 
 * Revision 5.6  97/01/12  18:33:39  18:33:39  goetz (Andy Goetz)
 * dev_import() now stateless i.e. import works even if server is not running
 * 
 * Revision 5.5  97/01/08  17:02:27  17:02:27  goetz (Andy Goetz)
 * Ported to Linux (2.0.9)
 * 
 * Revision 5.4  96/11/27  09:58:13  09:58:13  goetz (Andy Goetz)
 * removed rpc admin interface from DevServerMain.c; putenv() suppressed for _UCC
 * 
 * Revision 5.3  96/11/26  16:24:40  16:24:40  goetz (Andy Goetz)
 * fixed bug (i_nethost=0) in dev_import_local()
 * 
 * Revision 5.2  96/11/26  13:31:02  13:31:02  goetz (Andy Goetz)
 * OICDevice (C++ wrapper for OIC) added + fixed multi-nethost memory leaks
 * 
 * Revision 5.1  96/11/04  11:00:05  11:00:05  goetz (Andy Goetz)
 * added multi nethost support
 * 

 Copyright (c) 1990-1997 by European Synchrotron Radiation Facility, 
                            Grenoble, France

********************************************************************-*/

/*
 * Include files and Static Routine definitions
 */

#include <errno.h>

#include <API.h>
#include <ApiP.h>
#include <DevServer.h>
#include <DevServerP.h>
#include <DevSignal.h>
#include <Admin.h>
#include <DevErrors.h>


/****************************************
 *          Globals                     *
 ****************************************/

/*
 *  Type for global state flags for the current
 *  server or client status is defined in API.h
 */

/*
 *  Configuration flags
 */

        extern configuration_flags      config_flags;

/*
 *  Debug flag
 */

	extern long 	debug_flag;


/*
 * Declare a pointer for the globale device array.
 * All exported devices are stored here.
 * Memory will be dynamically allocated during the
 * device_export().
 */
	extern DevServerDevices	*devices;
	extern long 		max_no_of_devices;

/* 
 * private methods accessible only via the method_finder
 */

static long class_initialise	PT_( (long *error) );
/*
static long device_export	PT_( (char *dev_name, DevServer ds, 
				long *error) );
 */
static long command_handler	PT_( (DevServer ds, long cmd, 
				DevArgument argin,  long argin_type, 
				DevArgument argout, long argout_type, 
				long *error) );
static long error_handler	PT_( (DevServer ds, long *error) );
static long destroy		PT_( ( DevServer ds, long *error) );

static DevMethodListEntry methods_list[] = {
 {DevMethodClassInitialise, (DevMethodFunction)class_initialise},
 {DevMethodDevExport, (DevMethodFunction)dev_export},
 {DevMethodCommandHandler, (DevMethodFunction)command_handler},
 {DevMethodErrorHandler, (DevMethodFunction)error_handler},
 {DevMethodDestroy, (DevMethodFunction)destroy},
};

/*
 * only the list of methods have to be initialise in
 * the static region, all the other fields get initialised
 * at runtime
 */

DevServerClassRec devServerClassRec = {
   /* n_methods */		5,
   /* methods_list */		methods_list,
};

DevServerClass devServerClass = (DevServerClass)&devServerClassRec;

/*+**********************************************************************
 Function   :   static long class_initialise()

 Description:   Device server class initialise.
            :   Called by the method finder via :
		DevMethodClassInitialise
		
 Arg(s) In  :   none

 Arg(s) Out :  	long *error - Will contain an appropriate error
			      code if the corresponding call
			      returns a non-zero value.

 Return(s)  :   DS_OK or DS_NOTOK
***********************************************************************-*/

static long class_initialise (long *error)
{
   *error = 0;

#ifdef EBUG
   dev_printdebug (DBG_TRACE | DBG_DEV_SVR_CLASS,
		 "\nclass_initialise() [devServerClass] : entering routine\n");
#endif /* EBUG */

/*
 * initialise all class related fields
 */

   devServerClass->devserver_class.class_name = 
			(char*)malloc(sizeof("DevServerClass"));
   if ( devServerClass->devserver_class.class_name == NULL )
      {
      *error = DevErr_InsufficientMemory;
      return(DS_NOTOK);
      }
   sprintf(devServerClass->devserver_class.class_name,"DevServerClass");

/*
 * this is a root class
 */
   devServerClass->devserver_class.superclass = 0;
   devServerClass->devserver_class.class_inited = 1;

/*
 * the devServerClass has no commands of its own
 */
   devServerClass->devserver_class.n_commands = 0;
   devServerClass->devserver_class.commands_list = 0;
 
   return (0);
}


/*+**********************************************************************
 Function   :   static long command_handler()

 Description:	Device server's command handler   
            :   Called by the method finder via :
		DevMethodCommandHandler.	

 Arg(s) In  :   DevServer ds       - pointer to the object.
            :   long ds_cmd        - command to be executed.
            :   DevArgument argin  - pointer to input arguments.
            :   DevType argin_type - data type of input arguments.

 Arg(s) Out :   DevArgument argout  - pointer for output arguments.
            :   DevType argout_type - data type of output arguments.
            :	long *error         - Will contain an appropriate error
			              code if the corresponding call
			      	      returns a non-zero value.

 Return(s)  :   DS_OK or DS_NOTOK
***********************************************************************-*/

static long command_handler (DevServer ds, long ds_cmd, 
			     DevArgument argin,  long argin_type,
			     DevArgument argout, long argout_type, long *error)
{
   long i, iret = 0;
   DevServerClass ds_class;
   DevMethodFunction cmd_function;

#ifdef EBUG
   dev_printdebug (DBG_TRACE | DBG_DEV_SVR_CLASS,
		   "\ncommand_handler() : entering routine\n");
#endif /* EBUG */

   ds_class = ds->devserver.class_pointer;

/*
 * first check if the command is implemented in the device server
 */

   for (i = 0; i < ds_class->devserver_class.n_commands; i++)
   {
      if (ds_cmd == (ds_class->devserver_class.commands_list[i].cmd))
      {
	 /*
	  *  check types of incoming and outgoing arguments for
	  *  the command function
	  */

	 if (argin_type != 
		ds_class->devserver_class.commands_list[i].argin_type || 
	     argout_type !=
		ds_class->devserver_class.commands_list[i].argout_type)  
	 {
   		(*error) = DevErr_IncompatibleCmdArgumentTypes;
            	return (-1);
	 }

/*
 * found command , now check the device state if it is possible to
 * execute this command
 *
 * this version does not recuperate the new state from the state-handler
 * in the command execution part the state will be updated. 
 *
 * NOTE - this method is not using the david carron Finite State Automaton
 */

         if((iret = (ds__method_finder(ds,DevMethodStateHandler))
                                      (ds, ds_cmd, error)) != 0)
         {
            return (-1);
         }
	
	/*
	 *  call command function
	 */

         cmd_function = (DevMethodFunction)(ds_class->devserver_class.commands_list[i].fn);
         iret = (cmd_function)(ds, argin, argout, error);

         return (iret);
      }
   }
   
/*
 * if program arrives here then command is not implemented
 */

   (*error) = DevErr_CommandNotImplemented;
   return (-1);
}


/*+**********************************************************************
 Function   :   static long error_handler()

 Description:	Device server's error handler   
            :   Called by the method finder via :
		DevMethodErrorHandler.	

            :   NOT YET USED !!

 Arg(s) In  :   DevServer ds        - pointer to the object.

 Arg(s) Out :	long *error         - Will contain an appropriate error
			              code if the corresponding call
			      	      returns a non-zero value.

 Return(s)  :   DS_OK or DS_NOTOK
***********************************************************************-*/


static long error_handler (DevServer ds, long *error)
{
   int iret = DS_OK;

   /*
   printf("ds::error_handler()\n");
   */

   return (iret);
}


/*+**********************************************************************
 Function   :   static long destroy()

 Description:	Device server's device destroy   
            :   Called by the method finder via :
		DevMethodDestroy.	
            :   Simply frees the object structure.

 Arg(s) In  :   DevServer ds   - pointer to the object.

 Arg(s) Out :	long *error    - Will contain an appropriate error
			         code if the corresponding call
			         returns a non-zero value.

 Return(s)  :   DS_OK or DS_NOTOK
***********************************************************************-*/

static long destroy (DevServer ds, long *error)
{
#ifdef EBUG
   dev_printdebug (DBG_TRACE | DBG_DEV_SVR_CLASS,
		   "\ndestroy() : entering routine\n");
#endif /* EBUG */

/*
 * this very simple version of destroy simply does a
 * free on the space occupied by the object
 */

   free (ds->devserver.name);
   free (ds);

   return (DS_OK);
}




/***************************************************************************
 * Convenience functions for the Device Server programs. These provide     *
 * and alternate calling sequence for executing methods of the root        *
 * class. This enables programmers who are more familiar with procedure    *
 * oriented interfaces to write procedure driven programs without being    *
 * aware of the object oriented design of the Device Servers.              *
 *                                                                         *
 * - andy 25nov90                                                          *
 *                                                                         *
 ***************************************************************************/

/*+**********************************************************************
 Function   :   extern long dev_cmd()

 Description:	Convenience function for executing commands 
		on a device. 
	    :   Only calls the command handler internally.

 Arg(s) In  :   DevServer ds       - pointer to the object.
            :   long cmd           - command to be executed.
            :   DevArgument argin  - pointer to input arguments.
            :   DevType argin_type - data type of input arguments.

 Arg(s) Out :   DevArgument argout  - pointer for output arguments.
            :   DevType argout_type - data type of output arguments.
            :	long *error         - Will contain an appropriate error
			              code if the corresponding call
			      	      returns a non-zero value.

 Return(s)  :   DS_OK or DS_NOTOK
***********************************************************************-*/

long dev_cmd (void *ptr_ds, long cmd, DevArgument argin,  long argin_type,
	      DevArgument argout, long argout_type, long *error)
{
   	DevServer       ds;
	ds = (DevServer) ptr_ds;

	return (ds__method_finder(ds, DevMethodCommandHandler)
               (ds, cmd, argin, argin_type, argout, argout_type, error));
}

#if !defined(_NT)
/*+**********************************************************************
 Function   :	extern long ds__svcrun()

 Description:	The function supports the checking of pending
		device server commands (rpc requests) on
		all open sockets.

            :	If commands are available on filedesciptors (sockets),
		the next pending command for every descriptor will
		be executed and ds__svcrun will return aterwards.

            :	If no commands are pending on any descriptor 
		ds__svcrun should return after 10ms.

 Problem    : 	OS9 seems to have a fixed minimal timeout for
	 	the select() about 1sec.

 Arg(s) In  :	none

 Arg(s) Out :   long *error - pointer to error code, in case routine fails.

 Return(s)  :	0 = DS_OK / -1 = DS_NOTOK
***********************************************************************-*/

long ds__svcrun (long *error)
{
	struct timeval	timeout;
#ifdef linux
	fd_set		readfds;
#else
	int 		readfds;
#endif /* linux */


	*error = 0;

	/*
	 * Set the startup configuration flag.
	 * Indicates, that the process acts as a server now.
         */

	config_flags.startup = True;

	/*
  	 *  set timeout to the shortest time os9 can measure (1 tick).
	 */

	timeout.tv_sec  = 0;
	timeout.tv_usec = 10000;

	/*
 	 *  set filedescriptor mask 
	 */

#if !defined (vxworks)
#ifdef linux
	readfds = svc_fdset;
#else
   	readfds = svc_fds;
#endif /* linux */
#else  /* !vxworks */
/*
 * the global symbol svc_fds is apparently NOT DEFINED for VxWorks
 * ignore it for the moment BUT this means that ds__svcrun() will
 * NOT WORK because the select() call will not be looking at the
 * correct (rpc) file descriptors. 
 *
 * andy 28apr97
 */
	readfds = 0;
#endif /* !vxworks */

	/*
	 *  check for pending commands on sockets
	 */

#if defined (__hpux)
#if defined (__STDCPP__) && !defined (_GNU_PP)
	switch ( select (32, (fd_set *) &readfds, NULL, NULL, &timeout) )
#else
	switch ( select (32, (int *) &readfds, NULL, NULL, &timeout) )
#endif /* hpux10 and STDCPP */
#else
#ifdef linux
	switch ( select (32, &readfds, NULL, NULL, &timeout) )
#else
	switch ( select (32, (struct fd_set *) &readfds, NULL, NULL, &timeout) )
#endif /* linux */
#endif /* hpux */
	   {
	   case -1:
		/* 
		 * A signal was delivered before any of the
                 * selected for events occurred or before the
                 * time limit expired.
	         */

		if ( errno == EINTR )
			break;

		/* 
		 * Return error message
		 */

		dev_printerror (SEND, 
			"ds__svcrun() : select() : errno = %d", (char*)errno);	
		*error = DevErr_RPCFailed;
		return (-1);

	   case  0:
		/*
 		 * timeout, no commands pending.
		 */
		break;

	   default:
		/*
 		 *  execute the next available command on every socket.
		 */
#ifdef linux
		svc_getreqset (&readfds);
#else
		svc_getreq (readfds);
#endif /* linux */
		break;
	   }
	
	return (0);
}
#endif  /* _NT */

