
/*+*******************************************************************

 File:		ApiP.h

 Project:	Device Servers with sun-rpc

 Description:	Private include for the applications 
		programmers interface.

 Author(s):	Jens Meyer

 Original:	June 1992


 $Revision: 8.14 $
 $Date: 2000/06/22 14:50:27 $

 $Author: goetz $

 $Log:	ApiP.h,v $
 * Revision 8.14  2000/06/22  14:50:27  14:50:27  goetz (Andrew GOETZ)
 * fixed bug in dev_event_listen() which caused server to crash
 * 
 Revision 8.13  2000/06/02 21:56:44  goetz
 _DEVICE_H now _TANGO_DEVICE_H in Device.H; (char*)taco_tango

 Revision 8.12  2000/06/02 15:58:03  goetz
 dev_event_fire() now device specific; ported to SuSE V6.4

 Revision 8.11  2000/05/31 07:47:49  goetz
 tango_api has local copies of argc and argv, ported to HP-UX

 * Revision 8.10  2000/05/29  21:39:15  21:39:15  goetz (Andrew GOETZ)
 * fixed prototyping problems with C++ on HP-UX
 * 
 * Revision 8.9  2000/05/29  18:13:25  18:13:25  goetz (Andrew GOETZ)
 * fixed bug in dev_import_timeout() which prevented timeouts < 2s
 * 
 Revision 8.8  2000/05/02 15:32:09  goetz
 added prototype for tsleep() for OS9 C++

 * Revision 8.7  2000/05/02  14:19:01  14:19:01  goetz (Andy Goetz)
 * removed check for device server running on different host
 * 
 * Revision 8.6  2000/05/02  13:28:11  13:28:11  goetz (Andy Goetz)
 * added random sleep to gettransient + 3 retries
 * 
 Revision 8.5  2000/03/27 17:13:44  goetz
 declared pmap_getmaps() as external C function for OS9 C++

 Revision 8.4  2000/03/13 14:50:01  goetz
 import timeout now programmable using dev_import_timeout()

 Revision 8.3  2000/03/13 10:31:34  goetz
 added Jens' modifications to fix bug in local putget

 Revision 8.2  2000/03/10 17:01:22  goetz
 dev_synch() now excludes udp clients and new imports

 Revision 8.1  2000/01/18 16:48:43  goetz
 tango_dev_import() now only called in dev_import if -DTANGO

 Revision 8.0  1999/12/28 14:18:30  goetz
 added TANGO support for TACO dev_xxx() calls via -DTANGO for C++

 Revision 7.10  1999/11/25 08:27:12  goetz
 replaced fprintf(stderr) with printf; made startup() C++ compatible

 Revision 7.9  1999/11/22 20:18:59  goetz
 removed const from gettransient() prototype

 Revision 7.8  1999/11/21 20:45:37  goetz
 included all M.Diehl's patches (major changes to gettransient() + main())

 Revision 7.7  1999/11/18 22:28:56  goetz
 fixed event multi-client bug, free client handle after event_listen, timeout in dev_synch()

 Revision 7.6  1999/11/01 19:05:16  goetz
 make local copy of user name returned by getpwuid() in sec_api.c

 Revision 7.5  1999/08/06 17:44:07  goetz
 removed usage of varargs for g++ on solaris and hpux

 * Revision 7.4  99/07/09  05:15:27  05:15:27  goetz (Andy Goetz)
 * added M.Diehl's patch to DevServerSig.c to exit() after calling unregister_server()
 * 
 Revision 7.3  1999/06/07 15:26:56  goetz
 fixed bug with multi-nethost reimport, device name stored with nethost

 Revision 7.2  1999/05/12 15:21:56  goetz
 changed dev_event_fire() to void; fixed bug in dev_event_unlisten()

 * Revision 7.1  99/05/11  15:59:43  15:59:43  goetz (Andy Goetz)
 * replace static declaration of event_client[] array by malloc()
 * 
 Revision 7.0  1999/04/26 07:30:37  goetz
 implemented user events (added event_api.c)

 Revision 6.15  1999/03/27 09:00:15  goetz
 asynch_cleanup() only checks for asynch clients; C++ returns output arguments if DS_WARNING

 * Revision 6.14  99/02/27  15:21:15  15:21:15  goetz (Andy Goetz)
 * fixed reimport bug; disabled reimport for rpc version 1
 * 
 Revision 6.13  1999/02/05 00:50:22  goetz
 fixed reimport socket+memory leak; ported to aCC on HPUX; suppressed rpc errors

 * Revision 6.12  99/01/18  21:38:58  21:38:58  goetz (Andy Goetz)
 * suppressed test for RPC_TIMEDOUT in svc_check()
 * 
 * Revision 6.11  99/01/14  23:14:48  23:14:48  goetz (Andy Goetz)
 * dbase timeout = 4 s; unregister ver. 1; svc_check() handles RPC_TIMEDOUT
 * 
 * Revision 6.10  98/12/22  10:29:41  10:29:41  taurel (E.Taurel)
 * Added support for Solaris and HP C++ native compiler. Remove K_R C support
 * 
 * Revision 6.9  98/12/15  14:04:57  14:04:57  goetz (Andy Goetz)
 * unregister RPC; use pgm no. 1 as flag; dev_pending() checks timeout; extern C prototype
 * 
 * Revision 6.8  98/11/20  14:35:32  14:35:32  goetz (Andy Goetz)
 * unregister API_VERSION (4) correctly now + check return value of svc_register()
 * 
 * Revision 6.7  98/11/20  10:34:57  10:34:57  goetz (Andy Goetz)
 * improved gettrans_ut(); multi-config_flags=0; removde static client_data; fixed linux select() bug; only register pgm # 0,4,5; portmap address == 111
 * 
 * Revision 6.6  98/09/24  09:25:07  09:25:07  goetz (Andy Goetz)
 * fixed stupid type which reintroduced asynchronous memory leak
 * 
 * Revision 6.5  98/08/26  16:20:31  16:20:31  goetz (Andy Goetz)
 * added dynamic NETHOST allocation, fixed bug in db_setup_multi, ported to Irix 6.4
 * 
 * Revision 6.4  98/04/29  10:21:20  10:21:20  goetz (Andy Goetz)
 * asynchronous - memory leak fixed, OS9 bug fixed, stale handle cleanup, pending=300
 * 
 * Revision 6.3  97/12/10  15:28:30  15:28:30  meyer (J.Meyer)
 * Changed select() timeout in rpc_check_host() to 200ms
 * 
 * Revision 6.2  97/12/01  12:59:12  12:59:12  goetz (Andy Goetz)
 * intermediate checkin before opening 5.14.1 branch
 * 
 * Revision 6.1  97/11/20  21:49:21  21:49:21  goetz (Andy Goetz)
 * main() continue even if cannot register asynch rpc
 * 
 * Revision 6.0  97/11/03  17:22:23  17:22:23  goetz (Andy Goetz)
 * merged synchronous and asynchronous branches
 * 

 Copyright (c) 1990-1997 by European Synchrotron Radiation Facility, 
                            Grenoble, France

********************************************************************-*/

#ifndef _apiP_h
#define _apiP_h


/*
 *  standard header string to use "what" or "ident".
 */
#ifdef _IDENT
static char ApiPh[] =
"@(#)$Header: ApiP.h,v 8.14 2000/06/22 14:50:27 goetz Rel $";
#endif /* _IDENT */


/*
 * dsxdr library include files
 */
#include <API_xdr.h>
#ifndef __cplusplus
#include <DevServer.h>
#else
#include <Device.H>
#endif /* __cplusplus */

/*
 * Define the number of array fields to allocate as a
 * data block.
 */

#define BLOCK_SIZE      50

/*
 * Defines to handle the export of devices and the
 * import of devices.
 */

#define NOT_EXPORTED            -1
#define EXPORTED                0

#define MAX_DEVICES             2047
#define MAX_CONNECTIONS         4095
#define MAX_COUNT                255
#define MAX_ASYNCH_CALLS	 300

/*
 * Masks to decode the device identification variable.
 */

#define DEVICES_MASK            0x7FF
#define CONNECTIONS_MASK        0xFFF
#define COUNT_MASK              0xFF
#define LOCALACCESS_MASK        0x1

#define CONNECTIONS_SHIFT       11
#define COUNT_SHIFT             23
#define LOCALACCESS_SHIFT       31

/*
 * defines to mark rpc connections
 */

#define NFILE 100 /* maximum number of server connections per process */

#define RPC_ERROR	1
#define GOOD_SVC_CONN	0
#define BAD_SVC_CONN	3

#define DELAY_TIME	10

/*
 * asynchronous + event symbols
 */

#define D_ASYNCH_TYPE 0x10000000
#define D_EVENT_TYPE  0x20000000

#define EVENT_MAX_CLIENTS 100
/* 
 * timeouts for rpc calls
 */

static struct timeval zero_timeout = { 0 , 0 };        /* { sec , usec } */

/*  timeout for a client server connection  */
static struct timeval timeout = { 3 , 0 };        /* { sec , usec } */
#ifndef lynx
static struct timeval retry_timeout = { 3 , 0 };  /* { sec , usec } */
#else /* lynx */
static struct timeval retry_timeout = { 1 , 0 };  /* { sec , usec } */
#endif

/*  timeout for a server server connection  */
static struct timeval inner_timeout = { 2, 0 };        /* { sec , usec } */
#ifndef lynx
static struct timeval inner_retry_timeout = { 2 , 0 };  /* { sec , usec } */
#else /* lynx */
static struct timeval inner_retry_timeout = { 1 , 0 };  /* { sec , usec } */
#endif /* lynx */

/*  internal timeout for api library functions  */
static struct timeval api_timeout = { 1 , 0 };        /* { sec , usec } */
#ifndef lynx
static struct timeval api_retry_timeout = { 1 , 0 };  /* { sec , usec } */
#else /* lynx */
static struct timeval api_retry_timeout = { 0 , 500000 };  /* { sec , usec } */
#endif /* lynx */

/*  timeout for a message server connection  */
static struct timeval msg_timeout = { 1 , 0 };        /* { sec , usec } */
#ifndef lynx
static struct timeval msg_retry_timeout = { 1 , 0 };  /* { sec , usec } */
#else /* lynx */
static struct timeval msg_retry_timeout = { 0 , 500000 };  /* { sec , usec } */
#endif /* lynx */

/*  timeout for database server connection  */
static struct timeval dbase_timeout = { 4, 0 };        /* { sec , usec } */
static struct timeval dbase_retry_timeout = { 4 , 0 };  /* { sec , usec } */

/* timeout for asynchronous calls i.e. maximum time to wait for reply after 
 * sending request, after this time declare the request as failed due to TIMEOUT
 */
static struct timeval asynch_timeout = { 25 , 0 };        /* { sec , usec } */

/*  default timeout for import */
static struct timeval import_timeout = { 2 , 0 };        /* { sec , usec } */
static struct timeval import_retry_timeout = { 2 , 0 };  /* { sec , usec } */

/*  timeout for the select in rpc_check_host   */
static struct timeval check_host_timeout = { 0 , 200000 }; /* { sec , usec } */

/*
 *  status flags for device server configuration
 */

typedef struct {
		DevBoolean 	configuration;
		DevBoolean 	message_server;
		DevBoolean 	database_server;
		DevBoolean 	startup;
		DevBoolean 	security;
		char		server_name[80];
		char		server_host[80];
		long		prog_number;
		long		vers_number;
		DevBoolean	device_server;
		DevBoolean	asynch_rpc;
	       } configuration_flags; 
	      
/*
 * configuration structure for the database server
 */

typedef struct {
		devserver	conf;
		} dbserver_info;

/*
 * configuration structure for the message server
 */

typedef struct {
		devserver 	conf;
		char  		DS_name [256];
		char  		DS_host [32];
		long		DS_prog_number;
		char  		DS_display [32];
		} msgserver_info;

/*
 * the following structure groups all the information needed per
 * nethost (i.e. control system) in a multi-nethost environment
 *
 * config_flags - indicate what has been imported and if security
 *                has been switched on
 * nethost - connection to a nethost
 * db_info - connection to the corresponding static database
 * msg_info - connection to the corresponding message server
 */

typedef struct {
		char			nethost[SHORT_NAME_SIZE];
		configuration_flags 	config_flags;
		devserver		nh_info;
		devserver		db_info;
		devserver		msg_info;
		} nethost_info;

/*
 * the following structure contains all the information needed by
 * the client to receive replies from asynchronous dev_putget() calls 
 *
 * asynch_id - asynchronous call identifier
 * argout_type - argout type requested by client
 * argout - pointer to argout argument of client
 */

typedef struct {
		short flag;
		long type;
		long event;
		struct timeval timesent;
		devserver ds;
                long asynch_id;
		DevArgument argout;
		DevType argout_type;
		DevCallbackFunction *callback;
		void *user_data;
		} asynch_request_arg;

typedef struct { 
		long pending;
		asynch_request_arg *args;
		} asynch_request;

struct _asynch_client_data {
	long asynch_id;
        long status;
        long error;
        long argout_type;
        DevArgument argout;
        DevVarArgumentArray var_argument;
};
typedef struct _asynch_client_data _asynch_client_data;

struct _asynch_client_raw_data {
	long asynch_id;
        long status;
        long error;
        long ser_argout_type;
        long deser_argout_type;
        long xdr_length;
        DevArgument argout;
        DevVarArgumentArray var_argument;
};
typedef struct _asynch_client_raw_data _asynch_client_raw_data;

typedef struct {
		short flag;
		long event;
		long ds_id;
#ifndef __cplusplus
		DevServer ds;
#else
		Device *device;
#endif /* __cplusplus */
		long id;
		char *server_name;
		char *server_host;
		long prog_number;
		long vers_number;
		long no_svc_conn;
		long argout_type;
		} event_client;
/*
 * definitions for message transfer to message server
 */

#define NUMBER_OF_MSG_TYPES  3
#define ERROR_TYPE  	0
#define DEBUG_TYPE  	1
#define DIAG_TYPE   	2

typedef struct {
                 short 	init_flg;
		 int 	nbytes;
		 char  *messages;
               } _message_buffer;

#ifdef __cplusplus
extern "C" {
#endif
extern _DLLFunc _dev_import_out *  rpc_dev_import_4
			PT_( (_dev_import_in *dev_import_in,
					struct svc_req *rqstp) );
extern _DLLFunc _dev_free_out *  rpc_dev_free_4
			PT_( (_dev_free_in *dev_free_in) );
extern _DLLFunc _client_data *  rpc_dev_putget_4
			PT_( (_server_data *server_data) );
extern _DLLFunc _client_data *  rpc_dev_put_4
			PT_( (_server_data *server_data) );
extern _DLLFunc _client_raw_data *  rpc_dev_putget_raw_4
			PT_( (_server_data *server_data));
extern _DLLFunc _client_data *  rpc_dev_put_asyn_4
			PT_( (_server_data *server_data) );
extern _DLLFunc _dev_query_out *  rpc_dev_cmd_query_4
			PT_((_dev_query_in *dev_query_in));
extern _DLLFunc _dev_import_out *  rpc_dev_ping_4
			PT_( (_dev_import_in *dev_import_in,
					struct svc_req *rqstp) );
extern _DLLFunc _dev_import_out *  rpc_asynch_import_5
                        PT_( (_dev_import_in *dev_import_in));
extern _DLLFunc _dev_free_out *  rpc_asynch_free_5
			PT_( (_dev_free_in *dev_free_in));
extern _DLLFunc _asynch_client_data *  rpc_asynch_reply_5
			PT_( (_asynch_client_data *asynch_client_data) );
extern _DLLFunc _asynch_client_raw_data *  rpc_raw_asynch_reply_5
			PT_( (_asynch_client_raw_data *asynch_client_raw_data) );
extern _DLLFunc _dev_import_out * rpc_event_listen_5
			PT_( (_server_data *event_client_data) );
extern _DLLFunc _dev_free_out * rpc_event_unlisten_5
			PT_( (_server_data *event_client_data) );
/*
 * RPC ADMIN service temporarily disabled, to be reimplemented later
 *
 * - andy 26nov96
 *
 *extern _DLLFunc long *  rpc_admin_import_4
 *			PT_( (long *cmd) );
 *extern _DLLFunc long *  rpc_admin_4
 *			PT_((_server_admin *server_admin));
 */
/*
 * Entry point for local dev_putget() calls!
 */
extern _DLLFunc _client_data *  rpc_dev_putget_local
			PT_( (_server_data *server_data));
/*
 * Entry point for asynchronous command
 */
extern _DLLFunc void rpc_dev_put_asyn_cmd 
			PT_( (_server_data *server_data));
/*
 * Remote procedure stub for message server
 */
extern _DLLFunc _msg_out *  rpc_msg_send_1
			PT_( (_msg_data *msg_data) );
/*
 * Remote procedure stub for the manager
 */
extern _DLLFunc _manager_data *  rpc_get_config_4
			  PT_( (_register_data *register_data) );
extern _DLLFunc _msg_manager_data *  rpc_msg_register_1
			  PT_( (_register_data *register_data) );
extern _DLLFunc int *  rpc_db_register_1
			  PT_( (_register_data *register_data) );

/*
 *	Functions used by library only, not for external use !!!
 */
long  dev_rpc_connection
	PT_( (devserver ds, long *error) );
long  dev_rpc_error
	PT_( (devserver ds, enum clnt_stat clnt_stat, long *error) );
long  check_rpc_connection
	PT_( (devserver ds, long *error) );
long  reinstall_rpc_connection
	PT_( (devserver ds, long *error) );
long  rpc_check_host
	PT_( (char *host_name, long *error) );
long dev_query_svr
	PT_( (char* host,long prog_number,long vers_number) );

/*
 * Calls to setup the connection to the manager, database and message server
 */
long setup_config_multi         
        PT_( (char *nethost, long *error) );
long db_import_multi 
	PT_( (char *nethost, long *error) );
/*
 * Utility functions for multi-nethost support
 */
long nethost_alloc 
	PT_( (long *error) );
long get_i_nethost_by_device_name
	PT_( (char *device_name, long *error) );
long get_i_nethost_by_name
	PT_( (char *nethost, long *error) );
char* get_nethost_by_index
	PT_( (long i_nethost, long *error) );
char* extract_device_name
	PT_( (char *full_name, long *error) );
/*
 * Private functions used to implement the asynchronism
 */
long asynch_rpc_register 
	PT_( (long *error) );
long asynch_server_import 
	PT_( (devserver ds, long *error) );
long asynch_client_import 
	PT_( (devserver ds, long *error) );
long asynch_client_check 
	PT_( (devserver ds, long *error) );
long asynch_add_request
	PT_( (devserver ds, long asynch_type, long event_type,
	      DevArgument argout, DevType argout_type, 
	      DevCallbackFunction *callback, void *user_data,
	      long *asynch_id, long *asynch_index, long *error) );
long asynch_get_index
	PT_( (long asynch_id) );
void asynch_client_cleanup 
	PT_( (long *error) );
void asynch_timed_out 
	PT_( (devserver ds) );
long asynch_client_ping 
	PT_( (long i, long *error) );
void event_client_cleanup 
	PT_( (long *error) );

/* TANGO entry points */

long tango_db_import(char*, char*, long, long*);
long tango_dev_import(char*, long, devserver*, long*);
long tango_dev_putget(devserver,long,void*,long,void*,long,long*);
long tango_dev_putget_raw(devserver,long,void*,long,void*,long,long*);
long tango_dev_cmd_query(devserver,DevVarCmdArray*,long*); 
long tango_dev_ping(devserver,long*); 

#ifdef __cplusplus
}
#endif

/*
 *  rpc service definitions used for to identify the rpc's
 */

/*
 * device related services
 */

#define DEVSERVER_VERS ((u_long)1) /* The old version number !!!!! */
#define API_VERSION    ((u_long)4) /* The new version of the library !!! */
#define ASYNCH_API_VERSION ((u_long)5) /* Asynchronous call version for API_VERSION */

#define RPC_DEV_IMPORT ((u_long)1)
#define RPC_DEV_FREE ((u_long)2)
#define RPC_DEV_PUTGET ((u_long)3)
#define RPC_DEV_PUT ((u_long)4)
#define RPC_DEV_CMD_QUERY ((u_long)5)
#define RPC_ADMIN_IMPORT ((u_long)6)
#define RPC_ADMIN ((u_long)7)
#define RPC_CHECK ((u_long)8)
#define RPC_DEV_PUTGET_RAW ((u_long)9)
#define RPC_DEV_PUT_ASYN ((u_long)10)
#define RPC_DEV_PING ((u_long)11)
#define RPC_DEV_PUTGET_ASYN ((u_long)11)
#define RPC_DEV_PUTGET_RAW_ASYN ((u_long)12)
#define RPC_PUTGET_ASYN_REPLY ((u_long)13)
#define RPC_PUTGET_RAW_ASYN_REPLY ((u_long)14)
#define RPC_ASYN_IMPORT ((u_long)15)
#define RPC_ASYN_FREE ((u_long)16)
#define RPC_FLUSH ((u_long)17)
#define RPC_EVENT_LISTEN ((u_long)18)
#define RPC_EVENT_UNLISTEN ((u_long)19)


/*
 *  message server related service
 */

#define MSGSERVER_VERS   ((u_long)1)

#define RPC_MSG_SEND     ((u_long)1)
#define RPC_STARTUP_MSG  ((u_long)98)
#define RPC_QUIT_SERVER  ((u_long)99)

/*
 *  network manager related service
 */

#define NMSERVER_PROG 	((u_long)100)
#define NMSERVER_VERS 	((u_long)4)
#define NMSERVER_VERS_1 ((u_long)1)

#define RPC_GET_CONFIG 	   ((u_long)1)
#define RPC_MSG_REGISTER   ((u_long)2)
#define RPC_DB_REGISTER    ((u_long)3)
#define RPC_GET_RDB_CONFIG ((u_long)4)
#define RPC_RDB_REGISTER   ((u_long)5)

/*
 * special case for Solaris C++ and OS9 because no prototype defined !
 */
#if defined(solaris) || defined(_UCC)
#ifdef __cplusplus
extern "C"
{
#endif /* __cplusplus */
int gethostname(char *name, int namelen);
void get_myaddress(struct sockaddr_in *);
#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* solaris || _UCC */

#endif /* _apiP_h */

