static char RcsId[] = "$Header: oicdevice_test.C,v 1.1 96/11/12 17:06:10 goetz Exp $";

//+**********************************************************************
//
// File:	main.c
//
// Project:	Device Servers in C++
//
// Description:	main source code file for testing the OICDevice wrapper class
//		in C++ to create (old) AGPowerSupply OIC devices.
//		
//
// Author(s):	Andy Goetz
//
// Original:	November 1996
//
// $Revision: 1.1 $
//
// $Date: 96/11/12 17:06:10 $
//
// $Author: goetz $
//
// $Log:	oicdevice_test.C,v $
//Revision 1.1  96/11/12  17:06:10  17:06:10  goetz (Andy Goetz)
//Initial revision
//
// Revision 1.2  95/07/20  18:07:00  18:07:00  goetz (Andy Goetz)
// *** empty log message ***
// 
// Revision 1.1  95/07/20  16:48:49  16:48:49  goetz (Andy Goetz)
// Initial revision
// 
//
//+**********************************************************************
		
#include <iostream.h>

#include <API.h>
#include <Device.H>
#include <DevServer.h>
#include <DevServerP.h>
#include <OICDevice.H>
#include <PowerSupply.h>
#include <PowerSupplyP.h>
#include <AGPowerSupply.h>
#include <AGPowerSupplyP.h>
#include <PulsedRelay.h>

extern int errno;

void main (int argc, char **argv)
//long startup (char *svr_name, long *error)
{
   char **dev_list;
   unsigned int n_devices, i=0;
   OICDevice *device[10];
   short state;
   long status, lerror;
   float voltage=123.;

//  debug_flag = 0xffffffff;

   printf ("main++() program to test OICDevice\n");
//
// first import the static database
//
//   if (db_import(&lerror) != DS_OK)
//   {
//      printf("main(): db_import failed, error %s\n",dev_error_str(lerror));
//      exit(-1);
//   }
//
//
// now loop round creating and exporting the devices
//
   lerror = 0;
// device[i] = new OICDevice ("TL1/PS-D/D++",(DevServerClass)aGPowerSupplyClass,&lerror);
   device[i] = new OICDevice ("TL1/PS-D/D++",(DevServerClass)pulsedRelayClass,&lerror);
   if (lerror != 0)
   {
      printf("main(): new OICDevice failed, error %s\n",dev_error_str(lerror));
      exit(-1);
   }

   printf("After new !!!!!!!!!!!!!!\n");

//
// test calling Device::State via Device::Command method
//
   lerror = 0;
   device[i]->Command(DevState, NULL, D_VOID_TYPE, (void*)&state, D_SHORT_TYPE, &lerror);
   if (lerror != 0)
   {
      printf("main(): OICDevice::Command failed, error %s\n",dev_error_str(lerror));
      exit(-1);
   }

//
// test calling Device::On via Device::Command method
//
   lerror = 0;
   device[i]->Command(DevOn, NULL, D_VOID_TYPE, NULL, D_VOID_TYPE, &lerror);
   if (lerror != 0)
   {
      printf("main(): OICDevice::Command failed, error %s\n",dev_error_str(lerror));
      exit(-1);
   }

//
// test calling Device::SetValue via Device::Command method
//
   lerror = 0;
   device[i]->Command(DevSetValue, (void*)&voltage, D_FLOAT_TYPE, NULL, D_VOID_TYPE, &lerror);
   if (lerror != 0)
   {
      printf("main(): OICDevice::Command failed, error %s\n",dev_error_str(lerror));
      exit(-1);
   }
//
// export the device onto the network
//
   status = dev_export((char*)device[i]->name,(Device*)device[i],(long*)&lerror);

   printf("main() dev_export() returned %d (error = %d)\n",status,lerror);

//   return(DS_OK);
}
