//static char RcsId[] = "$Header: Device.H,v 8.14 2000/06/22 14:50:43 goetz Rel $";

//+**********************************************************************
//
// File:		Device.h
//
// Project:	Device Servers in C++
//
// Description:	public include file containing definitions and declarations 
//		for implementing the device server Device base class in C++
//		(DeviceClass).
//
// Author(s):	Andy Goetz
//
// Original:	February 1995
//
// $Revision: 8.14 $
//
// $Date: 2000/06/22 14:50:43 $
//
// $Author: goetz $
//
// $Log:	Device.H,v $
//Revision 8.14  2000/06/22  14:50:43  14:50:43  goetz (Andrew GOETZ)
//fixed bug in dev_event_listen() which caused server to crash
//
// Revision 8.13  2000/06/02 21:56:58  goetz
// _DEVICE_H now _TANGO_DEVICE_H in Device.H; (char*)taco_tango
//
// Revision 8.12  2000/06/02 15:58:15  goetz
// dev_event_fire() now device specific; ported to SuSE V6.4
//
// Revision 8.11  2000/05/31 07:48:03  goetz
// tango_api has local copies of argc and argv, ported to HP-UX
//
//Revision 8.10  2000/05/29  21:39:28  21:39:28  goetz (Andrew GOETZ)
//fixed prototyping problems with C++ on HP-UX
//
//Revision 8.9  2000/05/29  18:13:38  18:13:38  goetz (Andrew GOETZ)
//fixed bug in dev_import_timeout() which prevented timeouts < 2s
//
// Revision 8.8  2000/05/02 15:32:22  goetz
// added prototype for tsleep() for OS9 C++
//
//Revision 8.7  2000/05/02  14:19:44  14:19:44  goetz (Andy Goetz)
//removed check for device server running on different host
//
//Revision 8.6  2000/05/02  13:29:38  13:29:38  goetz (Andy Goetz)
//added random sleep to gettransient + 3 retries
//
// Revision 8.5  2000/03/27 17:13:49  goetz
// declared pmap_getmaps() as external C function for OS9 C++
//
// Revision 8.4  2000/03/13 14:50:06  goetz
// import timeout now programmable using dev_import_timeout()
//
// Revision 8.3  2000/03/13 10:33:34  goetz
// *** empty log message ***
//
//+**********************************************************************

#ifndef _TACO_DEVICE_H
#define _TACO_DEVICE_H
		

// Some remarks about the Device class definition
//
// 1 - Members class_name and dev_type should not be defined as static members
//     otherwise, there will be only one copy of them for the device server
//     process and it is not possible to correctly handle device server
//     with several embedded classes
//     Therefore, don't forget to initialize them in the object constructor
//     and not in the class_initialise function which is executed only once
//     for a class.
//
// 2 - The State and Status member function are declared as public. This is due
//     to the OS-9 C++ compiler. To reuse them in a device derived class
//     (by specifying a pointer to them in the command list), the OS-9 compiler
//     needs the function to be declared as public !!
//


class Device {

//
// private members
//

private :

//
// private virtual functions which should be defined in each new sub-class
//

   static short class_inited;

   virtual long ClassInitialise( long *error );
   virtual long GetResources (char *res_name, long *error); // pure virtual


//
// public members
//

public:

typedef long (Device::* DeviceMemberFunction)(void*, void*, long* );
typedef struct _DeviceCommandListEntry {
                                     DevCommand         cmd;
                                     DeviceMemberFunction  fn;
                                     DevArgType         argin_type;
                                     DevArgType         argout_type;
                                     long               min_access;
                                    }
               DeviceCommandListEntry;

typedef struct _DeviceCommandListEntry *DeviceCommandList;

   virtual long State(void *vargin, void *vargout , long *error);
   virtual long Status(void *vargin, void *vargout, long *error);

// 
// class variables
//
  
   char* class_name;
   char dev_type[24];

   char* name;

   Device (DevString name, long *error);
   virtual ~Device ();
//
// following method is "virtual" which means derived classes can
// override it with their own version
//
   virtual long Command ( long cmd, 
                  void *argin, long argin_type,
                  void *argout, long argout_type, 
                  long *error);
   long  Get_min_access_right(long,long *,long *);
   void  Get_command_number(unsigned int *);
   long  Command_Query(_dev_cmd_info *,long *);
   

//
// protected members - accessible only be derived classes
// 

protected:


//
// the following virtual commands must exist in all new sub-classes
//
   virtual long StateMachine( long cmd, long *error);

   
   long state; // device state
   long n_state; // convenience variable for storing next device state
   long n_commands;
   DeviceCommandList commands_list;
   
};


#define TYPE_DEFAULT		"DevType_Default"
#define TYPE_INIT 		"DevType_"

#endif /* _TACO_DEVICE_H */
