static char RcsId[] = "$Header: db_update.cpp,v 6.3 99/01/27 11:14:49 taurel Exp $";

/* $Log:	db_update.cpp,v $
Revision 6.3  99/01/27  11:14:49  11:14:49  taurel (Emmanuel Taurel)
No change. Checked out only for test purpose

Revision 6.2  98/12/22  08:48:42  08:48:42  taurel (Emmanuel Taurel)
Don't call db_updres if no resources is defined in resource file.

Revision 6.1  98/12/21  16:17:35  16:17:35  taurel (Emmanuel Taurel)
Don't call db_upddev function if no device is defined in file.

Revision 6.0  98/08/14  10:58:35  10:58:35  taurel (Emmanuel Taurel)
New utilities release which are server oriented
 */

/* TACO include file */

#include <API.h>

/* Include files */

#include <string.h>
#include <unistd.h>

#include <iostream.h>
#include <string>


/****************************************************************************
*                                                                           *
*		Code for db_update command                                  *
*                        ---------                                          *
*                                                                           *
*    Command rule : To delete a device and its resources from the database. *
*                   The -r option is used if the user does not want device  *
*		    resources to be also deleted			    *
*                                                                           *
*    Synopsis : db_update <file name>               		    	    *
*                                                                           *
****************************************************************************/


int main(int argc,char *argv[])
{
	long i;
	long error,res;
	char *ptr;
	long nb_dev,nb_res,err_line,dev_err;
	char **dev_def;
	char **res_def;
	long sec = False;
	char *pa;
	long pass = True;
	char *answer;
	
/* Argument test and device name structure*/

	if (argc != 2)
	{
		cerr << "db_update usage : db_update <file name>" << endl;
		exit(-1);
	}

	string file_name(argv[1]);

//
// Get environment variable
//

	if ((ptr = (char *)getenv("RES_BASE_DIR")) == NULL)
	{
		cerr << "Can't find environment variable RES_BASE_DIR" << endl;
		exit(-1);
	}
	string base(ptr);
	
//
// Build real file name path
//

	base.append(1,'/');
	file_name.insert(0,base);
	
#ifdef DEBUG
	cout  << "File name : " << file_name << endl;
#endif /* DEBUG */
	
//
// Connect to database server
//

	if (db_import(&error) == -1)
	{
		cerr << "db_devinfo : Impossible to connect to database server" << endl;
		exit(-1);
	}

//
// Analyse resource file
//

	res = db_analyze_data(Db_File,file_name.c_str(),&nb_dev,&dev_def,
			      &nb_res,&res_def,&err_line,&error);	

//
// Display error message if the analysis fails
//

	if (res == -1)
	{
		if (err_line != 0)
		{
			if (error == DbErr_BadDevSyntax)
			{
				cerr << "Error in device definition" << endl;
			}
			else
			{
				cerr << "Error at line " << err_line << " in file " << file_name << " (" << error << ")" << endl;
				cerr << "Error message : " << dev_error_str(error) << endl;
			}
		}
		else
		{
			cerr << "File analyzis failed with error " << error << endl;
			cerr << "Error message : " << dev_error_str(error) << endl;
		}
		exit(-1);
	}
	
#ifdef DEBUG
	cout << "File analyzis is OK" << endl;

	cout << nb_dev << " device list defined" << endl;	
	for (i = 0;i < nb_dev;i++)
		cout << dev_def[i] << endl;
	cout << nb_res << " resources defined" << endl;
	for (i = 0;i < nb_res;i++)
		cout << res_def[i] << endl;
#endif /* DEBUG */

//
// Check if there is any security resources
//

	for (i = 0;i < nb_res;i++)
	{
		string str(res_def[i]);
		string::size_type pos;

		if ((pos = str.find('/')) == string::npos)
		{
			cerr << "Wrong resource syntax !!!, exiting" << endl;
			exit(-1);
		}
	
		string domain(str,0,pos);					
		if (domain == "sec")
		{
			sec = True;
			break;
		}
	}
	
//
// If some security resources are defined, check if a password is used
//

	if (sec == True)
	{
		res = db_secpass(&pa,&error);
		
		if (res == -1)
		{
			if (error == DbErr_NoPassword)
				pass = False;
			else
			{
				cerr << "Can't retrieve the database defined password, update not allowed" << endl;
				exit(-1);
			}
		}
		
		if (pass == True)
		{
			answer = (char *)getpass("Security passwd : ");
			
			if (strcmp(answer,pa) != 0)
			{
				cout << "Sorry, wrong password. Update not allowed" << endl;
				cout << "Hint : Remove security resources from file" << endl;
				exit(-1);
			}
		}
	}
	
//
// Update device list in db
//

	if (nb_dev != 0)
	{
		res = db_upddev(nb_dev,dev_def,&dev_err,&error);
	
//
// Display message if this call fails
//

		if (res == -1)
		{
			if (dev_err != 0)
			{
				cerr << "Error in device definition number " << dev_err << ", error = " << error << endl;
				cerr << "Error message : " << dev_error_str(error) << endl;
			}
			else
			{
				cerr << "Device(s) update call failed with error " << error << endl;
				cerr << "Error message : " << dev_error_str(error) << endl;
			}
			exit(-1);
		}
	}
	
#ifdef DEBUG
	cout << "Update device successfull" << endl;
#endif /* DEBUG */

//
// Update resources in db
//

	if (nb_res != 0)
	{
		res = db_updres(nb_res,res_def,&dev_err,&error);
	
//
// Display message if this call fails
//

		if (res == -1)
		{
			if (dev_err != 0)
			{
				cerr << "Error in resource definition number " << dev_err << ", error = " << error << endl;
				cerr << "Error message : " << dev_error_str(error) << endl;
			}
			else
			{
				cerr << "Resource(s) update call failed with error " << error << endl;
				cerr << "Error message : " << dev_error_str(error) << endl;
			}
		}
	}	

}
