static char RcsId[] = "$Header: dbm_psdev.cpp,v 6.9 2000/03/15 17:07:56 taurel Rel $";

/* $Log:	dbm_psdev.cpp,v $
Revision 6.9  2000/03/15  17:07:56  17:07:56  taurel (E.Taurel)
Change compilation variable from -solaris to sun

Revision 6.8  2000/02/15  12:40:30  12:40:30  taurel (E.Taurel)
Fix bug in update of arrays in the updres_1_svc function (file dbm_update.cpp). Change the value of the array flag when calling the upd_res function.

Revision 6.7  99/11/21  21:47:59  21:47:59  goetz (Andy Goetz)
register version 1 of database service

 * Revision 6.6  1999/11/21 14:41:02  goetz
 * included M.Diehl's patches for dbm_getdev.cpp, dbm_serv.cpp and main_svc.cpp
 *
 * Revision 6.5  1999/08/20 17:21:33  taurel
 * Added a static before RcsId in dbm_impexp.cpp file in irder to make gcc quiet
 *
Revision 6.4  99/08/19  16:45:39  16:45:39  taurel (E.Taurel)
Remove the last two pagf in main_svc and dbm_clo_op files.

Revision 6.3  99/08/04  15:42:32  15:42:32  goetz (Andy Goetz)
version 1 of rpc service not registered anymore

 * Revision 6.2  1998/12/01 15:28:02  taurel
 * Just add new function in the xdr file
 *
Revision 6.1  98/10/27  08:43:34  08:43:34  taurel (E.Taurel)
Fix bug for GRETA appli

Revision 6.0  98/08/14  09:22:20  09:22:20  taurel (E.Taurel)
Added

 * Revision 5.4  96/12/24  15:05:39  15:05:39  taurel (E.Taurel)
 * minor cahnge du to directory reorganization in the 
 * include files.
 * 
 * Revision 5.3  96/11/06  10:44:50  10:44:50  taurel (E.Taurel)
 * Change in svc_unreg call. The device class is not
 * reset to unknown. This allows gret to retrieve class resources even if the
 * device server is not running.
 * 
 * Revision 5.2  96/07/16  11:09:59  11:09:59  taurel (E.Taurel)
 * Fix a bug in db_store2 function (dbm_impxp.c file).
 * It ii necessary during the dev_export to keep process name even for old
 * server !
 * .
 * 
 * Revision 5.1  96/07/02  16:30:33  16:30:33  taurel (E.Taurel)
 * No change, check out only for test.
 * 
 * Revision 5.0  96/06/05  10:58:35  10:58:35  taurel (E.Taurel)
 * Lot of change due to db software release 5.
 *  */

#include <API.h>

#include <DevErrors.h>

#include <string.h>
#include <ctype.h>
#include <db_xdr.h>
#include <ndbm.h>

/* Some C++ include files */

#include <iostream.h>
#include <NdbmClass.h>

/* Some local functions definition */

long reg_ps(char *,long,char *,long,long *);
long unreg_ps(char *,long *);

/* Variables defined in setacc_svc.c */

extern NdbmInfo dbgen;

/* Global variables */


/* Function declaration */

long reg_ps();
long unreg_ps();



/****************************************************************************
*                                                                           *
*		Server code for db_psdev_register function                  *
*                               -----------------            	            *
*                                                                           *
*    Function rule : To store in the database (builded from resources files)*
*                    the host_name, the program number and the version      *
*                    number of the device server for a specific device      *
*                                                                           *
*    Argin : A pointer to a structure of the "tab_dbdev" type               *
*            The definition of the tab_dbdev type is :                      *
*            struct {                                                       *
*              u_int tab_dbdev_len;     The number of structures db_devinfo *
*              db_devinfo *tab_dbdev_val;    A pointer to the array of      *
*					     structures                     *
*                  }                                                        *
*                                                                           *
*    Argout : No argout                                                     *
*                                                                           *
*    This function returns an integer which is an error code                *
*         Zero means no error                                               * 
*                                                                           *
*****************************************************************************/


db_psdev_error *db_psdev_reg_1_svc(psdev_reg_x *rece)
{
	static db_psdev_error err;
	int num_psdev;
	psdev_elt *tmp;
	long error;
	register long i;

/* Miscellaneous init */

	num_psdev = rece->psdev_arr.psdev_arr_len;
	err.error_code = 0;
	err.psdev_err = 0;

#ifdef DEBUG
	cout << "Begin db_psdev_register" << endl;
	cout << "Host name : " << rece->h_name << endl;
	cout << "PID = " << rece->pid << endl;
	for (i = 0;i < num_psdev;i++)
	{
		tmp = &(rece->psdev_arr.psdev_arr_val[i]);
		cout << "Pseudo device name : " << tmp->psdev_name << endl;
		cout << "Refresh period : " << tmp->poll << endl;
	}
#endif

/* Return error code if the server is not connected */

	if (dbgen.connected == False)
	{
		err.error_code = DbErr_DatabaseNotConnected;
		return(&err);
	}

/* For each pseudo device, register it in the PS_NAMES table */

	for (i = 0;i < num_psdev;i++)
	{
		tmp = &(rece->psdev_arr.psdev_arr_val[i]);
		if (reg_ps(rece->h_name,rece->pid,tmp->psdev_name,
			   tmp->poll,&error) == -1)
		{
			err.error_code =  error;
			err.psdev_err = i + 1;
			return(&err);
		}
	}

/* Leave server */

#ifdef DEBUG
	cout << "End db_psdev_register" << endl;
#endif /* DEBUG */
	return(&err);
}



/****************************************************************************
*                                                                           *
*		Code for reg_ps function                		    *
*                        ------                         		    *
*                                                                           *
*    Function rule : To register a pseuo device in the PS_NAMES database    *
*		     table						    *
*									    *
*    Argin(s) : - h_name : The host name				    *
*		- pid : The process PID					    *
*		- ps_name : The pseudo device name			    *
*		- poll : The polling period				    *
*									    *
*    Argout(s) : - p_error : Pointer for an error code			    *
*									    *
*    This function returns 0 is everything OK. Otherwise, the returned value*
*    is -1 and the error code is set to the appropiate error.		    *
*                                                                           *
****************************************************************************/


long reg_ps(char *h_name,long pid,char *ps_name,long poll,long *p_error)
{
	datum key,content;
	register long i;
	long l;
	char *ps_name_low;
	char key_buf[MAX_KEY];
	char cont_buf[MAX_CONT];
	register char *tbeg;
	register char *tend;
	unsigned int diff;
	char d_name[40];

/* Make a copy of the pseudo device name in lowercase letter */

	l = strlen(ps_name);
	if ((ps_name_low = (char *)malloc(l + 1)) == (char *)NULL)
	{
		*p_error = DbErr_ServerMemoryAllocation;
		return(-1);
	}
	for (i = 0;i < l;i++)
		ps_name_low[i] = tolower(ps_name[i]);
	ps_name_low[i] = '\0';

/* First, check that the name used for the pseudo device is not already used
   for a real device */

	for (key = dbm_firstkey(dbgen.tid[0]);key.dptr != NULL;key = dbm_nextkey(dbgen.tid[0]))
	{
		content = dbm_fetch(dbgen.tid[0],key);
		if (content.dptr == NULL)
		{
			free(ps_name_low);
			*p_error = DbErr_DatabaseAccess;
			return(-1);
		}
		tbeg = content.dptr;
		tend = strchr(tbeg,'|');
		diff = (unsigned int)(tend - tbeg);
		strncpy(d_name,tbeg,diff);
		d_name[diff] = '\0';

		if (strcmp(d_name,ps_name_low) == 0)
			break;
	}

	if (key.dptr == NULL)
	{
		if (dbm_error(dbgen.tid[0]) != 0)
		{
			free(ps_name_low);
			*p_error = DbErr_DatabaseAccess;
			return(-1);
		}
	}
	else
	{
		free(ps_name_low);
		*p_error = DbErr_NameAlreadyUsed;
		return(-1);
	}

/* Now, try to retrieve a tuple in the PS_NAMES table with the same pseudo
   device name */

	strcpy(key_buf,ps_name_low);

	key.dptr = key_buf;
	key.dsize = strlen(key_buf);

	content = dbm_fetch(dbgen.tid[dbgen.ps_names_index],key);
	if (content.dptr == NULL)
	{

/* In case of error */

		if (dbm_error(dbgen.tid[dbgen.ps_names_index]) != 0)
		{
			free(ps_name_low);
			*p_error = DbErr_DatabaseAccess;
			return(-1);
		}

/* Insert a new record in database */

		else
		{
			strcpy(cont_buf,h_name);
			strcat(cont_buf,"|");
			sprintf(&(cont_buf[strlen(cont_buf)]),"%d",pid);
			strcat(cont_buf,"|");
			sprintf(&(cont_buf[strlen(cont_buf)]),"%d",poll);
			strcat(cont_buf,"|");

			content.dptr = cont_buf;
			content.dsize = strlen(cont_buf);
			
			if (dbm_store(dbgen.tid[dbgen.ps_names_index],key,content,DBM_INSERT) != 0)
			{
				free(ps_name_low);
				*p_error = DbErr_DatabaseAccess;
				return(-1);
			}
		}
	}

	else
	{

/* Update database information */

		strcpy(cont_buf,h_name);
		strcat(cont_buf,"|");
		sprintf(&(cont_buf[strlen(cont_buf)]),"%d",pid);
		strcat(cont_buf,"|");
		sprintf(&(cont_buf[strlen(cont_buf)]),"%d",poll);
		strcat(cont_buf,"|");

		content.dptr = cont_buf;
		content.dsize = strlen(cont_buf);
			
		if (dbm_store(dbgen.tid[dbgen.ps_names_index],key,content,DBM_REPLACE) != 0)
		{
			free(ps_name_low);
			*p_error = DbErr_DatabaseAccess;
			return(-1);
		}
	}

/* Free memory and leave function */

	free(ps_name_low);
	return(0);

}



/****************************************************************************
*                                                                           *
*		Server code for db_psdev_unregister function                *
*                               -------------------                         *
*                                                                           *
*    Function rule : To retrieve (from database) the host_name, the program *
*                    number and the version number for specific devices     *
*                                                                           *
*    Argin : A pointer to a structure of the "arr1" type                    *
*            The definition of the arr1 type is :                           *
*            struct {                                                       *
*               u_int arr1_len;      The number of strings                  *
*               char **arr1_val;     A pointer to the array of strings      *
*                   }                                                       *
*                                                                           *
*    Argout : No argout                                                     *
*                                                                           *
*    This function returns a pointer to a structure of the "db_resimp" type *
*    The definition of this structure is :                                  *
*    struct {                                                               *
*      tab_dbdev imp_dev;   A structure of the tab_dbdev type (see above)   *
*                           with the informations needed (host_name,        *
*                           program number and version number)              *
*      int db_imperr;    The database error code                            *
*                        0 if no error                                      *
*            }                                                              *
*                                                                           *
****************************************************************************/


db_psdev_error *db_psdev_unreg_1_svc(arr1 *rece)
{
	static db_psdev_error err;
	u_int num_psdev;
	register long i;
	long error;

/* Miscellaneous init */

	num_psdev = rece->arr1_len;
	err.error_code = 0;
	err.psdev_err = 0;

#ifdef DEBUG
	cout << "Begin db_psdev_unregister" << endl;
	for (i = 0;i < num_psdev;i++)
		cout << "Pseudo device name : " << rece->arr1_val[i] << endl;
#endif

/* Return error code if the server is not connected */

	if (dbgen.connected == False)
	{
		err.error_code = DbErr_DatabaseNotConnected;
		return(&err);
	}

/* For each pseudo device, unregister it in the PS_NAMES table */

	for (i = 0;i < num_psdev;i++)
	{
		if (unreg_ps(rece->arr1_val[i],&error) == -1)
		{
			err.error_code =  error;
			err.psdev_err = i + 1;
			return(&err);
		}
	}

/* Leave server */

#ifdef DEBUG
	cout << "End db_psdev_unregister" << endl;
#endif /* DEBUG */
	return(&err);
}



/****************************************************************************
*                                                                           *
*		Code for unreg_ps function                		    *
*                        --------                         		    *
*                                                                           *
*    Function rule : To unregister pseuo device from the database PS_NAMES  *
*		     table						    *
*									    *
*    Argin(s) : - ps_name : The pseudo device name			    *
*									    *
*    Argout(s) : - p_error : Pointer for an error code			    *
*									    *
*    This function returns 0 is everything OK. Otherwise, the returned value*
*    is -1 and the error code is set to the appropiate error.		    *
*                                                                           *
****************************************************************************/


long unreg_ps(char *ps_name,long *p_error)
{
	register long i;
	long l;
	char *ps_name_low;
	datum key,content;
	char key_buf[MAX_KEY];

/* Make a copy of the pseudo device name in lowercase letter */

	l = strlen(ps_name);
	if ((ps_name_low = (char *)malloc(l + 1)) == (char *)NULL)
	{
		*p_error = DbErr_ServerMemoryAllocation;
		return(-1);
	}
	for (i = 0;i < l;i++)
		ps_name_low[i] = tolower(ps_name[i]);
	ps_name_low[i] = '\0';

/* Retrieve a tuple in the PS_NAMES table with the same pseudo device name */

	strcpy(key_buf,ps_name_low);

	key.dptr = key_buf;
	key.dsize = strlen(key_buf);

	content = dbm_fetch(dbgen.tid[dbgen.ps_names_index],key);

	if (content.dptr == NULL)
	{
		if (dbm_error(dbgen.tid[dbgen.ps_names_index]) != 0)
		{
			free(ps_name_low);
			*p_error = DbErr_DatabaseAccess;
			return(-1);
		}
		else
		{
			free(ps_name_low);
			*p_error = DbErr_DeviceNotDefined;
			return(-1);
		}
	}
	else
	{

/* Remove pseudo device */

		if (dbm_delete(dbgen.tid[dbgen.ps_names_index],key) != 0)
		{
			free(ps_name_low);
			*p_error = DbErr_DatabaseAccess;
			return(-1);
		}

	}

/* Free memory and leave function */

	free(ps_name_low);
	return(0);

}
