static char RcsId[] = "$Header: dbm_clo_op.cpp,v 6.9 2000/03/15 17:07:50 taurel Rel $";

/* $Log:	dbm_clo_op.cpp,v $
Revision 6.9  2000/03/15  17:07:50  17:07:50  taurel (E.Taurel)
Change compilation variable from -solaris to sun

Revision 6.8  2000/02/15  12:40:24  12:40:24  taurel (E.Taurel)
Fix bug in update of arrays in the updres_1_svc function (file dbm_update.cpp). Change the value of the array flag when calling the upd_res function.

Revision 6.7  99/11/21  21:47:59  21:47:59  goetz (Andy Goetz)
register version 1 of database service

 * Revision 6.6  1999/11/21 14:41:02  goetz
 * included M.Diehl's patches for dbm_getdev.cpp, dbm_serv.cpp and main_svc.cpp
 *
 * Revision 6.5  1999/08/20 17:21:27  taurel
 * Added a static before RcsId in dbm_impexp.cpp file in irder to make gcc quiet
 *
Revision 6.4  99/08/19  16:45:32  16:45:32  taurel (E.Taurel)
Remove the last two pagf in main_svc and dbm_clo_op files.

Revision 6.3  99/08/04  15:42:32  15:42:32  goetz (Andy Goetz)
version 1 of rpc service not registered anymore

 * Revision 6.2  1998/12/01 15:27:56  taurel
 * Just add new function in the xdr file
 *
Revision 6.1  98/10/27  08:43:27  08:43:27  taurel (E.Taurel)
Fix bug for GRETA appli

Revision 6.0  98/08/14  09:20:39  09:20:39  taurel (E.Taurel)
Added

 * Revision 5.4  96/12/24  15:05:36  15:05:36  taurel (E.Taurel)
 * minor cahnge du to directory reorganization in the 
 * include files.
 * 
 * Revision 5.3  96/11/06  10:44:44  10:44:44  taurel (E.Taurel)
 * Change in svc_unreg call. The device class is not
 * reset to unknown. This allows gret to retrieve class resources even if the
 * device server is not running.
 * 
 * Revision 5.2  96/07/16  11:09:56  11:09:56  taurel (E.Taurel)
 * Fix a bug in db_store2 function (dbm_impxp.c file).
 * It ii necessary during the dev_export to keep process name even for old
 * server !
 * .
 * 
 * Revision 5.1  96/07/02  16:30:30  16:30:30  taurel (E.Taurel)
 * No change, check out only for test.
 * 
 * Revision 5.0  96/06/05  10:58:32  10:58:32  taurel (E.Taurel)
 * Lot of change due to db software release 5.
 * 
 * Revision 4.2  96/02/27  13:47:59  13:47:59  taurel (E.Taurel)
 * Ported to Solaris
 * 
 * Revision 4.1  94/06/10  15:08:22  15:08:22  taurel (Emmanuel TAUREL)
 * Added the new db_cmd_query call
 * 
 * Revision 4.0  94/05/17  16:11:01  16:11:01  taurel (Emmanuel TAUREL)
 * Check in of release 4.0 with :
 * - new table SEC
 * - A new call db_delresource
 * - Version 1 and 2 of db_dev_export. In version2 of db_dev_export, the PID
 * is stored in the database
 * .
 * 
 * Revision 2.4  94/03/31  13:44:35  13:44:35  taurel (Emmanuel TAUREL)
 * Check
 * 
 * Revision 2.3  94/03/31  13:42:07  13:42:07  taurel (Emmanuel TAUREL)
 * Added
 * 
 * Revision 2.2  93/12/06  17:09:41  17:09:41  taurel (Emmanuel Taurel)
 * Added new signal management. Now,
 * all the signals which kill the process without generating core are 
 * caught.
 * 
 * Revision 2.1  93/09/14  17:27:16  17:27:16  taurel (Emmanuel Taurel)
 * Remove the DBNAME env. variable which is not used.
 * 
 * Revision 2.0  93/09/13  15:36:03  15:36:03  taurel (Emmanuel Taurel)
 * First
 * 
 * Revision 1.6  93/08/04  17:48:53  17:48:53  karhu ()
 * Resource values up to 2048 characters
 * 
 * Revision 1.5  93/07/20  05:04:49  05:04:49  karhu ()
 * In error handling calls to the function leave were replaced by errorcode
 * and return mechanism
 * 
 * Revision 1.4  93/06/28  14:46:24  14:46:24  karhu ()
 * Corrected some semantic mistakes
 * 
 * Revision 1.3  92/12/13  01:38:09  01:38:09  karhu ()
 * Supports flexible table definition.
 * 
 * Revision 1.2  92/09/24  16:50:53  16:50:53  karhu ()
 * This dbm-version is based on the rtdb-version of clo_op.c (Revision 2.1)
 * 
 * Revision 1.1  92/09/24  16:50:37  16:50:37  karhu ()
 * Initial revision
 * 
 *  
 */

#include <API.h>

#include <DevErrors.h>

#include <db_xdr.h>
#include <ndbm.h>
#include <fcntl.h>

/* Some C++ include files */

#include <string>
#include <NdbmClass.h>
#include <iostream.h>
#include <fstream.h>

/* Variables defined elsewhere */

extern NdbmInfo dbgen;



/****************************************************************************
*                                                                           *
*		Server code for dbm_close function                          *
*                               --------                                    *
*                                                                           *
*    Function rule : To close the database to be able to reload a new       *
*		     database.						    *
*                                                                           *
*    Argin :  No argin							    *
*                                                                           *
*    Argout : No argout                                                     *
*                                                                           *
*    This function returns a pointer to an integer. This integer is simply  *
*    an error code (0 if no error).					    * 
*                                                                           *
****************************************************************************/

int *db_clodb_1_svc()
{
	static int errcode;
	int flags;
	int i;

	errcode = 0;

#ifdef DEBUG
	cout << "db_clodb()" << endl;
#endif /* DEBUG */

/* Return error code if the server is not connected to the database files */

	if (dbgen.connected == False)
	{
		errcode = DbErr_DatabaseNotConnected;
		return(&errcode);
	}

/* Disconnect server from database files */

	for (i = 0;i < dbgen.TblNum;i++)
		dbm_close(dbgen.tid[i]);
	dbgen.connected = False;

/* Leave server */

	return(&errcode);

}



/****************************************************************************
*                                                                           *
*		Server code for dbm_reopendb function                       *
*                               ------------                                *
*                                                                           *
*    Function rule : Reopen the database after it has been updated by a     *
*		     dbm_update command in a single user mode or after      *
*		     the rebuilding from a backup file.			    *
*									    *
*                                                                           *
*    Argin :  No argin							    *
*                                                                           *
*    Argout : No argout                                                     *
*                                                                           *
*    This function returns a pointer to an integer. This integer is simply  *
*    an error code (0 if no error).					    * 
*                                                                           *
****************************************************************************/

int *db_reopendb_1_svc()
{
	static int errcode;
	int flags;
	char *ptr;
	int i;

#ifdef DEBUG
	cout << "db_reopendb" << endl;
#endif /* DEBUG */

	errcode = 0;

	flags = O_RDWR;

/* Find the dbm_database files */        

	if ((ptr = (char *)getenv("DBM_DIR")) == NULL)
	{
		cerr << "dbm_server: Can't find environment variable DBM_DIR" << endl;
		errcode = DbErr_DatabaseAccess;
		return(&errcode);
	}

	string dir_name(ptr);

	if (dir_name[dir_name.size() - 1] != '/')
		dir_name.append(1,'/');

/* Open database tables according to the definitions  */

	for (i = 0;i < dbgen.TblNum;i++)
	{

		string dbm_file(dir_name);
		
		dbm_file.append(dbgen.TblName[i]);
		
		string uni_file(dbm_file);
		uni_file.append(".dir");

		ifstream fi(uni_file.c_str());
		if (!fi)
		{
			cerr << "dbm_clo_op : Can't find file " << uni_file << endl;
			errcode = DbErr_DatabaseAccess;
			return(&errcode);
		}

		dbgen.tid[i] = dbm_open((char *)dbm_file.c_str(), flags, 0666);
		if (dbgen.tid[i] == NULL)
		{
			cerr <<"dbm_server : Can't open " << dbgen.TblName[i] << " table"; 
			errcode = DbErr_DatabaseAccess;
			return(&errcode);
		}
	} 
	
/* Mark the server as connected to the database */

	dbgen.connected = True;

/* Leave server */

	return(&errcode);

}
