static char RcsId[] = "$Header: cmd_query.cpp,v 6.9 2000/03/15 17:07:55 taurel Rel $";

/* $Log:	cmd_query.cpp,v $
Revision 6.9  2000/03/15  17:07:55  17:07:55  taurel (E.Taurel)
Change compilation variable from -solaris to sun

Revision 6.8  2000/02/15  12:40:28  12:40:28  taurel (E.Taurel)
Fix bug in update of arrays in the updres_1_svc function (file dbm_update.cpp). Change the value of the array flag when calling the upd_res function.

Revision 6.7  99/11/21  21:47:59  21:47:59  goetz (Andy Goetz)
register version 1 of database service

 * Revision 6.6  1999/11/21 14:41:02  goetz
 * included M.Diehl's patches for dbm_getdev.cpp, dbm_serv.cpp and main_svc.cpp
 *
 * Revision 6.5  1999/08/20 17:21:31  taurel
 * Added a static before RcsId in dbm_impexp.cpp file in irder to make gcc quiet
 *
Revision 6.4  99/08/19  16:45:37  16:45:37  taurel (E.Taurel)
Remove the last two pagf in main_svc and dbm_clo_op files.

Revision 6.3  99/08/04  15:42:32  15:42:32  goetz (Andy Goetz)
version 1 of rpc service not registered anymore

 * Revision 6.2  1998/12/01 15:28:01  taurel
 * Just add new function in the xdr file
 *
Revision 6.1  98/10/27  08:43:32  08:43:32  taurel (E.Taurel)
Fix bug for GRETA appli

Revision 6.0  98/08/14  09:21:54  09:21:54  taurel (E.Taurel)
Added

 * Revision 5.4  96/12/24  15:05:39  15:05:39  taurel (E.Taurel)
 * minor cahnge du to directory reorganization in the 
 * include files.
 * 
 * Revision 5.3  96/11/06  10:44:48  10:44:48  taurel (E.Taurel)
 * Change in svc_unreg call. The device class is not
 * reset to unknown. This allows gret to retrieve class resources even if the
 * device server is not running.
 * 
 * Revision 5.2  96/07/16  11:09:58  11:09:58  taurel (E.Taurel)
 * Fix a bug in db_store2 function (dbm_impxp.c file).
 * It ii necessary during the dev_export to keep process name even for old
 * server !
 * .
 * 
 * Revision 5.1  96/07/02  16:30:32  16:30:32  taurel (E.Taurel)
 * No change, check out only for test.
 * 
 * Revision 5.0  96/06/05  10:58:34  10:58:34  taurel (E.Taurel)
 * Lot of change due to db software release 5.
 * 
 * Revision 4.2  96/02/27  13:48:01  13:48:01  taurel (E.Taurel)
 * Ported to Solaris
 * 
 * Revision 4.1  94/06/10  15:08:32  15:08:32  taurel (Emmanuel TAUREL)
 * Added the new db_cmd_query call
 *  */

#include <API.h>

#include <string.h>
#include <ndbm.h>
#include <fcntl.h>
#include <db_xdr.h>

/* Some C++ include files */

#include <string>
#include <NdbmClass.h>
#include <iostream.h>

/* Variables defined elsewhere */

extern NdbmInfo dbgen;



/****************************************************************************
*                                                                           *
*		Server code for db_cmd_query function                       *
*                               ------------                                *
*                                                                           *
*    Function rule : To retrieve (from database) the command code           *
*		     associated to a command name (the string)		    *
*                                                                           *
*    Argin : A pointer to string which is the command name		    *
*                                                                           *
*    Argout : No argout                                                     *
*                                                                           *
*    This function returns a pointer to a structure of the "cmd_que" type   *
*    The definition of this structure is :                                  *
*    struct {                                                               *
*      int db_err;    The database error code                               *
*                        0 if no error                                      *
*      unsigned int xcmd_code;	The command code.			    *
*				0 if the database query fails		    *
*            }                                                              *
*                                                                           *
****************************************************************************/


cmd_que *db_cmd_query_1_svc(nam *pcmd_name)
{
	static cmd_que back;
	int i,found;
	datum key;
	datum content;
	char *tbeg,*tend;
	DBM *tab;
	unsigned int diff;
	int ds_num;
	int team;
	int cmd_num;
	char fam[40];
	char memb[40];
	char r_name[40];
	char cmd_str[50];

#ifdef DEBUG
	cout << "Command name : " << *pcmd_name << endl;
#endif

/* Initialize error code sended back to client */

	back.db_err = 0;
	found = False;

/* Return error code if the server is not connected to the database files */

	if (dbgen.connected == False)
	{
		back.db_err = DbErr_DatabaseNotConnected;
		back.xcmd_code = 0;
		return(&back);
	}

/* Retrieve the right "table" in the table array */

	for (i = 0;i < dbgen.TblNum;i++)
	{
		if (dbgen.TblName[i] == "cmds")
		{
			tab = dbgen.tid[i];
			break;
		}
	}

	if (i == dbgen.TblNum)
	{
		back.db_err = DbErr_DomainDefinition;
		back.xcmd_code = 0;
		return(&back);
	}

/* Try to retrieve a resource in the CMDS table with a resource value equal
   to the command name */

	for (key=dbm_firstkey(tab);key.dptr!=NULL;key=dbm_nextkey(tab))
	{

		content = dbm_fetch(tab,key);
		if (content.dptr == NULL)
		{
			back.db_err = DbErr_DatabaseAccess;
			back.xcmd_code = 0;
			return(&back);
		}

		strncpy(cmd_str,content.dptr,content.dsize);
		cmd_str[content.dsize] = 0;

		if (strcmp(cmd_str,*pcmd_name) == 0)
		{
			found = True;
			break;
		}
	}

	if (found == True)
	{

/* Get family from key */

		tbeg = key.dptr;
		tend = (char *)strchr(tbeg,'|');
		if (tend == NULL)
		{
			back.db_err = DbErr_DatabaseAccess;
			back.xcmd_code = 0;
			return(&back);
		}
		diff = (unsigned int)(tend++ - tbeg);
		strncpy(fam,tbeg,diff);
		fam[diff] = 0;

/* Get member from key */

		tbeg = tend;

		tend = (char *)strchr(tbeg,'|');
		if (tend == NULL)
		{
			back.db_err = DbErr_DatabaseAccess;
			back.xcmd_code = 0;
			return(&back);
		}
		diff = (unsigned int)(tend++ - tbeg);
		strncpy(memb,tbeg,diff);
		memb[diff] = 0;

/* Get resource name from key */

		tbeg = tend;

		tend = (char *)strchr(tbeg,'|');
		if (tend == NULL)
		{
			back.db_err = DbErr_DatabaseAccess;
			back.xcmd_code = 0;
			return(&back);
		}
		diff = (unsigned int)(tend++ - tbeg);
		strncpy(r_name,tbeg,diff);
		r_name[diff] = 0;

/* Build the command code */

		team = atoi(fam);
		ds_num = atoi(memb);
		cmd_num = atoi(r_name);
		back.xcmd_code = (team << DS_TEAM_SHIFT) + (ds_num << DS_IDENT_SHIFT) + cmd_num;

	}

/* If no command string founded */

	else
	{
		back.xcmd_code = 0;
		back.db_err = DbErr_ResourceNotDefined;
	}


/* Leave server */

	return(&back);
}
