
/* $Log:	db_setup.h,v $
 * Revision 6.6  98/12/22  10:24:58  10:24:58  taurel (Emmanuel Taurel)
 * Added const for the resource_name field of the db_resource structure.
 * 
 * Revision 6.5  98/12/01  15:22:51  15:22:51  taurel (Emmanuel Taurel)
 * Added resource cache call and getdsonhost call.
 * 
 * Revision 6.4  98/10/26  16:37:05  16:37:05  taurel (E.Taurel)
 * Change in alone host definition.
 * 
 * Revision 6.3  98/10/12  17:32:12  17:32:12  taurel (E.Taurel)
 * Added a new call : db_delreslist().
 * 
 * Revision 6.2  1998/09/02  09:16:01  taurel
 * New database software release with all utilities server oriented.
 *
 * Revision 5.15  97/12/01  15:40:40  15:40:40  klotz (W.D. Klotz)
 * WIN_NT_95_released_NOV_97
 * 
 * Revision 5.3  97/01/06  15:55:01  15:55:01  taurel (E.Taurel)
 * Change the r_name filed size in the reso_xxx structures.
 * 
 * Revision 5.2  96/12/24  15:33:07  15:33:07  taurel (E.Taurel)
 * Only one db_setup.h file for ndbm and rtdb software with a NDBM define
 * statement.
 * 
 * Revision 5.1  96/09/17  17:25:27  17:25:27  klotz (W.D. Klotz)
 * WD Klotz: checked NT build
 * 
 * Revision 5.0  96/06/06  09:05:20  09:05:20  taurel (E.Taurel)
 * Lot of changes due to db software release 5.
 * 
 * Revision 4.4  95/12/18  16:55:34  16:55:34  taurel (Emmanuel TAUREL)
 * Added new constant definition.
 * 
 * Revision 4.3  95/12/18  14:21:02  14:21:02  taurel (Emmanuel TAUREL)
 * Changed for the C++ port. Done by A.G but he did not unlock the file before
 * he leaves.
 * 
 * Revision 4.2  94/06/10  10:51:56  10:51:56  taurel (Emmanuel TAUREL)
 * Added new definition for the db_cmd_query function.
 * 
 * Revision 4.1  94/06/08  08:44:30  08:44:30  taurel (Emmanuel TAUREL)
 * Added a new structure definition for the dbset_hostinfo command.
 * 
 * Revision 4.0  94/05/18  09:26:35  09:26:35  taurel (Emmanuel TAUREL)
 * Check in for release 4.0
 * 
 * Revision 2.5  93/08/10  14:39:39  14:39:39  taurel (Emmanuel TAUREL)
 * Added two new domains in database with resource size up to 245
 * characters and defined a new structure for these domains.
 * 
 * Revision 2.4  92/09/30  14:27:19  14:27:19  taurel (Emmanuel Taurel)
 * Add a new structure definition for the db_dev_import function.
 * 
 * Revision 2.3  92/04/14  11:05:22  11:05:22  taurel (Emmanuel Taurel)
 * Add indice in the database for device number (in device list) and
 * resource number (for resources which are arrays).
 * 
 * Revision 2.2  92/01/09  11:14:36  11:14:36  taurel (Emmanuel Taurel)
 * Added db_putresource function definition.
 * 
 * Revision 2.1  91/12/16  10:12:03  10:12:03  taurel (Emmanuel Taurel)
 * Added constants for new resources type (array)
 * 
 * Revision 2.0  91/10/25  08:52:28  08:52:28  taurel (Emmanuel Taurel)
 * Added new elements in the device and db_devinf structures.
 * Added prototyping for ANSI C.
 * 
 * Revision 1.5  91/10/11  10:56:45  10:56:45  taurel (Emmanuel Taurel)
 * Added constant definitions for the db_getdevexp function.
 * 
 * Revision 1.4  91/05/24  14:55:08  14:55:08  taurel (Emmanuel Taurel)
 * Change MAXDEV constant.
 * 
 * Revision 1.3  91/05/22  10:49:22  10:49:22  taurel (Emmanuel Taurel)
 * Change column size in resources and class database tables.
 * 
 * Revision 1.2  91/04/11  13:19:43  13:19:43  taurel (Emmanuel Taurel)
 * new device structure (according to the new NAMES table).
 * Added NB_CHAR macro definition.
 * 
 * 
 * Revision 1.1  91/02/26  08:48:52  08:48:52  taurel (Emmanuel Taurel)
 * Initial revision
 *  */

#ifndef _db_setup_h
#define _db_setup_h

/* Constants definition */

#define	MAXDEV		16		/* Maximun number of device for a d 
					   server before memory reallocation */
#define ST_ALLOC	8		/* For allocation algorithm
					   DON'T CHANGE THIS VALUE OR THE SKY
					   WILL FALL ON YOUR HEAD ! */
#define	MAXDEV_UDP	201		/* The max. number of device names in
					   one UDP packet (8 K of data) */
#define STRING_SIZE	23		/* Maximun size for a resource defined
					   as a atring */
#define MAX_RES		256		/* Maximun size for a resource belonging
					   to the ERROR or CMDS domains */
#define	ERR_DEVNAME	0x1		/* Error in device name def. */
#define	ERR_RESVAL	0x2		/* Error in resource definition */
#define	ERR_DEV_NOT_FD	0x3		/* No device */

#define	SIZE		8192		/* The buffer size for dbset_update */
#define	SIZE_DEL	1024		/* The buffer size for db_delresource */
#define	LIM		256		/* For the RPC information */
#define	SEP_ELT		0x02		/* Separator between resource element
					   array */
#define	INIT_ARRAY	0x05		/* The first string character when the 
				   	   resource is an array */
#define	PAS_MAX_LENGTH	23		/* Max length for the sec. passwd */
#define	RETRY		2		/* Max number of retries after not
					   connected error (only for ndbm) */
#define	DB_SETUPVERS	((u_long)1)	/* The original version number */
#define	DB_VERS_2	((u_long)2)	/* Version number 2 ! */
#define	DB_VERS_3	((u_long)3)	/* Version number 3 ! */

#define SLEEP_TIME	0x80000006	/* 20 mS in 1/256 seconds */

#define	DEV_CLASS_LENGTH	24
#define DEV_TYPE_LENGTH		24
#define	HOST_NAME_LENGTH	20
#define	PROC_NAME_LENGTH	40
#define DSPERS_NAME_LENGTH	12
#define DS_NAME_LENGTH		24
#define DOMAIN_NAME_LENGTH	8
#define FAMILY_NAME_LENGTH	20
#define MEMBER_NAME_LENGTH	20
#define DEV_NAME_LENGTH		24
#define RES_NAME_LENGTH		32
#define RES_VAL_LENGTH		256

#define ORA_LOOP		50
#define ORA_MEDIUM_LOOP		20
#define ORA_SMALL_LOOP		10

#define	DB_Device		1
#define DB_Pseudo_Device	2

#define Db_File			1
#define Db_Buffer		2

#define SEC_SEP			'^'

#define UDP_MAX_SIZE		(8 * 1024) - 512

#define DB_GLOBAL_ERROR		1
#define DB_DELETE_ERROR		2
#define DB_UPD_DEV_ERROR	3
#define DB_UPD_RES_ERROR	4

#define DB_DEV_LIST		0
#define DB_RES_LIST		1

#define DB_UDP			0
#define DB_TCP			1

#ifdef sun
#define	ALONE_SERVER_HOST	"apus"
#else
#define ALONE_SERVER_HOST	"pollux"
#endif

/* Special definitions for ndbm software */

#define	MAX_CONT	2150		/* Max. length of the dbm database
					   content */
#define	MAXDOMAIN	20		/* Max. number of domain */
#define	MAX_KEY		100		/* Max. length of the dbm database 
					   key */
#define	MAX_RES_SERVDEL	500		/* Max res. number */


/* Structures definitions */

typedef struct _db_resource
{
	const char	*resource_name;
	short 		resource_type;
	void 		*resource_adr;
}db_resource,*Db_resource;

typedef struct _db_devinf_imp
{
	char 		device_name[DEV_NAME_LENGTH];
	char 		host_name[HOST_NAME_LENGTH];
	char 		device_type[24];
	char 		device_class[DEV_CLASS_LENGTH];
	unsigned int 	pn;
	unsigned int 	vn;
}db_devinf_imp,*Db_devinf_imp;

typedef struct _db_devinf
{
	char 		*device_name;
	char 		*host_name;
	char 		*device_type;
	char 		*device_class;
	unsigned int 	pn;
	unsigned int 	vn;
	char 		*proc_name;
}db_devinf,*Db_devinf;

typedef struct _device
{
	char 		h_name[HOST_NAME_LENGTH];
	char 		ds_class[DS_NAME_LENGTH];
	char 		ds_name[DSPERS_NAME_LENGTH];
	char 		d_name[DEV_NAME_LENGTH];
	int 		pn;
	int 		vn;
	char 		d_type[24];
	char 		d_class[DEV_CLASS_LENGTH];
	int 		indi;
	int 		pid;
	char 		proc_name[PROC_NAME_LENGTH];
}device;

typedef struct _ps_device
{
	char 		h_name[HOST_NAME_LENGTH];
	char 		ps_name[24];
	int 		pid;
	int 		refresh;
}ps_device;

#ifdef NDBM
typedef struct _reso
{
	char 		fam[20];
	char 		member[20];
	char 		r_name[32];
	char 		r_val[2048];
	int 		indi;
}reso;
#else
typedef struct _reso
{
	char 		fam[20];
	char 		member[20];
	char 		r_name[32];
	char 		r_val[24];
	int 		indi;
}reso;
#endif /* NDBM */

typedef struct _reso_long
{
	char 		fam[20];
	char	 	member[20];
	char 		r_name[32];
	char 		r_val[256];
	int 		indi;
}reso_long;

typedef struct _dena
{
	char 		devina[24];
	char 		oh_name[20];
	int 		opn;
	int 		ovn;
	char 		od_type[24];
	char 		od_class[DEV_CLASS_LENGTH];
	int 		opid;
	char 		od_proc[PROC_NAME_LENGTH];
}dena;

typedef struct _spec_data
{
	char 		name[60];
	char 		access[40];
}spec_data;

typedef struct _servinfo
{
	unsigned int 	pn;
	char 		ds_name[DS_NAME_LENGTH];
	char 		pers_name[DSPERS_NAME_LENGTH];
	int 		pid;
	int 		bad_answer;
	int 		class_number;
	char 		class_name[10][40];
}servinfo;

typedef struct _db_psdev_info
{
	char 		*psdev_name;
	long 		poll_interval;
}db_psdev_info;

typedef struct _db_error
{
	long 		error_code;
	long 		psdev_err;
}db_error;

typedef struct _db_devinfo_call
{
	long		device_type;
	long		device_exported;
	char		device_class[DEV_CLASS_LENGTH];
	char		server_name[DS_NAME_LENGTH];
	char		personal_name[DSPERS_NAME_LENGTH];
	char		process_name[PROC_NAME_LENGTH];
	unsigned long	server_version;
	char		host_name[HOST_NAME_LENGTH];
	unsigned long	pid;
	unsigned long   program_num;
}db_devinfo_call;

typedef struct _db_info_dom
{
	char		dom_name[DOMAIN_NAME_LENGTH];
	long		dom_elt;
}db_info_dom;

typedef struct _db_stat_call
{
	long		dev_defined;
	long		dev_exported;
	long		psdev_defined;
	long		res_number;
	long		dev_domain_nb;
	db_info_dom	*dev_domain;
	long		res_domain_nb;
	db_info_dom	*res_domain;
}db_stat_call;


typedef struct _db_svcinfo_dev
{
	long		exported_flag;
	char		dev_name[DEV_NAME_LENGTH];
}db_svcinfo_dev;


typedef struct _db_svcinfo_server
{
	char		server_name[DS_NAME_LENGTH];
	long		device_nb;
	db_svcinfo_dev	*device;
}db_svcinfo_server;


typedef struct _db_svcinfo_call
{
	long			embedded_server_nb;
	db_svcinfo_server	*server;
	char			process_name[PROC_NAME_LENGTH];
	unsigned long		pid;
	char			host_name[HOST_NAME_LENGTH];
	unsigned long		program_num;
}db_svcinfo_call;		

typedef struct _db_dev_in_db
{
	char			dev_name[DEV_NAME_LENGTH];
	long			found;
	long			seq;
	char			key_buf[MAX_KEY];
	device			dev_info;
}db_dev_in_db;

typedef struct _db_poller
{
	char		server_name[DS_NAME_LENGTH];
	char 		personal_name[DSPERS_NAME_LENGTH];
	char		host_name[HOST_NAME_LENGTH];
	char		process_name[PROC_NAME_LENGTH];
	unsigned long	pid;
}db_poller;


typedef struct _db_svc
{
	char		server_name[DS_NAME_LENGTH];
	char 		personal_name[DSPERS_NAME_LENGTH];
	char		host_name[HOST_NAME_LENGTH];
	unsigned long	pid;
	unsigned long 	program_num;
}db_svc;


typedef struct _db_delupd_error 
{
	long	type;
	long 	number;
	long 	error;
}db_delupd_error;


/* Macros definitions */

/* This macros initialize A with the number of C character in the string
   pointed to by B */

#define NB_CHAR(A,B,C) {\
	int im,lm;\
	lm = strlen(B);\
	for (im=0;im<lm;im++) {\
		if (B[im] == C)\
			A++;\
			}\
}\

/* Functions definitions */

#ifndef __cplusplus
/*
 * OIC version
 */
int _DLLFunc db_getresource PT_((char *dev_name,register Db_resource resource,u_int num_resource,long *error));
int _DLLFunc db_getdevlist PT_((char *ds_name,char ***device_tab,u_int *dev_num,long *error));
int _DLLFunc db_dev_export PT_((register Db_devinf devinfo,u_int num_device,long *error));
int _DLLFunc db_dev_import PT_((char **devname,Db_devinf_imp *devinf,unsigned int num_device,long *error));
int _DLLFunc db_svc_unreg PT_((char *dsn_name,long *error));
int _DLLFunc db_svc_check PT_((char *dsn_name,char **host_name,u_int *p_num,u_int *v_num,long *error));
int _DLLFunc db_getdevexp  PT_((char *filter,char ***device_tab,u_int *dev_num,long *error));
int _DLLFunc db_freedevexp  PT_((char **buffer));
int _DLLFunc db_svc_close PT_((long *error));
int _DLLFunc db_svc_reopen PT_((long *error));
int _DLLFunc db_putresource PT_((char *dev_name,register Db_resource resource,u_int num_resource,long *error));
int _DLLFunc db_delresource PT_((char *dev_name,register char **res_name,u_int num_resource,long *error));
int _DLLFunc db_cmd_query PT_((char *cmd_name,u_int *cmd_code,long *error));
int _DLLFunc db_psdev_register PT_((db_psdev_info *psdev,long num_psdev,db_error *error));
int _DLLFunc db_psdev_unregister PT_((char *psdev_list[],long num_psdev,db_error *error));

long _DLLFunc db_getdevdomainlist PT_((long *domain_nb,char ***domain_list,long *error));
long _DLLFunc db_getdevfamilylist PT_((char *domain,long *family_nb,char ***family_list,long *error));
long _DLLFunc db_getdevmemberlist PT_((char *domain,char *family,long *member_nb,char ***member_list,long *error));
long _DLLFunc db_getresdomainlist PT_((long *domain_nb,char ***domain_list,long *error));
long _DLLFunc db_getresfamilylist PT_((char *domain,long *family_nb,char ***family_list,long *error));
long _DLLFunc db_getresmemberlist PT_((char *domain,char *family,long *member_nb,char ***member_list,long *error));
long _DLLFunc db_getresresolist PT_((char *domain,char *family,char *member,long *resource_nb,char ***resource_list,long *error));
long _DLLFunc db_getresresoval PT_((char *domain,char *family,char *member,char *resource,long *resval_nb,char ***resval_list,long *error));
long _DLLFunc db_getdsserverlist PT_((long *server_nb,char ***server_list,long *error));
long _DLLFunc db_getdspersnamelist PT_((char *server,long *persname_nb,char ***persname_list,long *error));
long _DLLFunc db_gethostlist PT_((long *host_nb,char ***host_list,long *error));
long _DLLFunc db_getdsonhost PT_((char *host,long *ds_nb,db_svc **ds_list,long *error));

long _DLLFunc db_deviceinfo PT_((const char *dev_name,db_devinfo_call *devinfo,long *error));
long _DLLFunc db_deviceres PT_((long dev_nb,char **dev_name_list,long *res_nb,char ***res_list,long *error));
long _DLLFunc db_devicedelete PT_((const char *dev_name,long *error));
long _DLLFunc db_devicedeleteres PT_((long dev_nb,char **dev_name_list,db_error *error));
long _DLLFunc db_stat PT_((db_stat_call *info,long *error));
long _DLLFunc db_servunreg PT_((const char *ds_name,const char *pers_name,long *error));
long _DLLFunc db_servinfo PT_((const char *ds_name,const char *pers_name,db_svcinfo_call *s_info,long *error));
long _DLLFunc db_servdelete PT_((const char *ds_name,const char *pers_name,long delres_flag,long *error));
long _DLLFunc db_getpoller PT_((const char *dev_name,db_poller *poll,long *error));
long _DLLFunc db_delreslist PT_((char **res_list,long res_num,long *error));
long _DLLFunc db_initcache PT_((const char *domain,long *error));

long _DLLFunc db_analyze_data PT_((long in_type,const char *buffer,long *nb_devdef,char ***devdef,long *nb_resdef,char ***resdef,long *error_line,long *error));
long _DLLFunc db_upddev PT_((long devdef_nb,char **devdef,long *deferr_nb,long *error));
long _DLLFunc db_updres PT_((long resdef_nb,char **resdef,long *deferr_nb,long *error));
long _DLLFunc db_secpass PT_((char **pass,long *error));
long _DLLFunc db_delete_update PT_((long dev_nb,char **dev_name_list,long list_type,long devdef_nb,char **devdef,long resdef_nb,char **resdef,db_delupd_error *p_error));

#else
/*
 * C++ version
 */
extern "C" 
{
int _DLLFunc db_getresource (char *dev_name,Db_resource resource,u_int num_resource,long *error);
int _DLLFunc db_getdevlist (char *ds_name,char ***device_tab,u_int *dev_num,long *error);
int _DLLFunc db_dev_export (register Db_devinf devinfo,u_int num_device,long *error);
int _DLLFunc db_dev_import (char **devname,Db_devinf_imp *devinf,unsigned int num_device,long *error);
int _DLLFunc db_svc_unreg (char *dsn_name,long *error);
int _DLLFunc db_svc_check (char *dsn_name,char **host_name,u_int *p_num,u_int *v_num,long *error);
int _DLLFunc db_getdevexp  (char *filter,char ***device_tab,u_int *dev_num,long *error);
int _DLLFunc db_freedevexp (char **buffer);
int _DLLFunc db_svc_close (long *error);
int _DLLFunc db_svc_reopen (long *error);
int _DLLFunc db_putresource (char *dev_name,register Db_resource resource,u_int num_resource,long *error);
int _DLLFunc db_delresource (char *dev_name,register char **res_name,u_int num_resource,long *error);
int _DLLFunc db_cmd_query (char *cmd_name,u_int *cmd_code,long *error);
int _DLLFunc db_psdev_register (db_psdev_info *psdev,long num_psdev,db_error *error);
int _DLLFunc db_psdev_unregister (char *psdev_list[],long num_psdev,db_error *error);

long _DLLFunc db_getdevdomainlist (long *domain_nb,char ***domain_list,long *error);
long _DLLFunc db_getdevfamilylist (char *domain,long *family_nb,char ***family_list,long *error);
long _DLLFunc db_getdevmemberlist (char *domain,char *family,long *member_nb,char ***member_list,long *error);
long _DLLFunc db_getresdomainlist (long *domain_nb,char ***domain_list,long *error);
long _DLLFunc db_getresfamilylist (char *domain,long *family_nb,char ***family_list,long *error);
long _DLLFunc db_getresmemberlist (char *domain,char *family,long *member_nb,char ***member_list,long *error);
long _DLLFunc db_getresresolist (char *domain,char *family,char *member,long *resource_nb,char ***resource_list,long *error);
long _DLLFunc db_getresresoval (char *domain,char *family,char *member,char *resource,long *resval_nb,char ***resval_list,long *error);
long _DLLFunc db_getdsserverlist (long *server_nb,char ***server_list,long *error);
long _DLLFunc db_getdspersnamelist (char *server,long *persname_nb,char ***persname_list,long *error);
long _DLLFunc db_gethostlist (long *host_nb,char ***host_list,long *error);
long _DLLFunc db_getdsonhost (char *host,long *ds_nb,db_svc **ds_list,long *error);

long _DLLFunc db_deviceinfo (const char *dev_name,db_devinfo_call *devinfo,long *error);
long _DLLFunc db_deviceres (long dev_nb,char **dev_name_list,long *res_nb,char ***res_list,long *error);
long _DLLFunc db_devicedelete (const char *dev_name,long *error);
long _DLLFunc db_devicedeleteres (long dev_nb,char **dev_name_list,db_error *error);
long _DLLFunc db_stat (db_stat_call *info,long *error);
long _DLLFunc db_servunreg (const char *ds_name,const char *pers_name,long *error);
long _DLLFunc db_servinfo (const char *ds_name,const char *pers_name,db_svcinfo_call *s_info,long *error);
long _DLLFunc db_servdelete (const char *ds_name,const char *pers_name,long delres_flag,long *error);
long _DLLFunc db_getpoller (const char *dev_name,db_poller *poll,long *error);
long _DLLFunc db_delreslist (char **res_list,long res_num,long *error);
long _DLLFunc db_initcache (const char *domain,long *error);


long _DLLFunc db_analyze_data (long in_type,const char *buffer,long *nb_devdef,char ***devdef,long *nb_resdef,char ***resdef,long *error_line,long *error);
long _DLLFunc db_upddev (long devdef_nb,char **devdef,long *deferr_nb,long *error);
long _DLLFunc db_updres (long resdef_nb,char **resdef,long *deferr_nb,long *error);
long _DLLFunc db_secpass (char **pass,long *error);
long _DLLFunc db_delete_update(long dev_nb,char **dev_name_list,long list_type,long devdef_nb,char **devdef,long resdef_nb,char **resdef,db_delupd_error *p_error);

}
#endif /* __cplusplus */


#endif /* _db_setup_h */
