static char RcsId[] = "@(#)$Header: dc_sdev.c,v 4.8 99/06/02 12:59:16 taurel Rel $";


/* $Log:	dc_sdev.c,v $
 * Revision 4.8  99/06/02  12:59:16  12:59:16  taurel (E.Taurel)
 * No change, checked-in only for correct verion number
 * 
 * Revision 4.7  99/06/02  12:44:05  12:44:05  taurel (E.Taurel)
 * Fix bug with DC time for dc_devget_history
 * 
 * Revision 4.6  98/11/10  15:09:41  15:09:41  taurel (E.Taurel)
 * No change in lib. Only add func def. in dc.h include file
 * 
 * Revision 4.5  98/10/20  13:58:17  13:58:17  taurel (E.Taurel)
 * Fix a memory laek in the dc_devgetm function
 * 
 * Revision 4.4  98/09/03  10:41:45  10:41:45  taurel (E.Taurel)
 * Change dc_muli_nethost definition in dchist_cli.c file
 * 
 * Revision 4.3  98/09/02  09:24:08  09:24:08  taurel (E.Taurel)
 * Adapted to any number of nethosts
 * 
 * Revision 4.2  98/08/25  10:05:19  10:05:19  klotz (W.D. Klotz)
 * Version_used_for_NT
 * 
 * Revision 4.1  96/12/31  15:21:37  15:21:37  taurel (E.Taurel)
 * Remove .esrf.fr at the end of nethost before any connection to server
 * 
 * Revision 4.0  96/12/06  11:24:07  11:24:07  taurel (E.Taurel)
 * Multi-nethost release of dc library
 * 
 * Revision 3.19  96/11/25  15:22:15  15:22:15  klotz (W.D. Klotz)
 * untested NT compilation
 * 
 * Revision 3.18  96/06/14  10:48:47  10:48:47  taurel (E.Taurel)
 * Change for release 5 of db software (pseudo devices in dc_open and dc_close)
 * Also added the dc_dinfo call.
 * 
 * Revision 3.17  96/01/05  16:03:14  16:03:14  taurel (Emmanuel TAUREL)
 * Ported to Solaris in compatibility mode
 * 
 * Revision 3.16  95/12/21  16:07:02  16:07:02  taurel (Emmanuel TAUREL)
 * Change include files policy for the ULTRA-C compiler.
 * 
 * Revision 3.15  95/12/15  17:24:55  17:24:55  taurel (Emmanuel TAUREL)
 * Check out for debug purpose. No change.
 * 
 * Revision 3.14  95/10/10  13:55:26  13:55:26  taurel (Emmanuel TAUREL)
 * Return date in the dc_devget_history even if the command has failed.
 * 
 * Revision 3.13  94/05/27  17:05:55  17:05:55  taurel (Emmanuel TAUREL)
 * Forgotten to remove added printf for test purpose !
 * 
 * Revision 3.12  94/05/27  17:01:21  17:01:21  taurel (Emmanuel TAUREL)
 * Fix a bug in the dc_check function.
 * Free the memory allocated by XDR !.
 * .
 * 
 * Revision 3.11  94/02/15  14:27:22  14:27:22  taurel (Emmanuel Taurel)
 * Fix a bug in the dc_devget_history
 * function and in the reconnection (use max_call_rd instead of max_call)
 * 
 * Revision 3.10  94/01/25  13:46:49  13:46:49  taurel (Emmanuel TAUREL)
 * New release with these modif :
 * 
 * - Now, use the new XDR type system
 * - Fix a bug in the dc_devgetv and dc_devgetm function when the dc is not
 *   distributed on several hosts and when some devices are not corretly
 *   dc imported.
 * - Fix another bug in the dc_devget_history for the time returned to the
 *   caller.
 * 
 * Revision 3.9  93/12/02  17:27:52  17:27:52  taurel (Emmanuel Taurel)
 * Check in after minor modifications
 * for compilation without complaints from C compiler on different
 * computer system and hardware.
 * .
 * 
 * Revision 3.8  93/12/02  15:07:41  15:07:41  taurel (Emmanuel Taurel)
 * No change since last ci. This
 * co was just for test.
 * 
 * Revision 3.7  93/12/02  15:00:56  15:00:56  taurel (Emmanuel Taurel)
 * Change in the rpc_connect and 
 * rpc_reconnect functions. Now, before we decide to connect the caller 
 * process to a data collector server, the data collector server is
 * testted to verify if it answers correctly.
 * 
 * Revision 3.6  93/10/06  17:29:47  17:29:47  taurel (Emmanuel Taurel)
 * Modified the dc_info call for the
 * beam line. In the beam line control system, you can't predict the
 * device domain name (in utils_cli.c file).
 * .
 * 
 * Revision 3.5  93/10/06  08:54:06  08:54:06  taurel (Emmanuel Taurel)
 * A bug in the dc_devgetm function.
 * PAss the address of error1 to the rpc_reconnect function instead of 
 * error1 itself.
 * 
 * Revision 3.4  93/09/30  08:52:46  08:52:46  taurel (Emmanuel Taurel)
 * Change for the DS_WARNING feature
 * .
 * 
 * Revision 3.3  93/08/13  08:24:41  08:24:41  taurel (Emmanuel TAUREL)
 * Don't use clnt_control to change timeout with TCP
 * connection. This can be the reason of a server exit id the caller dies 
 * before the server sends the answer.
 * .
 * 
 * Revision 3.2  93/07/30  10:30:22  10:30:22  taurel (Emmanuel Taurel)
 * Fix a bug in the rpc_reconnect_rd function of the
 * dcrd_cli.c file
 * 
 * Revision 3.1  93/06/14  17:31:00  17:31:00  taurel (Emmanuel Taurel)
 * Add a new call to dc library : dc_devget_history
 * 
 * Revision 3.0  93/05/18  16:21:25  16:21:25  taurel (Emmanuel TAUREL)
 * Adapted for SUN release of the dc system (without RTDB).
 * 
 * Revision 2.3  93/04/20  08:35:01  08:35:01  taurel (Emmanuel Taurel)
 * Change in dcrd_cli.c file for the sun C compiler.
 * 
 * Revision 2.2  93/03/11  09:10:28  09:10:28  taurel (Emmanuel Taurel)
 * Check in to update release number. The bug was in the dcrd_cli.c file.
 * 
 * Revision 2.1  93/03/05  09:50:00  09:50:00  taurel (Emmanuel Taurel)
 * Added the new dc_dataconvert function
 * for pseudo devices.
 * .
 * .
 *  */


#include <API.h>
#include <dc.h>
#include <dcP.h>

#include <DevErrors.h>
#include <DevCmds.h>


#ifdef OSK
#include <strings.h>
#else
#include <stdlib.h>
#include <string.h>
#endif

/* Some variables defined elsewhere */

extern DevDataListEntry DevData_List[];


/****************************************************************************
*                                                                           *
*		dc_dataconvert function code                                *
*               --------------                                              *
*                                                                           *
*    Function rule : To store data belonging to super device into the data  *
*		     collector. Super devices are non physical devices. The *
*		     device name is used because of the analogy with        *
*		     real devices.					    *
*		     command for one device.				    *
*                                                                           *
*    Argins : - 							    *
*                                                                           *
*    Argout : - 							    *
*                                                                           *
*    In case of trouble, the function returns -1 and set the err variable   *
*    pointed to by "error". Otherwise, the function returns 0               *
*                                                                           *
*****************************************************************************/


#ifdef __STDC__
int dc_dataconvert(dc_datacmd *data_cmd,unsigned int num_cmd,dc_error *error)
#else
int dc_dataconvert(data_cmd,num_cmd,error)
dc_datacmd *data_cmd;
unsigned int num_cmd;
dc_error *error;
#endif /* __STDC__ */
{
	int i;
	XDR xdrs;
	int size;
	int buf_size;
	char *buf,*buf1;
	long err;
	DevDataListEntry type_info;
	DevType type;

/* Try to verify the function parameters (non NULL pointer and two
   \ character in the device name) */

	if (data_cmd == NULL || error == NULL)
	{
		error->error_code = DcErr_BadParameters;
		error->dev_error = 0;
		return(-1);
	}
	for (i = 0;i < (int)num_cmd;i++)
	{
		if (data_cmd[i].argout == NULL)
		{
			error->error_code = DcErr_BadParameters;
			error->dev_error = 0;
			return(-1);
		}
	}
	
/* A loop on every pseudo command */

	for (i = 0;i < (int)num_cmd;i++)
	{

/* Compute argout data size */

		type = data_cmd[i].argout_type;
		if (type < NUMBER_OF_GENERAL_XDR_TYPES)
		{
			if (DevData_List[type].type != type)
			{
				error->error_code = DevErr_XDRLengthCalculationFailed;
				error->dev_error = i + 1;
				return(1);
			}
			size = DevData_List[type].xdr_length(data_cmd[i].argout);
		}
		else
		{
			if (xdr_get_type(type,&type_info,&err) != DS_OK)
			{
				error->error_code = DevErr_XDRLengthCalculationFailed;
				error->dev_error = i + 1;
				return(1);
			}
			size = type_info.xdr_length(data_cmd[i].argout);
		}
		if (size == -1)
		{
			error->error_code = DevErr_XDRLengthCalculationFailed;
			error->dev_error = i + 1;
			return(1);
		}

/* Allocate memory for buffers used for data in XDR format */

		buf_size = size + SEC_MARGIN;
		if ((buf = (char *)malloc(buf_size)) == NULL)
		{
			error->error_code = DcErr_ClientMemoryAllocation;
			error->dev_error = i + 1;
			return(1);
		}
		if ((buf1 = (char *)malloc(buf_size)) == NULL)
		{
			error->error_code = DcErr_ClientMemoryAllocation;
			error->dev_error = i + 1;
			return(1);
		}

/* Create a memory stream to convert argout type to XDR format */

		xdrmem_create(&xdrs,(caddr_t)buf,buf_size,XDR_ENCODE);

/* Convert argout buffer to XDR type 
   If the argout type is one of the general types, directly access the API
   DevData_List array. If not, use the structure sent back by the previous
   call to the xdr_get_type */

		if (type < NUMBER_OF_GENERAL_XDR_TYPES)
		{
			if (!xdr_pointer(&xdrs,(char **)&data_cmd[i].argout,
 			        	 DevData_List[type].size,
		 		 	(xdrproc_t)DevData_List[type].xdr))
			{
		 		free(buf);
				free(buf1);
		 		error->error_code = DcErr_CantConvertDataToXDRFormat;
				error->dev_error = i + 1;
		 		return(1);
			}
		}
		else
		{
			if (!xdr_pointer(&xdrs,(char **)&data_cmd[i].argout,
 			         	 type_info.size,(xdrproc_t)type_info.xdr))
			{
		 		free(buf);
				free(buf1);
		 		error->error_code = DcErr_CantConvertDataToXDRFormat;
				error->dev_error = i + 1;
		 		return(1);
			}
		}

/* Copy XDR data into the buffer returned to caller */

		memcpy(buf1,&(buf[4]),size);
		
/* Returned data to caller */

		data_cmd[i].length = size;
		data_cmd[i].sequence = buf1;
		
/* Free the first buffer which is not used anymore (The freed of the second
   buffer is the caller responsability) */

		free(buf);
	}

/* Leave function */

	error->error_code = 0;
	error->dev_error = 0;
	return(0);
}
