static char RcsId[] = "@(#)$Header: shared.c,v 2.10 98/11/19 10:56:23 goetz Rel $";

/* $Log:	shared.c,v $
 * Revision 2.10  98/11/19  10:56:23  10:56:23  goetz (Andy Goetz)
 * added non-blocking wait call
 * 
 * Revision 2.9  1996/07/17 11:02:10  taurel
 * Remove _ev_wait_t definition for OS-9 release
 *
 * Revision 2.8  96/07/17  10:53:02  10:53:02  taurel (E.Taurel)
 * Check out in order to get correct version number in
 * all files.
 * 
 * Revision 2.7  96/07/17  10:49:59  10:49:59  scaring
 * Remove the _ev_wait_t function in the OS-9 release of the dataport
 * 
 * Revision 2.6  96/01/05  17:30:43  17:30:43  taurel (Emmanuel Taurel)
 * Ported to Solaris
 * 
 * Revision 2.5  95/12/22  10:27:43  10:27:43  taurel (Emmanuel TAUREL)
 * Change in UNIX semaphore management to strictly
 * follow the SUN specification of the semctl function.
 * 
 * Revision 2.4  94/11/22  16:19:12  16:19:12  taurel (Emmanuel TAUREL)
 * Change in the OS-9 release of the Closedataport
 * call the munlink function by a munload function
 * 
 * Revision 2.3  94/11/21  16:47:02  16:47:02  taurel (Emmanuel TAUREL)
 * Also remove the test on process ID
 * when the user try to close a dataport.
 * 
 * Revision 2.2  94/09/28  15:42:05  15:42:05  taurel (Emmanuel TAUREL)
 * Change
 * 
 * Revision 2.0  94/08/12  12:46:07  12:46:07  taurel (Emmanuel Taurel)
 * First check in after ET take over this
 * bloody dataport
 *  */

#include <string.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <errno.h>
#include <shared.h>
#include <boolean.h>
#include <errno.h>

static int shmid = -1;



/****************************************************************************
*                                                                           *
*		Code for get_shared function           				                   *
*              ----------                                          			 *
*                                                                           *
*    Function rule : To get a nes shared memory segment							 *
*									    														    *
*    Argin : - The shared memory size wanted by the caller						 *
*            - The key																		 *
*				 - A flag to inform the function that the shared memory has to  *
*					be created																	 *
*                                                                           *
*    Argout : - The shared memory identifier											 *
*                                                                           *
*    This function returns the shared memory address or -1 if it fails		 *
*                                                                           *
****************************************************************************/

char *get_shared (size,key_num,create,shar)
int size;
int key_num;
int create;
int *shar;
{
   key_t key_value;
   char *ret_value;

   key_value = (key_t) key_num;

   printf("get_shared(): create %d TRUE %d\n",create,TRUE);

   if (create == TRUE) 
   {

/* First, test to see if a shared memory with the same key already exists */

   	shmid = shmget(key_value,size,0600);
    	if (shmid != -1)
    	{
			fprintf(stderr,"Dataport : Shared memory already registered with key %x\n",key_value);
			return((char *)(-1));
    	}

/* Get a shared memory segment */

    	shmid = shmget(key_value,size,IPC_CREAT | 0666);
   }
   else
    	shmid = shmget(key_value,size,0600);

/* Impossible to get the shared memory segment ! */

   if (shmid == -1)
   {
#if defined (EBUG)
    	perror ("get_shared shmget .. ");
#endif
    	return ((char *)(-1));
   }

/* Attach the process to the new shared memory segment */

   ret_value = (char *)shmat(shmid,(char *)0,0);
   if (ret_value == (char *)(-1))
   {
#if defined (EBUG)
    	perror ("get_shared shmat .. ");
#endif
   }
   *shar = shmid;

   return (ret_value);
}



/****************************************************************************
*                                                                           *
*		Code for release_shared function         				                   *
*              --------------                                       			 *
*                                                                           *
*    Function rule : To detach a process from a shared memory segment.		 *
*									    														    *
*    Argin : - A pointer to the shared memory segment							    *
*                                                                           *
*    Argout : No argout																	    *
*                                                                           *
*    This function always return 0														 *
*                                                                           *
****************************************************************************/

int release_shared (address)
char *address;
{
	shmdt (address);
	return(0);
}



/****************************************************************************
*                                                                           *
*		Code for delete_shared function          				                   *
*              -------------                                        			 *
*                                                                           *
*    Function rule : To delete a shared memory segment						    *
*									    														    *
*    Argin : - The shared memory identifier										    *
*                                                                           *
*    Argout : No argout																		 *
*                                                                           *
*    This function returns 0 if successful. Otherwise, it returns -1.		 *
*    be set								    													 *
*                                                                           *
****************************************************************************/

int delete_shared (sid)
int sid;
{
	int ret;

   ret = shmctl (sid,IPC_RMID,NULL);
   if (ret == -1)
   {
#if defined (EBUG)
		perror ("delete_sema semctl .. ");
#endif
   }
   return (ret);
}
