static char RcsId[] = "$Header: db_servinfo.cpp,v 6.2 2002/09/03 13:40:52 taurel Rel $";

/* $Log:	db_servinfo.cpp,v $
Revision 6.2  2002/09/03  13:40:52  13:40:52  taurel (E.Taurel)
db_devinfo now print all available info even for unexported device

 * Revision 6.1  2002/09/03 11:24:20  goetz
 * fixed db_fillup to follow directory links
 *
 * Revision 6.0  1998/08/14 10:58:31  taurel
 * New utilities release which are server oriented
 * */

/* TACO include file */

#include <API.h>

/* Include files */

#include <string.h>

#include <iostream>
#include <string>

using namespace std;


/****************************************************************************
*                                                                           *
*		Code for db_servinfo command                                *
*                        -----------                                        *
*                                                                           *
*    Command rule : To display device server info			    *
*                                                                           *
*    Synopsis : db_servinfo [ full device server name ]                     *
*                                                                           *
****************************************************************************/


int main(int argc,char *argv[])
{
	long i,j;
	long error,res;
	db_svcinfo_call info;

/* Argument test and device name structure*/

	if (argc != 2)
	{
		cerr << "db_servinfo usage : db_servinfo <full device server name>" << endl;
		exit(-1);
	}

	string full_ds_name(argv[1]);

#ifdef DEBUG
	cout  << "Server name : " << full_ds_name << endl;
#endif /* DEBUG */

	i = 0;
	NB_CHAR(i,full_ds_name.c_str(),'/');
	if (i != 1)
	{
		cerr << "db_servinfo : Bad full device server name" << endl;
		exit(-1);
	}

//
// Extract device server and personal name from full device server
// name
//

	string::size_type pos,start;

	if ((pos = full_ds_name.find('/')) == string::npos)
	{
		cout << "db_servinfo : Can't split full device server" << endl;
		exit(-1);
	}
	
	string ds_name(full_ds_name,0,pos);
	
	pos++;
	start = pos;	
	string pers_name(full_ds_name,start,full_ds_name.size() - start);
	
#ifdef DEBUG
	cout << "DS name : " << ds_name << endl;
	cout << "Pers. name : " << pers_name << endl;
#endif /* DEBUG */
		
//
// Connect to database server
//

	if (db_import(&error) == -1)
	{
		cerr << "db_devinfo : Impossible to connect to database server" << endl;
		exit(-1);
	}

//
// Ask database server for server info
//

	res = db_servinfo(ds_name.c_str(),pers_name.c_str(),&info,&error);	

//
// Display error message if the call fails
//

	if (res == -1)
	{
		if (error == DbErr_DeviceServerNotDefined)
		{
			cout << "The device server " << full_ds_name << " is not defined in database" << endl;
		}
		else
		{
			cerr << "The call to database server failed with error " << error << endl;
			cerr << "Error message : " << dev_error_str(error) << endl;
		}
		exit(-1);
	}
	
//
// Display info sent back by server
//

	string pro(info.process_name);
	
	if (info.pid != 0)
	{
		if (pro != "unknown")
			cout << "Device server " << full_ds_name << " is part of the process " << info.process_name << endl;
		cout << "The process is running on host " << info.host_name << " with PID " << info.pid << " (Program number = " << info.program_num << ")" << endl;
	}
	
	for (i = 0;i < info.embedded_server_nb;i++)
	{
		if (info.embedded_server_nb != 1)
		{
			cout << endl;
			cout << "Device server class : " << info.server[i].server_name << endl;
		}
		for (j = 0;j < info.server[i].device_nb;j++)
		{
			if (info.server[i].device[j].exported_flag == True)
				cout << "Device number " << j << " : " << info.server[i].device[j].dev_name << " exported from host " << info.host_name << endl;
			else
				cout << "The device " << info.server[i].device[j].dev_name << " is defined for this server but is not exported" << endl;
		}
	}
	
}


