static char RcsId[] = "$Header: db_initcache.cpp,v 6.2 2002/09/03 13:40:57 taurel Rel $";

/* $Log:	db_initcache.cpp,v $
Revision 6.2  2002/09/03  13:40:57  13:40:57  taurel (E.Taurel)
db_devinfo now print all available info even for unexported device

 * Revision 6.1  2002/09/03 11:24:20  goetz
 * fixed db_fillup to follow directory links
 *
 * Revision 6.0  1998/12/01 15:50:11  taurel
 * First check in.
 * */

/* TACO include file */

#include <API.h>

/* Include files */

#include <string.h>

#include <iostream>
#include <string>

using namespace std;


/****************************************************************************
*                                                                           *
*		Code for db_initcache command                               *
*                        ------------                                       *
*                                                                           *
*    Command rule : To initialize a database server resource cache          *
*		    This command clears the old cache and (re)initialize it *
*		    with the contents of the RES database table for the     *
*		    wanted domain					    *
*                                                                           *
*    Synopsis : db_initcache [ domain name ]               		    *
*                                                                           *
****************************************************************************/


int main(int argc,char *argv[])
{
	long i;
	long error,res;

/* Argument test and device name structure*/

	if (argc != 2)
	{
		cerr << "db_initcache usage : db_initcache <domain name>" << endl;
		exit(-1);
	}

	string dom_name(argv[1]);

#ifdef DEBUG
	cout  << "Domain name : " << dom_name << endl;
#endif /* DEBUG */

//
// Connect to database server
//

	if (db_import(&error) == -1)
	{
		cerr << "db_initcache : Impossible to connect to database server" << endl;
		exit(-1);
	}

//
// Init. cache
//

	res = db_initcache(dom_name.c_str(),&error);	

//
// Display error message if the call fails
//

	if (res == -1)
	{
		cerr << "The call to database server failed with error " << error << endl;
		cerr << "Error message : " << dev_error_str(error) << endl;
		exit(-1);
	}

}


