static char RcsId[] = "$Header: db_fillup.cpp,v 6.8 2002/09/03 13:40:54 taurel Rel $";

/* $Log:	db_fillup.cpp,v $
Revision 6.8  2002/09/03  13:40:54  13:40:54  taurel (E.Taurel)
db_devinfo now print all available info even for unexported device

 * Revision 6.7  2002/09/03 11:24:20  goetz
 * fixed db_fillup to follow directory links
 *
 * Revision 6.6  2002/03/12 11:29:56  goetz
 * added sun to ifdef linux for flags = O_CREAT | O_RDWR; in db_fillup 0 case
 *
Revision 6.5  99/07/06  08:53:04  08:53:04  taurel (E.Taurel)
Remove all access inside the dbm structure (no pagf anymore)

Revision 6.4  99/06/16  13:24:52  13:24:52  taurel (Emmanuel Taurel)
Fix bug in RCS header.

Revision 6.3  99/06/16  13:16:40  13:16:40  taurel (E.Taurel)
Now create xx.pag and xx.dir files if they do not exist.

Revision 6.2  98/08/21  15:24:39  15:24:39  taurel (E.Taurel)
strcmp function returns int and not a pointer !!

Revision 6.1  98/08/21  14:10:45  14:10:45  taurel (E.Taurel)
Change main declaration function in order to have HP compiler quiet.

Revision 6.0  98/08/14  10:58:37  10:58:37  taurel (E.Taurel)
New utilities release which are server oriented
 */


#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <errno.h>
#include <unistd.h>

#include <API.h>

/* For database only */

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ipc.h>
#include <sys/shm.h>

#include <fcntl.h>
#include <ndbm.h>

/* Function definitions */

static void from_file();
static void from_res();
static void read_file();
static void dev_name();
static int read_file(char *);
static int TestLine(char *,char *,int);
static void dev_line(char *,FILE *,char *,int,char *);
static int dev_name(char *,int);
static int res_line(char *,FILE *,char *,int ,char *);
static int rs_val(char *,int);
static int ask_passwd();
static void create_db();
static void leave();

/* Global variables definitions */

DBM *tid[MAXDOMAIN];
int line_ptr;
char sec_first = TRUE;
char TblName[MAXDOMAIN][12];
char tblname[MAXDOMAIN][14];
int TblNum = 0;


/****************************************************************************
*                                                                           *
*		Code for db_fillup command                                  *
*                        ---------                                          *
*                                                                           *
*    Command rule : To fill up the static database with the contents of all *
*                   the resource files founded in the directory (and sub-   *
*                   directories) pointed to by the RES_BASE_DIR environment *
*                   variable. Database will be created in the directory     *
*                   defined by DBM_DIR environment variable.                *
*		    The database name is supposed to be given by DBNAME     *
*		    environment variable and the tables (domains) by        *
*		    DBTABLES environment variable.                          *
*                                                                           *
*    Synopsis : db_fillup <0/1>                             		    *
*                                                                           *
****************************************************************************/

int main(int argc,char *argv[])
{
	int ds;

/* Arguments number test */

	if(argc != 2) {
		fprintf(stderr,"db_fillup usage : db_fillup <data source>\n");
		fprintf(stderr,"\n                     data source parameter values\n");
		fprintf(stderr,"               0: from resource files\n");

		fprintf(stderr,"               1: from previously backuped database \n");
		exit(-1);
		}

/* Test the data source parameters */

	ds = atoi(argv[1]);
	if (ds < 0 || ds > 1) {
		printf("Bad value (%d) for the data source parameter.\n", ds);
		exit(0);
				}

/* Choose the right function according to data source parameter */

	switch (ds) {
		case 0 : from_res();
			 break;

		case 1 : from_file();
			 break;
			}
}


/****************************************************************************
*                                                                           *
*		Code for from_file  function                                *
*                        ---------                                          *
*                                                                           *
*    Function rule : To fill up the database from the contents of the       *
*                    backup files.					    *
*                                                                           *
*    Argin : No argin							    *
*                                                                           *
*    Argout : No argout                                                     *
*                                                                           *
****************************************************************************/

static void from_file()
{
	char cmd[80];

#ifdef DEBUG
	printf("From backup file\n");
#endif /* DEBUG */

/* Build the right command string for the db_build command */

	strcpy(cmd,"cp $DBM_DIR/backup/* $DBM_DIR/.");
	system(cmd);
	
	strcpy(cmd,"chmod 0664 $DBM_DIR/*.dir");
	system(cmd);

	strcpy(cmd,"chmod 0664 $DBM_DIR/*.pag");
	system(cmd);

#ifdef DEBUG
	printf("Command string: %s\n",cmd);
#endif /* DEBUG */


}


/****************************************************************************
*                                                                           *
*		Code for from_res  function                                 *
*                        --------                                           *
*                                                                           *
*    Function rule : To fill up the database from the contents of the       *
*                    resource files					    *
*                                                                           *
*    Argin : No argin							    *
*                                                                           *
*    Argout : No argout                                                     *
*                                                                           *
****************************************************************************/

static void from_res()
{

	char res_dir[80];
	char file_name[80];
	char temp[80];
	char base_dir[80];
	char dbm_dir[80];
	char dbm_file[100];
	char *ptr,*tmp;
	FILE *file;
	char line[80];
	char inter[80];
	char a;
	struct shmid_ds buf;
	int flags;
	FILE *fop;
	int i;

/* Get base directory name */

	if ((ptr = getenv("RES_BASE_DIR")) == NULL)
	{
		fprintf(stderr,"db_fillup : Can't find environment variable RES_BASE_DIR \n");
		exit(-1);
	}
	strcpy(res_dir,ptr);
	strcpy(base_dir,ptr);

/* Change working directory */

	if (chdir(res_dir))
	{
		perror ("db_fillup : Can't cd to resource base directory \n");
		exit(-1);
	}

/* Create the database tables */

	create_db();
	
/* Find the dbm_database files */        

	if ((ptr = (char *)getenv("DBM_DIR")) == NULL)
	{
		fprintf(stderr,"db_fillup: Can't find environment variable DBM_DIR\n");
		exit(-1);
	}
	
	strcpy(dbm_dir, ptr);

	if (strncmp(dbm_dir+strlen(dbm_dir)-1, "/",1) != 0)
		strcat(dbm_dir,"/");

	flags = O_RDWR;

/* Open database tables of the database */

	for (i = 0;i < TblNum;i++)
	{
		strcpy(dbm_file,dbm_dir);
		strcat(dbm_file,tblname[i]);

		tid[i] = dbm_open(dbm_file, flags, 0666);
		if (tid[i] == NULL)
		{
			fprintf(stderr,"db_fillup : Can't open %s table\n",tblname[i]);
			leave();
		}
	} /* end of for */


/* Get the contents of this directory */

	if (system("ls -R1pL >/usr/tmp/l"))
	{
		fprintf(stderr,"db_fillup : Can't get contents of directory \n");
		leave();
	}

/* Open file */

	if ((file = fopen("/usr/tmp/l","r")) == NULL)
	{
		fprintf(stderr,"db_fillup : Can't open file /usr/tmp/l \n");
		leave();
	}

/* File examination */

	while((fgets(line,sizeof(line),file)) != NULL)
	{

/* Change directory name if it's a new one */

		if (strlen(line) == 1)
		{
			fgets(line,sizeof(line),file);
#ifdef __hpux
			strcpy(temp,line+sizeof(a));
#endif /* __hpux */
#ifdef linux
			strcpy(temp,line);
#endif /* linux */
#ifdef sun
			strcpy(temp,line);
#endif /* sun */
			temp[strlen(temp) - 2] = '\0';
			strcpy(res_dir,base_dir);
#ifdef sun
			strcat(res_dir,"/");
#endif /* sun */
#ifdef linux
			strcat(res_dir,"/");
#endif /* linux */
			strcat(res_dir,temp);
		}

/* Is it a file ? If yes, build the right file name */

		else if ((strchr(line,(int)'/') == NULL) && ((tmp = strstr(line,".res")) != NULL))
		{
			strcpy(inter,tmp);
			inter[strlen(inter) - 1] = 0;
			if (strcmp(inter,".res") == 0)
			{
				strcpy(file_name,res_dir);
				strcat(file_name,"/");
				line[strlen(line) - 1] = '\0';
				strcat(file_name,line);

				if (read_file(file_name))
					leave();
				printf("Resources from file %s inserted\n",file_name);
			}
		}

	}

/* Close temporary file */

	fclose(file);

/* Delete temporary file */

	system("rm /usr/tmp/l");

/* Close database */

	for (i=0;i<TblNum;i++)
		dbm_close(tid[i]);

}


/****************************************************************************
*                                                                           *
*		Code for read_file function                                 *
*                        ---------                                          *
*                                                                           *
*    Function rule : To read a resource file                                *
*                                                                           *
*    Argin : - The name of the resource file                                *
*                                                                           *
*    Argout : No argout                                                     *
*                                                                           *
*    This function returns 0 if no errors occurs or the error code when     *
*    there is a problem.                                                    *
*                                                                           *
****************************************************************************/


static int read_file(char *f_name)
{
	FILE *file;
	int i,j,k,i1;
	char line[160];
	char line1[160];

#ifdef DEBUG
	printf("File name : %s \n",f_name);
#endif

/* Open resource file */

	if ((file = fopen(f_name,"r")) == NULL) {
		fprintf(stderr,"db_fillup : Couldn't open resource file %s \n",f_name);
		perror("db_fillup");
		return(-1);
		}
	line_ptr = 0;

/*   If the file line is a name definition, call dev_name function. 
     If the file line is a resource value definition, call rs_val function */

	while((fgets(line,sizeof(line),file)) != NULL) {
		line_ptr++;
		if (line[0] == '#') 
			continue;
		k = strlen(line) - 1;
		if (k == 0)
			continue;
		if (line[k] == 0x0a)
			line[k] = '\0';

		for (i1 = 0;i1 < k;i1++) {
			if (line[i1] != ' ')
				break;
					}
		if (i1 == k)
			continue;

		switch(TestLine(line,line1,k)) {
			case -1 : fprintf(stderr,"db_fillup : Error in resource file %s\n",f_name);
				  fprintf(stderr,"db_fillup : Error at line %d\n",line_ptr);
				  leave();
				  break;

			case 0 : dev_line(line1,file,f_name,sizeof(line),line);
				 break;

			case 1 : if (rs_val(line1,1)) {
					fprintf(stderr,"db_fillup : Error in resource file %s\n",f_name);
				  	fprintf(stderr,"db_fillup : Error at line %d\n",line_ptr);
					leave();
							}
				 break;

			case 2 : if (res_line(line1,file,f_name,sizeof(line),line)) {
					fprintf(stderr,"db_fillup : Error in resource file %s\n",f_name);
				  	fprintf(stderr,"db_fillup : Error at line %d\n",line_ptr);
					leave();
							}
				 break;
						}
	}

	fclose(file);

	return(0);

}


/****************************************************************************
*                                                                           *
*		Code for TestLine  function                                 *
*                        --------                                           *
*                                                                           *
*    Function rule : To change the line to lower case letters if it is      *
*                    necessary and to return a value which indicate which   *
*                    type of line it is (device definition, simple resource *
*                    definition or resources array definition)              *
*                                                                           *
*    Argin : - A pointer to a buffer where is stored a line of the resource *
*              file 						            *
*	     - A pointer to a buffer where the modified line will be store  *
*            - The length of the original line                              *
*                                                                           *
*    Argout : No argout                                                     *
*                                                                           *
*    Return value : -1 : Error  					    *
*                    0 : It is a device definition line                     *
*                    1 : It is a simple resource definition line            *
*                    2 : It is definition for an array of resources         *
*                                                                           *
****************************************************************************/

static int TestLine(char *line,char *line1,int k)
{
	char *tmp;
	u_int diff;
	int string = 0;
	int iret = 1;
	int i,j;
	int l1 = 0;

/* Return error in this line is not a definition line */

	if ((tmp = strchr(line,(int)':')) == NULL) 
		return(-1);

/* Change all the letters before the : to lower case */

	diff = (u_int)(tmp - line) + 1;
	i = 0;
	for (j=0;j<diff;j++)
	{
		if (line[j] != ' ' && line[j] != 0x09)
			line1[i++] = tolower(line[j]);
	}
	line1[i] = 0;

/* Is is a device defintion line ? In this case, all the line must be 
   translated to lower case letter */

	if (strstr(line1,"device:") != NULL)
	{
		for (j=diff;j<k;j++)
		{
			if (line[j] != ' ' && line[j] != 0x09)
				line1[i++] = tolower(line[j]);
		}
		iret = 0;
	}

/* Now it is a resource definition line */

	else
	{

/* If the last character is \ , this is a resource array definition */

		if (line[k - 1] == '\\')
			iret = 2;

		for (j=diff;j<k;j++)
		{

/* If the " character is detected, set a flag. If the flag is already set,
   reset it */

			if (line[j] == '"')
			{
				if (string)
					string = 0;
				else
					string = 1;
				continue;
			}

/* When the string flag is set, copy character from the original line to the
   new one without any modifications */

			if (string)
			{
				line1[i++] = line[j];
				l1 = 1;
				continue;
			}

/* If the , character is detected not in a string definition, this is a
   resource array definition */

			if (line[j] == ',')
			{
				line1[i++] = SEP_ELT;
				iret = 2;
				continue;
			}

/* Remove space and tab */

			if (line[j] != ' ' && line[j] != 0x09)
			{
				line1[i++] = line[j];
				l1 = 1;
			}
		}
	}

/* If an odd number of " character has been detected, it is an error */

	if (string)
		iret = -1;

/* Leave function */

	line1[i] = 0;
	if (strlen(line1) == diff && l1 == 0)
		iret = -1;
	return(iret);

}


/****************************************************************************
*                                                                           *
*		Code for dev_line function                                  *
*                        --------                                           *
*                                                                           *
*    Function rule : To extract from a resource file all the informations   *
*                    concerning the device name.                            *
*                                                                           *
*    Argin : - A pointer to a buffer where is stored a line of the resource *
*              file (The first line with the "device" word in it )          *
*            - The pointer to the FILE structure of the resource file       *
*            - Name of the resource file                                    *
*            - The size of the buffer where to stored the next line in the  *
*              resource file which defined device name                      *
*            - A pointer to a buffer where to store the next line in the    *
*              resource file which defined device name                      *
*                                                                           *
*    Argout : No argout                                                     *
*                                                                           *
****************************************************************************/


static void dev_line(char *line1,FILE *file,char *f_name,int siz_line,char *line)
{
	char temp[80];
	char base[80];
	unsigned int diff;
	char *tmp;
	int i,k,j;
	register char *ptr,*ptr1;
	int ind;

/* Make a copy of the device server network name */

	tmp = strchr(line1,(int)':');
	diff = (u_int)(tmp - line1) + 1;
	strncpy(base,line1,diff);
	base[diff] = '\0';

/* Copy the first line in the result buffer */

	k = strlen(line1);
	ptr = (char *)malloc(k + 1);
	strcpy(ptr,line1);
	if (line1[k - 1] == '\\')
		ptr[k - 1] = ',';

/* Following lines examination (discard space or tab at beginning of line) */

	while(line1[k - 1] == '\\')
	{
		fgets(line,siz_line,file);
		line_ptr++;
		line[strlen(line) - 1] = '\0';
		k = strlen(line);
		j = 0;
		for (i = 0;i < k;i++)
		{
			if (line[i] != ' ' && line[i] != 0x09)
				line1[j++] = tolower(line[i]);
		}
		line1[j] = '\0';
		k = strlen(line1);
		ptr = (char *)realloc(ptr,strlen(ptr) + k + 1);
		strcat(ptr,line1);
		if (line1[k - 1] == '\\')
			ptr[strlen(ptr) - 1] = ',';
	}

/* Fill up db with first device name */

	ind = 1;
	ptr1 = strtok(ptr,",");
	if (dev_name(ptr1,ind))
	{	
		fprintf(stderr,"db_fillup : Error in device definition in file %s\n",f_name);
		leave();
	} 

/* Fill up db with the other device names */

	while((ptr1 = strtok(NULL,",")) != NULL)
	{
		ind++;
		strcpy(temp,base);
		strcat(temp,ptr1);
		if (dev_name(temp,ind))
		{
			fprintf(stderr,"db_fillup : Error in device definition in file %s\n",f_name);
			leave();
		} 
	}

/* Free memory */

	free(ptr);
}


/****************************************************************************
*                                                                           *
*		Code for dev_name function                                  *
*                        --------                                           *
*                                                                           *
*    Function rule : To store all the devices names in the NAMES table      *
*                                                                           *
*    Argin : - The address of a buffer where is saved a device name         *
*              definition                                                   *
*              The buffer contains a string which follows this format :     * 
*              Device server network name/device:     device name           *
*	     - The number of the device in the device list		    *
*                                                                           *
*    Argout : No argout                                                     *
*                                                                           *
*    This function returns 0 if no errors occurs or the error code when     *
*    there is a problem.                                                    *
*                                                                           *
****************************************************************************/


static int dev_name(char *lin,int numb)
{
	device dev;
	datum ret, key, keyn, key_sto, content;
	unsigned int diff;
	register char *temp, *tmp;
	int i,l,flags;
	char seqnr[4];
	char prgnr[20];
	char keyr[MAX_KEY];


/* Verify device name syntax */

	l = 0;
	NB_CHAR(l,lin,'/')
	if (l != 4)
		return(ERR_DEVNAME);

/* Initialize host name, device type and device class */

	strcpy(dev.h_name,"not_exp");
	strcpy(dev.d_type,"unknown");
	strcpy(dev.d_class,"unknown");
	strcpy(dev.proc_name,"unknown");

/* Get device server class */

	tmp = strchr(lin,(int)'/');
	diff = (u_int)(tmp++ - lin);
	strncpy(dev.ds_class,lin,diff);
	dev.ds_class[diff] = '\0';

/* Get device server name */

	temp = strchr(tmp,(int)'/');
	diff = (u_int)(temp++ - tmp);
	strncpy(dev.ds_name,tmp,diff);
	dev.ds_name[diff] = '\0';

/* Get device name */

	temp = strchr(lin,(int)':');
	diff = (u_int)(temp - lin);
	l = strlen(lin);
	if ((diff + 1) == l)
		return(ERR_DEVNAME);
	strcpy(dev.d_name,temp + 1);

/* Initialize the other columns */

	dev.pn = 0;
	dev.vn = 0;
	dev.indi = numb;
	dev.pid = 0;

#ifdef DEBUG
	printf("Host name : %s \n",dev.h_name);
	printf("Device server class : %s \n",dev.ds_class);
	printf("Device server name : %s \n",dev.ds_name);
	printf("Device name : %s \n",dev.d_name);
	printf("Program number : %x \n",dev.pn);
	printf("Version number : %d \n",dev.vn);
	printf("Device type : %s \n",dev.d_type);
	printf("Device class : %s\n",dev.d_class);
	printf("Device number (in this device list) : %d\n",dev.indi);
	printf("Device server PID : %d\n",dev.pid);
	printf("Device server process name : %s\n",dev.proc_name);
#endif

/* Verify that no device with the same name is already registered in the
   database */

	key_sto.dptr = (char *)malloc(MAX_KEY); 

/* Go through the table to detect any double instance */

	for (key = dbm_firstkey(tid[0]); key.dptr != NULL;key = dbm_nextkey(tid[0]))
	{
		strncpy(keyr,key.dptr,key.dsize);
		keyr[key.dsize] = '\0';
		strncpy(key_sto.dptr, key.dptr, key.dsize);
		key_sto.dsize = key.dsize;
	
		ret = dbm_fetch(tid[0], key_sto);

		if (ret.dptr == NULL)
		{
			fprintf(stderr,"db_fillup: Error in dbm_fetch for %s\n", key.dptr);
			return(ERR_DEVNAME);
		}
		
		tmp = ret.dptr;
		temp = strchr(tmp,(int)'|');
		if (temp == NULL)
		{
			fprintf(stderr,"db_fillup: No separator in db tuple\n");
			return(ERR_DEVNAME);
		}
		diff = (u_int)(temp++ - tmp);
		strncpy(keyr, tmp, diff);
		keyr[diff] = '\0';
		if (strcmp(keyr, dev.d_name) == 0 )
		{
			fprintf(stderr,"db_fillup : Can't insert a tuple in NAMES table\n");
			fprintf(stderr,"Device %s already defined in the database\n",dev.d_name);
			return(ERR_DEVNAME);
		}		
	}


/* Insert tuple in NAMES table */

	if ((keyn.dptr = (char *)malloc(strlen(lin))) == NULL)
	{
		fprintf(stderr,"Error in memory allocation for the key.\n");
		leave();
	}

	strcpy(keyn.dptr, dev.ds_class);
	strcat(keyn.dptr,"|");
	strcat(keyn.dptr, dev.ds_name);
	strcat(keyn.dptr,"|");
	sprintf(seqnr,"%d",dev.indi);
	strcat(keyn.dptr, seqnr);
	strcat(keyn.dptr, "|");
	keyn.dsize = strlen(keyn.dptr);

	if ((content.dptr = (char *)malloc(MAX_CONT)) == NULL)
	{
		fprintf(stderr,"Error in memory allocation for the content.\n");
		leave();
	}
	
	strcpy(content.dptr, dev.d_name);
	strcat(content.dptr,"|");
	strcat(content.dptr, dev.h_name);
	strcat(content.dptr,"|");
	sprintf(prgnr,"%d",dev.pn);
	strcat(content.dptr, prgnr);
	strcat(content.dptr,"|");
	sprintf(prgnr,"%d",dev.vn);
	strcat(content.dptr, prgnr);
	strcat(content.dptr,"|");
	strcat(content.dptr, dev.d_type);
	strcat(content.dptr,"|");
	strcat(content.dptr, dev.d_class);
	strcat(content.dptr,"|");
	sprintf(prgnr,"%d",dev.pid);
	strcat(content.dptr,prgnr);
	strcat(content.dptr,"|");
	strcat(content.dptr,dev.proc_name);
	strcat(content.dptr,"|");

	content.dsize = strlen(content.dptr);	

	flags = DBM_INSERT;
	if ((i = dbm_store(tid[0], keyn, content, flags)) != 0)
	{
		if (i == 1) 
		fprintf(stderr,
		"db_fillup : Can't insert a double instance in NAMES table: %s \n", keyn.dptr);
		else          
		fprintf(stderr,
		"db_fillup : Can't insert an erroneous instance in NAMES table: %s\n", keyn.dptr);
		free(keyn.dptr);
		free(content.dptr);
		return(ERR_DEVNAME);
	}
	
	free(keyn.dptr);
	free(content.dptr);
	return(0);
	
}


/****************************************************************************
*                                                                           *
*		Code for res_line function                                  *
*                        --------                                           *
*                                                                           *
*    Function rule : To extract from a resource file all the informations   *
*                    concerning a resource array			    *
*                                                                           *
*    Argin : - A pointer to a buffer where is stored a line of the resource *
*              file (The first line of the resource array definition)       *
*	     - The pointer to the FILE structure of the resource file       *
*            - Name of the resource file                                    *
*            - The size of the buffer where to stored the next line in the  *
*              resource file which defined the resource array               *
*            - A pointer to a buffer where to store the next line in the    *
*              resource file which defined the resource array               *
*                                                                           *
*    Argout : No argout                                                     *
*                                                                           *
****************************************************************************/


static int res_line(char *line1,FILE *file,char *f_name,int siz_line,char *line)
{
	unsigned int diff;
	char *tmp;
	int l_base,i,j,k,l,ind;
	int string = 0;
	int k1 = 1;
	register char *ptr,*ptr1,*ptr2,*ptr3;
	char t_name[80];
	char base[80];
	char temp[80];
	char pat[2];

/* Make a copy of the resource array name */

	tmp = strchr(line1,(int)':');
	diff = (u_int)(tmp - line1) + 1;
	strncpy(base,line1,diff);
	base[diff] = 0;
	l_base = diff;

/* Copy the first line in the resulting buffer */

	k = strlen(line1);
	if ((ptr = (char *)malloc(SIZE)) == NULL) {
		fprintf(stderr,"Not enought memory, exiting...\n");
		leave();
		}
	strcpy(ptr,line1);
	if (line1[k - 1] == '\\') {
		ptr[k - 1] = SEP_ELT;
				}

/* Following line examination */

	while (line1[k - 1] == '\\') {
		fgets(line,siz_line,file);
		line_ptr++;
		line[strlen(line) - 1] = 0;

/* Verify the new line is not a simple resource definition */

		if ((ptr2 = strchr(line,(int)':')) != NULL) {
			diff = (u_int)(ptr2 - line);
			strncpy(t_name,line,diff);
			t_name[diff] = 0;
			k = 0;
			NB_CHAR(k,t_name,'/');
			if (k == 3) {
				line_ptr--;
				return(ERR_RESVAL);
				    }
						}

		k = strlen(line);
		j = 0;

/* Remove space and tab characters except if they are between two ".
   Replace the , character by 0x02 except if they are between two ". */

		for (i=0;i<k;i++) {
			if (line[i] == '"') {
				if (string)
					string = 0;
				else
					string = 1;
				continue;
					}

			if (string) {
				line1[j++] = line[i];
				continue;
				}

			if (line[i] == ',') {
				line1[j++] = SEP_ELT;
				continue;
					}

			if (line[i] != ' ' && line[i] != 0x09)
				line1[j++] = line[i];
				}

/* Error if odd number of " characters */

		if (string)
			return(ERR_RESVAL);
		line1[j] = 0;
		k = strlen(line1);

/* Add this new line to the result buffer */

		strcat(ptr,line1);
		l = strlen(ptr);
		if (line1[k - 1] == '\\') {
			if (ptr[l - 2] == SEP_ELT)
				ptr[l - 1] = 0;
			else
				ptr[l - 1] = SEP_ELT;
					}

/* Test to verify that the array (in ascii characters) is not bigger than
   the allocated memory and realloc memory if needed. */

		if (l > ((k1 * SIZE) - LIM)) {
			if ((ptr = (char *)realloc((void *)ptr,(size_t)
(l + SIZE))) == 0) {
				fprintf(stderr,"Not enought memory, exiting...\n");
				leave();
				}
			k1++;
			}
		}

/* Make two copies of the "ptr" string */

	ptr2 = (char*)malloc(strlen(ptr) + 1);
	strcpy(ptr2,ptr);
	ptr3 = (char*)malloc(strlen(ptr) + 1);
	strcpy(ptr3,ptr);

/* Fill up db with the first array element */

	ind = 1;
	pat[0] = SEP_ELT;
	pat[1] = 0;
	ptr1 = strtok(ptr3,pat);
	if (rs_val(ptr1,ind)) {
		base[l_base - 1] = 0;
		fprintf(stderr,"db_fillup : Error in storing");
		fprintf(stderr," %s array\n",base);
		leave();
			}

/* Fill up the db with the other elements of the resource array */

/* Reinitialize strtok internal pointer */

	ptr1 = strtok(ptr,pat);
	while ((ptr1 = strtok(NULL,pat)) != NULL) {
		ind++;
		strcpy(temp,base);
		strcat(temp,ptr1);
		if (rs_val(temp,ind)) {
			base[l_base - 1] = 0;
			fprintf(stderr,"db_fillup : Error in storing");
			fprintf(stderr," %s array\n",base);
			leave();
				}
						}

/* Free memory */

	free(ptr);
	free(ptr2);
	free(ptr3);

/* Leave function */

	return(0);

}


/****************************************************************************
*                                                                           *
*		Code for rs_val function                                    *
*                        ------                                             *
*                                                                           *
*    Function rule : To store resource definition in the static database    *
*                                                                           *
*    Argin : - The address of a buffer where is saved a resource definition *
*              The buffer contains a string which follows this format :     *
*              Resource name (DOMAIN/FAMILY/MEMBER):   resource value       *
*	     - The number of the resource if the resource type is array     *
*	       (must be one if the resource type is not an array)           *
*                                                                           *
*    Argout : No argout                                                     *
*                                                                           *
****************************************************************************/


static int rs_val(char *lin,int ind)
{
	char t_name[80];
	reso res;
	unsigned int diff;
	register char *temp,*tmp;
	char indnr[12];
	int i,l,flags;
	DBM *tab;
	datum key, content;
	static int res_pas;


/* Verify that the resource syntax is correct */

	if ((temp = strchr(lin,(int)':')) == NULL)
		return(ERR_RESVAL);
	diff = (u_int)(temp - lin);
	strncpy(t_name,lin,diff);
	t_name[diff] = 0;
	l = 0;
	NB_CHAR(l,t_name,'/')
	if (l != 3)
		return(ERR_RESVAL);

/* Get table name */

	temp = strchr(lin,(int)'/');
	diff = (u_int)(temp++ - lin);
	strncpy(t_name,lin,diff);
	t_name[diff] = '\0';

/* Get family name */

	tmp = strchr(temp,(int)'/');
	diff = (u_int)(tmp++ - temp);
	strncpy(res.fam,temp,diff);
	res.fam[diff] = '\0';

/* Get member name */

	temp = strchr(tmp,(int)'/');
	diff = (u_int)(temp++ - tmp);
	strncpy(res.member,tmp,diff);
	res.member[diff] = '\0';

/* Get resource name */

	if((tmp = strchr(temp,(int)':')) == NULL)
		return(ERR_RESVAL);
	diff = (u_int)(tmp - temp);
	strncpy(res.r_name,temp,diff);
	res.r_name[diff] = '\0';

/* Initialise resource number */

	res.indi = ind;

/* Get resource value and leave function if it is initilised to %  */

	strcpy(res.r_val,tmp + 1);
	if (res.r_val[0] == '%')
		return(0);

/* If the resource belongs to the security domain, change the | character
   to the classical / character */

	if (strcmp(t_name,"sec") == 0)
	{
		l = strlen(res.r_name);
		for (i = 0;i < l;i++)
		{
			if (res.r_name[i] == '|')
				res.r_name[i] = '/';
		}
	}

#ifdef DEBUG
	printf("Table name : %s \n",t_name);
	printf("Family name : %s \n",res.fam);
	printf("Member name : %s \n",res.member);
	printf("Resource name : %s \n",res.r_name);
	printf("Resource value : %s \n",res.r_val);
	printf("Number of the resource : %d\n\n",res.indi);
#endif

/* Select the right resource table in database */

	for (i=0;i<TblNum;i++)
	{	
		if (strcmp(t_name,tblname[i]) == 0)
		{
			tab = tid[i];
			break;
		}
	}

	if (i == TblNum) 
		return(ERR_RESVAL);

/* If it is a security resource (belonging to SEC domain) and it is the
   first time that a security resource is processed, ask for security
   password */

        if (strcmp(t_name,"sec") == 0)
	{
		if (sec_first == TRUE)
		{
			res_pas = ask_passwd();
                        sec_first = FALSE;
		}

/* Forget Security data if the supplied password was wrong */

                 if (res_pas == -1)
                        return(0);
                                                    }
	
	if ((key.dptr = (char *)malloc(sizeof(res))) == NULL) {
		fprintf(stderr,"Error in memory allocation for the key.\n");
		leave();
		}

	strcpy(key.dptr, res.fam);
	strcat(key.dptr, "|");
	strcat(key.dptr, res.member);
	strcat(key.dptr, "|");
	strcat(key.dptr, res.r_name);
	strcat(key.dptr, "|");
	sprintf(indnr,"%d",res.indi);
	strcat(key.dptr, indnr);
	strcat(key.dptr, "|");
	key.dsize = strlen(key.dptr);
	

	content.dptr = res.r_val;
	content.dsize = strlen(res.r_val);


/* Insert tuple in tables */
	
	flags = DBM_INSERT;

	if ((i = dbm_store(tab, key, content, flags)) != 0) {
		if (i == 1)
		fprintf(stderr,"db_fillup : Can't insert a double resource: %s\n", key.dptr);
		else
		fprintf(stderr,"db_fillup : Can't insert an erroneous resource: %s \n", key.dptr);
		free(key.dptr);
		return(ERR_RESVAL);
					}
	free(key.dptr);	
	return(0);
	
}



/****************************************************************************
*                                                                           *
*		Code for ask_passwd function                                *
*                        ----------                                         *
*                                                                           *
*    Function rule : To ask for the security passwd if one is defined. This *
*		     function also checks if the passwd typed by the user   *
*		     is the right one					    *
*                                                                           *
*    Argin : No argin							    *
*                                                                           *
*    Argout : No argout							    *
*                                                                           *
*    This function returns 0 if there is no passwd defined or if the passwd *
*    supplied by the user is the right one. The function returns -1 if the  *
*    passwd typed by the user is not correct				    *
*                                                                           *
****************************************************************************/

static int ask_passwd()
{
	char *user_pas;
	FILE *file_sec;
	char file_pas[40];
	char *db_env;
	char f_name[80];
	struct stat stat_info;

/* Get the database environment variable */

	db_env = getenv("DBM_DIR");

/* Build the security file name */

	strcpy(f_name,db_env);
	strcat(f_name,"/.sec_pass");

/* Is there any password defined for the security table ? */

	if (stat(f_name,&stat_info) == -1)
	{
       		if (errno == ENOENT)
                        return(0);
                else
		{
                        fprintf(stderr,"dbm_update : Can't get passwd information\n");
                        return(-1);
		}
	}

/* There is one password, so ask it to the user */

	user_pas = (char *)getpass("Security passwd : ");
	if (user_pas == NULL)
	{
		fprintf(stderr,"dbm_update : Can't get user passwd\n");
		return(-1);
	}

/* Get the passwd stored in the file */

        if ((file_sec = fopen(f_name,"r")) == 0)
	{
                fprintf(stderr,"dbm_update : Can't get passwd information\n");
                return(-1);
	}
        fgets(file_pas,sizeof(file_pas),file_sec);
        file_pas[strlen(file_pas) - 1] = 0;

/* Compare the two passwd */

	if (strcmp(user_pas,file_pas) != 0)
	{
		fprintf(stderr,"dbm_update : Sorry, bad passwd. The security resources will not be updated\n");
		fclose(file_sec);
		return(-1);
	}

/* Close passwd file */

	fclose(file_sec);
	return(0);

}




/****************************************************************************
*                                                                           *
*		Code for create_db function                                 *
*                        ---------                                          *
*                                                                           *
*    Function rule : To create database tables in CREATE mode and then      *
*    		     close them to be able to open them in RDWR mode.       *
*                                                                           *
*    Argin : No argin							    *
*                                                                           *
*    Argout : No argout                                                     *
*                                                                           *
****************************************************************************/

static void create_db()
{
	int flags;
	char *ptr;
	char *tbeg, *tend;
	char res_dir[80];
	char dbm_file[100];
	char dbm_dir[100];
	char dbm_pag[100];
	mode_t mode = S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP | S_IROTH | S_IWOTH;
	int i,j;
	int diff,ind;
	int names = False;
	int ps_names = False;

/* Find the dbm_database table names */        

	if ((ptr = (char *)getenv("DBTABLES")) == NULL)
	{
		fprintf(stderr,"db_fillup: Can't find environment variable DBTABLES\n");
		exit(-1);
	}

	TblNum = 0;
	tbeg = ptr;
	while ((tend = (char *)strchr(tbeg,(int)',')) != NULL)
	{
		diff = (unsigned int)(tend++ - tbeg);
		strncpy(TblName[TblNum], tbeg, diff);
		TblName[TblNum][diff] = '\0';
		TblNum++;
		tbeg = tend;
	}
	strcpy (TblName[TblNum++], tbeg);

	if (TblNum > MAXDOMAIN)
	{
		fprintf(stderr,"Too many domains (%d) were given in the environment variable list, max (%d)\n", TblNum, MAXDOMAIN);
		exit(-1);
	}
		
/* Change the database table names to lowercase letter names and check if there 
   is a names and ps_names tables defined */

	strcpy(tblname[0],"names");
	strcpy(tblname[1],"ps_names");
	ind = 2;
	for (i = 0;i < TblNum;i++)
	{
		if (strcasecmp(TblName[i],"names") == 0)
		{
			names = True;
			continue;
		}
		if (strcasecmp(TblName[i],"ps_names") == 0)
		{
			ps_names = True;
			continue;
		}		
		for (j = 0;j < (int)strlen(TblName[i]);j++)
			tblname[ind][j] = tolower(TblName[i][j]);
		tblname[ind][j] = '\0';
		ind++;
	}
	
/* Adjust the TblNum variable */

	if (names == False)
		TblNum++;
	if (ps_names == False)
		TblNum++;

#ifdef DEBUG
	for (i = 0;i < TblNum;i++)
		printf("Name = %s\n",tblname[i]);
#endif
			
/* Create the dbm_database files */        

	if ((ptr = (char *)getenv("DBM_DIR")) == NULL)
	{
		fprintf(stderr,"db_fillup: Can't find environment variable DBM_DIR\n");
		exit(-1);
	}
	
	strcpy(res_dir, ptr);

	if (strncmp(res_dir+strlen(res_dir)-1, "/",1) != 0)
		strcat(res_dir,"/");

/* Create database tables of the database definition */

#if defined linux || sun
	flags = O_CREAT | O_RDWR;
#else
	flags = O_CREAT;
#endif

/* Set the file permission mask in order to create db files with access for
   the rest of the world. The dbm_open */

	umask(0);
		
	for (i = 0;i < TblNum;i++)
	{
		strcpy(dbm_file,res_dir);
		strcat(dbm_file,tblname[i]);
		
		tid[i] = dbm_open(dbm_file, flags, mode);
		if (tid[i] == NULL)
		{
			fprintf(stderr,"db_fillup : Can't create %s table\n",tblname[i]);
			leave();	
		}
	} 
	

/* And now close the db_files */

	for (i = 0;i < TblNum;i++)
		dbm_close(tid[i]);

	return;
}



/****************************************************************************
*                                                                           *
*		Code for leave function                                     *
*                        -----                                              *
*                                                                           *
*    Function rule : To close everything before to exit the process         *
*                                                                           *
*    Argin : No argin							    *
*                                                                           *
*    Argout : No argout                                                     *
*                                                                           *
****************************************************************************/

static void leave()
{
	int i;

/* Close the database  */

	for (i = 0;i < TblNum;i++)
	{
		if (tid[i] != NULL)
			dbm_close(tid[i]);
	}

/* Exit now */

	exit(-1);
}
