static char RcsId[] = "$Header: db_devres.cpp,v 6.2 2002/09/03 13:40:47 taurel Rel $";

/* $Log:	db_devres.cpp,v $
Revision 6.2  2002/09/03  13:40:47  13:40:47  taurel (E.Taurel)
db_devinfo now print all available info even for unexported device

 * Revision 6.1  2002/09/03 11:24:20  goetz
 * fixed db_fillup to follow directory links
 *
 * Revision 6.0  1998/08/14 10:57:05  taurel
 * New utilities release which are server oriented
 * */

/* TACO include file */

#include <API.h>

/* Include files */

#include <string.h>

#include <iostream>
#include <string>

using namespace std;


/****************************************************************************
*                                                                           *
*		Code for db_devres command                                  *
*                        ---------                                          *
*                                                                           *
*    Command rule : To get device resources from the static database.       *
*                                                                           *
*    Synopsis : db_devres [ device name ]               		    *
*                                                                           *
****************************************************************************/


int main(int argc,char *argv[])
{
	long i;
	long error,res;
	long res_nb;
	char **res_list;
	char *tmp;

/* Argument test and device name structure*/

	if (argc != 2)
	{
		cerr << "db_devres usage : db_devres <device name>" << endl;
		exit(-1);
	}

	string dev_name(argv[1]);

#ifdef DEBUG
	cout  << "Device name : " << dev_name << endl;
#endif /* DEBUG */

	i = 0;
	NB_CHAR(i,dev_name.c_str(),'/');
	if (i != 2)
	{
		cerr << "db_devres : Bad device name" << endl;
		exit(-1);
	}

//
// Connect to database server
//

	if (db_import(&error) == -1)
	{
		cerr << "db_devinfo : Impossible to connect to database server" << endl;
		exit(-1);
	}

//
// Ask device resources to database server
//

	tmp = (char *)dev_name.c_str();
	res = db_deviceres(1,&tmp,&res_nb,&res_list,&error);	

//
// Display error message if the call fails
//

	if (res == -1)
	{
		cerr << "The call to database server failed with error " << error << endl;
		cerr << "Error message : " << dev_error_str(error) << endl;
		exit(-1);
	}

//
// Print device resources
//

	if (res_nb == 0)
	{
		cout << "The device " << dev_name << " does not have any resource defined in the database"<< endl;
	}
	else
	{
		for (i = 0;i < res_nb;i++)
			cout << res_list[i] << endl;
	}

}


