static char RcsId[] = "$Header: greta_misc.c,v 3.14 2002/09/05 09:34:02 taurel Rel $";

/* $Log:	greta_misc.c,v $
 * Revision 3.14  2002/09/05  09:34:02  09:34:02  taurel (E.Taurel)
 * Print device info even for non-exported device
 * 
 * Revision 3.13  00/04/03  13:03:16  13:03:16  taurel (E.Taurel)
 * change buffer size when the hdbget_info function is called (4000 instead of 2000)
 * 
 * Revision 3.12  99/02/23  15:19:10  15:19:10  taurel (Emmanuel Taurel)
 * Fix bug in xsCreateStringForTextServ function. Same bug than in release 3.5 !
 * 
 * Revision 3.11  99/02/10  09:58:01  09:58:01  taurel (Emmanuel Taurel)
 * fix a bug with the pass flag used when updated a SEC domain resource
 * 
 * Revision 3.10  99/01/27  13:27:09  13:27:09  taurel (Emmanuel Taurel)
 * Remove a check before call to getdevmemberlist if domain name=family name
 * 
 * Revision 3.9  99/01/14  17:26:23  17:26:23  taurel (Emmanuel Taurel)
 * Fix bug when two servers window are open and you try to update the second one
 * 
 * Revision 3.8  99/01/07  11:04:13  11:04:13  taurel (Emmanuel Taurel)
 * Replace system call in chaining function by a function call to file_concat
 * 
 * Revision 3.7  99/01/05  15:21:58  15:21:58  taurel (E.Taurel)
 * Add a test after file creation
 * 
 * Revision 3.6  99/01/05  14:16:16  14:16:16  taurel (E.Taurel)
 * Change chained device to lowercase letters
 * 
 * Revision 3.5  99/01/04  16:39:13  16:39:13  taurel (E.Taurel)
 * Fix bug in xsCreateStringForText function (greta.xs). Replace % by /
 * 
 * Revision 3.4  98/12/21  14:52:21  14:52:21  taurel (Emmanuel Taurel)
 * Fix miscellaneous bug when HDB info is required and when DC info is required
 * 
 * Revision 3.3  98/10/27  09:46:36  09:46:36  taurel (Emmanuel Taurel)
 * Fix bug in the ResUpdateCb function
 * 
 * Revision 3.2  98/10/14  09:31:34  09:31:34  taurel (E.Taurel)
 * Fix bg in update resource window. Change the call used to delete resource
 * 
 * Revision 3.1  98/09/03  16:31:34  16:31:34  taurel (E.Taurel)
 * Some change due to lesstif for Linux but it is still not perfect under Linux
 * 
 * Revision 3.0  98/08/20  17:30:34  17:30:34  taurel (E.Taurel)
 * Adapted to db software release 6.x
 * 
 * Revision 2.7  98/01/27  13:49:27  13:49:27  taurel (E.Taurel)
 * No change. CO only for test
 * 
 * Revision 2.6  98/01/27  13:14:31  13:14:31  taurel (E.Taurel)
 * Fix a bug in the pdbset_allresdel function (greta_db.c file) when the device list is plitted into several lines
 * 
 * Revision 2.5  97/07/15  14:01:33  14:01:33  taurel (E.Taurel)
 * Fixed a bug in the membres_lgcmp function when the resource was an array
 * with more than 10 characters.
 * 
 * Revision 2.4  97/06/09  16:37:18  16:37:18  taurel (E.Taurel)
 * Remove passwd window from help menu.
 * 
 * Revision 2.3  97/05/16  18:32:02  18:32:02  poncet (F.Poncet)
 * Added the window for input of the security resources password.
 * Added the 2 associated callbacks : PasswdCancelCb and PasswdOkCb
 * in the greta_cb.c file. These functions should be completed.
 * For the test purpose the window for the input of the password is poped
 * up when the user clicks on the help-->On Application button of the
 * main window menu bar.
 * 
 * Revision 2.2  97/05/16  13:16:55  13:16:55  poncet (F.Poncet)
 * Added the "Load" function in the main window to read and unpdate
 * resource from a text file.
 * Modified some "attachment" resources of XmForm widget so that the
 * "Open device" window and "Open resource window" do not grow any more.
 * 
 * Revision 2.1  97/05/12  18:50:19  18:50:19  poncet (F.Poncet)
 * Added chaining of the device resources in the "Server" windows.
 * Changed the suffix of generated files from ".gres" to ".res".
 * Added in ALL GENERATED files three lines of comments to show that which
 * version of Greta has generated the file.
 * Changed the label for the "chaining device resources" from "Chain ..." to
 * "Insert ...." in Device Windows Edit pulldown menus as well as in the
 * Server Windows Edit pulldown menus.
 * 
 * Revision 2.0  97/04/09  16:11:19  16:11:19  poncet (F.Poncet)
 * Added the function Save As ... to all sorts of windows (device, server and
 * resource). Addapted the old function "Save" accordingly.
 * Add the function "Chaining the resources of another device" in the device
 * windows.
 * 
 * Revision 1.4  97/03/06  10:00:00  10:00:00  taurel (E.Taurel)
 * Adapted to bx40 by fp.
 * 
 * Revision 1.3  97/01/08  15:24:38  15:24:38  taurel (E.Taurel)
 * Adapted
 * 
 * Revision 1.2  96/11/29  15:53:49  15:53:49  simard ()
 * Check in just before Elsa left ESRF
 * 
 * Revision 1.1  1996/10/09  07:45:10  simard
 * Initial revision
 *
 * Revision 1.5  96/09/26  19:58:24  19:58:24  simard ()
 *  dynamic device entry done
 * 
 * Revision 1.4  96/08/14  14:50:55  14:50:55  simard ()
 * *** empty log message ***
 * 
 * Revision 1.3  96/06/20  09:56:28  09:56:28  simard ()
 * il y avait un bug:le format du scanf etait sensible a ci
 * puisqu'il contenait $Header: greta_misc.c,v 3.14 2002/09/05 09:34:02 taurel Rel $
 * pour reconnaissance
 * 
 * Revision 1.2  96/06/19  18:48:34  18:48:34  simard ()
 * le message de la fenetre On Version est le num
 * de version de l'en tete Rcs de bib.c
 * 
 * Revision 1.1  96/06/19  16:30:12  16:30:12  simard ()
 * Initial revision
 * 
 */

#include <greta.h>

/* Some local function */

static int strchr_occurrence_nb(char *, char );


/****************************************************************************
*                                                                           *
*		char *frame(char *title)				    *
*		      -----						    *
*	Takes title and put it inside a string that forms a framed title    *
*	ready to be printed as returned, or returned a null string if title *
*	length exceeds 60 characters. 					    *
*                            		                                    *
****************************************************************************/

char *frame(char *title)
{
 	char *frame,*border,*blank_line,*main_line;
 	int l,i;
 	
 	l=strlen(title);
 	if (l>60){
 		printf("frame procedure: the title to frame is to long\n");
 		return NULL;
 	}
 	else {
 		l+=22; /* size of a whole line :
 		12 ' ', then the frame (4 spaces before and after the title
 		filled as needed by '*' or ' ')then an end-of-line '\n'
 		and the end-of=string '\0' character */
 	/* Memory allocation */
 		border=malloc(l*sizeof(char));
 		blank_line=malloc(l*sizeof(char));
 		main_line=malloc(l*sizeof(char));
 		frame=malloc((l-1)*5*sizeof(char)+1);
 	
 	/* Fill the different lines */
 		strcpy(border,"            ");
 		strncat(border,"*************************************\
******************************",l-14);
		strcat(border,"\n");
 		strcpy(blank_line,"            *");
 		strncat(blank_line,"                                                  \
                              ",l-16);
 		strcat(blank_line,"*\n");
 		strcpy(main_line,"            *   ");
 		strcat(main_line,title);
 		strcat(main_line,"   *\n");
 		
 	/* Join them into frame */	
 		strcpy(frame,border); /* to erase a possible previous content */
 		strcat(frame,blank_line);
 		strcat(frame,main_line);
 		strcat(frame,blank_line);
 		strcat(frame,border);
 		
 	/* Terminate : free the various strings and return frame*/
 		free(border);
 		free(blank_line);
 		free(main_line);
 		return frame;
 	}
}

/****************************************************************************
*                                                                           *
*		Code for arg_version procedure                              *
*                        -----------                                        *
*                                                                           *
*    returns the greta version number, found in RCS header of resources     *
*    file .								    *
*                                                                           *
****************************************************************************/

char *arg_version()
{
 	char no_version[5], *version_lb;

	version_lb=(char *)malloc(20*sizeof(char));
	sscanf(RcsId,"%*[^,],v %s %*[^$]$",no_version);
	sprintf(version_lb,"   Version %s",no_version);
	return version_lb;
}


/****************************************************************************
*									    *
*		code for the devresfile_create() procedure		    *
*			     -------------------			    *
*									    *
*	Profile : void devresfile_create(char *file,char *dev_name,         *
*                                                   char **res_text)	    *
*								            *
*       Rule : create a resource file that can be used as argument for	    *
*	       dbset_update() . It is called by the DevUpdateCb() which     *
*	       passes to it the list of resources of dev_name filling the   *
*	       DevResText of the DeviceForm, and the name of their device.  *
*									    *
****************************************************************************/

long devresfile_create(char *file, char *res_text)
{
 
  FILE     *stream;
  char     *line, s[1001];
  int      length_to_eoln;
  char     revision_text[120];
  char     *rev_nb_pointer;
  size_t   nb_chars;
  char     message_txt[301];


  strcpy(revision_text , "$Revision: 3.14 $");
  rev_nb_pointer = strstr(revision_text, ":");
  rev_nb_pointer++;
  nb_chars = strcspn(rev_nb_pointer, "$");

  strcpy(message_txt, "### File generated by GRETA  Version : ");
  strncat(message_txt, rev_nb_pointer, nb_chars);
  strcat(message_txt, " \n");



  stream=fopen(file, "w");
  if (stream == NULL)
  {   
	return(-1);
  }
  
  fputs("###\n", stream);
  fputs(message_txt, stream);
  fputs("###\n", stream);
  line=res_text;
  while (line!=NULL)
  {
      length_to_eoln = strcspn(line, "\n");
      strncpy(s, line, length_to_eoln);
      s[length_to_eoln] = '\0';
      strcat(s, "\n");
      fputs(s, stream);

      /** take the next line **/
      line=strstr(line, "\n");
      if (line != NULL)
         line = line + 1;
  }

  fclose (stream);
  return(0);

}





/****************************************************************************
*									    *
*		Code for the file_create() procedure			    *
*			     -------------				    *
*									    *
*	Profile : void file_create(char *file,char *res_text)		    *
*									    *
*       Rule : create a resource file that can be used as argument for	    *
*	       dbset_update() . It is called by the ServUpdateCb() which    *
*	       passes to it the lists of devices and resources filling the  *
*	       devstext	and resotext of the ServForm .			    *
*									    *
****************************************************************************/

long 
file_create(char *file, char *res_text)
{
  FILE     *stream;

  char     revision_text[120];
  char     *rev_nb_pointer;
  size_t   nb_chars;
  char     message_txt[301];


  strcpy(revision_text , "$Revision: 3.14 $");
  rev_nb_pointer = strstr(revision_text, ":");
  rev_nb_pointer++;
  nb_chars = strcspn(rev_nb_pointer, "$");

  strcpy(message_txt, "### File generated by GRETA  Version : ");
  strncat(message_txt, rev_nb_pointer, nb_chars);
  strcat(message_txt, " \n");



  stream=fopen(file, "w");
  if (stream == NULL)
  	return(-1);
	
  fputs("###\n", stream);
  fputs(message_txt, stream);
  fputs("###\n", stream);
  fputs(res_text, stream);
  fclose (stream);
  return(0);

}



/****************************************************************************
*									    *
*		code for the loadfile_create() procedure		    *
*			     -------------------			    *
*									    *
*	Profile : void loadfile_create(char *file, char *res_text)	    *
*								            *
*       Rule : create a resource file that contains exactly the same as the *
*              file loaded in the "loaded file window". In particular this  *
*              file has no starting comment "### Generated by GRETA ..."    *
*              and is a temporary file just used for "dbset_update" unix    *
*              command to update the data base by the content of a text     *
*              resource file.                                               *
*              This function is called by LoadFileUpdateCb().               *
*									    *
****************************************************************************/

void loadfile_create(char *file, char *res_text)
{
 
  FILE     *stream;
  char     *line, s[1001];
  int      length_to_eoln;

  stream=fopen(file, "w");
  line=res_text;
  while (line!=NULL)
  {
      length_to_eoln = strcspn(line, "\n");
      strncpy(s, line, length_to_eoln);
      s[length_to_eoln] = '\0';
      strcat(s, "\n");
      fputs(s, stream);

      /** take the next line **/
      line=strstr(line, "\n");
      if (line != NULL)
         line = line + 1;
  }

  fclose (stream);

}


/***************************************************************************
*									   *
* returns NULL if the file is empty, or else returns its content formatted *
* into a non-empty string .						   *
*									   *
****************************************************************************/

char *filetostr(char *file)
{
 	FILE *stream;
 	char *s, line[256];
 
  	stream=fopen(file, "r");
  	/* if file is empty, the first fgets begins on an end of file, and returns
  	   NULL, without touching line . */
  	if(fgets(line, sizeof(line), stream)==NULL)
  		return NULL;
  	else s=(char *)strdup(line);
  	while((fgets(line, sizeof(line), stream)) != NULL)
  	{
  		s=(char *)realloc(s, strlen(s)+strlen(line)+1);
  		strcat(s, line);
  	}
	fclose (stream);
	return s;
}


/****************************************************************************
*                                                                           *
*	Return the number of occurences of c in str			    *
*                                                                           *
****************************************************************************/

static int strchr_occurrence_nb(char *str, char c)
{
 	int i, resu, len;
 
	resu=0;
	len=strlen(str);
	for(i=0;i<len;i++)
		if(str[i]==c) resu++;
	return resu;
}


long file_concat(char *source_file_name,char *dest_file_name)
{
	FILE *source;
	FILE *dest;
	char buffer[512];
	
	if ((source = fopen(source_file_name,"r")) == NULL)
		return(-1);
	if ((dest = fopen(dest_file_name,"a")) == NULL)
		return(-1);

	while (fgets(buffer,512,source) != NULL)
	{
		fputs(buffer,dest);
	}
	
	if (feof(source) == 0)
	{
		fclose(source);
		fclose(dest);
		return(-1);
	}
			
	fclose(source);
	fclose(dest);
	
	return(0);
}
