/* $Log:	siggen.h,v $
 * Revision 1.19  97/11/13  08:56:40  08:56:40  taurel (E.Taurel)
 * Added some new error codes
 * 
 * Revision 1.18  97/08/25  13:26:25  13:26:25  taurel (E.Taurel)
 * No change, check out for test only !
 * 
 * Revision 1.17  97/04/08  10:01:35  10:01:35  taurel (E.Taurel)
 * Change sig. name size and add signal defined in DS
 * 
 * Revision 1.16  97/02/13  16:08:39  16:08:39  taurel (E.Taurel)
 * Align double in 8 bytes buondary (sig_get function)
 * 
 * Revision 1.15  96/12/30  14:26:11  14:26:11  taurel (E.Taurel)
 * Fix a buf in the dev_name field of the global structures array pointed to by P_dev_info in the sig_imp.c file (dev_init function).
 * 
 * Revision 1.13  96/12/13  16:37:23  16:37:23  taurel (E.Taurel)
 * Added multi-nethost support
 * 
 * Revision 1.12  96/11/13  15:38:28  15:38:28  taurel (E.Taurel)
 * Change the error code returned by dc_sig_import
 * if the dc_import failed.
 * 
 * Revision 1.11  96/06/11  16:34:07  16:34:07  taurel (E.Taurel)
 * Fix a bug in the dc_sig_import function. Don't forget
 * to increment the device counter in the class structure.
 * 
 * Revision 1.10  96/02/22  10:58:39  10:58:39  taurel (Emmanuel Taurel)
 * Fix a bug in the sig_get.c file. When the signal is
 * a short type, reserver 4 bytes for the following signals.
 * 
 * Revision 1.9  96/02/09  11:27:55  11:27:55  taurel (Emmanuel TAUREL)
 * Fixed a bug in the error treatement in the
 * sig_get file when the dc_devgetm command is used.
 * .
 * 
 * Revision 1.8  96/01/15  16:14:30  16:14:30  taurel (Emmanuel Taurel)
 * Change in sig_get:sort_signal function. It is exeactly
 * the opposite of the change between version 1.2 and 1.3 !!!!!
 * The sig_num field of the SigDevSort array is the number of signal in the
 * caller array.
 * 
 * Revision 1.7  95/12/15  17:32:06  17:32:06  taurel (Emmanuel TAUREL)
 * Check out for debug purpose. No change.
 * 
 * Revision 1.6  95/11/23  10:35:52  10:35:52  taurel (Emmanuel Taurel)
 * Fixed a bug in the dc_sig_query function for signal
 * with a name length up to 12 characters.
 * 
 * Revision 1.5  95/10/11  12:32:16  12:32:16  taurel (Emmanuel TAUREL)
 * Added pseudo-device support.
 * 
 * Revision 1.2  95/10/04  13:19:56  13:19:56  taurel (Emmanuel TAUREL)
 * Fix a bug in the dc_sig_get function when only a dc_devget
 * is needed and this one failed.
 * 
 * Revision 1.1  94/11/25  16:25:39  16:25:39  taurel (Emmanuel TAUREL)
 * Initial revision
 *  */

#ifndef _siggen_h
#define _siggen_h

#include <API.h>


/* Some constants */


#define		SIG_MAX_NAME		24

#define		SIG_DEFINED		0
#define		SIG_ONE_LEVEL		1
#define		SIG_TWO_LEVEL		2
#define		SIG_THREE_LEVEL		3

#define		SIG_UNDEF		0
#define		SIG_DEF			1

#define		SIG_LOCAL		0
#define		SIG_REMOTE		1

/* Constant for the kernel extraction routines */

#define		SIG_ARRAY_ALL		111111

#define		SIG_STATE		0
#define		SIG_READ		1
#define		SIG_SET			2

/* Some signal specific types */

typedef long (*SigMethod)();

typedef struct _SigUParamDesc {
	char		*param_desc;
	long		l_bound;
	long		u_bound;
	long 		def_value;
	}SigUParamDesc;

typedef struct _SigIParamVal {
	long		validity;
	long		value;
	}SigIParamVal;

typedef long SigFuncParamList[3];

typedef struct _SigDefEntry {
	char 		sig_name[SIG_MAX_NAME];
	long 		sig_kind;
	DevArgType 	sig_type;
	DevCommand 	sig_cmd;
	long		sig_cmd_size;
	SigMethod 	sig_method;
	long		sig_code;
	char 		*sig_desc;
	SigUParamDesc 	*sig_u_param_desc[3];
	SigIParamVal	sig_i_param_val[3];
}SigDefEntry;

typedef struct _dc_signal {
	char		sig_name[SIG_MAX_NAME];
	long		sig_number;
	long		dev_num;
	long 		cmd_code;
	long		cmd_type;
	}dc_signal;

typedef struct _SigInterface {
	char			*sig_name;
	long			sig_access;
	dc_signal		*sig_ptr;
	DevArgument		signal_value;
	SigFuncParamList	param;
	long			sig_error;
	}SigInterface;

typedef struct _SigParInfo {
	char			*sig_par_desc;
	long			sig_par_u_bound;
	long			sig_par_l_bound;
	long			sig_def_value;
	}SigParInfo;

typedef struct _SigVarParArray {
	unsigned int		length;
	SigParInfo		*sequence;
	}SigVarParArray;

typedef struct _SigInfo {
	char			sig_name[SIG_MAX_NAME];
	char			*sig_desc;
	long 			sig_kind;
	DevArgType		sig_type;
	DevCommand		sig_cmd;
	SigVarParArray		sig_par_info;
	}SigInfo;

typedef struct _DevVarSigArray {
	unsigned int		length;
	SigInfo			*sequence;
	}DevVarSigArray;

typedef struct _SigHistVal {
	DevArgument		signal_value;
	time_t			sig_time;
	long 			sig_error;
	}SigHistVal;

typedef struct _SigGetHistory {
	dc_signal		*sig_ptr;
	SigFuncParamList	param;
	long 			rec_nb;
	SigHistVal		*sighistvalarr;
	}SigGetHistory;

/* Macro definitions */

#define	DC_SIG_QUERY_FREE(A) {\
	int mi,mk;\
	SigInfo *p_tmp;\
	for (mi=0;mi<A.length;mi++) {\
		p_tmp = &(A.sequence[mi]);\
		free(p_tmp->sig_desc);\
		for (mk=0;mk<p_tmp->sig_kind;mk++) \
			free(p_tmp->sig_par_info.sequence[mk].sig_par_desc);\
		free(p_tmp->sig_par_info.sequence);\
				    }\
	free(A.sequence);\
}

/* Function definitions */

long dc_sig_import PT_((char *dev_name,SigInterface *impsigarr,long sig_number,long *error));
long dc_sig_free PT_((SigInterface *freesigarr,long sig_number,long *error));
long dc_sig_get PT_((SigInterface *getsigarr,long sig_number,long *error));
long dc_sig_get_history PT_((SigGetHistory *getsighistarr,long sig_number,long *error));
long dc_sig_query PT_((char *dev_name,DevVarSigArray *varsigarr,long *error));


#endif /* _siggen_h */
