/*+*******************************************************************

 File:          macros.h

 Project:       Device Servers with sun-rpc

 Description:   Public macro definitions.
		Macros for function declarations and prototypes.

 Author(s):     Jens Meyer

 Original:      July 1994


 $Revision: 5.23 $
 $Date: 2002/03/11 12:35:58 $

 $Author: goetz $

 $Log: macros.h,v $
 Revision 5.23  2002/03/11 12:35:58  goetz
 added extern C prototype to VGC xdr routines for C++

 Revision 5.22  2001/11/12 10:01:38  goetz
 updated C port for Windows 95/98/NT using Visual C++ 6

 Revision 5.21  2001/01/08 12:17:37  goetz
 added patch by B.Pedersen to support querying events

 Revision 5.20  2000/10/02 12:08:48  goetz
 removed stderr from api_xdr.c

 Revision 5.19  1999/07/08 14:10:49  goetz
 changed _LPfd_set type for Linux in macros.h

 * Revision 5.18  99/02/04  11:01:37  11:01:37  goetz (Andy Goetz)
 * added __STDCPP__ for typedef DevArgument
 * 
 * Revision 5.17  98/05/25  17:59:48  17:59:48  klotz (W.D. Klotz)
 * fixed C++ prototypes in api_xdr.h
 * 
 Revision 5.16  1998/04/29 10:24:10  goetz
 macros.h - added __STDCPP__ for HP C++ compiler (aCC)

 * Revision 5.15  97/12/01  15:22:28  15:22:28  klotz (W.D. Klotz)
 * WIN_NT_95_released_NOV_97
 * 
 * Revision 4.34  97/01/30  13:58:42  13:58:42  goetz (Andy Goetz)
 * removed dev_printdebug() from DevXdrKernel.h
 * 
 * Revision 4.33  97/01/09  10:08:47  10:08:47  goetz (Andy Goetz)
 * (xdrproc_t) castings added to maxe_xdr, ram_xdr, thc_xdr, seism_xdr
 * 
 * Revision 4.32  97/01/08  16:48:36  16:48:36  goetz (Andy Goetz)
 * Ported to Linux (2.0.9)
 * 
 Revision 4.31  1996/11/18 17:28:52  goetz
 Check

 * Revision 4.30  96/10/24  08:02:58  08:02:58  goetz (Andy Goetz)
 * fixed error with TOLOWER macro (extra space before #define) which causes
 * some compilers to bomb
 * 
 * Revision 4.29  1996/10/23  20:55:30  klotz
 * bug fix: HWALK() under unix
 *
 Revision 4.28  1996/10/21 16:22:33  taurel
 Check_in_after_port_to_OS9/ISP_2.1_and_OS9/RPC1.4

 * Revision 4.27  96/09/17  16:45:53  16:45:53  klotz (W.D. Klotz)
 * WD Klotz: checked NT build
 * 
 * Revision 4.26  96/07/19  10:01:06  10:01:06  taurel (E.Taurel)
 * Some_change_in_macros.h_for_the_API_port_to_OS-9_Ultra_C++
 * 
 * Revision 4.25  96/06/07  16:23:10  16:23:10  meyer (J.Meyer)
 * Corrected_elif_to_else_in_macros.h
 * 
 * Revision 4.24  96/06/05  15:01:45  15:01:45  meyer (J.Meyer)
 * Corrected_macros.h
 * 
 * Revision 4.23  96/06/03  13:10:23  13:10:23  meyer (J.Meyer)
 * Cleaned-up_MSDOS_and_added_porting_options_for_Windows_NT.
 * 
 * Revision 4.22  96/05/23  11:07:31  11:07:31  taurel (E.Taurel)
 * Added_some_definitions_for_C++_in_API_xdr.h_file
 * 
 * Revision 4.21  96/05/06  18:37:41  18:37:41  meyer (J.Meyer)
 * Fortran_compatibility_for:_dev_xdr.h,macros.h,maxe_xdr.h
 * 
 * Revision 4.20  96/02/27  13:31:41  13:31:41  meyer (J.Meyer)
 * Deleted_Cross_References_To_DSAPI_Library
 * 
 * Revision 4.19  96/01/11  17:40:26  17:40:26  meyer (Jens Meyer)
 * Added_#define_PORTMAP_to_macros.h.
 * 
 * Revision 4.18  95/12/21  10:33:40  10:33:40  meyer (Jens Meyer)
 * Corrected length calculation for D_VAR_MSTATARR.
 * 
 * Revision 4.17  95/08/02  16:05:18  16:05:18  meyer (Jens Meyer)
 * Corrected DevXdrKernel.h after C++ implementation.
 * 
 * Revision 4.15  95/03/02  10:28:04  10:28:04  meyer (Jens Meyer)
 * Added D_VAR_SFRPARR type to the kernel.
 * 
 * Revision 4.14  95/02/20  09:56:55  09:56:55  meyer (Jens Meyer)
 * Passed the compilers for HPUX, SUNOS and UCC after the first windows check in.
 * 
 * Revision 4.13  95/02/10  17:19:10  17:19:10  meyer (Jens Meyer)
 * Deleted
 * 
 * Revision 4.12  95/02/01  14:27:14  14:27:14  klotz (W.D. Klotz)
 * WDK: first successfull compile of dbase, api, xdr on WIN16/3.1
 * 
 * Revision 4.11  95/01/03  13:19:31  13:19:31  meyer (Jens Meyer)
 * Repared bug in dev_cmd_query() for version 3!
 * 
 * Revision 4.10  94/12/08  15:25:02  15:25:02  meyer (Jens Meyer)
 * Changed _manager_data in API_xdr and added old version to API_xdr_vers3.
 * 
 * Revision 4.9  94/11/28  17:04:24  17:04:24  meyer (Jens Meyer)
 * Data types for compatibility with library version 3.x
 * 
 * Revision 4.8  94/08/16  16:59:41  16:59:41  meyer (Jens Meyer)
 * Corrected error in ws_xdr.h
 * 
 * Revision 4.7  94/08/16  16:34:35  16:34:35  meyer (Jens Meyer)
 * Added define for MAX_RESOURCE_FIELD_LENGTH to macros.h
 * 
 * Revision 4.6  94/08/12  15:07:51  15:07:51  meyer (Jens Meyer)
 * Added valriable arguments to all API RPC structures.
 * 
 * Revision 4.5  94/07/20  18:15:50  18:15:50  meyer (Jens Meyer)
 * Changed include files in macros.h!
 * 
 * Revision 4.4  94/07/20  08:56:04  08:56:04  meyer (Jens Meyer)
 * All XDR functions with prototypes!
 * 
 * Revision 4.3  94/07/18  18:50:59  18:50:59  meyer (Jens Meyer)
 * Had to change macros.h, because #define must be in the first column!
 * 
 * Revision 4.2  94/07/18  18:27:34  18:27:34  meyer (Jens Meyer)
 * First test with PC macros for the XDR kernel.
 * 

 Copyright (c) 1990 by European Synchrotron Radiation Facility,
                       Grenoble, France

*******************************************************************-*/

#ifndef _macros_h
#define _macros_h

/*
 * convert NULL-terminated string to lower characters
 */
#define TOLOWER(a) {char* i; i=a; while ( '\0'!=*i ) \
      { *i=tolower(*i);i++; }}

#if !defined(FORTRAN)

#if defined (WIN32)
#undef __STDC__
#include <stdio.h>
#include <time.h>
#include <malloc.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <winsock.h>
#include <rpc/rpc.h>
#include <process.h>

/*
 *  macro emulates BSD Socket function inet_network
 *  which does not exist for WinSock API.
 */
#define inet_network(addr) htonl(inet_addr(addr))

#define NETMNG   1
#define __STDC__ 1


#else /* UNIX */

#ifdef NETMNG
#undef NETMNG
#endif

#include <stdio.h>
#include <time.h>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#ifndef _UCC
#include <unistd.h>
#endif


#ifndef _sunrpc
#define PORTMAP
#include <rpc/rpc.h>
#endif /* _sunrpc */

#ifdef _UCC
#include <inet/socket.h>
#ifdef __cplusplus
extern "C" {
int close(int);
int kill(int,int);
int getpid(void);
int _errmsg(...);
int intercept(...);
int sleep(unsigned int);
int os9exec(...);
int gettimeofday(struct timeval *,struct timezone *);

}
#endif /* __cplusplus */
#endif /* _UCC */

#endif /* (_NT) && (_WIN32) */
#endif /* FORTRAN */

/*
 * macro to extract prototypes in function declarations if
 * the ANSI C standad is not used.
 */

#if defined (__STDC__) || (__STDCPP__)
#define PT_(A) A
#else
#define PT_(A) ()
#endif /* __STDC__ || __STDCPP__ */


/*
 *  general definitions
 */

#define False 0
#define True 1
#ifndef NULL
#define NULL 0
#endif /* NULL */

#define DS_OK           0
#define DS_NOTOK        (-1)
#define DS_WARNING      1
#define DS_TRUE         1
#define DS_FALSE        0

/*
 * For the OS9 compiler cc68 size_t is not defined.
 * Define it here!
 */

#if !defined(FORTRAN)
#ifdef OSK
typedef unsigned int	size_t;
#endif /* OSK */
#endif /* FORTRAN */

/*
 * Definitions for name length
 */

#define LONG_NAME_SIZE			80
#define SHORT_NAME_SIZE			32

#define MAX_RESOURCE_FIELD_LENGTH	19
/*
 *	Definitions for PC_USER_AUTHENTICATION
 */
#define PC_USER_ID	33
#define PC_USER_NAME	"pc_user"
#define PC_GROUP_ID	33
#define PC_GROUP_NAME	"pc_group"

/*
 * Macros used for the Netmanage PC software !
 */

#if !defined (_NT)  /* UNIX definitions */
#if !defined (linux)
#define _LPfd_set	struct fd_set *
#else /* !(linux) */
#define _LPfd_set	fd_set *
#endif /* !(linux) */
#define	_Int		long
#define _WINAPI
#define TIMEVAL(a)  a
#define MAXU_INT    ~0
#define _DLLFunc        
#define HWALK(p)
#define PRINTF(a)      printf(a)

#else /* (_NT) */
#define _LPfd_set	struct fd_set *
#define	_Int		short
#define _WINAPI     WINAPI	   /* needed for MSVC++ */
#define TIMEVAL(a)    (struct timeval*)&a	  /* needed for NetManage's RPC clnt_call() */
#define MAXU_INT    0xFFFFFFFF

/* Macros for NT DLL symbol definition */
#define DllExport       __declspec( dllexport )
#define DllImport       __declspec( dllimport )
#ifdef _DLL           /* export definitions for NT Dlls */
#define _DLLFunc   DllExport
#else 
#define _DLLFunc
#endif /* (_DLL) */

/*
 * Heap Walk utility: very useful for debugging !!
 */
extern _DLLFunc size_t msize PT_( (void* pointer, int* error) );
#if defined (_HWALK)
static int msz_error;
static size_t msz_size;

#define HWALK(p) msz_size= msize(p,&msz_error); \
   if(msz_size ==0)    \
      printf("Heap Walk ERR= %d (File: %s, Line %d)\n",msz_error,__FILE__,__LINE__); \
   else    \
      printf("Heap Size = %u (File %s, Line %d)\n", msz_size,__FILE__,__LINE__)
#else
#define HWALK(p)
#endif     /* _HWALK */   

/* 
 * these macros are used to display ASCII strings on the
 * NT console. (See DevServerMain.c and NT_debug.c 
 * for creation of the console).
 */
/*
extern HANDLE hConOut;
#define conout(a) { DWORD dwNumWritten; \
					WriteConsole(hConOut,a,strlen(a),&dwNumWritten,NULL);}
*/

#ifdef WIN32
#include <NT_debug.h>
#define PRINTF(a)      MessageBox(NULL,a,NULL,MB_OK|MB_ICONASTERISK);
#endif  /* WIN32 */

#endif /* (_NT) */



/*
 * macros to define left/right bit shifts in a way that can be used both
 * in C and FORTRAN programs:
 *
 * DS_LSHIFT(x,y) shifts (x) left  by (y) bit positions
 * DS_RSHIFT(x,y) shifts (x) right by (y) bit positions
 */

#if !defined(FORTRAN)
#define DS_LSHIFT(x,y) ((x) << (y))
#define DS_RSHIFT(x,y) ((x) >> (y))
#else /* FORTRAN */
#define DS_LSHIFT(x,y) ISHFT(x,y)
#define DS_RSHIFT(x,y) ISHFT(x,-(y))
#endif /* FORTRAN */

#if !defined(FORTRAN)
#if defined (__STDC__) || (__STDCPP__) && !defined (NETMNG)
typedef void *DevArgument;
#else
typedef char *DevArgument;
#endif /* __STDC__ || __STDCPP__ */
#endif /* FORTRAN */

#endif /* _macros_h */
