
/*+*******************************************************************

 File:          gpib_xdr.h

 Project:       Device Servers with sun-rpc

 Description:   Include file for XDR definitions 
		of the GPIB data types.

 Author(s):  	Jens Meyer

 Original:	July 1992


 $Revision: 5.22 $
 $Date: 2002/03/11 12:35:58 $

 $Author: goetz $

 $Log: gpib_xdr.h,v $
 Revision 5.22  2002/03/11 12:35:58  goetz
 added extern C prototype to VGC xdr routines for C++

 Revision 5.21  2001/11/12 10:01:38  goetz
 updated C port for Windows 95/98/NT using Visual C++ 6

 Revision 5.20  2001/01/08 12:17:37  goetz
 added patch by B.Pedersen to support querying events

 Revision 5.19  2000/10/02 12:08:48  goetz
 removed stderr from api_xdr.c

 Revision 5.18  1999/07/08 14:10:49  goetz
 changed _LPfd_set type for Linux in macros.h

 Revision 5.17  1998/05/25 17:59:52  klotz
 fixed C++ prototypes in api_xdr.h

 Revision 5.16  1998/04/29 10:24:15  goetz
 macros.h - added __STDCPP__ for HP C++ compiler (aCC)

 * Revision 5.15  97/12/01  15:22:21  15:22:21  klotz (W.D. Klotz)
 * WIN_NT_95_released_NOV_97
 * 
 * Revision 4.34  97/01/30  13:58:46  13:58:46  goetz (Andy Goetz)
 * removed dev_printdebug() from DevXdrKernel.h
 * 
 * Revision 4.33  97/01/09  10:08:50  10:08:50  goetz (Andy Goetz)
 * (xdrproc_t) castings added to maxe_xdr, ram_xdr, thc_xdr, seism_xdr
 * 
 * Revision 4.32  97/01/08  16:48:40  16:48:40  goetz (Andy Goetz)
 * Ported to Linux (2.0.9)
 * 
 Revision 4.31  1996/11/18 17:28:55  goetz
 Check

 * Revision 4.28  96/10/21  16:22:39  16:22:39  taurel (E.Taurel)
 * Check_in_after_port_to_OS9/ISP_2.1_and_OS9/RPC1.4
 * 
 * Revision 4.27  96/09/17  16:45:45  16:45:45  klotz (W.D. Klotz)
 * WD Klotz: checked NT build
 * 
 * Revision 4.26  96/07/19  10:01:08  10:01:08  taurel (E.Taurel)
 * Some_change_in_macros.h_for_the_API_port_to_OS-9_Ultra_C++
 * 
 * Revision 4.25  96/06/07  16:23:12  16:23:12  meyer (J.Meyer)
 * Corrected_elif_to_else_in_macros.h
 * 
 * Revision 4.24  96/06/05  15:01:48  15:01:48  meyer (J.Meyer)
 * Corrected_macros.h
 * 
 * Revision 4.23  96/06/03  13:10:26  13:10:26  meyer (J.Meyer)
 * Cleaned-up_MSDOS_and_added_porting_options_for_Windows_NT.
 * 
 * Revision 4.22  96/05/23  11:07:34  11:07:34  taurel (E.Taurel)
 * Added_some_definitions_for_C++_in_API_xdr.h_file
 * 
 * Revision 4.21  96/05/06  18:37:44  18:37:44  meyer (J.Meyer)
 * Fortran_compatibility_for:_dev_xdr.h,macros.h,maxe_xdr.h
 * 
 * Revision 4.20  96/02/27  13:31:44  13:31:44  meyer (J.Meyer)
 * Deleted_Cross_References_To_DSAPI_Library
 * 
 * Revision 4.19  96/01/11  17:40:29  17:40:29  meyer (Jens Meyer)
 * Added_#define_PORTMAP_to_macros.h.
 * 
 * Revision 4.18  95/12/21  10:33:46  10:33:46  meyer (Jens Meyer)
 * Corrected length calculation for D_VAR_MSTATARR.
 * 
 * Revision 4.17  95/08/02  16:05:21  16:05:21  meyer (Jens Meyer)
 * Corrected DevXdrKernel.h after C++ implementation.
 * 
 * Revision 4.15  95/03/02  10:28:10  10:28:10  meyer (Jens Meyer)
 * Added D_VAR_SFRPARR type to the kernel.
 * 
 * Revision 4.14  95/02/20  09:57:08  09:57:08  meyer (Jens Meyer)
 * Passed the compilers for HPUX, SUNOS and UCC after the first windows check in.
 * 
 * Revision 4.13  95/02/10  17:19:17  17:19:17  meyer (Jens Meyer)
 * Deleted
 * 
 * Revision 4.12  95/02/01  14:27:26  14:27:26  klotz (W.D. Klotz)
 * WDK: first successfull compile of dbase, api, xdr on WIN16/3.1
 * 
 * Revision 4.11  95/01/03  13:19:37  13:19:37  meyer (Jens Meyer)
 * Repared bug in dev_cmd_query() for version 3!
 * 
 * Revision 4.10  94/12/08  15:25:09  15:25:09  meyer (Jens Meyer)
 * Changed _manager_data in API_xdr and added old version to API_xdr_vers3.
 * 
 * Revision 4.9  94/11/28  17:04:30  17:04:30  meyer (Jens Meyer)
 * Data types for compatibility with library version 3.x
 * 
 * Revision 4.8  94/08/16  16:59:45  16:59:45  meyer (Jens Meyer)
 * Corrected error in ws_xdr.h
 * 
 * Revision 4.7  94/08/16  16:34:41  16:34:41  meyer (Jens Meyer)
 * Added define for MAX_RESOURCE_FIELD_LENGTH to macros.h
 * 
 * Revision 4.6  94/08/12  15:07:57  15:07:57  meyer (Jens Meyer)
 * Added valriable arguments to all API RPC structures.
 * 
 * Revision 4.5  94/07/20  18:15:56  18:15:56  meyer (Jens Meyer)
 * Changed include files in macros.h!
 * 
 * Revision 4.4  94/07/20  08:56:14  08:56:14  meyer (Jens Meyer)
 * All XDR functions with prototypes!
 * 
 * Revision 4.3  94/07/18  18:51:04  18:51:04  meyer (Jens Meyer)
 * Had to change macros.h, because #define must be in the first column!
 * 
 * Revision 4.2  94/07/18  18:22:40  18:22:40  meyer (Jens Meyer)
 * First test with PC macros for the XDR kernel.
 * 
 * Revision 4.1  94/05/02  10:50:57  10:50:57  meyer (Jens Meyer)
 * For Security System without connection count.
 * 
 * Revision 4.0  94/03/14  18:17:42  18:17:42  meyer (Jens Meyer)
 * Library version with Security System.
 * 
 * Revision 3.50  94/03/12  14:36:35  14:36:35  meyer (Jens Meyer)
 * Changed API xdr structures for security.
 * 
 * Revision 3.35  94/03/03  10:52:21  10:52:21  taurel (Emmanuel TAUREL)
 * Added unsigned long array type in the XDRkernel
 * 
 * Revision 3.34  94/03/03  10:29:11  10:29:11  taurel (Emmanuel TAUREL)
 * Added the unsigned long array type in
 * XDR kernel (LC and ET).
 * 
 * Revision 3.33  94/01/12  16:34:36  16:34:36  meyer (Jens Meyer)
 * Global XDR type array for data collector access
 * 
 * Revision 3.31  93/12/02  09:39:15  09:39:15  meyer (Jens Meyer)
 * New release with small XDR data type kernel.
 * 
 * Revision 1.1  93/11/16  17:10:36  17:10:36  meyer (Jens Meyer)
 * Initial revision
 * 

 Copyright (c) 1990 by European Synchrotron Radiation Facility,
		       Grenoble, France

*******************************************************************-*/

#ifndef _gpib_xdr_h
#define _gpib_xdr_h


/*
 * definitions for Gpib
 */
struct DevGpibWrite {
	short number;
	char  *msg_str;
};
typedef struct DevGpibWrite 	DevGpibWrite;
bool_t 	_DLLFunc xdr_DevGpibWrite  PT_((XDR *xdrs, DevGpibWrite *objp));
#define D_GPIB_WRITE            32
#define LOAD_GPIB_WRITE(A)      xdr_load_type ( D_GPIB_WRITE, \
                                                xdr_DevGpibWrite, \
                                                sizeof(DevGpibWrite), \
                                                NULL, \
                                                A )



struct DevGpibMulWrite {
	DevVarShortArray number_arr;
	char  		 *msg_str;
};
typedef struct DevGpibMulWrite 	DevGpibMulWrite;
bool_t 	_DLLFunc xdr_DevGpibMulWrite
		 PT_((XDR *xdrs, DevGpibMulWrite *objp));
#define D_GPIB_MUL_WRITE        33
#define LOAD_GPIB_MUL_WRITE(A)  xdr_load_type ( D_GPIB_MUL_WRITE, \
                                                xdr_DevGpibMulWrite, \
                                                sizeof(DevGpibMulWrite), \
                                                NULL, \
                                                A )


struct DevGpibRes {
  	short number;  /* Device Number */
      	char  sendDC;
     	char  DoPPoll;
    	char  readMode;
   	char  readEnd1;
 	char  readEnd2;
	char  writeMode;
	char  writeEnd1;
       	char  writeEnd2;
      	char  primAddr;
     	char  readStat;
    	char  readMask;
   	char  res1;
  	long  frameCnt;
};
typedef struct DevGpibRes 	DevGpibRes;
bool_t 	_DLLFunc xdr_DevGpibRes  PT_((XDR *xdrs, DevGpibRes *objp));
#define D_GPIB_RES              37
#define LOAD_GPIB_RES(A)        xdr_load_type ( D_GPIB_RES, \
                                                xdr_DevGpibRes, \
                                                sizeof(DevGpibRes), \
                                                NULL, \
                                                A )


struct DevGpibLoc {
    	char  slave;
      	char  startCtrl;
     	char  fullAddr;
    	char  sendREN;
   	char  serialPoll;
  	char  paraPoll;
 	char  autoRead;
	char  autoSRQ;
      	char  defStat;
      	char  writeStat;
     	char  waitREN;
    	char  res0;
};
typedef struct DevGpibLoc 	DevGpibLoc;
bool_t 	_DLLFunc xdr_DevGpibLoc  PT_((XDR *xdrs, DevGpibLoc *objp));
#define D_GPIB_LOC              38
#define LOAD_GPIB_LOC(A)      	xdr_load_type ( D_GPIB_LOC, \
                                                xdr_DevGpibLoc, \
                                                sizeof(DevGpibLoc), \
                                                NULL, \
                                                A )


#endif /* _gpib_xdr_h */

