/****************************************************************************

 File          :   test_asc_stat.c

 Project       :   ASCII based interface to device server API

 Description   :   The code for a C program (main) which test the archived
                   version of the library libascapi.a. To debug the libascapi
                   library one should first build the archive version of that
                   libascapi.a and then use this (test_asc_stat.c) program to
                   test the library.

 Author        :   Faranguiss Poncet

 Original      :   November 1996

 $Revision: 1.7 $                               $Author: poncet $
 $Date: 97/04/10 15:49:55 $                                     $State: Rel $

 $Log:	test_asc_stat.c,v $
 * Revision 1.7  97/04/10  15:49:55  15:49:55  poncet (F.Poncet)
 * Unchanged. Archived for compatible revision numbers with libascapi.sl.
 * 
 * Revision 1.6  97/03/21  14:36:07  14:36:07  poncet (F.Poncet)
 * File Unchanged. Archived for compatible revision numbers with ascapi lib.
 * 
 * Revision 1.5  97/02/18  13:47:57  13:47:57  poncet (F.Poncet)
 * File not changed. Archived for compatible revision numbers.
 * 
 * Revision 1.4  97/01/21  16:01:28  16:01:28  poncet (F.Poncet)
 * File rearchived to initialize the first officially released version.
 * 
 * Revision 1.4  97/01/10  13:13:27  13:13:27  poncet (F.Poncet)
 * File unchanged. Archived for compatible revision numbers.
 * 
 * Revision 1.3  97/01/08  14:08:22  14:08:22  poncet (F.Poncet)
 * The name of the function used has changed from asc_dev_get to dev_get_asci
 * 
 * Revision 1.2  97/01/07  17:49:58  17:49:58  poncet (F.Poncet)
 * File unchanged. Archived for compatible revision numbers.
 * 
 * Revision 1.1  96/11/25  18:16:35  18:16:35  poncet (F.Poncet)
 * Initial revision
 * 

 Copyright (c) 1996 by European Synchrotron Radiation Facility,
                       Grenoble, France

                       All Rights Reserved

****************************************************************************/

#include <stdlib.h>
#include <string.h>
#include <errno.h>

#include <API.h>
#include <asc_api.h>



main ()
{

   char                        device_name[101];
   char                        command_name[101];
   char                        out_str[2001];
   char                        err_str[1001];
   char                        *result, *error_msg;
   long                        get_status;





   printf("\n\nLet's first try the dev_get_ascii command.\n\n");

 
   while (1)
   {
      printf("\n\nType in the name of the device : ");
      scanf("%s", device_name);

      if (strcmp("END", device_name) == 0)
         break;

      printf("\n\nType in the name of the command : ");
      scanf("%s", command_name);

      printf("Device = %s  ,  ", device_name);
      printf("Command = %s\n", command_name);


      out_str[0] = '\0';
      err_str[0] = '\0';

      result = (char *) out_str;
      error_msg = (char *) err_str;
      if ( dev_get_ascii(device_name, command_name, &result, &error_msg) == 0 )
      {
         printf("Youpi! dev_get_ascii succeeded!\n");
         printf("out argument = %s\n", out_str);
      }
      else
      {
         printf("Zut! dev_get_ascii failed!\n");
         printf("error message = %s\n", err_str);
      }
   }

}


