/* $Log:	dcrd_clnt.c,v $
 * Revision 4.10  2001/06/13  08:21:33  08:21:33  taurel (Emmanuel Taurel)
 * Remove all the dev_printdebug calls for C++ compatibility
 * 
 * Revision 4.9  2000/10/19  09:15:49  09:15:49  taurel (E.Taurel)
 * No change, check out and in for test purpose only
 * 
 * Revision 4.8  99/06/02  12:59:19  12:59:19  taurel (E.Taurel)
 * No change, checked-in only for correct verion number
 * 
 * Revision 4.7  99/06/02  12:44:07  12:44:07  taurel (E.Taurel)
 * Fix bug with DC time for dc_devget_history
 * 
 * Revision 4.6  98/11/10  15:09:44  15:09:44  taurel (E.Taurel)
 * No change in lib. Only add func def. in dc.h include file
 * 
 * Revision 4.5  98/10/20  13:58:20  13:58:20  taurel (E.Taurel)
 * Fix a memory laek in the dc_devgetm function
 * 
 * Revision 4.4  98/09/03  10:41:47  10:41:47  taurel (E.Taurel)
 * Change dc_muli_nethost definition in dchist_cli.c file
 * 
 * Revision 4.3  98/09/02  09:24:09  09:24:09  taurel (E.Taurel)
 * Adapted to any number of nethosts
 * 
 * Revision 4.2  98/08/25  10:05:21  10:05:21  klotz (W.D. Klotz)
 * Version_used_for_NT
 * 
 * Revision 4.1  96/12/31  15:21:38  15:21:38  taurel (E.Taurel)
 * Remove .esrf.fr at the end of nethost before any connection to server
 * 
 * Revision 4.0  96/12/06  11:24:08  11:24:08  taurel (E.Taurel)
 * Multi-nethost release of dc library
 * 
 * Revision 3.6  96/11/25  15:23:04  15:23:04  klotz (W.D. Klotz)
 * untested NT compile
 * 
 * Revision 3.5  96/01/05  16:05:06  16:05:06  taurel (E.Taurel)
 * Ported to Solaris in compatibility mode.
 * 
 * Revision 3.4  94/01/24  15:18:43  15:18:43  taurel (Emmanuel TAUREL)
 * Add a new case of error for the new XDR type system
 * 
 * Revision 3.3  93/12/02  17:59:35  17:59:35  taurel (Emmanuel Taurel)
 * Add a function to call the RPC_CHECK procedure. Add also the management
 * of the RPC_CANTSEND error.
 * 
 * Revision 3.2  93/11/30  10:45:26  10:45:26  taurel (Emmanuel Taurel)
 * check out and in only for test purpose. Nothing has been changed in this
 * file.
 * 
 * Revision 3.1  93/06/14  17:36:39  17:36:39  taurel (Emmanuel TAUREL)
 * Added the new dc_devget_history call and some new tests if call to
 * server fails.
 * 
 * Revision 3.0  93/05/17  17:48:46  17:48:46  taurel (Emmanuel TAUREL)
 * Modified to port the dc system to SUN (without RTDB).
 * 
 * Revision 1.1  93/02/04  09:19:50  09:19:50  taurel (Emmanuel Taurel)
 * Initial revision
 *  */

#include <API.h>
#include <ApiP.h>
#include <DevErrors.h>
#include <Admin.h>

#ifndef OSK
#include <time.h>
#endif

#include <dc_xdr.h>

#ifndef NULL
#define NULL  0
#endif  /* NULL */

static struct timeval TIMEOUT = { 3, 0 };


xres_clnt *
dc_devget_clnt_1(argp, clnt, argout, argout_type,perr)
	xdevget *argp;
	CLIENT *clnt;
	DevArgument argout;
	DevType argout_type;
	long *perr;
{
	static xres_clnt res;
	enum clnt_stat clnt_stat;

/* Clear only place for the error code coming from server, and initialize 
   the remaining parameters of the "res" structure with the parameters
   coming from the caller */

	memset((char *)&res, 0, sizeof(res));
	res.xargout_type = argout_type;
	res.xargout = argout;

	clnt_stat = clnt_call(clnt, DC_DEVGET,(xdrproc_t)xdr_xdevget, (caddr_t)argp,(xdrproc_t)xdr_xres_clnt, (caddr_t)&res, TIMEOUT);

	if (clnt_stat != RPC_SUCCESS)
	{
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DcErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTRECV || clnt_stat == RPC_CANTSEND)
			*perr = DcErr_CantContactServer;
		else if (clnt_stat == RPC_CANTDECODERES)
			*perr = DevErr_DevArgTypeNotCorrectImplemented;
		else
			*perr = DcErr_RPCreception;
		return (NULL);
	}
	return (&res);
}



xresv_clnt *
dc_devgetv_clnt_1(argp, clnt, st_ptr,perr)
	xdevgetv *argp;
	CLIENT *clnt;
	xres_clnt *st_ptr;
	long *perr;
{
	static xresv_clnt res;
	enum clnt_stat clnt_stat;

	memset((char *)&res, 0, sizeof(res));

	res.xresa_clnt.xresv_clnt_val = st_ptr;

	clnt_stat = clnt_call(clnt, DC_DEVGETV,(xdrproc_t)xdr_xdevgetv, (caddr_t)argp,(xdrproc_t)xdr_xresv_clnt, (caddr_t)&res, TIMEOUT);
	if (clnt_stat != RPC_SUCCESS)
	{
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DcErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTRECV || clnt_stat == RPC_CANTSEND)
			*perr = DcErr_CantContactServer;
		else if (clnt_stat == RPC_CANTDECODERES)
			*perr = DevErr_DevArgTypeNotCorrectImplemented;
		else
			*perr = DcErr_RPCreception;
		return (NULL);
	}
	return (&res);
}



xresm_clnt *
dc_devgetm_clnt_1(argp, clnt, st_ptr,perr)
	mpar *argp;
	CLIENT *clnt;
	mint *st_ptr;
	long *perr;
{
	static xresm_clnt res;
	enum clnt_stat clnt_stat;

	memset((char *)&res, 0, sizeof(res));

	res.x_clnt.x_clnt_val = st_ptr;

	clnt_stat = clnt_call(clnt, DC_DEVGETM,(xdrproc_t)xdr_mpar, (caddr_t)argp,(xdrproc_t)xdr_xresm_clnt, (caddr_t)&res, TIMEOUT);
	if (clnt_stat != RPC_SUCCESS)
	{
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DcErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTRECV || clnt_stat == RPC_CANTSEND)
			*perr = DcErr_CantContactServer;
		else if (clnt_stat == RPC_CANTDECODERES)
			*perr = DevErr_DevArgTypeNotCorrectImplemented;
		else
			*perr = DcErr_RPCreception;
		return (NULL);
	}
	return (&res);
}



outpar *
dc_devdef_1(argp, clnt,perr)
	imppar *argp;
	CLIENT *clnt;
	long *perr;
{
	static outpar res;
	enum clnt_stat clnt_stat;

	memset((char *)&res, 0, sizeof(res));

	clnt_stat = clnt_call(clnt, DC_DEVDEF,(xdrproc_t)xdr_imppar, (caddr_t)argp,(xdrproc_t)xdr_outpar, (caddr_t)&res, TIMEOUT);
	if (clnt_stat != RPC_SUCCESS)
	{
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DcErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTRECV || clnt_stat == RPC_CANTSEND)
			*perr = DcErr_CantContactServer;
		else if (clnt_stat == RPC_CANTDECODERES)
			*perr = DevErr_DevArgTypeNotCorrectImplemented;
		else
			*perr = DcErr_RPCreception;
		return (NULL);
	}
	return (&res);
}


xres_hist_clnt *
dc_devgeth_clnt_1(argp, clnt, st_ptr,perr)
	xdevgeth *argp;
	CLIENT *clnt;
	xresh_clnt *st_ptr;
	long *perr;
{
	static xres_hist_clnt res;
	enum clnt_stat clnt_stat;

	memset((char *)&res, 0, sizeof(res));

	res.xresb_clnt.xresh_clnt_val = st_ptr;

	clnt_stat = clnt_call(clnt, DC_DEVGET_H,(xdrproc_t)xdr_xdevgeth, (caddr_t)argp,(xdrproc_t)xdr_xres_hist_clnt, (caddr_t)&res, TIMEOUT);
	if (clnt_stat != RPC_SUCCESS)
	{
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DcErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTRECV || clnt_stat == RPC_CANTSEND)
			*perr = DcErr_CantContactServer;
		else if (clnt_stat == RPC_CANTDECODERES)
			*perr = DevErr_DevArgTypeNotCorrectImplemented;
		else
			*perr = DcErr_RPCreception;
		return (NULL);
	}
	return (&res);
}



int dc_rpc_check_clnt_1(clnt,res,perr)
	CLIENT *clnt;
	long *perr;
	char **res;
{
	enum clnt_stat clnt_stat;

	clnt_stat = clnt_call(clnt, RPC_CHECK,(xdrproc_t)xdr_void, NULL,(xdrproc_t)xdr_wrapstring,(caddr_t)res, TIMEOUT);
	if (clnt_stat != RPC_SUCCESS)
	{
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DcErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTRECV || clnt_stat == RPC_CANTSEND)
			*perr = DcErr_CantContactServer;
		else if (clnt_stat == RPC_CANTDECODERES)
			*perr = DevErr_DevArgTypeNotCorrectImplemented;
		else
			*perr = DcErr_RPCreception;
		return (-1);
	}
	return (0);
}
