static char RcsId[] = "@(#)$Header: dchist_cli.c,v 4.10 2001/06/13 08:21:31 taurel Rel $";

/* $Log:	dchist_cli.c,v $
 * Revision 4.10  2001/06/13  08:21:31  08:21:31  taurel (Emmanuel Taurel)
 * Remove all the dev_printdebug calls for C++ compatibility
 * 
 * Revision 4.9  2000/10/19  09:15:48  09:15:48  taurel (E.Taurel)
 * No change, check out and in for test purpose only
 * 
 * Revision 4.8  99/06/02  12:59:17  12:59:17  taurel (E.Taurel)
 * No change, checked-in only for correct verion number
 * 
 * Revision 4.7  99/06/02  12:44:06  12:44:06  taurel (E.Taurel)
 * Fix bug with DC time for dc_devget_history
 * 
 * Revision 4.6  98/11/10  15:09:42  15:09:42  taurel (E.Taurel)
 * No change in lib. Only add func def. in dc.h include file
 * 
 * Revision 4.5  98/10/20  13:58:18  13:58:18  taurel (E.Taurel)
 * Fix a memory laek in the dc_devgetm function
 * 
 * Revision 4.4  98/09/03  10:41:46  10:41:46  taurel (E.Taurel)
 * Change dc_muli_nethost definition in dchist_cli.c file
 * 
 * Revision 4.3  98/09/02  09:24:08  09:24:08  taurel (E.Taurel)
 * Adapted to any number of nethosts
 * 
 * Revision 4.2  98/08/25  10:05:20  10:05:20  klotz (W.D. Klotz)
 * Version_used_for_NT
 * 
 * Revision 4.1  96/12/31  15:21:38  15:21:38  taurel (E.Taurel)
 * Remove .esrf.fr at the end of nethost before any connection to server
 * 
 * Revision 4.0  96/12/06  11:24:07  11:24:07  taurel (E.Taurel)
 * Multi-nethost release of dc library
 * 
 * Revision 3.19  96/11/25  15:22:15  15:22:15  klotz (W.D. Klotz)
 * untested NT compilation
 * 
 * Revision 3.18  96/06/14  10:48:48  10:48:48  taurel (E.Taurel)
 * Change for release 5 of db software (pseudo devices in dc_open and dc_close)
 * Also added the dc_dinfo call.
 * 
 * Revision 3.17  96/01/05  16:03:15  16:03:15  taurel (Emmanuel TAUREL)
 * Ported to Solaris in compatibility mode
 * 
 * Revision 3.16  95/12/21  16:07:03  16:07:03  taurel (Emmanuel TAUREL)
 * Change include files policy for the ULTRA-C compiler.
 * 
 * Revision 3.15  95/12/15  17:24:55  17:24:55  taurel (Emmanuel TAUREL)
 * Check out for debug purpose. No change.
 * 
 * Revision 3.14  95/10/10  13:55:26  13:55:26  taurel (Emmanuel TAUREL)
 * Return date in the dc_devget_history even if the command has failed.
 * 
 * Revision 3.13  94/05/27  17:05:56  17:05:56  taurel (Emmanuel TAUREL)
 * Forgotten to remove added printf for test purpose !
 * 
 * Revision 3.12  94/05/27  17:01:22  17:01:22  taurel (Emmanuel TAUREL)
 * Fix a bug in the dc_check function.
 * Free the memory allocated by XDR !.
 * .
 * 
 * Revision 3.11  94/02/15  14:27:23  14:27:23  taurel (Emmanuel Taurel)
 * Fix a bug in the dc_devget_history
 * function and in the reconnection (use max_call_rd instead of max_call)
 * 
 * Revision 3.10  94/01/25  13:46:51  13:46:51  taurel (Emmanuel TAUREL)
 * New release with these modif :
 * 
 * - Now, use the new XDR type system
 * - Fix a bug in the dc_devgetv and dc_devgetm function when the dc is not
 *   distributed on several hosts and when some devices are not corretly
 *   dc imported.
 * - Fix another bug in the dc_devget_history for the time returned to the
 *   caller.
 * 
 * Revision 3.9  93/12/02  17:27:54  17:27:54  taurel (Emmanuel Taurel)
 * Check in after minor modifications
 * for compilation without complaints from C compiler on different
 * computer system and hardware.
 * .
 * 
 * Revision 3.8  93/12/02  15:07:43  15:07:43  taurel (Emmanuel Taurel)
 * No change since last ci. This
 * co was just for test.
 * 
 * Revision 3.7  93/12/02  15:00:58  15:00:58  taurel (Emmanuel Taurel)
 * Change in the rpc_connect and 
 * rpc_reconnect functions. Now, before we decide to connect the caller 
 * process to a data collector server, the data collector server is
 * testted to verify if it answers correctly.
 * 
 * Revision 3.6  93/10/06  17:29:48  17:29:48  taurel (Emmanuel Taurel)
 * Modified the dc_info call for the
 * beam line. In the beam line control system, you can't predict the
 * device domain name (in utils_cli.c file).
 * .
 * 
 * Revision 3.5  93/10/06  08:54:07  08:54:07  taurel (Emmanuel Taurel)
 * A bug in the dc_devgetm function.
 * PAss the address of error1 to the rpc_reconnect function instead of 
 * error1 itself.
 * 
 * Revision 3.4  93/09/30  08:52:48  08:52:48  taurel (Emmanuel Taurel)
 * Change for the DS_WARNING feature
 * .
 * 
 * Revision 3.3  93/08/13  08:24:42  08:24:42  taurel (Emmanuel TAUREL)
 * Don't use clnt_control to change timeout with TCP
 * connection. This can be the reason of a server exit id the caller dies 
 * before the server sends the answer.
 * .
 * 
 * Revision 3.2  93/07/30  10:30:23  10:30:23  taurel (Emmanuel Taurel)
 * Fix a bug in the rpc_reconnect_rd function of the
 * dcrd_cli.c file
 * 
 * Revision 3.1  93/06/14  17:31:01  17:31:01  taurel (Emmanuel Taurel)
 * Add a new call to dc library : dc_devget_history
 *  */

#include <API.h>
#include <dc.h>
#include <dcP.h>

#include <ApiP.h>
#include <DevErrors.h>
#include <DserverTeams.h>

#include <dc_xdr.h>

#ifdef _OSK
#ifdef _UCC
#include <string.h>
#include <stdlib.h>
#else
#include <strings.h>
#endif /* _UCC */
#include <inet/socket.h>
#include <inet/netdb.h>
#else /* _OSK */
#include <stdlib.h>
#include <string.h>
#ifndef _NT
#include <sys/socket.h>
#ifndef __hp9000s300
#include <netinet/in.h>
#endif
#include <netdb.h>
#include <unistd.h>
#endif  /* _NT */
#endif /* _OSK */

/* Some global variables defined elsewhere */

extern dc_nethost_info *dc_multi_nethost;




/****************************************************************************
*                                                                           *
*		dc_devget_history function code                             *
*               -----------------                                           *
*                                                                           *
*    Function rule : To retrieve from the data collector the history of a   *
*                    command result for a device.            		    *
*                                                                           *
*    Argins : - dc_ptr : Device handle					    *
*	      - cmd_code : The command code				    *
*	      - argout_type : Command result type			    *
*	      - nb_rec : Number of record to be retrieved		    *
*                                                                           *
*    Argout : - hist_buff : Pointer to buffer where command result history  *
*			    must be stored				    *
*	      - error : Pointer to error code				    *
*                                                                           *
*    In case of trouble, the function returns -1. If there is a problem for *
*    only some command result in the history, the function returns the      *
*    number of command which failed.Otherwise, the function returns 0       *
*                                                                           *
*****************************************************************************/


#ifdef __STDC__
int dc_devget_history(datco *dc_ptr,long cmd_code,dc_hist *hist_buff,DevType argout_type,long nb_rec,long *error)
#else
int dc_devget_history(dc_ptr,cmd_code,hist_buff,argout_type,nb_rec,error)
datco *dc_ptr;
long cmd_code;
dc_hist *hist_buff;
DevType argout_type;
long nb_rec;
long *error;
#endif /* __STDC__ */
{
	int i,l,ind;
	int max;
	xdevgeth send;
	xres_hist_clnt *recev;
	xresh_clnt *tmp_ptr;
	int tmp_err;
	long err;
	long error1;
	int ret = 0;
	long i_net;
	dc_nethost_info *tmp_net;

/* Try to verify function parameters */

	if (dc_ptr == NULL || error == NULL || nb_rec == 0 || nb_rec > HIST)
	{
		*error = DcErr_BadParameters;
		return(-1);
	}

/* Miscellaneous initialisation */

	i_net = dc_ptr->net_ind;
	tmp_net = &dc_multi_nethost[i_net];

	ind = dc_ptr->indice;
	max = tmp_net->host_dc.length;

/* Is it necessary to reconnect to dc server? */

	for (i = 0;i < max;i++)
	{
		if ((tmp_net->dchost_arr[i].nb_call == tmp_net->max_call_rd) ||
		    (tmp_net->dchost_arr[i].cantcont_error == MAXERR))
		{
			if (rpc_reconnect_rd(i,i_net,&error1))
			{
				*error = error1;
				return(-1);
			}
			tmp_net->dchost_arr[i].nb_call = 0;
		}
	}

/* Allocate memory for the device name and initialise the structure sent to
   server. */

	l = strlen(dc_ptr->device_name);
	if ((send.xdev_name = (char *)malloc(l + 1)) == NULL)
	{
		*error = DcErr_ClientMemoryAllocation;
		return(-1);
	}
	strcpy(send.xdev_name,dc_ptr->device_name);
	send.xcmd = cmd_code;
	send.xargout_type = argout_type;
	send.xnb_rec = nb_rec;

/* Allocate memory for the array of "xresh_clnt" structure used by XDR
   routine to deserialise data */

	if ((tmp_ptr = (xresh_clnt *)calloc(nb_rec,sizeof(xresh_clnt))) == NULL)
	{
		*error = DcErr_ClientMemoryAllocation;
		return(-1);
	}
	for (i = 0;i < nb_rec;i++)
	{
		tmp_ptr[i].xerr = 0;
		tmp_ptr[i].xtime = 0;
		tmp_ptr[i].xargout_type = argout_type;
		tmp_ptr[i].xargout = (DevArgument)(hist_buff[i].argout);
	}

/* Call server */

	recev = dc_devgeth_clnt_1(&send,tmp_net->dchost_arr[ind].rpc_handle,tmp_ptr,&err);
	tmp_net->dchost_arr[ind].nb_call++;

/* Return memory allocated to send data to server */

	free(send.xdev_name);

/* Any problem with server ? */

	if (recev == NULL)
	{
		free(tmp_ptr);
		if (err == DcErr_CantContactServer)
			tmp_net->dchost_arr[ind].cantcont_error++;
		else
			tmp_net->dchost_arr[ind].cantcont_error = 0;
		*error = err;
		return(-1);
	}
	else
		tmp_net->dchost_arr[ind].cantcont_error = 0;

/* Big problem with server ? */

	tmp_err = recev->xgen_err;
	if (tmp_err != 0)
	{
		free(tmp_ptr);
		*error = tmp_err;
		return(-1);
	}

/* Copy results into caller structures */

	for (i = 0;i < nb_rec;i++)
	{
		tmp_err = recev->xresb_clnt.xresh_clnt_val[i].xerr;
		hist_buff[i].cmd_error = tmp_err;
		if (tmp_err != 0)
		{
			ret++;
			hist_buff[i].time = (recev->xresb_clnt.xresh_clnt_val[i].xtime / 10) + TIME_OFF;
			if (((tmp_err >> DS_CAT_SHIFT) & DS_CAT_MASK) == WarningError)
			{
				hist_buff[i].argout = (DevArgument)recev->xresb_clnt.xresh_clnt_val[i].xargout;
			}
		}
		else
		{
			hist_buff[i].time = (recev->xresb_clnt.xresh_clnt_val[i].xtime / 10) + TIME_OFF;
			hist_buff[i].argout = (DevArgument)recev->xresb_clnt.xresh_clnt_val[i].xargout;
		}
	}

/* Free the memory allocated for the XDR routines used for deserialization */

	free(tmp_ptr);

/* Leave function */

	*error = 0;
	return(ret);

}
