
/*********************************************************************

 File:		Message.h

 Project:	Device Servers with sun-rpc

 Description:	Include file for applications using 
                the Message-Server.

 Author(s):	Jens Meyer

 Original:	January 1991

 $Revision: 4.2 $
 $Date: 1999/11/21 14:19:46 $

 $Author: goetz $

 $Log: Message.h,v $
 Revision 4.2  1999/11/21 14:19:46  goetz
 replaced MessageServerMain.c with M.Diehl's version which uses gettransient()

 Revision 4.1  1996/01/16 11:04:42  meyer
 Corrected warnings from solaris compiler.

 * Revision 4.0  95/01/04  16:46:46  16:46:46  meyer (Jens Meyer)
 * Version ported to solaris2.
 * 
 * Revision 3.1  93/03/02  13:42:00  13:42:00  meyer (Jens Meyer)
 * Corrected pathes to DSHOME/system.
 * 
 * Revision 3.0  92/11/11  11:54:17  11:54:17  meyer (Jens Meyer)
 * Adapted main version number 3.x
 * 
 * Revision 1.1  91/02/26  10:16:48  10:16:48  meyer (Jens Meyer)
 * Initial revision
 * 


 Copyright (c) 1990 by European Synchrotron Radiation Facility, 
                       Grenoble, France

		       All Rights Reserved

 *********************************************************************/

#ifndef _Message_h
#define _Message_h

extern void msg_alarm_handler();
extern void msg_initialise();
extern void msg_fault_handler();

typedef struct _MessageServerPart {
                                  char      name [256];
                                  char      host_name [32];
				  long	    prog_number;
                                  char      display [32];
                                  char	    ER_file_dir [256];
                                  char      pipe_dir [256];
                                  char      aw_path [256];
                                  } MessageServerPart;

#endif /* _Message_h */

