static char RcsId[] = "@(#)$Header: /segfs/dserver/system/dc/tools/RCS/dc_mfree.c,v 3.6 2002/01/31 11:20:11 goetz Exp $";
/*
 * $Log: dc_mfree.c,v $
 * Revision 3.6  2002/01/31 11:20:11  goetz
 * Linux port uses "rsh" now and not "remsh" anymore
 *
 * Revision 3.5  1996/02/27 16:52:04  taurel
 * Ported to Solaris.
 *
 * Revision 3.4  94/01/26  10:01:34  10:01:34  taurel (Emmanuel TAUREL)
 * A little bug for the sun release !
 * 
 * Revision 3.3  94/01/25  18:13:03  18:13:03  taurel (Emmanuel Taurel)
 * odified for the experiment guys. They use tcsh or csh as login shell for
 * the dserver login so, force the remsh to be executed with a sh.
 * 
 * Revision 3.2  93/09/15  10:15:52  10:15:52  taurel (Emmanuel Taurel)
 * The login used in the remote shell is now a resource.
 * 
 * Revision 3.1  93/07/19  15:18:29  15:18:29  taurel (Emmanuel Taurel)
 * Now, the dc_mfrees command path is a resource.
 * 
 * Revision 3.0  93/05/17  17:33:54  17:33:54  taurel (Emmanuel Taurel)
 * Modified to port the dc system to SUN (without RTDB).
 * 
 * Revision 1.3  93/02/03  12:49:34  12:49:34  taurel (Emmanuel Taurel)
 * Major change to be able to cope with the distributed data collector.
 * 
 * Revision 1.2  92/09/30  16:50:29  16:50:29  taurel (Emmanuel Taurel)
 * Several changes due to real first tests.
 * 
 * Revision 1.1  92/08/26  16:02:34  16:02:34  taurel (Emmanuel Taurel)
 * Initial revision
 *  */

#include <API.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/stat.h>

DevVarStringArray host_dc;
char *dc_path;
char *s_dc_path;
char *dc_login;

db_resource res1[] = {
	{"host",D_VAR_STRINGARR,&host_dc},
		     };

int res1_size = sizeof(res1) / sizeof(db_resource);

db_resource res2[] = {
	{"path",D_STRING_TYPE,&dc_path},
	{"s_path",D_STRING_TYPE,&s_dc_path},
	{"login",D_STRING_TYPE,&dc_login},
		     };

int res2_size = sizeof(res2) / sizeof(db_resource);


/****************************************************************************
*                                                                           *
*		Code for dc_mfree command                                   *
*                        --------                                           *
*                                                                           *
*    Command rule : To display information about the data collector data    *
*		    buffer.						    *
*		    The data collector system could be distributed on       *
*		    several hosts. This command will retrieve on which host *
*		    this system is running (with resources) and will run a  *
*		    local command (with remote shell) on ecah host          *
*                                                                           *
*    Synopsis : dc_mfree		    				    *
*                                                                           *
****************************************************************************/


main(argc,argv)
int argc;
char *argv[];
{
	long error;
	char *tmp,*net;
	unsigned int diff;
	char hostna[32];
	char dev_name[40];
	char psd_name[80];
	char cmd[160];
	int i;
	struct stat fista;

/* Argument test */

	if (argc != 1) {
		fprintf(stderr,"dc_mfree usage : dc_mfree\n");
		exit(-1);
			}

/* Import static database */

	if (db_import(&error)) {
		fprintf(stderr,"dc_mfree : Can't import static database\n");
		fprintf(stderr,"dc_mfree : Check your NETHOST environment variable\n");
		exit(-1);
				}

/* Retrieve on which host the data collector is running */

	host_dc.length = 0;
	if (db_getresource("CLASS/DC/1",res1,res1_size,&error)) {
		fprintf(stderr,"dc_mfree : Can't retrieve resources\n");
		fprintf(stderr,"dc_mfree : Error code : %d\n",error);
		exit(-1);
								  }
	if (host_dc.length == 0) {
		fprintf(stderr,"dc_mfree : Resource host not defined\n");
		fprintf(stderr,"dc_mfree : Sorry, but I exit !\n");
		exit(-1);
				 }

/* Get the NETHOST environment variable (No need to test if NETHOST is
   defined because this has been done during the static database import
   stuff */

	net = getenv("NETHOST");

/* Call the dc_dels command on each dc host */

	for (i = 0;i < host_dc.length;i++) {

/* Retrieve from database the primary path for dc tools */

		psd_name[0] = 0;
		strcpy(psd_name,"class/dc/");
		strcat(psd_name,host_dc.sequence[i]);

		dc_path = NULL;
		s_dc_path = NULL;
		dc_login = NULL;

		if(db_getresource(psd_name,res2,res2_size,&error)) {
			fprintf(stderr,"dc_mfree : Can't retrieve primary dc tools path for %s\n",host_dc.sequence[i]);
			fprintf(stderr,"dc_mfree : Error code : %d\n",error);
			exit(-1);
								}

		if (dc_path == NULL || s_dc_path == NULL || dc_login == NULL) {
			fprintf(stderr,"dc_mfree : Path or login for dc_tools on %s not defined\n",host_dc.sequence[i]);
			fprintf(stderr,"dc_mfree : Sorry, but I exit\n");
			exit(-1);
				     }

/* Build the string which is the remsh command */

#if defined(sun) || defined(linux)
		strcpy(cmd,"rsh ");
#else
		strcpy(cmd,"remsh ");
#endif /* sun || linux */
		strcat(cmd,host_dc.sequence[i]);
		strcat(cmd," -l ");
		strcat(cmd,dc_login);
		strcat(cmd," \"echo \\\"NETHOST=");
		strcat(cmd,net);
		strcat(cmd,";export NETHOST;");
		strcat(cmd,dc_path);
		strcat(cmd,"/");
		strcat(cmd,s_dc_path);
		strcat(cmd,"/dc_mfrees ");
		strcat(cmd,"\\\" | sh \"");

#ifdef DEBUG
		printf("Command string : %s\n",cmd);
#endif /* DEBUG */

		printf("Data collector data buffer status on %s \n\n",host_dc.sequence[i]);
		system(cmd);
					   }

}
