static char RcsId[] = "@(#)$Header: /segfs/dserver/system/dc/tools/RCS/dc_init.c,v 3.8 2002/07/05 11:13:06 taurel Exp $";
/*
 * $Log: dc_init.c,v $
 * Revision 3.8  2002/07/05 11:13:06  taurel
 * =Create dc resources iif they do not exist
 *
 * Revision 3.7  2002/01/31 10:26:15  goetz
 * Linux port using "rsh"
 *
 * Revision 3.6  1996/02/27 16:51:12  taurel
 * Ported to Solaris.
 *
 * Revision 3.5  95/12/19  14:16:55  14:16:55  taurel (Emmanuel TAUREL)
 * Remove command parameter.
 * 
 * Revision 3.4  94/01/26  10:01:22  10:01:22  taurel (Emmanuel TAUREL)
 * A little bug for the sun release !
 * 
 * Revision 3.3  94/01/25  18:11:15  18:11:15  taurel (Emmanuel Taurel)
 * Modified for the experiment guys. They use tcsh or csh as login shell for
 * the dserver login so, force the remsh to be executed with a sh.
 * 
 * Revision 3.2  93/09/15  10:15:43  10:15:43  taurel (Emmanuel Taurel)
 * The login used in the remote shell is now a resource.
 * 
 * Revision 3.1  93/07/19  15:17:36  15:17:36  taurel (Emmanuel Taurel)
 * Now, the dc_inits command path is a resource.
 * 
 * Revision 3.0  93/05/17  17:33:07  17:33:07  taurel (Emmanuel Taurel)
 * Modified to port the dc system to SUN (without RTDB).
 * 
 * Revision 1.3  93/02/03  11:26:27  11:26:27  taurel (Emmanuel Taurel)
 * Strong modifications to be able to cope with the distributed data collector.
 * 
 * Revision 1.2  92/09/30  16:49:24  16:49:24  taurel (Emmanuel TAUREL)
 * Several changes dur to real first tests.
 * 
 * Revision 1.1  92/08/26  16:02:07  16:02:07  taurel (Emmanuel Taurel)
 * Initial revision
 *  */

#include <API.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/stat.h>
#include <netdb.h>

#define	DEFAULT_TIMEOUT		9
#define	DEFAULT_MAX_CALL	1000
#define DEFAULT_READ_SVC_NB	2
#define DEFAULT_WRITE_SVC_NB	2
#define DEFAULT_DEV_NUMBER	100
#define	DEFAULT_CELLAR_NUMBER	50
#define DEFAULT_DATA_SIZE	512 * 1024
#define DEFAULT_PASSWORD	"setup"
#define	DEFAULT_LOGIN		"blissadm"

DevVarStringArray host_dc;
char *dc_path;
char *s_dc_path;
char *dc_login;

db_resource res1[] = {
	{"host",D_VAR_STRINGARR,&host_dc},
		     };

int res1_size = sizeof(res1) / sizeof(db_resource);

db_resource res2[] = {
	{"path",D_STRING_TYPE,&dc_path},
	{"s_path",D_STRING_TYPE,&s_dc_path},
	{"login",D_STRING_TYPE,&dc_login},
		     };

int res2_size = sizeof(res2) / sizeof(db_resource);

db_resource res_class_def[] = {
	{"host",D_VAR_STRINGARR},
	{"max_call",D_LONG_TYPE},
	{"timeout",D_LONG_TYPE},
		     };
int res_class_def_size = sizeof(res_class_def) / sizeof(db_resource);

db_resource res_class_host[] = {
	{"dev_number",D_LONG_TYPE},
	{"cellar_number",D_LONG_TYPE},
	{"data_size",D_LONG_TYPE},
	{"password",D_STRING_TYPE},
	{"path",D_STRING_TYPE},
	{"s_path",D_STRING_TYPE},
	{"login",D_STRING_TYPE}
		     };
int res_class_host_size = sizeof(res_class_host) / sizeof(db_resource);

/****************************************************************************
*                                                                           *
*		Code for dc_init command                                    *
*                        -------                                            *
*                                                                           *
*    Command rule : To initialise the data collector and to 		    *
*		    create the shared memories segments used by the dc.     *
*		    The data collector system could be distributed on       *
*		    several hosts. This command will retrieve on which host *
*		    this system is running (with resources) and will run a  *
*		    local command (with remote shell) on each host          *
*                                                                           *
*    Synopsis : dc_init		 		   			    *
*                                                                           *
****************************************************************************/


main(argc,argv)
int argc;
char *argv[];
{
	int ds;
	long error;
	char *tmp,*net;
	unsigned int diff;
	char hostna[32];
	char dev_name[40];
	char psd_name[80];
	char cmd[160];
	int i,resu;
	struct stat fista;

/* Arguments number test */

	if(argc != 1)
	{
		fprintf(stderr,"dc_init usage : dc_init\n");
		exit(-1);
	}

/* Import static database */

	if (db_import(&error))
	{
		fprintf(stderr,"dc_init : Can't import static database\n");
		fprintf(stderr,"dc_init : Check your NETHOST environment variable\n");
		exit(-1);
	}

/* Create default resource if necessary */

	if (dc_res_management(&error))
	{
		fprintf(stderr,"dc_init: Can't correctly manage dc resources\n");
		fprintf(stderr,"dc_init: Error code = %d\n",error);
		exit(-1);
	}
	
	if (dc_res_serv_nb(&error))
	{
		fprintf(stderr,"dc_init: Can't correctly manage server_nb dc resources\n");
		fprintf(stderr,"dc_init: Error code = %d\n",error);
		exit(-1);
	}

	if (dc_res_request(&error))
	{
		fprintf(stderr,"dc_init: Can't correctly manage server request dc resources\n");
		fprintf(stderr,"dc_init: Error code = %d\n",error);
		exit(-1);
	}
	
	if (dc_class_dc(&error))
	{
		fprintf(stderr,"dc_init: Can't correctly manage class/dc/<host> dc resources\n");
		fprintf(stderr,"dc_init: Error code = %d\n",error);
		exit(-1);
	}
			
/* Retrieve on which host the data collector is running */

	host_dc.length = 0;
	if (db_getresource("CLASS/DC/1",res1,res1_size,&error))
	{
		fprintf(stderr,"dc_init : Can't retrieve resources\n");
		fprintf(stderr,"dc_init : Error code : %d\n",error);
		exit(-1);
	}
	if (host_dc.length == 0)
	{
		fprintf(stderr,"dc_init : Resource host not defined\n");
		fprintf(stderr,"dc_init : Sorry, but I exit !\n");
		exit(-1);
	}

/* Get the NETHOST environment variable (No need to test if NETHOST is
   defined because this has been done during the static database import 
   stuff */

	net = getenv("NETHOST");

/* Call the dc_inits command on each dc host */

	for (i = 0;i < host_dc.length;i++)
	{

/* Retrieve from database the primary path for dc tools */

		psd_name[0] = 0;
		strcpy(psd_name,"class/dc/");
		strcat(psd_name,host_dc.sequence[i]);

		dc_path = NULL;
		s_dc_path = NULL;
		dc_login = NULL;

		if(db_getresource(psd_name,res2,res2_size,&error))
		{
			fprintf(stderr,"dc_init : Can't retrieve primary dc tools path for %s\n",host_dc.sequence[i]);
			fprintf(stderr,"dc_init : Error code : %d\n",error);
			exit(-1);
		}

		if (dc_path == NULL || s_dc_path == NULL || dc_login == NULL)
		{
			fprintf(stderr,"dc_init : Path or login for dc_tools on %s not defined\n",host_dc.sequence[i]);
			fprintf(stderr,"dc_init : Sorry, but I exit\n");
			exit(-1);
		}

/* Build the string which is the remsh command */

#if defined(sun) || defined(linux)
		strcpy(cmd,"rsh ");
#else
		strcpy(cmd,"remsh ");
#endif /* sun */
		strcat(cmd,host_dc.sequence[i]);
		strcat(cmd," -l ");
		strcat(cmd,dc_login);
		strcat(cmd," \" echo \\\"NETHOST=");
		strcat(cmd,net);
		strcat(cmd,";export NETHOST;");
		strcat(cmd,dc_path);
		strcat(cmd,"/");
		strcat(cmd,s_dc_path);
		strcat(cmd,"/dc_inits ");
		strcat(cmd," \\\" | sh \" | tee /usr/tmp/dcinitsta");

#ifdef DEBUG
		printf("Command string : %s\n",cmd);
#endif /* DEBUG */

		printf("Executing dc_init on %s \n",host_dc.sequence[i]);
		system(cmd);

/* Any error during local dc_init command ? */

		stat("/usr/tmp/dcinitsta",&fista);
		if (fista.st_size != 0)
		{
			unlink("/usr/tmp/dcinitsta");
			break;
		}
		else
			unlink("/usr/tmp/dcinitsta");
		
	}

}

int dc_res_management(long *error_ptr)
{
	int m_call,to;
	DevVarStringArray host_dc;
	int nb_put_class_res = 0;
	char hostna[64];
	char hostna_wo_dot[64];
	db_resource put_class_res[4];
	char *net_def;
	db_resource net_res;
	char res_name[32];
	unsigned char ho = 0;
	unsigned char net = 0;
	struct hostent *host;
	char *def;
	char *tmp;
	unsigned int diff;
		
/* First, check class resource definition */

	m_call = 0;
	to = 1000;
	host_dc.length = 0;
	net_def = NULL;
	
	res_class_def[0].resource_adr = &host_dc;
	res_class_def[1].resource_adr = &m_call;
	res_class_def[2].resource_adr = &to;
	
	if (db_getresource("class/dc/1",res_class_def,res_class_def_size,error_ptr) == -1)
	{
		fprintf(stderr,"dc_init: Can't retrieve class/dc/1 resources\n");
		return -1;
	}


	gethostname(hostna,sizeof(hostna));
	if ((host = gethostbyname(hostna)) == (struct hostent *)NULL)
	{
		fprintf(stderr,"dc_init: Can't retrieve host network address\n");
		return -1;
	}
	
	ho = (unsigned char)(host->h_addr_list[0][3]);
	net = (unsigned char)(host->h_addr_list[0][2]);
	
	sprintf(res_name,"%u",net);
	strcat(res_name,"_default");
	net_res.resource_name = res_name;
	net_res.resource_type = D_STRING_TYPE;
	net_res.resource_adr = &net_def;
	
	if (db_getresource("class/dc/1",&net_res,(unsigned int)1,error_ptr) == -1)
	{
		fprintf(stderr,"dc_init: Can't retrieve class/dc/1 resources\n");
		return -1;
	}	

/* Check for each variable if it is necessary to insert one in db */

	if (host_dc.length == 0)
	{
	
/* Set a default value to one host which is the host where this command
   is running. Remove domain name from its name */
   
		host_dc.length = 1;
		host_dc.sequence = calloc(1,sizeof(char *));
		
		tmp = strchr(hostna,'.');
		if (tmp != NULL)
		{
			diff = (unsigned int)(tmp - hostna);
			strncpy(hostna_wo_dot,hostna,diff);
			hostna_wo_dot[diff] = '\0';
		}
		else
			strcpy(hostna_wo_dot,hostna);
		host_dc.sequence[0] = hostna_wo_dot;
		
		put_class_res[nb_put_class_res].resource_name = "host";
		put_class_res[nb_put_class_res].resource_type = D_VAR_STRINGARR;
		put_class_res[nb_put_class_res].resource_adr = &host_dc;		
		nb_put_class_res++;
	}
		
	if (m_call == 0)
	{
	
/* Set a default value for the max_call resource */

		m_call = DEFAULT_MAX_CALL;
		put_class_res[nb_put_class_res].resource_name = "max_call";
		put_class_res[nb_put_class_res].resource_type = D_LONG_TYPE;
		put_class_res[nb_put_class_res].resource_adr = &m_call;
		nb_put_class_res++;
	}
	
	if (to == 1000)
	{
	
/* Set a default value for timeout */

		to = DEFAULT_TIMEOUT;
		put_class_res[nb_put_class_res].resource_name = "timeout";
		put_class_res[nb_put_class_res].resource_type = D_LONG_TYPE;
		put_class_res[nb_put_class_res].resource_adr = &to;
		nb_put_class_res++;
	}
	
	if (net_def == NULL)
	{
	
/* Set a default value for the default dc host based on the net number of the
   IP address of the computer on which this command is executed */

		tmp = strchr(hostna,'.');
		if (tmp != NULL)
		{
			diff = (unsigned int)(tmp - hostna);
			strncpy(hostna_wo_dot,hostna,diff);
			hostna_wo_dot[diff] = '\0';
		}
		else
			strcpy(hostna_wo_dot,hostna);
			
		def = hostna_wo_dot;	
		put_class_res[nb_put_class_res].resource_name = res_name;
		put_class_res[nb_put_class_res].resource_type = D_STRING_TYPE;
		put_class_res[nb_put_class_res].resource_adr = &def;
		nb_put_class_res++;
	}
	
/* Update db if necessary */

	if (nb_put_class_res != 0)
	{
		if (db_putresource("class/dc/1",put_class_res,nb_put_class_res,error_ptr))
		{
			fprintf(stderr,"dc_init: Error while trying to put default class resource\n");
			return -1;
		}
	}
	
	return 0;
}

int dc_res_serv_nb(long *error_ptr)
{
	int rd_nb,wr_nb;
	int nb_put_class_res = 0;
	db_resource put_class_res[2];
	db_resource net_res[2];
	char hostna[64];
	char hostna_wo_dot[64];
	unsigned int diff;
	char *tmp;
	char res_name_rd[64];
	char res_name_wr[64];
		
/* First, check if resources are defined */

	rd_nb = wr_nb = 1000;
	
	gethostname(hostna,sizeof(hostna));
	tmp = strchr(hostna,'.');
	if (tmp != NULL)
	{
		diff = (unsigned int)(tmp - hostna);
		strncpy(hostna_wo_dot,hostna,diff);
		hostna_wo_dot[diff] = '\0';
	}
	else
		strcpy(hostna_wo_dot,hostna);

	strcpy(res_name_rd,hostna_wo_dot);
	strcat(res_name_rd,"_rd");
	
	strcpy(res_name_wr,hostna_wo_dot);
	strcat(res_name_wr,"_wr");
				
	net_res[0].resource_name = res_name_rd;
	net_res[0].resource_type = D_LONG_TYPE;
	net_res[0].resource_adr = &rd_nb;

	net_res[1].resource_name = res_name_wr;	
	net_res[1].resource_type = D_LONG_TYPE;
	net_res[1].resource_adr = &wr_nb;
	
	if (db_getresource("class/dc/server_nb",net_res,2,error_ptr) == -1)
	{
		fprintf(stderr,"dc_init: Can't retrieve class/dc/server_nb resources\n");
		return -1;
	}
	
	if (rd_nb == 1000)
	{
	
/* Set a default value for read server numbers */

		rd_nb = DEFAULT_READ_SVC_NB;
		put_class_res[nb_put_class_res].resource_name = res_name_rd;
		put_class_res[nb_put_class_res].resource_type = D_LONG_TYPE;
		put_class_res[nb_put_class_res].resource_adr = &rd_nb;
		nb_put_class_res++;
	}
	
	if (wr_nb == 1000)
	{
	
/* Set a default value for read server numbers */

		wr_nb = DEFAULT_WRITE_SVC_NB;
		put_class_res[nb_put_class_res].resource_name = res_name_wr;
		put_class_res[nb_put_class_res].resource_type = D_LONG_TYPE;
		put_class_res[nb_put_class_res].resource_adr = &wr_nb;
		nb_put_class_res++;
	}
	
/* Update db if necessary */

	if (nb_put_class_res != 0)
	{
		if (db_putresource("class/dc/server_nb",put_class_res,nb_put_class_res,error_ptr))
		{
			fprintf(stderr,"dc_init: Error while trying to put default server_nb resource\n");
			return -1;
		}
	}
	
	return 0;
}

int dc_res_request(long *error_ptr)
{
	int req1,req2,req3,req4;
	int nb_put_class_res = 0;
	db_resource put_class_res[4];
	db_resource net_res[4];
	char hostna[64];
	unsigned char ho = 0;
	unsigned char net = 0;
	struct hostent *host;
	char dev_name[64];
		
/* First, check if resources are defined */

	req1 = req2 = req3 = req4 = 1234;
	
	gethostname(hostna,sizeof(hostna));
	if ((host = gethostbyname(hostna)) == (struct hostent *)NULL)
	{
		fprintf(stderr,"dc_init: Can't retrieve host network address\n");
		return -1;
	}
	
	ho = (unsigned char)(host->h_addr_list[0][3]);
	net = (unsigned char)(host->h_addr_list[0][2]);

	strcpy(dev_name,"sys/dc_wr_");
	sprintf(&(dev_name[strlen(dev_name)]),"%u",ho);
	strcat(dev_name,"/request");
				
	net_res[0].resource_name = "1";
	net_res[0].resource_type = D_LONG_TYPE;
	net_res[0].resource_adr = &req1;

	net_res[1].resource_name = "2";	
	net_res[1].resource_type = D_LONG_TYPE;
	net_res[1].resource_adr = &req2;

	net_res[2].resource_name = "3";	
	net_res[2].resource_type = D_LONG_TYPE;
	net_res[2].resource_adr = &req3;
	
	net_res[3].resource_name = "4";	
	net_res[3].resource_type = D_LONG_TYPE;
	net_res[3].resource_adr = &req4;
		
	if (db_getresource(dev_name,net_res,4,error_ptr) == -1)
	{
		fprintf(stderr,"dc_init: Can't retrieve wr server request nb resources\n");
		return -1;
	}
	
	if (req1 == 1234)
	{
	
/* Set a default value for read server numbers */

		req1 = 0;
		put_class_res[nb_put_class_res].resource_name = "1";
		put_class_res[nb_put_class_res].resource_type = D_LONG_TYPE;
		put_class_res[nb_put_class_res].resource_adr = &req1;
		nb_put_class_res++;
	}
	
	if (req2 == 1234)
	{
	
/* Set a default value for read server numbers */

		req2 = 0;
		put_class_res[nb_put_class_res].resource_name = "2";
		put_class_res[nb_put_class_res].resource_type = D_LONG_TYPE;
		put_class_res[nb_put_class_res].resource_adr = &req2;
		nb_put_class_res++;
	}

	if (req3 == 1234)
	{
	
/* Set a default value for read server numbers */

		req3 = 0;
		put_class_res[nb_put_class_res].resource_name = "3";
		put_class_res[nb_put_class_res].resource_type = D_LONG_TYPE;
		put_class_res[nb_put_class_res].resource_adr = &req3;
		nb_put_class_res++;
	}
	
	if (req4 == 1234)
	{
	
/* Set a default value for read server numbers */

		req4 = 0;
		put_class_res[nb_put_class_res].resource_name = "4";
		put_class_res[nb_put_class_res].resource_type = D_LONG_TYPE;
		put_class_res[nb_put_class_res].resource_adr = &req4;
		nb_put_class_res++;
	}
		
/* Update db if necessary */

	if (nb_put_class_res != 0)
	{
		if (db_putresource(dev_name,put_class_res,nb_put_class_res,error_ptr))
		{
			fprintf(stderr,"dc_init: Error while trying to put default wr server request resource\n");
			return -1;
		}
	}

/* Now, do the same for rd servers */

	nb_put_class_res = 0;
	req1 = req2 = req3 = req4 = 1234;	
	strcpy(dev_name,"sys/dc_rd_");
	sprintf(&(dev_name[strlen(dev_name)]),"%u",ho);
	strcat(dev_name,"/request");
				
	net_res[0].resource_name = "1";
	net_res[0].resource_type = D_LONG_TYPE;
	net_res[0].resource_adr = &req1;

	net_res[1].resource_name = "2";	
	net_res[1].resource_type = D_LONG_TYPE;
	net_res[1].resource_adr = &req2;

	net_res[2].resource_name = "3";	
	net_res[2].resource_type = D_LONG_TYPE;
	net_res[2].resource_adr = &req3;
	
	net_res[3].resource_name = "3";	
	net_res[3].resource_type = D_LONG_TYPE;
	net_res[3].resource_adr = &req4;
		
	if (db_getresource(dev_name,net_res,4,error_ptr) == -1)
	{
		fprintf(stderr,"dc_init: Can't retrieve wr server request nb resources\n");
		return -1;
	}
	
	if (req1 == 1234)
	{
	
/* Set a default value for read server numbers */

		req1 = 0;
		put_class_res[nb_put_class_res].resource_name = "1";
		put_class_res[nb_put_class_res].resource_type = D_LONG_TYPE;
		put_class_res[nb_put_class_res].resource_adr = &req1;
		nb_put_class_res++;
	}
	
	if (req2 == 1234)
	{
	
/* Set a default value for read server numbers */

		req2 = 0;
		put_class_res[nb_put_class_res].resource_name = "2";
		put_class_res[nb_put_class_res].resource_type = D_LONG_TYPE;
		put_class_res[nb_put_class_res].resource_adr = &req2;
		nb_put_class_res++;
	}

	if (req3 == 1234)
	{
	
/* Set a default value for read server numbers */

		req3 = 0;
		put_class_res[nb_put_class_res].resource_name = "3";
		put_class_res[nb_put_class_res].resource_type = D_LONG_TYPE;
		put_class_res[nb_put_class_res].resource_adr = &req3;
		nb_put_class_res++;
	}
	
	if (req4 == 1234)
	{
	
/* Set a default value for read server numbers */

		req4 = 0;
		put_class_res[nb_put_class_res].resource_name = "4";
		put_class_res[nb_put_class_res].resource_type = D_LONG_TYPE;
		put_class_res[nb_put_class_res].resource_adr = &req4;
		nb_put_class_res++;
	}
		
/* Update db if necessary */

	if (nb_put_class_res != 0)
	{
		if (db_putresource(dev_name,put_class_res,nb_put_class_res,error_ptr))
		{
			fprintf(stderr,"dc_init: Error while trying to put default wr server request resource\n");
			return -1;
		}
	}
	
	return 0;
}

int dc_class_dc(long *error_ptr)
{
	int dev_number,cellar_number,data_size;
	db_resource put_class_res[7];
	int nb_put_class_res = 0;
	char hostna[64];
	char hostna_wo_dot[64];
	unsigned int diff;
	char *tmp;
	char dev_name[64];
	char *pass;
	char *path;
	char *s_path;
	char *login;
	char tmp_path[128];
	char tmp_spath[128];
	char *pa;
	char *spa;
	char *taco_path;

/* Get host name without domain name */
	
	gethostname(hostna,sizeof(hostna));
	tmp = strchr(hostna,'.');
	if (tmp != NULL)
	{
		diff = (unsigned int)(tmp - hostna);
		strncpy(hostna_wo_dot,hostna,diff);
		hostna_wo_dot[diff] = '\0';
	}
	else
		strcpy(hostna_wo_dot,hostna);
		
	dev_number = cellar_number = data_size = 1234;
	pass = path = s_path = login = NULL;

/* Try to get resource */
	
	res_class_host[0].resource_adr = &dev_number;
	res_class_host[1].resource_adr = &cellar_number;
	res_class_host[2].resource_adr = &data_size;
	res_class_host[3].resource_adr = &pass;
	res_class_host[4].resource_adr = &path;
	res_class_host[5].resource_adr = &s_path;
	res_class_host[6].resource_adr = &login;
	
	strcpy(dev_name,"class/dc/");
	strcat(dev_name,hostna_wo_dot);
	
	if (db_getresource(dev_name,res_class_host,res_class_host_size,error_ptr) == -1)
	{
		fprintf(stderr,"dc_init: Can't retrieve class/dc/<host> resources\n");
		return -1;
	}

	if (dev_number == 1234)
	{
	
/* Set a default value for dev_number */

		dev_number = DEFAULT_DEV_NUMBER;
		put_class_res[nb_put_class_res].resource_name = "dev_number";
		put_class_res[nb_put_class_res].resource_type = D_LONG_TYPE;
		put_class_res[nb_put_class_res].resource_adr = &dev_number;
		nb_put_class_res++;
	}

	if (cellar_number == 1234)
	{
	
/* Set a default value for dev_number */

		cellar_number = DEFAULT_CELLAR_NUMBER;
		put_class_res[nb_put_class_res].resource_name = "cellar_number";
		put_class_res[nb_put_class_res].resource_type = D_LONG_TYPE;
		put_class_res[nb_put_class_res].resource_adr = &cellar_number;
		nb_put_class_res++;
	}
	
	if (data_size == 1234)
	{
	
/* Set a default value for dev_number */

		data_size = DEFAULT_DATA_SIZE;
		put_class_res[nb_put_class_res].resource_name = "data_size";
		put_class_res[nb_put_class_res].resource_type = D_LONG_TYPE;
		put_class_res[nb_put_class_res].resource_adr = &data_size;
		nb_put_class_res++;
	}
	
	if (pass == NULL)
	{
	
/* Set a default value for dev_number */

		pass = DEFAULT_PASSWORD;
		put_class_res[nb_put_class_res].resource_name = "password";
		put_class_res[nb_put_class_res].resource_type = D_STRING_TYPE;
		put_class_res[nb_put_class_res].resource_adr = &pass;
		nb_put_class_res++;
	}
	
	if (login == NULL)
	{
	
/* Set a default value for dev_number */

		login = DEFAULT_LOGIN;
		put_class_res[nb_put_class_res].resource_name = "login";
		put_class_res[nb_put_class_res].resource_type = D_STRING_TYPE;
		put_class_res[nb_put_class_res].resource_adr = &login;
		nb_put_class_res++;
	}
	
	if (path == NULL)
	{
		taco_path = getenv("TACO_PATH");
		if (taco_path == NULL)
		{
			fprintf(stderr,"dc_init: Environment variable TACO_PATH not set !\n");
			fprintf(stderr,"dc_init: Exiting\n");
			exit(-1);
		}
		tmp = strrchr(taco_path,'/');
		diff = (unsigned int)(tmp - taco_path);
		strncpy(tmp_path,taco_path,diff);
		tmp_path[diff] = '\0';

		tmp++;
		diff = strlen(taco_path) - strlen(tmp_path);		
		strncpy(tmp_spath,tmp,diff);
		tmp_spath[diff] = '\0';

		pa = tmp_path;		
		put_class_res[nb_put_class_res].resource_name = "path";
		put_class_res[nb_put_class_res].resource_type = D_STRING_TYPE;
		put_class_res[nb_put_class_res].resource_adr = &pa;
		nb_put_class_res++;

		spa = tmp_spath;		
		put_class_res[nb_put_class_res].resource_name = "s_path";
		put_class_res[nb_put_class_res].resource_type = D_STRING_TYPE;
		put_class_res[nb_put_class_res].resource_adr = &spa;
		nb_put_class_res++;
	}
	
/* Update db if necessary */

	if (nb_put_class_res != 0)
	{
		if (db_putresource(dev_name,put_class_res,nb_put_class_res,error_ptr))
		{
			fprintf(stderr,"dc_init: Error while trying to put default class/dc/<host> resource\n");
			return -1;
		}
	}
	
	return 0;	
}
